/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.components;

import android.graphics.DashPathEffect;
import android.graphics.Paint;
import info.appdev.charting.components.ComponentBase;
import info.appdev.charting.components.LegendEntry;
import info.appdev.charting.utils.CanvasUtilsKt;
import info.appdev.charting.utils.FSize;
import info.appdev.charting.utils.UtilsKtKt;
import info.appdev.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005yz{|}B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0017\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007J\u0014\u0010N\u001a\u00020O2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060PJ\u000e\u0010Q\u001a\u0002012\u0006\u0010R\u001a\u00020SJ\u000e\u0010T\u001a\u0002012\u0006\u0010R\u001a\u00020SJ\u0014\u0010U\u001a\u00020O2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060PJ\u0019\u0010U\u001a\u00020O2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J!\u0010U\u001a\u00020O2\u0006\u0010V\u001a\u00020W2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0\u0005\u00a2\u0006\u0002\u0010ZJ\u0019\u0010[\u001a\u00020O2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010[\u001a\u00020O2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060PJ\u0006\u0010\\\u001a\u00020OJ\u000e\u0010]\u001a\u00020O2\u0006\u0010\b\u001a\u00020\u000eJ\u0016\u0010u\u001a\u00020O2\u0006\u0010v\u001a\u00020S2\u0006\u0010w\u001a\u00020xR,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR,\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\nR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00103\"\u0004\b8\u00105R\u001c\u00109\u001a\u0004\u0018\u00010:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00103\"\u0004\bA\u00105R\u001a\u0010B\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u00103\"\u0004\bD\u00105R\u001a\u0010E\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u00103\"\u0004\bG\u00105R\u001a\u0010H\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u00103\"\u0004\bJ\u00105R\u001a\u0010K\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u00103\"\u0004\bM\u00105R\u001a\u0010^\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b_\u00103\"\u0004\b`\u00105R\u001a\u0010a\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u00103\"\u0004\bc\u00105R\u001a\u0010d\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u00103\"\u0004\bf\u00105R\u001a\u0010g\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u00103\"\u0004\bi\u00105R\u001a\u0010j\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bj\u0010\u0010\"\u0004\bk\u0010lR\u0019\u0010m\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010n0P\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010pR\u0019\u0010q\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0P\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010pR\u0019\u0010s\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010n0P\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010p\u00a8\u0006~"}, d2={"Linfo/appdev/charting/components/Legend;", "Linfo/appdev/charting/components/ComponentBase;", "<init>", "()V", "entries", "", "Linfo/appdev/charting/components/LegendEntry;", "([Linfo/appdev/charting/components/LegendEntry;)V", "value", "getEntries", "()[Linfo/appdev/charting/components/LegendEntry;", "[Linfo/appdev/charting/components/LegendEntry;", "extraEntries", "getExtraEntries", "", "isLegendCustom", "()Z", "horizontalAlignment", "Linfo/appdev/charting/components/Legend$LegendHorizontalAlignment;", "getHorizontalAlignment", "()Linfo/appdev/charting/components/Legend$LegendHorizontalAlignment;", "setHorizontalAlignment", "(Linfo/appdev/charting/components/Legend$LegendHorizontalAlignment;)V", "verticalAlignment", "Linfo/appdev/charting/components/Legend$LegendVerticalAlignment;", "getVerticalAlignment", "()Linfo/appdev/charting/components/Legend$LegendVerticalAlignment;", "setVerticalAlignment", "(Linfo/appdev/charting/components/Legend$LegendVerticalAlignment;)V", "orientation", "Linfo/appdev/charting/components/Legend$LegendOrientation;", "getOrientation", "()Linfo/appdev/charting/components/Legend$LegendOrientation;", "setOrientation", "(Linfo/appdev/charting/components/Legend$LegendOrientation;)V", "isDrawInsideEnabled", "direction", "Linfo/appdev/charting/components/Legend$LegendDirection;", "getDirection", "()Linfo/appdev/charting/components/Legend$LegendDirection;", "setDirection", "(Linfo/appdev/charting/components/Legend$LegendDirection;)V", "form", "Linfo/appdev/charting/components/Legend$LegendForm;", "getForm", "()Linfo/appdev/charting/components/Legend$LegendForm;", "setForm", "(Linfo/appdev/charting/components/Legend$LegendForm;)V", "formSize", "", "getFormSize", "()F", "setFormSize", "(F)V", "formLineWidth", "getFormLineWidth", "setFormLineWidth", "formLineDashEffect", "Landroid/graphics/DashPathEffect;", "getFormLineDashEffect", "()Landroid/graphics/DashPathEffect;", "setFormLineDashEffect", "(Landroid/graphics/DashPathEffect;)V", "xEntrySpace", "getXEntrySpace", "setXEntrySpace", "yEntrySpace", "getYEntrySpace", "setYEntrySpace", "formToTextSpace", "getFormToTextSpace", "setFormToTextSpace", "stackSpace", "getStackSpace", "setStackSpace", "maxSizePercent", "getMaxSizePercent", "setMaxSizePercent", "setEntries", "", "", "getMaximumEntryWidth", "p", "Landroid/graphics/Paint;", "getMaximumEntryHeight", "setExtra", "colors", "", "labels", "", "([I[Ljava/lang/String;)V", "setCustom", "resetCustom", "setDrawInside", "neededWidth", "getNeededWidth", "setNeededWidth", "neededHeight", "getNeededHeight", "setNeededHeight", "mTextHeightMax", "getMTextHeightMax", "setMTextHeightMax", "mTextWidthMax", "getMTextWidthMax", "setMTextWidthMax", "isWordWrapEnabled", "setWordWrapEnabled", "(Z)V", "calculatedLabelSizes", "Linfo/appdev/charting/utils/FSize;", "getCalculatedLabelSizes", "()Ljava/util/List;", "calculatedLabelBreakPoints", "getCalculatedLabelBreakPoints", "calculatedLineSizes", "getCalculatedLineSizes", "calculateDimensions", "labelpaint", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "LegendForm", "LegendHorizontalAlignment", "LegendVerticalAlignment", "LegendOrientation", "LegendDirection", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nLegend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Legend.kt\ninfo/appdev/charting/components/Legend\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,521:1\n37#2,2:522\n37#2,2:524\n37#2,2:526\n37#2,2:528\n*S KotlinDebug\n*F\n+ 1 Legend.kt\ninfo/appdev/charting/components/Legend\n*L\n186#1:522,2\n238#1:524,2\n267#1:526,2\n292#1:528,2\n*E\n"})
public final class Legend
extends ComponentBase {
    @NotNull
    private LegendEntry[] entries;
    @NotNull
    private LegendEntry[] extraEntries;
    private boolean isLegendCustom;
    @NotNull
    private LegendHorizontalAlignment horizontalAlignment;
    @NotNull
    private LegendVerticalAlignment verticalAlignment;
    @NotNull
    private LegendOrientation orientation;
    private boolean isDrawInsideEnabled;
    @NotNull
    private LegendDirection direction;
    @NotNull
    private LegendForm form;
    private float formSize;
    private float formLineWidth;
    @Nullable
    private DashPathEffect formLineDashEffect;
    private float xEntrySpace;
    private float yEntrySpace;
    private float formToTextSpace;
    private float stackSpace;
    private float maxSizePercent;
    private float neededWidth;
    private float neededHeight;
    private float mTextHeightMax;
    private float mTextWidthMax;
    private boolean isWordWrapEnabled;
    @NotNull
    private final List<FSize> calculatedLabelSizes;
    @NotNull
    private final List<Boolean> calculatedLabelBreakPoints;
    @NotNull
    private final List<FSize> calculatedLineSizes;

    public Legend() {
        this.entries = new LegendEntry[0];
        this.extraEntries = new LegendEntry[0];
        this.horizontalAlignment = LegendHorizontalAlignment.LEFT;
        this.verticalAlignment = LegendVerticalAlignment.BOTTOM;
        this.orientation = LegendOrientation.HORIZONTAL;
        this.direction = LegendDirection.LEFT_TO_RIGHT;
        this.form = LegendForm.SQUARE;
        this.formSize = 8.0f;
        this.formLineWidth = 3.0f;
        this.xEntrySpace = 6.0f;
        this.formToTextSpace = 5.0f;
        this.stackSpace = 3.0f;
        this.maxSizePercent = 0.95f;
        this.calculatedLabelSizes = new ArrayList(16);
        this.calculatedLabelBreakPoints = new ArrayList(16);
        this.calculatedLineSizes = new ArrayList(16);
        this.setMTextSize(UtilsKtKt.convertDpToPixel(10.0f));
        this.setMXOffset(UtilsKtKt.convertDpToPixel(5.0f));
        this.setMYOffset(UtilsKtKt.convertDpToPixel(3.0f));
    }

    @NotNull
    public final LegendEntry[] getEntries() {
        return this.entries;
    }

    @NotNull
    public final LegendEntry[] getExtraEntries() {
        return this.extraEntries;
    }

    public final boolean isLegendCustom() {
        return this.isLegendCustom;
    }

    @NotNull
    public final LegendHorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public final void setHorizontalAlignment(@NotNull LegendHorizontalAlignment legendHorizontalAlignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)legendHorizontalAlignment), (String)"<set-?>");
        this.horizontalAlignment = legendHorizontalAlignment;
    }

    @NotNull
    public final LegendVerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public final void setVerticalAlignment(@NotNull LegendVerticalAlignment legendVerticalAlignment) {
        Intrinsics.checkNotNullParameter((Object)((Object)legendVerticalAlignment), (String)"<set-?>");
        this.verticalAlignment = legendVerticalAlignment;
    }

    @NotNull
    public final LegendOrientation getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(@NotNull LegendOrientation legendOrientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)legendOrientation), (String)"<set-?>");
        this.orientation = legendOrientation;
    }

    public final boolean isDrawInsideEnabled() {
        return this.isDrawInsideEnabled;
    }

    @NotNull
    public final LegendDirection getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull LegendDirection legendDirection) {
        Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"<set-?>");
        this.direction = legendDirection;
    }

    @NotNull
    public final LegendForm getForm() {
        return this.form;
    }

    public final void setForm(@NotNull LegendForm legendForm) {
        Intrinsics.checkNotNullParameter((Object)((Object)legendForm), (String)"<set-?>");
        this.form = legendForm;
    }

    public final float getFormSize() {
        return this.formSize;
    }

    public final void setFormSize(float f) {
        this.formSize = f;
    }

    public final float getFormLineWidth() {
        return this.formLineWidth;
    }

    public final void setFormLineWidth(float f) {
        this.formLineWidth = f;
    }

    @Nullable
    public final DashPathEffect getFormLineDashEffect() {
        return this.formLineDashEffect;
    }

    public final void setFormLineDashEffect(@Nullable DashPathEffect dashPathEffect) {
        this.formLineDashEffect = dashPathEffect;
    }

    public final float getXEntrySpace() {
        return this.xEntrySpace;
    }

    public final void setXEntrySpace(float f) {
        this.xEntrySpace = f;
    }

    public final float getYEntrySpace() {
        return this.yEntrySpace;
    }

    public final void setYEntrySpace(float f) {
        this.yEntrySpace = f;
    }

    public final float getFormToTextSpace() {
        return this.formToTextSpace;
    }

    public final void setFormToTextSpace(float f) {
        this.formToTextSpace = f;
    }

    public final float getStackSpace() {
        return this.stackSpace;
    }

    public final void setStackSpace(float f) {
        this.stackSpace = f;
    }

    public final float getMaxSizePercent() {
        return this.maxSizePercent;
    }

    public final void setMaxSizePercent(float f) {
        this.maxSizePercent = f;
    }

    public Legend(@NotNull LegendEntry[] entries) {
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        this();
        this.entries = entries;
    }

    public final void setEntries(@NotNull List<LegendEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Collection $this$toTypedArray$iv = entries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.entries = thisCollection$iv.toArray(new LegendEntry[0]);
    }

    public final float getMaximumEntryWidth(@NotNull Paint p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        float max = 0.0f;
        float maxFormSize = 0.0f;
        float formToTextSpace = UtilsKtKt.convertDpToPixel(this.formToTextSpace);
        for (LegendEntry entry : this.entries) {
            String label;
            float length;
            float formSize = UtilsKtKt.convertDpToPixel(Float.isNaN(entry.getFormSize()) ? this.formSize : entry.getFormSize());
            if (formSize > maxFormSize) {
                maxFormSize = formSize;
            }
            if (entry.getLabel() == null || !((length = (float)CanvasUtilsKt.calcTextWidth(p, label)) > max)) continue;
            max = length;
        }
        return max + maxFormSize + formToTextSpace;
    }

    public final float getMaximumEntryHeight(@NotNull Paint p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        float max = 0.0f;
        for (LegendEntry entry : this.entries) {
            float length;
            String label = entry.getLabel();
            if (label == null || !((length = (float)UtilsKtKt.calcTextHeight(p, label)) > max)) continue;
            max = length;
        }
        return max;
    }

    public final void setExtra(@NotNull List<LegendEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Collection $this$toTypedArray$iv = entries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.extraEntries = thisCollection$iv.toArray(new LegendEntry[0]);
    }

    public final void setExtra(@NotNull LegendEntry[] entries) {
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        this.extraEntries = entries;
    }

    public final void setExtra(@NotNull int[] colors, @NotNull String[] labels) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
        List entries = new ArrayList();
        int n = Math.min(colors.length, labels.length);
        for (int i = 0; i < n; ++i) {
            LegendEntry entry = new LegendEntry();
            entry.setFormColor(colors[i]);
            entry.setLabel(labels[i]);
            if (entry.getFormColor() == 1122868 || entry.getFormColor() == 0) {
                entry.setForm(LegendForm.NONE);
            } else if (entry.getFormColor() == 0x112233) {
                entry.setForm(LegendForm.EMPTY);
            }
            entries.add(entry);
        }
        Collection $this$toTypedArray$iv = entries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.extraEntries = thisCollection$iv.toArray(new LegendEntry[0]);
    }

    public final void setCustom(@NotNull LegendEntry[] entries) {
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        this.entries = entries;
        this.isLegendCustom = true;
    }

    public final void setCustom(@NotNull List<LegendEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Collection $this$toTypedArray$iv = entries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.entries = thisCollection$iv.toArray(new LegendEntry[0]);
        this.isLegendCustom = true;
    }

    public final void resetCustom() {
        this.isLegendCustom = false;
    }

    public final void setDrawInside(boolean value) {
        this.isDrawInsideEnabled = value;
    }

    public final float getNeededWidth() {
        return this.neededWidth;
    }

    public final void setNeededWidth(float f) {
        this.neededWidth = f;
    }

    public final float getNeededHeight() {
        return this.neededHeight;
    }

    public final void setNeededHeight(float f) {
        this.neededHeight = f;
    }

    public final float getMTextHeightMax() {
        return this.mTextHeightMax;
    }

    public final void setMTextHeightMax(float f) {
        this.mTextHeightMax = f;
    }

    public final float getMTextWidthMax() {
        return this.mTextWidthMax;
    }

    public final void setMTextWidthMax(float f) {
        this.mTextWidthMax = f;
    }

    public final boolean isWordWrapEnabled() {
        return this.isWordWrapEnabled;
    }

    public final void setWordWrapEnabled(boolean bl) {
        this.isWordWrapEnabled = bl;
    }

    @NotNull
    public final List<FSize> getCalculatedLabelSizes() {
        return this.calculatedLabelSizes;
    }

    @NotNull
    public final List<Boolean> getCalculatedLabelBreakPoints() {
        return this.calculatedLabelBreakPoints;
    }

    @NotNull
    public final List<FSize> getCalculatedLineSizes() {
        return this.calculatedLineSizes;
    }

    public final void calculateDimensions(@NotNull Paint labelpaint, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)labelpaint, (String)"labelpaint");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        float defaultFormSize = UtilsKtKt.convertDpToPixel(this.formSize);
        float stackSpace = UtilsKtKt.convertDpToPixel(this.stackSpace);
        float formToTextSpace = UtilsKtKt.convertDpToPixel(this.formToTextSpace);
        float xEntrySpace = UtilsKtKt.convertDpToPixel(this.xEntrySpace);
        float yEntrySpace = UtilsKtKt.convertDpToPixel(this.yEntrySpace);
        boolean wordWrapEnabled = this.isWordWrapEnabled;
        LegendEntry[] entries = this.entries;
        int entryCount = entries.length;
        this.mTextWidthMax = this.getMaximumEntryWidth(labelpaint);
        this.mTextHeightMax = this.getMaximumEntryHeight(labelpaint);
        switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: {
                float maxWidth = 0.0f;
                float maxHeight = 0.0f;
                float width = 0.0f;
                float labelLineHeight = UtilsKtKt.getLineHeight(labelpaint);
                boolean wasStacked = false;
                for (int i = 0; i < entryCount; ++i) {
                    LegendEntry e = entries[i];
                    boolean drawingForm = e.getForm() != LegendForm.NONE;
                    float formSize = Float.isNaN(e.getFormSize()) ? defaultFormSize : UtilsKtKt.convertDpToPixel(e.getFormSize());
                    String label = e.getLabel();
                    if (!wasStacked) {
                        width = 0.0f;
                    }
                    if (drawingForm) {
                        if (wasStacked) {
                            width += stackSpace;
                        }
                        width += formSize;
                    }
                    if (label != null) {
                        if (drawingForm && !wasStacked) {
                            width += formToTextSpace;
                        } else if (wasStacked) {
                            maxWidth = Math.max(maxWidth, width);
                            maxHeight += labelLineHeight + yEntrySpace;
                            width = 0.0f;
                            wasStacked = false;
                        }
                        width += (float)CanvasUtilsKt.calcTextWidth(labelpaint, label);
                        maxHeight += labelLineHeight + yEntrySpace;
                    } else {
                        wasStacked = true;
                        width += formSize;
                        if (i < entryCount - 1) {
                            width += stackSpace;
                        }
                    }
                    maxWidth = Math.max(maxWidth, width);
                }
                this.neededWidth = maxWidth;
                this.neededHeight = maxHeight;
                break;
            }
            case 2: {
                float labelLineHeight = UtilsKtKt.getLineHeight(labelpaint);
                float labelLineSpacing = UtilsKtKt.getLineSpacing(labelpaint) + yEntrySpace;
                float contentWidth = viewPortHandler.contentWidth() * this.maxSizePercent;
                float maxLineWidth = 0.0f;
                float currentLineWidth = 0.0f;
                float requiredWidth = 0.0f;
                int stackedStartIndex = -1;
                this.calculatedLabelBreakPoints.clear();
                this.calculatedLabelSizes.clear();
                this.calculatedLineSizes.clear();
                for (int i = 0; i < entryCount; ++i) {
                    LegendEntry e = entries[i];
                    boolean drawingForm = e.getForm() != LegendForm.NONE;
                    float formSize = Float.isNaN(e.getFormSize()) ? defaultFormSize : UtilsKtKt.convertDpToPixel(e.getFormSize());
                    String label = e.getLabel();
                    this.calculatedLabelBreakPoints.add(false);
                    requiredWidth = stackedStartIndex == -1 ? 0.0f : (requiredWidth += stackSpace);
                    if (label != null) {
                        this.calculatedLabelSizes.add(UtilsKtKt.calcTextSize(labelpaint, label));
                        requiredWidth += drawingForm ? formToTextSpace + formSize : 0.0f;
                        FSize fSize = this.calculatedLabelSizes.get(i);
                        Intrinsics.checkNotNull((Object)fSize);
                        requiredWidth += fSize.getWidth();
                    } else {
                        this.calculatedLabelSizes.add(FSize.Companion.getInstance(0.0f, 0.0f));
                        requiredWidth += drawingForm ? formSize : 0.0f;
                        if (stackedStartIndex == -1) {
                            stackedStartIndex = i;
                        }
                    }
                    if (label != null || i == entryCount - 1) {
                        float requiredSpacing;
                        float f = requiredSpacing = currentLineWidth == 0.0f ? 0.0f : xEntrySpace;
                        if (!wordWrapEnabled || currentLineWidth == 0.0f || contentWidth - currentLineWidth >= requiredSpacing + requiredWidth) {
                            currentLineWidth += requiredSpacing + requiredWidth;
                        } else {
                            this.calculatedLineSizes.add(FSize.Companion.getInstance(currentLineWidth, labelLineHeight));
                            maxLineWidth = Math.max(maxLineWidth, currentLineWidth);
                            this.calculatedLabelBreakPoints.set(stackedStartIndex > -1 ? stackedStartIndex : i, true);
                            currentLineWidth = requiredWidth;
                        }
                        if (i == entryCount - 1) {
                            this.calculatedLineSizes.add(FSize.Companion.getInstance(currentLineWidth, labelLineHeight));
                            maxLineWidth = Math.max(maxLineWidth, currentLineWidth);
                        }
                    }
                    stackedStartIndex = label != null ? -1 : stackedStartIndex;
                }
                this.neededWidth = maxLineWidth;
                this.neededHeight = labelLineHeight * (float)this.calculatedLineSizes.size() + labelLineSpacing * (float)(this.calculatedLineSizes.isEmpty() ? 0 : this.calculatedLineSizes.size() - 1);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.neededHeight += this.getMYOffset();
        this.neededWidth += this.getMXOffset();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Linfo/appdev/charting/components/Legend$LegendDirection;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT_TO_RIGHT", "RIGHT_TO_LEFT", "chartLib_release"})
    public static final class LegendDirection
    extends Enum<LegendDirection> {
        public static final /* enum */ LegendDirection LEFT_TO_RIGHT = new LegendDirection();
        public static final /* enum */ LegendDirection RIGHT_TO_LEFT = new LegendDirection();
        private static final /* synthetic */ LegendDirection[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LegendDirection[] values() {
            return (LegendDirection[])$VALUES.clone();
        }

        public static LegendDirection valueOf(String value) {
            return Enum.valueOf(LegendDirection.class, value);
        }

        @NotNull
        public static EnumEntries<LegendDirection> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = legendDirectionArray = new LegendDirection[]{LegendDirection.LEFT_TO_RIGHT, LegendDirection.RIGHT_TO_LEFT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Linfo/appdev/charting/components/Legend$LegendForm;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "EMPTY", "DEFAULT", "SQUARE", "CIRCLE", "LINE", "chartLib_release"})
    public static final class LegendForm
    extends Enum<LegendForm> {
        public static final /* enum */ LegendForm NONE = new LegendForm();
        public static final /* enum */ LegendForm EMPTY = new LegendForm();
        public static final /* enum */ LegendForm DEFAULT = new LegendForm();
        public static final /* enum */ LegendForm SQUARE = new LegendForm();
        public static final /* enum */ LegendForm CIRCLE = new LegendForm();
        public static final /* enum */ LegendForm LINE = new LegendForm();
        private static final /* synthetic */ LegendForm[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LegendForm[] values() {
            return (LegendForm[])$VALUES.clone();
        }

        public static LegendForm valueOf(String value) {
            return Enum.valueOf(LegendForm.class, value);
        }

        @NotNull
        public static EnumEntries<LegendForm> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = legendFormArray = new LegendForm[]{LegendForm.NONE, LegendForm.EMPTY, LegendForm.DEFAULT, LegendForm.SQUARE, LegendForm.CIRCLE, LegendForm.LINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Linfo/appdev/charting/components/Legend$LegendHorizontalAlignment;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT", "CENTER", "RIGHT", "chartLib_release"})
    public static final class LegendHorizontalAlignment
    extends Enum<LegendHorizontalAlignment> {
        public static final /* enum */ LegendHorizontalAlignment LEFT = new LegendHorizontalAlignment();
        public static final /* enum */ LegendHorizontalAlignment CENTER = new LegendHorizontalAlignment();
        public static final /* enum */ LegendHorizontalAlignment RIGHT = new LegendHorizontalAlignment();
        private static final /* synthetic */ LegendHorizontalAlignment[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LegendHorizontalAlignment[] values() {
            return (LegendHorizontalAlignment[])$VALUES.clone();
        }

        public static LegendHorizontalAlignment valueOf(String value) {
            return Enum.valueOf(LegendHorizontalAlignment.class, value);
        }

        @NotNull
        public static EnumEntries<LegendHorizontalAlignment> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = legendHorizontalAlignmentArray = new LegendHorizontalAlignment[]{LegendHorizontalAlignment.LEFT, LegendHorizontalAlignment.CENTER, LegendHorizontalAlignment.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Linfo/appdev/charting/components/Legend$LegendOrientation;", "", "<init>", "(Ljava/lang/String;I)V", "HORIZONTAL", "VERTICAL", "chartLib_release"})
    public static final class LegendOrientation
    extends Enum<LegendOrientation> {
        public static final /* enum */ LegendOrientation HORIZONTAL = new LegendOrientation();
        public static final /* enum */ LegendOrientation VERTICAL = new LegendOrientation();
        private static final /* synthetic */ LegendOrientation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LegendOrientation[] values() {
            return (LegendOrientation[])$VALUES.clone();
        }

        public static LegendOrientation valueOf(String value) {
            return Enum.valueOf(LegendOrientation.class, value);
        }

        @NotNull
        public static EnumEntries<LegendOrientation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = legendOrientationArray = new LegendOrientation[]{LegendOrientation.HORIZONTAL, LegendOrientation.VERTICAL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Linfo/appdev/charting/components/Legend$LegendVerticalAlignment;", "", "<init>", "(Ljava/lang/String;I)V", "TOP", "CENTER", "BOTTOM", "chartLib_release"})
    public static final class LegendVerticalAlignment
    extends Enum<LegendVerticalAlignment> {
        public static final /* enum */ LegendVerticalAlignment TOP = new LegendVerticalAlignment();
        public static final /* enum */ LegendVerticalAlignment CENTER = new LegendVerticalAlignment();
        public static final /* enum */ LegendVerticalAlignment BOTTOM = new LegendVerticalAlignment();
        private static final /* synthetic */ LegendVerticalAlignment[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LegendVerticalAlignment[] values() {
            return (LegendVerticalAlignment[])$VALUES.clone();
        }

        public static LegendVerticalAlignment valueOf(String value) {
            return Enum.valueOf(LegendVerticalAlignment.class, value);
        }

        @NotNull
        public static EnumEntries<LegendVerticalAlignment> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = legendVerticalAlignmentArray = new LegendVerticalAlignment[]{LegendVerticalAlignment.TOP, LegendVerticalAlignment.CENTER, LegendVerticalAlignment.BOTTOM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LegendOrientation.values().length];
            try {
                nArray[LegendOrientation.VERTICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegendOrientation.HORIZONTAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

