/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import info.appdev.charting.charts.BarLineChartBase;
import info.appdev.charting.components.IMarker;
import info.appdev.charting.data.BarData;
import info.appdev.charting.data.BubbleData;
import info.appdev.charting.data.CandleData;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.CombinedData;
import info.appdev.charting.data.Entry;
import info.appdev.charting.data.LineData;
import info.appdev.charting.data.ScatterData;
import info.appdev.charting.highlight.CombinedHighlighter;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.highlight.IHighlighter;
import info.appdev.charting.interfaces.dataprovider.CombinedDataProvider;
import info.appdev.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import info.appdev.charting.interfaces.datasets.IDataSet;
import info.appdev.charting.renderer.CombinedChartRenderer;
import info.appdev.charting.renderer.DataRenderer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001MB\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0006\u0010\nB%\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\rJ\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u0012\u0010#\u001a\u00020\u001f2\b\u0010$\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J\u000e\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020\u000fJ\u000e\u0010@\u001a\u00020\u001f2\u0006\u0010A\u001a\u00020\u000fJ\u0010\u0010F\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020HH\u0014R\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0010\"\u0004\b\u0016\u0010\u0012R\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010 \u001a\u0004\u0018\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0016\u0010*\u001a\u0004\u0018\u00010+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0016\u0010.\u001a\u0004\u0018\u00010/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0016\u00102\u001a\u0004\u0018\u0001038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u0004\u0018\u0001078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0016\u0010:\u001a\u0004\u0018\u00010;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R4\u0010C\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u000e\u0010B\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010\u001b\"\u0004\bE\u0010\u001dR\u0014\u0010I\u001a\u00020J8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006N"}, d2={"Linfo/appdev/charting/charts/CombinedChart;", "Linfo/appdev/charting/charts/BarLineChartBase;", "Linfo/appdev/charting/data/CombinedData;", "Linfo/appdev/charting/interfaces/dataprovider/CombinedDataProvider;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "isDrawValueAboveBarEnabled", "", "()Z", "setDrawValueAboveBarEnabled", "(Z)V", "isHighlightFullBarEnabled", "setHighlightFullBarEnabled", "isDrawBarShadowEnabled", "setDrawBarShadowEnabled", "mDrawOrder", "", "Linfo/appdev/charting/charts/CombinedChart$DrawOrder;", "getMDrawOrder", "()Ljava/util/List;", "setMDrawOrder", "(Ljava/util/List;)V", "init", "", "combinedData", "getCombinedData", "()Linfo/appdev/charting/data/CombinedData;", "setData", "data", "getHighlightByTouchPoint", "Linfo/appdev/charting/highlight/Highlight;", "x", "", "y", "lineData", "Linfo/appdev/charting/data/LineData;", "getLineData", "()Linfo/appdev/charting/data/LineData;", "barData", "Linfo/appdev/charting/data/BarData;", "getBarData", "()Linfo/appdev/charting/data/BarData;", "scatterData", "Linfo/appdev/charting/data/ScatterData;", "getScatterData", "()Linfo/appdev/charting/data/ScatterData;", "candleData", "Linfo/appdev/charting/data/CandleData;", "getCandleData", "()Linfo/appdev/charting/data/CandleData;", "bubbleData", "Linfo/appdev/charting/data/BubbleData;", "getBubbleData", "()Linfo/appdev/charting/data/BubbleData;", "setDrawValueAboveBar", "enabled", "setDrawBarShadow", "value", "order", "drawOrder", "getDrawOrder", "setDrawOrder", "drawMarkers", "canvas", "Landroid/graphics/Canvas;", "accessibilityDescription", "", "getAccessibilityDescription", "()Ljava/lang/String;", "DrawOrder", "chartLib_release"})
public class CombinedChart
extends BarLineChartBase<CombinedData>
implements CombinedDataProvider {
    private boolean isDrawValueAboveBarEnabled = true;
    private boolean isHighlightFullBarEnabled;
    private boolean isDrawBarShadowEnabled;
    @Nullable
    private List<DrawOrder> mDrawOrder;

    @Override
    public boolean isDrawValueAboveBarEnabled() {
        return this.isDrawValueAboveBarEnabled;
    }

    @Override
    public void setDrawValueAboveBarEnabled(boolean bl) {
        this.isDrawValueAboveBarEnabled = bl;
    }

    @Override
    public boolean isHighlightFullBarEnabled() {
        return this.isHighlightFullBarEnabled;
    }

    @Override
    public void setHighlightFullBarEnabled(boolean bl) {
        this.isHighlightFullBarEnabled = bl;
    }

    @Override
    public boolean isDrawBarShadowEnabled() {
        return this.isDrawBarShadowEnabled;
    }

    @Override
    public void setDrawBarShadowEnabled(boolean bl) {
        this.isDrawBarShadowEnabled = bl;
    }

    @Nullable
    protected final List<DrawOrder> getMDrawOrder() {
        return this.mDrawOrder;
    }

    protected final void setMDrawOrder(@Nullable List<DrawOrder> list) {
        this.mDrawOrder = list;
    }

    public CombinedChart(@Nullable Context context) {
        super(context);
    }

    public CombinedChart(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CombinedChart(@Nullable Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        DrawOrder[] drawOrderArray = new DrawOrder[]{DrawOrder.BAR, DrawOrder.BUBBLE, DrawOrder.LINE, DrawOrder.CANDLE, DrawOrder.SCATTER};
        this.mDrawOrder = CollectionsKt.mutableListOf((Object[])drawOrderArray);
        this.setHighlighter(new CombinedHighlighter(this, this));
        this.setHighlightFullBarEnabled(true);
        this.setMRenderer(new CombinedChartRenderer(this, this.getMAnimator(), this.getViewPortHandler()));
    }

    @Override
    @Nullable
    public CombinedData getCombinedData() {
        return (CombinedData)this.getMData();
    }

    @Override
    public void setData(@Nullable CombinedData data) {
        block0: {
            super.setData((ChartData)data);
            this.setHighlighter(new CombinedHighlighter(this, this));
            DataRenderer dataRenderer = this.getMRenderer();
            Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type info.appdev.charting.renderer.CombinedChartRenderer");
            ((CombinedChartRenderer)dataRenderer).createRenderers();
            DataRenderer dataRenderer2 = this.getMRenderer();
            if (dataRenderer2 == null) break block0;
            dataRenderer2.initBuffers();
        }
    }

    @Override
    @Nullable
    public Highlight getHighlightByTouchPoint(float x, float y) {
        if (this.getMData() == null) {
            Timber.Forest.e("Can't select by touch. No data set.", new Object[0]);
            return null;
        }
        IHighlighter iHighlighter = this.getHighlighter();
        if (iHighlighter != null) {
            IHighlighter it = iHighlighter;
            boolean bl = false;
            Highlight highlight = it.getHighlight(x, y);
            if (highlight == null || !this.isHighlightFullBarEnabled()) {
                return highlight;
            }
            return new Highlight(highlight.getX(), highlight.getY(), highlight.getXPx(), highlight.getYPx(), highlight.getDataSetIndex(), -1, highlight.getAxis());
        }
        return null;
    }

    @Override
    @Nullable
    public LineData getLineData() {
        if (this.getMData() == null) {
            return null;
        }
        Object t = this.getMData();
        Intrinsics.checkNotNull(t);
        LineData lineData = ((CombinedData)t).getLineData();
        Intrinsics.checkNotNull((Object)lineData);
        return lineData;
    }

    @Override
    @Nullable
    public BarData getBarData() {
        if (this.getMData() == null) {
            return null;
        }
        Object t = this.getMData();
        Intrinsics.checkNotNull(t);
        return ((CombinedData)t).getBarData();
    }

    @Override
    @Nullable
    public ScatterData getScatterData() {
        if (this.getMData() == null) {
            return null;
        }
        Object t = this.getMData();
        Intrinsics.checkNotNull(t);
        return ((CombinedData)t).getScatterData();
    }

    @Override
    @Nullable
    public CandleData getCandleData() {
        if (this.getMData() == null) {
            return null;
        }
        Object t = this.getMData();
        Intrinsics.checkNotNull(t);
        return ((CombinedData)t).getCandleData();
    }

    @Override
    @Nullable
    public BubbleData getBubbleData() {
        if (this.getMData() == null) {
            return null;
        }
        Object t = this.getMData();
        Intrinsics.checkNotNull(t);
        return ((CombinedData)t).getBubbleData();
    }

    public final void setDrawValueAboveBar(boolean enabled) {
        this.setDrawValueAboveBarEnabled(enabled);
    }

    public final void setDrawBarShadow(boolean value) {
        this.setDrawBarShadowEnabled(value);
    }

    @Nullable
    public final List<DrawOrder> getDrawOrder() {
        return this.mDrawOrder;
    }

    public final void setDrawOrder(@Nullable List<DrawOrder> order) {
        if (order == null || order.isEmpty()) {
            return;
        }
        this.mDrawOrder = order;
    }

    @Override
    protected void drawMarkers(@NotNull Canvas canvas) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (!this.isDrawMarkersEnabled() || !this.valuesToHighlight()) {
                return;
            }
            Highlight[] highlightArray = this.getHighlighted();
            if (highlightArray == null) break block2;
            Highlight[] it = highlightArray;
            boolean bl = false;
            int n = it.length;
            for (int i = 0; i < n; ++i) {
                IDataSet set;
                int entryIndex;
                Highlight highlight = it[i];
                Object t = this.getMData();
                Intrinsics.checkNotNull(t);
                IBarLineScatterCandleBubbleDataSet<? extends Entry> dataset = ((CombinedData)t).getDataSetByHighlight(highlight);
                Object t2 = this.getMData();
                Intrinsics.checkNotNull(t2);
                Entry e = ((CombinedData)t2).getEntryForHighlight(highlight);
                if (e == null || dataset == null || (float)(entryIndex = (set = (IDataSet)dataset).getEntryIndex(e)) > (float)set.getEntryCount() * this.getMAnimator().getPhaseX()) continue;
                float[] pos = this.getMarkerPosition(highlight);
                if (!this.getViewPortHandler().isInBounds(pos[0], pos[1]) || this.getMarker().isEmpty()) continue;
                IMarker markerItem = this.getMarker().get(i % this.getMarker().size());
                markerItem.refreshContent(e, highlight);
                markerItem.draw(canvas, pos[0], pos[1]);
            }
        }
    }

    @Override
    @NotNull
    public String getAccessibilityDescription() {
        return "This is a combined chart";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Linfo/appdev/charting/charts/CombinedChart$DrawOrder;", "", "<init>", "(Ljava/lang/String;I)V", "BAR", "BUBBLE", "LINE", "CANDLE", "SCATTER", "chartLib_release"})
    public static final class DrawOrder
    extends Enum<DrawOrder> {
        public static final /* enum */ DrawOrder BAR = new DrawOrder();
        public static final /* enum */ DrawOrder BUBBLE = new DrawOrder();
        public static final /* enum */ DrawOrder LINE = new DrawOrder();
        public static final /* enum */ DrawOrder CANDLE = new DrawOrder();
        public static final /* enum */ DrawOrder SCATTER = new DrawOrder();
        private static final /* synthetic */ DrawOrder[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DrawOrder[] values() {
            return (DrawOrder[])$VALUES.clone();
        }

        public static DrawOrder valueOf(String value) {
            return Enum.valueOf(DrawOrder.class, value);
        }

        @NotNull
        public static EnumEntries<DrawOrder> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = drawOrderArray = new DrawOrder[]{DrawOrder.BAR, DrawOrder.BUBBLE, DrawOrder.LINE, DrawOrder.CANDLE, DrawOrder.SCATTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

