/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PathEffect;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.RadarData;
import com.github.mikephil.charting.interfaces.datasets.IRadarDataSet;
import com.github.mikephil.charting.renderer.YAxisRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/mikephil/charting/renderer/YAxisRendererRadarChart;", "Lcom/github/mikephil/charting/renderer/YAxisRenderer;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "yAxis", "Lcom/github/mikephil/charting/components/YAxis;", "chart", "Lcom/github/mikephil/charting/charts/RadarChart;", "<init>", "(Lcom/github/mikephil/charting/utils/ViewPortHandler;Lcom/github/mikephil/charting/components/YAxis;Lcom/github/mikephil/charting/charts/RadarChart;)V", "renderLimitLinesPathBuffer", "Landroid/graphics/Path;", "computeAxisValues", "", "min", "", "max", "renderAxisLabels", "canvas", "Landroid/graphics/Canvas;", "renderLimitLines", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nYAxisRendererRadarChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAxisRendererRadarChart.kt\ncom/github/mikephil/charting/renderer/YAxisRendererRadarChart\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public final class YAxisRendererRadarChart
extends YAxisRenderer {
    @NotNull
    private final RadarChart chart;
    @NotNull
    private final Path renderLimitLinesPathBuffer;

    public YAxisRendererRadarChart(@NotNull ViewPortHandler viewPortHandler, @NotNull YAxis yAxis, @NotNull RadarChart chart) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)yAxis, (String)"yAxis");
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(viewPortHandler, yAxis, null);
        this.chart = chart;
        this.renderLimitLinesPathBuffer = new Path();
    }

    @Override
    protected void computeAxisValues(float min, float max) {
        boolean centeringEnabled;
        int n;
        double intervalMagnitude;
        int intervalSigDigit;
        int labelCount = this.axis.getLabelCount();
        double range = Math.abs((double)(max - min));
        if (labelCount == 0 || range <= 0.0 || Double.isInfinite(range)) {
            this.axis.setEntries(new float[0]);
            this.axis.setCenteredEntries(new float[0]);
            this.axis.entryCount = 0;
            return;
        }
        double rawInterval = range / (double)labelCount;
        double interval = UtilsKtKt.roundToNextSignificant(rawInterval);
        if (this.axis.isGranularityEnabled()) {
            double d = interval = interval < (double)this.axis.getGranularity() ? (double)this.axis.getGranularity() : interval;
        }
        if ((intervalSigDigit = (int)(interval / (intervalMagnitude = (double)UtilsKtKt.roundToNextSignificant(Math.pow(10.0, (int)Math.log10(interval)))))) > 5) {
            interval = Math.floor(10.0 * intervalMagnitude) == 0.0 ? interval : Math.floor(10.0 * intervalMagnitude);
        }
        int n2 = n = (centeringEnabled = this.axis.isCenterAxisLabelsEnabled()) ? 1 : 0;
        if (this.axis.isForceLabelsEnabled()) {
            float step = (float)range / (float)(labelCount - 1);
            this.axis.entryCount = labelCount;
            if (this.axis.getEntries().length < labelCount) {
                this.axis.setEntries(new float[labelCount]);
            }
            float v = min;
            for (int i = 0; i < labelCount; ++i) {
                this.axis.getEntries()[i] = v;
                v += step;
            }
            n = labelCount;
        } else {
            double first;
            double d = first = interval == 0.0 ? 0.0 : Math.ceil((double)min / interval) * interval;
            if (centeringEnabled) {
                first -= interval;
            }
            double last = interval == 0.0 ? 0.0 : Math.nextUp(Math.floor((double)max / interval) * interval);
            double f = 0.0;
            if (!(interval == 0.0)) {
                for (f = first; f <= last; f += interval) {
                    ++n;
                }
            }
            this.axis.entryCount = ++n;
            if (this.axis.getEntries().length < n) {
                this.axis.setEntries(new float[n]);
            }
            f = first;
            for (int i = 0; i < n; ++i) {
                if (f == 0.0) {
                    f = 0.0;
                }
                this.axis.getEntries()[i] = (float)f;
                f += interval;
            }
        }
        if (interval < 1.0) {
            this.axis.setMDecimals((int)Math.ceil(-Math.log10(interval)));
        } else {
            this.axis.setMDecimals(0);
        }
        if (centeringEnabled) {
            if (this.axis.getCenteredEntries().length < n) {
                this.axis.setCenteredEntries(new float[n]);
            }
            float offset = (this.axis.getEntries()[1] - this.axis.getEntries()[0]) / 2.0f;
            int n3 = n;
            for (int i = 0; i < n3; ++i) {
                this.axis.getCenteredEntries()[i] = this.axis.getEntries()[i] + offset;
            }
        }
        this.axis.mAxisMinimum = this.axis.getEntries()[0];
        this.axis.mAxisMaximum = this.axis.getEntries()[n - 1];
        this.axis.mAxisRange = (float)Math.abs((double)(this.axis.mAxisMaximum - this.axis.mAxisMinimum));
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.yAxis.isEnabled() || !this.yAxis.isDrawLabelsEnabled()) {
            return;
        }
        this.getPaintAxisLabels().setTypeface(this.yAxis.getTypeface());
        this.getPaintAxisLabels().setTextSize(this.yAxis.getTextSize());
        this.getPaintAxisLabels().setColor(this.yAxis.getTextColor());
        MPPointF center = this.chart.getCenterOffsets();
        MPPointF pOut = MPPointF.Companion.getInstance(0.0f, 0.0f);
        float factor = this.chart.getFactor();
        int from = this.yAxis.isDrawBottomYLabelEntryEnabled() ? 0 : 1;
        int to = this.yAxis.isDrawTopYLabelEntryEnabled() ? this.yAxis.entryCount : this.yAxis.entryCount - 1;
        float xOffset = this.yAxis.getLabelXOffset();
        for (int j = from; j < to; ++j) {
            String it;
            float r = (this.yAxis.getEntries()[j] - this.yAxis.mAxisMinimum) * factor;
            Utils.INSTANCE.getPosition(center, r, this.chart.getRotationAngle(), pOut);
            String label = this.yAxis.getFormattedLabel(j);
            if (label == null) continue;
            boolean bl = false;
            canvas.drawText(it, pOut.getX() + xOffset, pOut.getY(), this.getPaintAxisLabels());
        }
        MPPointF.Companion.recycleInstance(center);
        MPPointF.Companion.recycleInstance(pOut);
    }

    @Override
    public void renderLimitLines(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        List<LimitLine> limitLines = this.yAxis.getLimitLines();
        float sliceAngle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        MPPointF center = this.chart.getCenterOffsets();
        MPPointF pOut = MPPointF.Companion.getInstance(0.0f, 0.0f);
        int n = ((Collection)limitLines).size();
        for (int i = 0; i < n; ++i) {
            LimitLine limitLine = limitLines.get(i);
            if (!limitLine.isEnabled()) continue;
            this.limitLinePaint.setColor(limitLine.getLineColor());
            this.limitLinePaint.setPathEffect((PathEffect)limitLine.getDashPathEffect());
            this.limitLinePaint.setStrokeWidth(limitLine.getLineWidth());
            float r = (limitLine.getLimit() - this.chart.getYChartMin()) * factor;
            Path limitPath = this.renderLimitLinesPathBuffer;
            limitPath.reset();
            Object t = this.chart.getData();
            Intrinsics.checkNotNull(t);
            if ((IRadarDataSet)((RadarData)t).getMaxEntryCountSet() != null) {
                IRadarDataSet maxEntryCountSet;
                boolean bl = false;
                int n2 = maxEntryCountSet.getEntryCount();
                for (int j = 0; j < n2; ++j) {
                    Utils.INSTANCE.getPosition(center, r, sliceAngle * (float)j + this.chart.getRotationAngle(), pOut);
                    if (j == 0) {
                        limitPath.moveTo(pOut.getX(), pOut.getY());
                        continue;
                    }
                    limitPath.lineTo(pOut.getX(), pOut.getY());
                }
            }
            limitPath.close();
            canvas.drawPath(limitPath, this.limitLinePaint);
        }
        MPPointF.Companion.recycleInstance(center);
        MPPointF.Companion.recycleInstance(pOut);
    }
}

