/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Range;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarLineScatterCandleBubbleRenderer;
import com.github.mikephil.charting.utils.Fill;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J0\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J#\u0010,\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0016\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020\u0010H\u0014J\u0010\u00104\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00108\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00128\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u00158\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00158\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/github/mikephil/charting/renderer/BarChartRenderer;", "Lcom/github/mikephil/charting/renderer/BarLineScatterCandleBubbleRenderer;", "dataProvider", "Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "mDrawRoundedBars", "", "mRoundedBarRadius", "", "(Lcom/github/mikephil/charting/interfaces/dataprovider/BarDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;ZF)V", "barRect", "Landroid/graphics/RectF;", "barBuffers", "", "Lcom/github/mikephil/charting/buffer/BarBuffer;", "shadowPaint", "Landroid/graphics/Paint;", "barBorderPaint", "drawRoundedBars", "roundedBarRadius", "initBuffers", "", "drawData", "canvas", "Landroid/graphics/Canvas;", "barShadowRectBuffer", "drawDataSet", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/IBarDataSet;", "index", "", "prepareBarHighlight", "x", "y1", "y2", "barWidthHalf", "trans", "Lcom/github/mikephil/charting/utils/Transformer;", "drawValues", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "setHighlightDrawPos", "high", "bar", "drawExtras", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nBarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarChartRenderer.kt\ncom/github/mikephil/charting/renderer/BarChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,562:1\n1915#2,2:563\n1#3:565\n*S KotlinDebug\n*F\n+ 1 BarChartRenderer.kt\ncom/github/mikephil/charting/renderer/BarChartRenderer\n*L\n63#1:563,2\n*E\n"})
public class BarChartRenderer
extends BarLineScatterCandleBubbleRenderer {
    @JvmField
    @NotNull
    public BarDataProvider dataProvider;
    @JvmField
    @NotNull
    protected RectF barRect;
    @JvmField
    @NotNull
    protected List<BarBuffer> barBuffers;
    @JvmField
    @NotNull
    protected Paint shadowPaint;
    @JvmField
    @NotNull
    protected Paint barBorderPaint;
    private boolean drawRoundedBars;
    private float roundedBarRadius;
    @NotNull
    private final RectF barShadowRectBuffer;

    public BarChartRenderer(@NotNull BarDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataProvider = dataProvider;
        this.barRect = new RectF();
        this.barBuffers = new ArrayList();
        this.barShadowRectBuffer = new RectF();
        this.setPaintHighlight(new Paint(1));
        this.getPaintHighlight().setStyle(Paint.Style.FILL);
        this.getPaintHighlight().setColor(Color.rgb((int)0, (int)0, (int)0));
        this.getPaintHighlight().setAlpha(120);
        this.shadowPaint = new Paint(1);
        this.shadowPaint.setStyle(Paint.Style.FILL);
        this.barBorderPaint = new Paint(1);
        this.barBorderPaint.setStyle(Paint.Style.STROKE);
    }

    public BarChartRenderer(@NotNull BarDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler, boolean mDrawRoundedBars, float mRoundedBarRadius) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        this(dataProvider, animator, viewPortHandler);
        this.drawRoundedBars = mDrawRoundedBars;
        this.roundedBarRadius = mRoundedBarRadius;
    }

    @Override
    public void initBuffers() {
        block1: {
            BarData barData = this.dataProvider.getBarData();
            this.barBuffers = new ArrayList();
            Object object = barData;
            if (object == null || (object = ((ChartData)object).getDataSets()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IBarDataSet it = (IBarDataSet)element$iv;
                boolean bl = false;
                this.barBuffers.add(new BarBuffer(it.getEntryCount() * 4 * (it.isStacked() ? it.getStackSize() : 1), barData.getDataSetCount(), it.isStacked()));
            }
        }
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (this.barBuffers.isEmpty()) {
                this.initBuffers();
            }
            BarData barData = this.dataProvider.getBarData();
            if (barData == null) break block2;
            BarData barData2 = barData;
            boolean bl = false;
            int n = barData2.getDataSetCount();
            for (int i = 0; i < n; ++i) {
                IBarDataSet it;
                IBarDataSet dataSet = (IBarDataSet)barData2.getDataSetByIndex(i);
                if (dataSet == null) continue;
                boolean bl2 = false;
                if (!it.isVisible()) continue;
                this.drawDataSet(canvas, it, i);
            }
        }
    }

    protected void drawDataSet(@NotNull Canvas canvas, @NotNull IBarDataSet dataSet, int index) {
        BarBuffer barBuffer;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        this.barBorderPaint.setColor(dataSet.getBarBorderColor());
        this.barBorderPaint.setStrokeWidth(UtilsKtKt.convertDpToPixel(dataSet.getBarBorderWidth()));
        boolean drawBorder = dataSet.getBarBorderWidth() > 0.0f;
        float phaseX = this.animator.getPhaseX();
        float phaseY = this.animator.getPhaseY();
        if (this.dataProvider.isDrawBarShadowEnabled()) {
            this.shadowPaint.setColor(dataSet.getBarShadowColor());
            BarData barData = this.dataProvider.getBarData();
            if (barData != null) {
                BarData barData2 = barData;
                boolean bl = false;
                float barWidth = barData2.getBarWidth();
                float barWidthHalf = barWidth / 2.0f;
                float x = 0.0f;
                int i = 0;
                int count = (int)Math.min((double)((int)Math.ceil((float)dataSet.getEntryCount() * phaseX)), (double)dataSet.getEntryCount());
                while (i < count) {
                    BarEntry barEntry = (BarEntry)dataSet.getEntryForIndex(i);
                    if (barEntry != null) {
                        boolean bl2 = false;
                        x = barEntry.getX();
                        this.barShadowRectBuffer.left = x - barWidthHalf;
                        this.barShadowRectBuffer.right = x + barWidthHalf;
                        Transformer transformer = trans;
                        Intrinsics.checkNotNull((Object)transformer);
                        transformer.rectValueToPixel(this.barShadowRectBuffer);
                    }
                    if (!this.viewPortHandler.isInBoundsLeft(this.barShadowRectBuffer.right)) {
                        ++i;
                        continue;
                    }
                    if (this.viewPortHandler.isInBoundsRight(this.barShadowRectBuffer.left)) {
                        this.barShadowRectBuffer.top = this.viewPortHandler.contentTop();
                        this.barShadowRectBuffer.bottom = this.viewPortHandler.contentBottom();
                        if (this.drawRoundedBars) {
                            canvas.drawRoundRect(this.barShadowRectBuffer, this.roundedBarRadius, this.roundedBarRadius, this.shadowPaint);
                        } else {
                            canvas.drawRect(this.barShadowRectBuffer, this.shadowPaint);
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        }
        BarBuffer barBuffer2 = this.barBuffers.get(index);
        Intrinsics.checkNotNull((Object)barBuffer2);
        BarBuffer $this$drawDataSet_u24lambda_u241 = barBuffer = barBuffer2;
        boolean bl = false;
        $this$drawDataSet_u24lambda_u241.setPhases(phaseX, phaseY);
        $this$drawDataSet_u24lambda_u241.setDataSet(index);
        $this$drawDataSet_u24lambda_u241.setInverted(this.dataProvider.isInverted(dataSet.getAxisDependency()));
        BarData barData = this.dataProvider.getBarData();
        if (barData != null) {
            BarData it = barData;
            boolean bl3 = false;
            $this$drawDataSet_u24lambda_u241.setBarWidth(it.getBarWidth());
        }
        $this$drawDataSet_u24lambda_u241.feed(dataSet);
        BarBuffer buffer = barBuffer;
        Transformer transformer = trans;
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pointValuesToPixel(buffer.buffer);
        boolean isCustomFill = !((Collection)dataSet.getFills()).isEmpty();
        boolean isSingleColor = dataSet.getColors().size() == 1;
        boolean isInverted = this.dataProvider.isInverted(dataSet.getAxisDependency());
        if (isSingleColor) {
            this.getPaintRender().setColor(dataSet.getColor());
        }
        int j = 0;
        int pos = 0;
        while (j < buffer.size()) {
            if (!this.viewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) {
                j += 4;
                ++pos;
                continue;
            }
            if (!this.viewPortHandler.isInBoundsRight(buffer.buffer[j])) break;
            if (!isSingleColor) {
                this.getPaintRender().setColor(dataSet.getColorByIndex(pos));
            }
            if (isCustomFill) {
                Fill fill = dataSet.getFill(pos);
                if (fill != null) {
                    fill.fillRect(canvas, this.getPaintRender(), buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], isInverted ? Fill.Direction.DOWN : Fill.Direction.UP, this.roundedBarRadius);
                }
            } else if (this.drawRoundedBars) {
                canvas.drawRoundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedBarRadius, this.roundedBarRadius, this.getPaintRender());
            } else {
                canvas.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.getPaintRender());
            }
            if (drawBorder) {
                if (this.drawRoundedBars) {
                    canvas.drawRoundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedBarRadius, this.roundedBarRadius, this.barBorderPaint);
                } else {
                    canvas.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.barBorderPaint);
                }
            }
            j += 4;
            ++pos;
        }
    }

    protected void prepareBarHighlight(float x, float y1, float y2, float barWidthHalf, @NotNull Transformer trans) {
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        float left = x - barWidthHalf;
        float right = x + barWidthHalf;
        this.barRect.set(left, y1, right, y2);
        trans.rectToPixelPhase(this.barRect, this.animator.getPhaseY());
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        block22: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (!this.isDrawingValuesAllowed(this.dataProvider)) break block22;
            BarData barData = this.dataProvider.getBarData();
            List dataSets = barData != null ? barData.getDataSets() : null;
            float valueOffsetPlus = UtilsKtKt.convertDpToPixel(4.5f);
            float posOffset = 0.0f;
            float negOffset = 0.0f;
            boolean drawValueAboveBar = this.dataProvider.isDrawValueAboveBarEnabled();
            BarData barData2 = this.dataProvider.getBarData();
            if (barData2 == null) break block22;
            BarData barData3 = barData2;
            boolean bl = false;
            int n = barData3.getDataSetCount();
            for (int i = 0; i < n; ++i) {
                MPPointF iconsOffset;
                block21: {
                    List list = dataSets;
                    Intrinsics.checkNotNull(list);
                    IBarDataSet dataSet = (IBarDataSet)list.get(i);
                    if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet)) continue;
                    this.applyValueTextStyle(dataSet);
                    boolean isInverted = this.dataProvider.isInverted(dataSet.getAxisDependency());
                    float valueTextHeight = Utils.INSTANCE.calcTextHeight(this.getPaintValues(), "8");
                    posOffset = drawValueAboveBar ? -valueOffsetPlus : valueTextHeight + valueOffsetPlus;
                    float f = negOffset = drawValueAboveBar ? valueTextHeight + valueOffsetPlus : -valueOffsetPlus;
                    if (isInverted) {
                        posOffset = -posOffset - valueTextHeight;
                        negOffset = -negOffset - valueTextHeight;
                    }
                    BarBuffer buffer = this.barBuffers.get(i);
                    float phaseY = this.animator.getPhaseY();
                    iconsOffset = MPPointF.Companion.getInstance(dataSet.getIconsOffset());
                    iconsOffset.setX(UtilsKtKt.convertDpToPixel(iconsOffset.getX()));
                    iconsOffset.setY(UtilsKtKt.convertDpToPixel(iconsOffset.getY()));
                    if (!dataSet.isStacked()) {
                        int j = 0;
                        while (true) {
                            float x;
                            float f2 = j;
                            BarBuffer barBuffer = buffer;
                            Intrinsics.checkNotNull((Object)barBuffer);
                            if (!(f2 < (float)barBuffer.buffer.length * this.animator.getPhaseX()) || !this.viewPortHandler.isInBoundsRight(x = (buffer.buffer[j] + buffer.buffer[j + 2]) / 2.0f)) break block21;
                            if (!this.viewPortHandler.isInBoundsY(buffer.buffer[j + 1]) || !this.viewPortHandler.isInBoundsLeft(x)) {
                                j += 4;
                                continue;
                            }
                            BarEntry barEntry = (BarEntry)dataSet.getEntryForIndex(j / 4);
                            if (barEntry != null) {
                                boolean bl2 = false;
                                float value = barEntry.getY();
                                if (dataSet.isDrawValues()) {
                                    this.drawValue(canvas, dataSet.getValueFormatter(), value, barEntry, i, x, value >= 0.0f ? buffer.buffer[j + 1] + posOffset : buffer.buffer[j + 3] + negOffset, dataSet.getValueTextColor(j / 4));
                                }
                                if (barEntry.getIcon() != null && dataSet.isDrawIcons()) {
                                    Drawable icon = barEntry.getIcon();
                                    float px = 0.0f;
                                    px = x;
                                    float py = 0.0f;
                                    py = value >= 0.0f ? buffer.buffer[j + 1] + posOffset : buffer.buffer[j + 3] + negOffset;
                                    px += iconsOffset.getX();
                                    py += iconsOffset.getY();
                                    if (icon != null) {
                                        Drawable it;
                                        boolean bl3 = false;
                                        Utils.INSTANCE.drawImage(canvas, it, (int)px, (int)py);
                                    }
                                }
                            }
                            j += 4;
                        }
                    }
                    Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
                    int bufferIndex = 0;
                    int index = 0;
                    while ((float)index < (float)dataSet.getEntryCount() * this.animator.getPhaseX()) {
                        block23: {
                            float[] vals;
                            block25: {
                                int color;
                                float x;
                                BarEntry barEntry;
                                block24: {
                                    Drawable it;
                                    barEntry = (BarEntry)dataSet.getEntryForIndex(index);
                                    if (barEntry == null) break block23;
                                    boolean bl4 = false;
                                    vals = barEntry.getYVals();
                                    BarBuffer barBuffer = buffer;
                                    Intrinsics.checkNotNull((Object)barBuffer);
                                    x = (barBuffer.buffer[bufferIndex] + buffer.buffer[bufferIndex + 2]) / 2.0f;
                                    color = dataSet.getValueTextColor(index);
                                    if (vals != null) break block24;
                                    if (!this.viewPortHandler.isInBoundsRight(x)) break;
                                    if (!this.viewPortHandler.isInBoundsY(buffer.buffer[bufferIndex + 1]) || !this.viewPortHandler.isInBoundsLeft(x)) continue;
                                    if (dataSet.isDrawValues()) {
                                        this.drawValue(canvas, dataSet.getValueFormatter(), barEntry.getY(), barEntry, i, x, buffer.buffer[bufferIndex + 1] + (barEntry.getY() >= 0.0f ? posOffset : negOffset), color);
                                    }
                                    if (barEntry.getIcon() == null || !dataSet.isDrawIcons()) break block25;
                                    Drawable icon = barEntry.getIcon();
                                    float px = 0.0f;
                                    px = x;
                                    float py = 0.0f;
                                    py = buffer.buffer[bufferIndex + 1] + (barEntry.getY() >= 0.0f ? posOffset : negOffset);
                                    px += iconsOffset.getX();
                                    py += iconsOffset.getY();
                                    if (icon == null) break block25;
                                    boolean bl5 = false;
                                    Utils.INSTANCE.drawImage(canvas, it, (int)px, (int)py);
                                    break block25;
                                }
                                float[] transformed = new float[vals.length * 2];
                                float posY = 0.0f;
                                float negY = 0.0f;
                                negY = -barEntry.getNegativeSum();
                                BarChartRenderer $this$drawValues_u24lambda_u240_u241_u241 = this;
                                boolean bl6 = false;
                                int k = 0;
                                int idx = 0;
                                while (k < transformed.length) {
                                    float value = vals[idx];
                                    float y = 0.0f;
                                    if (value == 0.0f && (posY == 0.0f || negY == 0.0f)) {
                                        y = value;
                                    } else if (value >= 0.0f) {
                                        y = posY += value;
                                    } else {
                                        y = negY;
                                        negY -= value;
                                    }
                                    transformed[k + 1] = y * phaseY;
                                    k += 2;
                                    ++idx;
                                }
                                Transformer transformer = trans;
                                Intrinsics.checkNotNull((Object)transformer);
                                transformer.pointValuesToPixel(transformed);
                                int k2 = 0;
                                while (k2 < transformed.length) {
                                    float val = vals[k2 / 2];
                                    boolean drawBelow = val == 0.0f && negY == 0.0f && posY > 0.0f || val < 0.0f;
                                    float y = transformed[k2 + 1] + (drawBelow ? negOffset : posOffset);
                                    if (!this.viewPortHandler.isInBoundsRight(x)) break;
                                    if (!this.viewPortHandler.isInBoundsY(y) || !this.viewPortHandler.isInBoundsLeft(x)) {
                                        k2 += 2;
                                        continue;
                                    }
                                    if (dataSet.isDrawValues()) {
                                        this.drawValue(canvas, dataSet.getValueFormatter(), vals[k2 / 2], barEntry, i, x, y, color);
                                    }
                                    if (barEntry.getIcon() != null && dataSet.isDrawIcons()) {
                                        Drawable icon = barEntry.getIcon();
                                        if (icon != null) {
                                            Drawable it;
                                            boolean bl7 = false;
                                            Utils.INSTANCE.drawImage(canvas, it, (int)(x + iconsOffset.getX()), (int)(y + iconsOffset.getY()));
                                        }
                                    }
                                    k2 += 2;
                                }
                            }
                            bufferIndex = vals == null ? bufferIndex + 4 : bufferIndex + 4 * vals.length;
                        }
                        ++index;
                    }
                }
                MPPointF.Companion.recycleInstance(iconsOffset);
            }
        }
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        BarData barData = this.dataProvider.getBarData();
        for (Highlight high : indices) {
            IBarDataSet set;
            BarData barData2 = barData;
            IBarDataSet iBarDataSet = set = barData2 != null ? (IBarDataSet)barData2.getDataSetByIndex(high.getDataSetIndex()) : null;
            if (set == null || !set.isHighlightEnabled()) continue;
            Object t = set.getEntryForXValue(high.getX(), high.getY());
            Intrinsics.checkNotNull(t);
            BarEntry barEntry = (BarEntry)t;
            if (!this.isInBoundsX((Entry)barEntry, set)) continue;
            Transformer trans = this.dataProvider.getTransformer(set.getAxisDependency());
            this.getPaintHighlight().setColor(set.getHighLightColor());
            this.getPaintHighlight().setAlpha(set.getHighLightAlpha());
            boolean isStack = high.getStackIndex() >= 0 && barEntry.isStacked();
            float y1 = 0.0f;
            float y2 = 0.0f;
            if (isStack) {
                if (this.dataProvider.isHighlightFullBarEnabled()) {
                    y1 = barEntry.getPositiveSum();
                    y2 = -barEntry.getNegativeSum();
                } else {
                    Range range = barEntry.getRanges()[high.getStackIndex()];
                    y1 = range.getFrom();
                    y2 = range.getTo();
                }
            } else {
                y1 = barEntry.getY();
                y2 = 0.0f;
            }
            float f = barEntry.getX();
            float f2 = barData.getBarWidth() / 2.0f;
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            this.prepareBarHighlight(f, y1, y2, f2, transformer);
            this.setHighlightDrawPos(high, this.barRect);
            if (this.drawRoundedBars) {
                canvas.drawRoundRect(new RectF(this.barRect), this.roundedBarRadius, this.roundedBarRadius, this.getPaintHighlight());
                continue;
            }
            canvas.drawRect(this.barRect, this.getPaintHighlight());
        }
    }

    protected void setHighlightDrawPos(@NotNull Highlight high, @NotNull RectF bar) {
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        Intrinsics.checkNotNullParameter((Object)bar, (String)"bar");
        high.setDraw(bar.centerX(), bar.top);
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }
}

