/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.listener;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.animation.AnimationUtils;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.HorizontalBarChart;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.listener.ChartTouchListener;
import com.github.mikephil.charting.listener.OnChartGestureListener;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001d\u0018\u0000 H2\u001e\u0012\u001a\u0012\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u00030\u00020\u0001:\u0001HB5\u0012\u001c\u0010\u0006\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u00030\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0017J\u0010\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020*H\u0002J \u0010-\u001a\u00020,2\u0006\u0010)\u001a\u00020*2\u0006\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\nH\u0002J\u0010\u00100\u001a\u00020,2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0013H\u0002J\u0018\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00103\u001a\u00020\u0013H\u0002J\u0010\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020*H\u0002J\u0016\u00108\u001a\u00020\u00132\u0006\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nJ\b\u0010;\u001a\u00020&H\u0002J\u000e\u0010<\u001a\u00020,2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010=\u001a\u00020&2\u0006\u0010>\u001a\u00020*H\u0016J\u0010\u0010?\u001a\u00020,2\u0006\u0010>\u001a\u00020*H\u0016J\u0010\u0010@\u001a\u00020&2\u0006\u0010>\u001a\u00020*H\u0016J*\u0010A\u001a\u00020&2\b\u0010B\u001a\u0004\u0018\u00010*2\u0006\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\nH\u0016J\u0006\u0010F\u001a\u00020,J\u0006\u0010G\u001a\u00020,R\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/github/mikephil/charting/listener/BarLineChartTouchListener;", "Lcom/github/mikephil/charting/listener/ChartTouchListener;", "Lcom/github/mikephil/charting/charts/BarLineChartBase;", "Lcom/github/mikephil/charting/data/BarLineScatterCandleBubbleData;", "Lcom/github/mikephil/charting/interfaces/datasets/IBarLineScatterCandleBubbleDataSet;", "Lcom/github/mikephil/charting/data/Entry;", "chart", "touchMatrix", "Landroid/graphics/Matrix;", "dragTriggerDistance", "", "<init>", "(Lcom/github/mikephil/charting/charts/BarLineChartBase;Landroid/graphics/Matrix;F)V", "value", "matrix", "getMatrix", "()Landroid/graphics/Matrix;", "savedMatrix", "touchStartPoint", "Lcom/github/mikephil/charting/utils/MPPointF;", "touchPointCenter", "savedXDist", "savedYDist", "savedDist", "closestDataSetToTouch", "Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "velocityTracker", "Landroid/view/VelocityTracker;", "decelerationLastTime", "", "decelerationCurrentPoint", "decelerationVelocity", "dragTriggerDist", "minScalePointerDistance", "matrixBuffer", "", "tempMatrix", "onTouch", "", "v", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "saveTouchStart", "", "performDrag", "distanceX", "distanceY", "performZoom", "getLimitedScaleX", "scaleX", "t", "getLimitedScaleY", "scaleY", "performHighlightDrag", "motionEvent", "getTrans", "x", "y", "inverted", "setDragTriggerDist", "onDoubleTap", "e", "onLongPress", "onSingleTapUp", "onFling", "e1", "e2", "velocityX", "velocityY", "stopDeceleration", "computeScroll", "Companion", "MPChartLib_release"})
@SourceDebugExtension(value={"SMAP\nBarLineChartTouchListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarLineChartTouchListener.kt\ncom/github/mikephil/charting/listener/BarLineChartTouchListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,648:1\n1#2:649\n*E\n"})
public final class BarLineChartTouchListener
extends ChartTouchListener<BarLineChartBase<? extends BarLineScatterCandleBubbleData<? extends IBarLineScatterCandleBubbleDataSet<? extends Entry>>>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Matrix matrix;
    @NotNull
    private final Matrix savedMatrix;
    @NotNull
    private final MPPointF touchStartPoint;
    @NotNull
    private final MPPointF touchPointCenter;
    private float savedXDist;
    private float savedYDist;
    private float savedDist;
    @Nullable
    private IDataSet<?> closestDataSetToTouch;
    @Nullable
    private VelocityTracker velocityTracker;
    private long decelerationLastTime;
    @NotNull
    private final MPPointF decelerationCurrentPoint;
    @NotNull
    private final MPPointF decelerationVelocity;
    private float dragTriggerDist;
    private final float minScalePointerDistance;
    @NotNull
    private final float[] matrixBuffer;
    @NotNull
    private final Matrix tempMatrix;

    public BarLineChartTouchListener(@NotNull BarLineChartBase<? extends BarLineScatterCandleBubbleData<? extends IBarLineScatterCandleBubbleDataSet<? extends Entry>>> chart, @NotNull Matrix touchMatrix, float dragTriggerDistance) {
        Intrinsics.checkNotNullParameter(chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)touchMatrix, (String)"touchMatrix");
        super((Chart)chart);
        this.matrix = new Matrix();
        this.savedMatrix = new Matrix();
        this.touchStartPoint = MPPointF.Companion.getInstance(0.0f, 0.0f);
        this.touchPointCenter = MPPointF.Companion.getInstance(0.0f, 0.0f);
        this.savedXDist = 1.0f;
        this.savedYDist = 1.0f;
        this.savedDist = 1.0f;
        this.decelerationCurrentPoint = MPPointF.Companion.getInstance(0.0f, 0.0f);
        this.decelerationVelocity = MPPointF.Companion.getInstance(0.0f, 0.0f);
        this.matrixBuffer = new float[9];
        this.tempMatrix = new Matrix();
        this.matrix = touchMatrix;
        this.dragTriggerDist = UtilsKtKt.convertDpToPixel(dragTriggerDistance);
        this.minScalePointerDistance = UtilsKtKt.convertDpToPixel(3.5f);
    }

    @NotNull
    public final Matrix getMatrix() {
        return this.matrix;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
        VelocityTracker velocityTracker = this.velocityTracker;
        Intrinsics.checkNotNull((Object)velocityTracker);
        velocityTracker.addMovement(event);
        if (event.getActionMasked() == 3 && this.velocityTracker != null) {
            VelocityTracker velocityTracker2 = this.velocityTracker;
            Intrinsics.checkNotNull((Object)velocityTracker2);
            velocityTracker2.recycle();
            this.velocityTracker = null;
        }
        if (this.getTouchMode() == 0 || ((BarLineChartBase)this.chart).isFlingEnabled()) {
            GestureDetector gestureDetector = this.gestureDetector;
            if (gestureDetector != null) {
                gestureDetector.onTouchEvent(event);
            }
        }
        if (!(((BarLineChartBase)this.chart).isDragEnabled() || ((BarLineChartBase)this.chart).isScaleXEnabled() || ((BarLineChartBase)this.chart).isScaleYEnabled())) {
            return true;
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.startAction(event);
                this.stopDeceleration();
                this.saveTouchStart(event);
                break;
            }
            case 5: {
                if (event.getPointerCount() < 2) break;
                ((BarLineChartBase)this.chart).disableScroll();
                this.saveTouchStart(event);
                this.savedXDist = BarLineChartTouchListener.Companion.getXDist(event);
                this.savedYDist = BarLineChartTouchListener.Companion.getYDist(event);
                this.savedDist = BarLineChartTouchListener.Companion.spacing(event);
                if (this.savedDist > 10.0f) {
                    this.setTouchMode(((BarLineChartBase)this.chart).isPinchZoomEnabled() ? 4 : (((BarLineChartBase)this.chart).isScaleXEnabled() != ((BarLineChartBase)this.chart).isScaleYEnabled() ? (((BarLineChartBase)this.chart).isScaleXEnabled() ? 2 : 3) : (this.savedXDist > this.savedYDist ? 2 : 3)));
                }
                BarLineChartTouchListener.Companion.midPoint(this.touchPointCenter, event);
                break;
            }
            case 2: {
                boolean shouldPan;
                if (this.getTouchMode() == 1) {
                    ((BarLineChartBase)this.chart).disableScroll();
                    float x = ((BarLineChartBase)this.chart).isDragXEnabled() ? event.getX() - this.touchStartPoint.getX() : 0.0f;
                    float y = ((BarLineChartBase)this.chart).isDragYEnabled() ? event.getY() - this.touchStartPoint.getY() : 0.0f;
                    this.performDrag(event, x, y);
                    break;
                }
                if (this.getTouchMode() == 2 || this.getTouchMode() == 3 || this.getTouchMode() == 4) {
                    ((BarLineChartBase)this.chart).disableScroll();
                    if (!((BarLineChartBase)this.chart).isScaleXEnabled() && !((BarLineChartBase)this.chart).isScaleYEnabled()) break;
                    this.performZoom(event);
                    break;
                }
                if (this.getTouchMode() != 0) break;
                if (!(Math.abs((double)ChartTouchListener.distance(event.getX(), this.touchStartPoint.getX(), event.getY(), this.touchStartPoint.getY())) > (double)this.dragTriggerDist) || !((BarLineChartBase)this.chart).isDragEnabled()) break;
                boolean bl = shouldPan = !((BarLineChartBase)this.chart).isFullyZoomedOut() || !((BarLineChartBase)this.chart).hasNoDragOffset();
                if (shouldPan) {
                    float distanceX = (float)Math.abs((double)(event.getX() - this.touchStartPoint.getX()));
                    float distanceY = (float)Math.abs((double)(event.getY() - this.touchStartPoint.getY()));
                    if (!((BarLineChartBase)this.chart).isDragXEnabled() && !(distanceY >= distanceX) || !((BarLineChartBase)this.chart).isDragYEnabled() && !(distanceY <= distanceX)) break;
                    this.setLastGesture(ChartTouchListener.ChartGesture.DRAG);
                    this.setTouchMode(1);
                    break;
                }
                if (!((BarLineChartBase)this.chart).isHighlightPerDragEnabled()) break;
                this.setLastGesture(ChartTouchListener.ChartGesture.DRAG);
                if (!((BarLineChartBase)this.chart).isHighlightPerDragEnabled()) break;
                this.performHighlightDrag(event);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker3 = this.velocityTracker;
                if (velocityTracker3 != null) {
                    VelocityTracker it = velocityTracker3;
                    boolean bl = false;
                    int pointerId = event.getPointerId(0);
                    it.computeCurrentVelocity(1000, (float)Utils.INSTANCE.getMaximumFlingVelocity());
                    float velocityY = it.getYVelocity(pointerId);
                    float velocityX = it.getXVelocity(pointerId);
                    if ((Math.abs((double)velocityX) > (double)Utils.INSTANCE.getMinimumFlingVelocity() || Math.abs((double)velocityY) > (double)Utils.INSTANCE.getMinimumFlingVelocity()) && this.getTouchMode() == 1 && ((BarLineChartBase)this.chart).isDragDecelerationEnabled()) {
                        this.stopDeceleration();
                        this.decelerationLastTime = AnimationUtils.currentAnimationTimeMillis();
                        this.decelerationCurrentPoint.setX(event.getX());
                        this.decelerationCurrentPoint.setY(event.getY());
                        this.decelerationVelocity.setX(velocityX);
                        this.decelerationVelocity.setY(velocityY);
                        ((BarLineChartBase)this.chart).postInvalidateOnAnimation();
                    }
                    if (this.getTouchMode() == 2 || this.getTouchMode() == 3 || this.getTouchMode() == 4 || this.getTouchMode() == 5) {
                        ((BarLineChartBase)this.chart).calculateOffsets();
                        ((BarLineChartBase)this.chart).postInvalidate();
                    }
                    this.setTouchMode(0);
                    ((BarLineChartBase)this.chart).enableScroll();
                    it.recycle();
                    this.velocityTracker = null;
                    this.endAction(event);
                }
                break;
            }
            case 6: {
                VelocityTracker velocityTracker4 = this.velocityTracker;
                if (velocityTracker4 != null) {
                    VelocityTracker it = velocityTracker4;
                    boolean bl = false;
                    Utils.INSTANCE.velocityTrackerPointerUpCleanUpIfNecessary(event, it);
                }
                this.setTouchMode(5);
                break;
            }
            case 3: {
                this.setTouchMode(0);
                this.endAction(event);
            }
        }
        this.matrix = ((BarLineChartBase)this.chart).getViewPortHandler().refresh(this.matrix, (View)this.chart, true);
        return true;
    }

    private final void saveTouchStart(MotionEvent event) {
        this.savedMatrix.set(this.matrix);
        this.touchStartPoint.setX(event.getX());
        this.touchStartPoint.setY(event.getY());
        this.closestDataSetToTouch = ((BarLineChartBase)this.chart).getDataSetByTouchPoint(event.getX(), event.getY());
    }

    private final void performDrag(MotionEvent event, float distanceX, float distanceY) {
        block3: {
            float distanceXLocal = distanceX;
            float distanceYLocal = distanceY;
            this.setLastGesture(ChartTouchListener.ChartGesture.DRAG);
            this.matrix.set(this.savedMatrix);
            OnChartGestureListener l = ((BarLineChartBase)this.chart).getOnChartGestureListener();
            if (this.inverted()) {
                if (this.chart instanceof HorizontalBarChart) {
                    distanceXLocal = -distanceXLocal;
                } else {
                    distanceYLocal = -distanceYLocal;
                }
            }
            this.matrix.postTranslate(distanceXLocal, distanceYLocal);
            OnChartGestureListener onChartGestureListener = l;
            if (onChartGestureListener == null) break block3;
            onChartGestureListener.onChartTranslate(event, distanceXLocal, distanceYLocal);
        }
    }

    private final void performZoom(MotionEvent event) {
        if (event.getPointerCount() >= 2) {
            OnChartGestureListener l = ((BarLineChartBase)this.chart).getOnChartGestureListener();
            float totalDist = BarLineChartTouchListener.Companion.spacing(event);
            if (totalDist > this.minScalePointerDistance) {
                MPPointF t = this.getTrans(this.touchPointCenter.getX(), this.touchPointCenter.getY());
                ViewPortHandler h = ((BarLineChartBase)this.chart).getViewPortHandler();
                if (this.getTouchMode() == 4) {
                    float scaleY;
                    this.setLastGesture(ChartTouchListener.ChartGesture.PINCH_ZOOM);
                    float scale = totalDist / this.savedDist;
                    boolean isZoomingOut = scale < 1.0f;
                    boolean canZoomMoreX = isZoomingOut ? h.canZoomOutMoreX() : h.canZoomInMoreX();
                    boolean canZoomMoreY = isZoomingOut ? h.canZoomOutMoreY() : h.canZoomInMoreY();
                    float scaleX = ((BarLineChartBase)this.chart).isScaleXEnabled() ? scale : 1.0f;
                    float f = scaleY = ((BarLineChartBase)this.chart).isScaleYEnabled() ? scale : 1.0f;
                    if (canZoomMoreY || canZoomMoreX) {
                        this.matrix.set(this.savedMatrix);
                        this.matrix.postScale(this.getLimitedScaleX(scaleX, t), this.getLimitedScaleY(scaleY, t), t.getX(), t.getY());
                        OnChartGestureListener onChartGestureListener = l;
                        if (onChartGestureListener != null) {
                            onChartGestureListener.onChartScale(event, scaleX, scaleY);
                        }
                    }
                } else if (this.getTouchMode() == 2 && ((BarLineChartBase)this.chart).isScaleXEnabled()) {
                    boolean canZoomMoreX;
                    this.setLastGesture(ChartTouchListener.ChartGesture.X_ZOOM);
                    float xDist = BarLineChartTouchListener.Companion.getXDist(event);
                    float scaleX = xDist / this.savedXDist;
                    boolean isZoomingOut = scaleX < 1.0f;
                    boolean bl = canZoomMoreX = isZoomingOut ? h.canZoomOutMoreX() : h.canZoomInMoreX();
                    if (canZoomMoreX) {
                        this.matrix.set(this.savedMatrix);
                        this.matrix.postScale(this.getLimitedScaleX(scaleX, t), 1.0f, t.getX(), t.getY());
                        OnChartGestureListener onChartGestureListener = l;
                        if (onChartGestureListener != null) {
                            onChartGestureListener.onChartScale(event, scaleX, 1.0f);
                        }
                    }
                } else if (this.getTouchMode() == 3 && ((BarLineChartBase)this.chart).isScaleYEnabled()) {
                    boolean canZoomMoreY;
                    this.setLastGesture(ChartTouchListener.ChartGesture.Y_ZOOM);
                    float yDist = BarLineChartTouchListener.Companion.getYDist(event);
                    float scaleY = yDist / this.savedYDist;
                    boolean isZoomingOut = scaleY < 1.0f;
                    boolean bl = canZoomMoreY = isZoomingOut ? h.canZoomOutMoreY() : h.canZoomInMoreY();
                    if (canZoomMoreY) {
                        this.matrix.set(this.savedMatrix);
                        this.matrix.postScale(1.0f, this.getLimitedScaleY(scaleY, t), t.getX(), t.getY());
                        OnChartGestureListener onChartGestureListener = l;
                        if (onChartGestureListener != null) {
                            onChartGestureListener.onChartScale(event, 1.0f, scaleY);
                        }
                    }
                }
                MPPointF.Companion.recycleInstance(t);
            }
        }
    }

    private final float getLimitedScaleX(float scaleX, MPPointF t) {
        ViewPortHandler h = ((BarLineChartBase)this.chart).getViewPortHandler();
        this.tempMatrix.set(this.savedMatrix);
        this.tempMatrix.postScale(scaleX, 1.0f, t.getX(), t.getY());
        this.savedMatrix.getValues(this.matrixBuffer);
        float lastScaleX = this.matrixBuffer[0];
        this.tempMatrix.getValues(this.matrixBuffer);
        float calScaleX = this.matrixBuffer[0];
        float resultScaleX = scaleX;
        if (calScaleX < h.getMinScaleX()) {
            resultScaleX = h.getMinScaleX() / lastScaleX;
        } else if (calScaleX > h.getMaxScaleX()) {
            resultScaleX = h.getMaxScaleX() / lastScaleX;
        }
        return resultScaleX;
    }

    private final float getLimitedScaleY(float scaleY, MPPointF t) {
        ViewPortHandler h = ((BarLineChartBase)this.chart).getViewPortHandler();
        this.tempMatrix.set(this.savedMatrix);
        this.tempMatrix.postScale(1.0f, scaleY, t.getX(), t.getY());
        this.savedMatrix.getValues(this.matrixBuffer);
        float lastScaleY = this.matrixBuffer[4];
        this.tempMatrix.getValues(this.matrixBuffer);
        float calScaleY = this.matrixBuffer[4];
        float resultScaleY = scaleY;
        if (calScaleY < h.getMinScaleY()) {
            resultScaleY = h.getMinScaleY() / lastScaleY;
        } else if (calScaleY > h.getMaxScaleY()) {
            resultScaleY = h.getMaxScaleY() / lastScaleY;
        }
        return resultScaleY;
    }

    private final void performHighlightDrag(MotionEvent motionEvent) {
        Highlight highlight = ((BarLineChartBase)this.chart).getHighlightByTouchPoint(motionEvent.getX(), motionEvent.getY());
        if (highlight != null && !highlight.equalTo(this.getMLastHighlighted())) {
            this.setMLastHighlighted(highlight);
            ((BarLineChartBase)this.chart).highlightValue(highlight, true);
        }
    }

    @NotNull
    public final MPPointF getTrans(float x, float y) {
        ViewPortHandler vph = ((BarLineChartBase)this.chart).getViewPortHandler();
        float xTrans = x - vph.offsetLeft();
        float yTrans = this.inverted() ? -(y - vph.offsetTop()) : -((float)((BarLineChartBase)this.chart).getMeasuredHeight() - y - vph.offsetBottom());
        return MPPointF.Companion.getInstance(xTrans, yTrans);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean inverted() {
        if (this.closestDataSetToTouch == null) {
            if (((BarLineChartBase)this.chart).isAnyAxisInverted()) return true;
        }
        if (this.closestDataSetToTouch == null) return false;
        BarLineChartBase barLineChartBase = (BarLineChartBase)this.chart;
        IDataSet<?> iDataSet = this.closestDataSetToTouch;
        Intrinsics.checkNotNull(iDataSet);
        if (!barLineChartBase.isInverted(iDataSet.getAxisDependency())) return false;
        return true;
    }

    public final void setDragTriggerDist(float dragTriggerDistance) {
        this.dragTriggerDist = UtilsKtKt.convertDpToPixel(dragTriggerDistance);
    }

    public boolean onDoubleTap(@NotNull MotionEvent e) {
        OnChartGestureListener onChartGestureListener;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.setLastGesture(ChartTouchListener.ChartGesture.DOUBLE_TAP);
        OnChartGestureListener onChartGestureListener2 = onChartGestureListener = ((BarLineChartBase)this.chart).getOnChartGestureListener();
        if (onChartGestureListener2 != null) {
            onChartGestureListener2.onChartDoubleTapped(e);
        }
        if (((BarLineChartBase)this.chart).isDoubleTapToZoomEnabled()) {
            Object t = ((BarLineChartBase)this.chart).getData();
            Intrinsics.checkNotNull(t);
            if (((BarLineScatterCandleBubbleData)t).getEntryCount() > 0) {
                MPPointF trans = this.getTrans(e.getX(), e.getY());
                float scaleX = ((BarLineChartBase)this.chart).isScaleXEnabled() ? 1.4f : 1.0f;
                float scaleY = ((BarLineChartBase)this.chart).isScaleYEnabled() ? 1.4f : 1.0f;
                ((BarLineChartBase)this.chart).zoom(scaleX, scaleY, trans.getX(), trans.getY());
                if (((BarLineChartBase)this.chart).isLogEnabled()) {
                    Timber.Forest.i("Double-Tap, Zooming In, x: " + trans.getX() + " y: " + trans.getY(), new Object[0]);
                }
                OnChartGestureListener onChartGestureListener3 = onChartGestureListener;
                if (onChartGestureListener3 != null) {
                    onChartGestureListener3.onChartScale(e, scaleX, scaleY);
                }
                MPPointF.Companion.recycleInstance(trans);
            }
        }
        return super.onDoubleTap(e);
    }

    public void onLongPress(@NotNull MotionEvent e) {
        block0: {
            OnChartGestureListener l;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.setLastGesture(ChartTouchListener.ChartGesture.LONG_PRESS);
            OnChartGestureListener onChartGestureListener = l = ((BarLineChartBase)this.chart).getOnChartGestureListener();
            if (onChartGestureListener == null) break block0;
            onChartGestureListener.onChartLongPressed(e);
        }
    }

    public boolean onSingleTapUp(@NotNull MotionEvent e) {
        OnChartGestureListener l;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.setLastGesture(ChartTouchListener.ChartGesture.SINGLE_TAP);
        OnChartGestureListener onChartGestureListener = l = ((BarLineChartBase)this.chart).getOnChartGestureListener();
        if (onChartGestureListener != null) {
            onChartGestureListener.onChartSingleTapped(e);
        }
        if (!((BarLineChartBase)this.chart).isHighlightPerTapEnabled()) {
            return false;
        }
        Highlight h = ((BarLineChartBase)this.chart).getHighlightByTouchPoint(e.getX(), e.getY());
        this.performHighlight(h, e);
        return super.onSingleTapUp(e);
    }

    public boolean onFling(@Nullable MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
        block0: {
            OnChartGestureListener chartGestureListener;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
            this.setLastGesture(ChartTouchListener.ChartGesture.FLING);
            OnChartGestureListener onChartGestureListener = chartGestureListener = ((BarLineChartBase)this.chart).getOnChartGestureListener();
            if (onChartGestureListener == null) break block0;
            onChartGestureListener.onChartFling(e1, e2, velocityX, velocityY);
        }
        return super.onFling(e1, e2, velocityX, velocityY);
    }

    public final void stopDeceleration() {
        this.decelerationVelocity.setX(0.0f);
        this.decelerationVelocity.setY(0.0f);
    }

    public final void computeScroll() {
        if (this.decelerationVelocity.getX() == 0.0f && this.decelerationVelocity.getY() == 0.0f) {
            return;
        }
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        MPPointF mPPointF = this.decelerationVelocity;
        mPPointF.setX(mPPointF.getX() * ((BarLineChartBase)this.chart).getDragDecelerationFrictionCoef());
        mPPointF = this.decelerationVelocity;
        mPPointF.setY(mPPointF.getY() * ((BarLineChartBase)this.chart).getDragDecelerationFrictionCoef());
        float timeInterval = (float)(currentTime - this.decelerationLastTime) / 1000.0f;
        float distanceX = this.decelerationVelocity.getX() * timeInterval;
        float distanceY = this.decelerationVelocity.getY() * timeInterval;
        MPPointF mPPointF2 = this.decelerationCurrentPoint;
        mPPointF2.setX(mPPointF2.getX() + distanceX);
        mPPointF2 = this.decelerationCurrentPoint;
        mPPointF2.setY(mPPointF2.getY() + distanceY);
        MotionEvent event = MotionEvent.obtain((long)currentTime, (long)currentTime, (int)2, (float)this.decelerationCurrentPoint.getX(), (float)this.decelerationCurrentPoint.getY(), (int)0);
        float dragDistanceX = ((BarLineChartBase)this.chart).isDragXEnabled() ? this.decelerationCurrentPoint.getX() - this.touchStartPoint.getX() : 0.0f;
        float dragDistanceY = ((BarLineChartBase)this.chart).isDragYEnabled() ? this.decelerationCurrentPoint.getY() - this.touchStartPoint.getY() : 0.0f;
        Intrinsics.checkNotNull((Object)event);
        this.performDrag(event, dragDistanceX, dragDistanceY);
        event.recycle();
        this.matrix = ((BarLineChartBase)this.chart).getViewPortHandler().refresh(this.matrix, (View)this.chart, false);
        this.decelerationLastTime = currentTime;
        if (Math.abs((double)this.decelerationVelocity.getX()) >= 0.01 || Math.abs((double)this.decelerationVelocity.getY()) >= 0.01) {
            ((BarLineChartBase)this.chart).postInvalidateOnAnimation();
        } else {
            ((BarLineChartBase)this.chart).calculateOffsets();
            ((BarLineChartBase)this.chart).postInvalidate();
            this.stopDeceleration();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/github/mikephil/charting/listener/BarLineChartTouchListener$Companion;", "", "<init>", "()V", "midPoint", "", "point", "Lcom/github/mikephil/charting/utils/MPPointF;", "event", "Landroid/view/MotionEvent;", "spacing", "", "getXDist", "e", "getYDist", "MPChartLib_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void midPoint(MPPointF point, MotionEvent event) {
            float x = event.getX(0) + event.getX(1);
            float y = event.getY(0) + event.getY(1);
            point.setX(x / 2.0f);
            point.setY(y / 2.0f);
        }

        private final float spacing(MotionEvent event) {
            float x = event.getX(0) - event.getX(1);
            float y = event.getY(0) - event.getY(1);
            return (float)Math.sqrt(x * x + y * y);
        }

        private final float getXDist(MotionEvent e) {
            float x = (float)Math.abs((double)(e.getX(0) - e.getX(1)));
            return x;
        }

        private final float getYDist(MotionEvent e) {
            float y = (float)Math.abs((double)(e.getY(0) - e.getY(1)));
            return y;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

