/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Typeface;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\u00020\u0004B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\b\"\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\tB\u0017\b\u0016\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ!\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u000eJ\b\u0010,\u001a\u00020(H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\b\u00101\u001a\u0004\u0018\u000102J\u0010\u0010\u0010\u001a\u00020\u000e2\b\u00101\u001a\u0004\u0018\u000102J&\u00103\u001a\u00020.2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0004J\u0012\u0010;\u001a\u0004\u0018\u00010\u00032\u0006\u0010<\u001a\u00020=H\u0016J\u001f\u0010>\u001a\u0004\u0018\u00018\u00002\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016\u00a2\u0006\u0002\u0010?J\u0017\u0010@\u001a\u0004\u0018\u00018\u00002\u0006\u0010A\u001a\u00020.H\u0016\u00a2\u0006\u0002\u0010BJ\u0015\u0010C\u001a\u00020(2\b\u0010D\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010EJ\u0017\u0010F\u001a\u0002072\b\u0010D\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010GJ\u0010\u0010F\u001a\u0002072\u0006\u0010A\u001a\u00020.H\u0016J\u0016\u0010H\u001a\u00020(2\u0006\u0010I\u001a\u00020\u00032\u0006\u0010J\u001a\u00020.J\u001a\u0010,\u001a\u00020(2\u0006\u0010K\u001a\u00020\u00032\b\u00101\u001a\u0004\u0018\u000102H\u0004J\u0017\u0010,\u001a\u00020(2\b\u0010D\u001a\u0004\u0018\u00018\u0000H\u0004\u00a2\u0006\u0002\u0010EJ\u001a\u0010L\u001a\u0002072\b\u0010I\u001a\u0004\u0018\u00010\u00032\u0006\u0010J\u001a\u00020.H\u0016J\u0018\u0010L\u001a\u0002072\u0006\u0010M\u001a\u00020\u000e2\u0006\u0010J\u001a\u00020.H\u0016J\u0017\u0010N\u001a\u0004\u0018\u00018\u00002\b\u0010K\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010OJ\u0015\u0010T\u001a\u00020.2\b\u0010U\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010VJ\u001d\u0010W\u001a\u0004\u0018\u00018\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0004\u00a2\u0006\u0002\u0010XJ\u001b\u0010Y\u001a\u0004\u0018\u00018\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010XJ\u000e\u0010Z\u001a\u00020(2\u0006\u0010[\u001a\u00020\\J\u000e\u0010]\u001a\u00020(2\u0006\u0010^\u001a\u00020.J\u0014\u0010_\u001a\u00020(2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020.0\u000bJ\u0010\u0010`\u001a\u00020(2\b\u0010a\u001a\u0004\u0018\u00010bJ\u000e\u0010c\u001a\u00020(2\u0006\u0010d\u001a\u00020\u000eJ\u000e\u0010e\u001a\u00020(2\u0006\u0010f\u001a\u000207J\u0006\u0010k\u001a\u00020(J\u0015\u0010l\u001a\u0002072\b\u0010U\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010GR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R$\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R$\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u0012\u0010\u001d\u001a\u00020\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00020\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u00020\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00020\u000e8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000b@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010\fR\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0019\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001050\b8F\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0013\u0010P\u001a\u0004\u0018\u00010Q8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR$\u0010g\u001a\u0002072\u0006\u0010f\u001a\u0002078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\u0011\u0010m\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\bn\u00100R\u0013\u0010o\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\bp\u0010q\u00a8\u0006r"}, d2={"Lcom/github/mikephil/charting/data/ChartData;", "T", "Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "Lcom/github/mikephil/charting/data/Entry;", "Ljava/io/Serializable;", "<init>", "()V", "dataSets", "", "([Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;)V", "sets", "", "(Ljava/util/List;)V", "value", "", "yMax", "getYMax", "()F", "setYMax", "(F)V", "yMin", "getYMin", "setYMin", "xMax", "getXMax", "setXMax", "xMin", "getXMin", "setXMin", "mLeftAxisMax", "mLeftAxisMin", "mRightAxisMax", "mRightAxisMin", "getDataSets", "()Ljava/util/List;", "setDataSets", "arrayToList", "array", "([Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;)Ljava/util/List;", "notifyDataChanged", "", "calcMinMaxY", "fromX", "toX", "calcMinMax", "dataSetCount", "", "getDataSetCount", "()I", "axis", "Lcom/github/mikephil/charting/components/YAxis$AxisDependency;", "getDataSetIndexByLabel", "label", "", "ignoreCase", "", "dataSetLabels", "getDataSetLabels", "()[Ljava/lang/String;", "getEntryForHighlight", "highlight", "Lcom/github/mikephil/charting/highlight/Highlight;", "getDataSetByLabel", "(Ljava/lang/String;Z)Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "getDataSetByIndex", "index", "(I)Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "addDataSet", "d", "(Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;)V", "removeDataSet", "(Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;)Z", "addEntry", "entry", "dataSetIndex", "e", "removeEntry", "xValue", "getDataSetForEntry", "(Lcom/github/mikephil/charting/data/Entry;)Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "colors", "", "getColors", "()[I", "getIndexOfDataSet", "dataSet", "(Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;)I", "getFirstLeft", "(Ljava/util/List;)Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "getFirstRight", "setValueFormatter", "f", "Lcom/github/mikephil/charting/formatter/IValueFormatter;", "setValueTextColor", "color", "setValueTextColors", "setValueTypeface", "tf", "Landroid/graphics/Typeface;", "setValueTextSize", "size", "setDrawValues", "enabled", "isHighlightEnabled", "()Z", "setHighlightEnabled", "(Z)V", "clearValues", "contains", "entryCount", "getEntryCount", "maxEntryCountSet", "getMaxEntryCountSet", "()Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "MPChartLib_release"})
public abstract class ChartData<T extends IDataSet<? extends Entry>>
implements Serializable {
    private float yMax;
    private float yMin;
    private float xMax;
    private float xMin;
    @JvmField
    protected float mLeftAxisMax;
    @JvmField
    protected float mLeftAxisMin;
    @JvmField
    protected float mRightAxisMax;
    @JvmField
    protected float mRightAxisMin;
    @Nullable
    private List<T> dataSets;

    public final float getYMax() {
        return this.yMax;
    }

    protected final void setYMax(float f) {
        this.yMax = f;
    }

    public final float getYMin() {
        return this.yMin;
    }

    protected final void setYMin(float f) {
        this.yMin = f;
    }

    public final float getXMax() {
        return this.xMax;
    }

    protected final void setXMax(float f) {
        this.xMax = f;
    }

    public final float getXMin() {
        return this.xMin;
    }

    protected final void setXMin(float f) {
        this.xMin = f;
    }

    @Nullable
    public List<T> getDataSets() {
        return this.dataSets;
    }

    protected void setDataSets(@Nullable List<T> list) {
        this.dataSets = list;
    }

    public ChartData() {
        this.yMax = -3.4028235E38f;
        this.yMin = Float.MAX_VALUE;
        this.xMax = -3.4028235E38f;
        this.xMin = Float.MAX_VALUE;
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        this.setDataSets(new ArrayList());
    }

    public ChartData(T ... dataSets) {
        Intrinsics.checkNotNullParameter(dataSets, (String)"dataSets");
        this.yMax = -3.4028235E38f;
        this.yMin = Float.MAX_VALUE;
        this.xMax = -3.4028235E38f;
        this.xMin = Float.MAX_VALUE;
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        this.setDataSets(ArraysKt.toMutableList((Object[])dataSets));
        this.notifyDataChanged();
    }

    private final List<T> arrayToList(T[] array) {
        List list = new ArrayList();
        Collections.addAll(list, Arrays.copyOf(array, array.length));
        return list;
    }

    public ChartData(@NotNull List<T> sets) {
        Intrinsics.checkNotNullParameter(sets, (String)"sets");
        this.yMax = -3.4028235E38f;
        this.yMin = Float.MAX_VALUE;
        this.xMax = -3.4028235E38f;
        this.xMin = Float.MAX_VALUE;
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        this.setDataSets(sets);
        this.notifyDataChanged();
    }

    public void notifyDataChanged() {
        this.calcMinMax();
    }

    public final void calcMinMaxY(float fromX, float toX) {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            set.calcMinMaxY(fromX, toX);
        }
        this.calcMinMax();
    }

    public void calcMinMax() {
        if (this.getDataSets() == null) {
            return;
        }
        this.yMax = -3.4028235E38f;
        this.yMin = Float.MAX_VALUE;
        this.xMax = -3.4028235E38f;
        this.xMin = Float.MAX_VALUE;
        for (Object set : this.getDataSets()) {
            this.calcMinMax(set);
        }
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        T firstLeft = this.getFirstLeft(list);
        if (firstLeft != null) {
            this.mLeftAxisMax = firstLeft.getYMax();
            this.mLeftAxisMin = firstLeft.getYMin();
            for (IDataSet dataSet : this.getDataSets()) {
                if (dataSet.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
                if (dataSet.getYMin() < this.mLeftAxisMin) {
                    this.mLeftAxisMin = dataSet.getYMin();
                }
                if (!(dataSet.getYMax() > this.mLeftAxisMax)) continue;
                this.mLeftAxisMax = dataSet.getYMax();
            }
        }
        List<T> list2 = this.getDataSets();
        Intrinsics.checkNotNull(list2);
        T firstRight = this.getFirstRight(list2);
        if (firstRight != null) {
            this.mRightAxisMax = firstRight.getYMax();
            this.mRightAxisMin = firstRight.getYMin();
            for (IDataSet dataSet : this.getDataSets()) {
                if (dataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
                if (dataSet.getYMin() < this.mRightAxisMin) {
                    this.mRightAxisMin = dataSet.getYMin();
                }
                if (!(dataSet.getYMax() > this.mRightAxisMax)) continue;
                this.mRightAxisMax = dataSet.getYMax();
            }
        }
    }

    public final int getDataSetCount() {
        if (this.getDataSets() == null) {
            return 0;
        }
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        return list.size();
    }

    public final float getYMin(@Nullable YAxis.AxisDependency axis) {
        return axis == YAxis.AxisDependency.LEFT ? (this.mLeftAxisMin == Float.MAX_VALUE ? this.mRightAxisMin : this.mLeftAxisMin) : (this.mRightAxisMin == Float.MAX_VALUE ? this.mLeftAxisMin : this.mRightAxisMin);
    }

    public final float getYMax(@Nullable YAxis.AxisDependency axis) {
        return axis == YAxis.AxisDependency.LEFT ? (this.mLeftAxisMax == -3.4028235E38f ? this.mRightAxisMax : this.mLeftAxisMax) : (this.mRightAxisMax == -3.4028235E38f ? this.mLeftAxisMax : this.mRightAxisMax);
    }

    protected final int getDataSetIndexByLabel(@NotNull List<T> dataSets, @NotNull String label, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter(dataSets, (String)"dataSets");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        if (ignoreCase) {
            int n = ((Collection)dataSets).size();
            for (int i = 0; i < n; ++i) {
                if (!StringsKt.equals((String)label, (String)((IDataSet)dataSets.get(i)).getLabel(), (boolean)true)) continue;
                return i;
            }
        } else {
            int n = ((Collection)dataSets).size();
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual((Object)label, (Object)((IDataSet)dataSets.get(i)).getLabel())) continue;
                return i;
            }
        }
        return -1;
    }

    @NotNull
    public final String[] getDataSetLabels() {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        String[] types = new String[list.size()];
        List<T> list2 = this.getDataSets();
        Intrinsics.checkNotNull(list2);
        int n = ((Collection)list2).size();
        for (int i = 0; i < n; ++i) {
            List<T> list3 = this.getDataSets();
            Intrinsics.checkNotNull(list3);
            types[i] = ((IDataSet)list3.get(i)).getLabel();
        }
        return types;
    }

    @Nullable
    public Entry getEntryForHighlight(@NotNull Highlight highlight) {
        Entry entry;
        Intrinsics.checkNotNullParameter((Object)highlight, (String)"highlight");
        int n = highlight.getDataSetIndex();
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        if (n >= list.size()) {
            entry = null;
        } else {
            List<T> list2 = this.getDataSets();
            Intrinsics.checkNotNull(list2);
            entry = (Entry)((IDataSet)list2.get(highlight.getDataSetIndex())).getEntryForXValue(highlight.getX(), highlight.getY());
        }
        return entry;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public T getDataSetByLabel(@NotNull String label, boolean ignoreCase) {
        IDataSet iDataSet;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        int index = this.getDataSetIndexByLabel(list, label, ignoreCase);
        if (index >= 0) {
            List<T> list2 = this.getDataSets();
            Intrinsics.checkNotNull(list2);
            if (index < list2.size()) {
                List<T> list3 = this.getDataSets();
                Intrinsics.checkNotNull(list3);
                iDataSet = (IDataSet)list3.get(index);
                return (T)iDataSet;
            }
        }
        iDataSet = null;
        return (T)iDataSet;
    }

    @Nullable
    public T getDataSetByIndex(int index) {
        block3: {
            block2: {
                if (this.getDataSets() == null || index < 0) break block2;
                List<T> list = this.getDataSets();
                Intrinsics.checkNotNull(list);
                if (index < list.size()) break block3;
            }
            return null;
        }
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        return (T)((IDataSet)list.get(index));
    }

    public final void addDataSet(@Nullable T d) {
        if (d == null) {
            return;
        }
        this.calcMinMax(d);
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        list.add(d);
    }

    public boolean removeDataSet(@Nullable T d) {
        if (d == null) {
            return false;
        }
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        boolean removed = list.remove(d);
        if (removed) {
            this.notifyDataChanged();
        }
        return removed;
    }

    public boolean removeDataSet(int index) {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        if (index >= list.size() || index < 0) {
            return false;
        }
        List<T> list2 = this.getDataSets();
        Intrinsics.checkNotNull(list2);
        IDataSet set = (IDataSet)list2.get(index);
        return this.removeDataSet(set);
    }

    public final void addEntry(@NotNull Entry entry, int dataSetIndex) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        if (list.size() > dataSetIndex && dataSetIndex >= 0) {
            List<T> list2 = this.getDataSets();
            Intrinsics.checkNotNull(list2);
            IDataSet set = (IDataSet)list2.get(dataSetIndex);
            Intrinsics.checkNotNull((Object)set, (String)"null cannot be cast to non-null type com.github.mikephil.charting.interfaces.datasets.IDataSet<com.github.mikephil.charting.data.Entry>");
            IDataSet dataSet = set;
            if (!dataSet.addEntry(entry)) {
                return;
            }
            this.calcMinMax(entry, set.getAxisDependency());
        } else {
            Timber.Forest.e("Cannot add Entry because dataSetIndex too high or too low.", new Object[0]);
        }
    }

    protected final void calcMinMax(@NotNull Entry e, @Nullable YAxis.AxisDependency axis) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.yMax < e.getY()) {
            this.yMax = e.getY();
        }
        if (this.yMin > e.getY()) {
            this.yMin = e.getY();
        }
        if (this.xMax < e.getX()) {
            this.xMax = e.getX();
        }
        if (this.xMin > e.getX()) {
            this.xMin = e.getX();
        }
        if (axis == YAxis.AxisDependency.LEFT) {
            if (this.mLeftAxisMax < e.getY()) {
                this.mLeftAxisMax = e.getY();
            }
            if (this.mLeftAxisMin > e.getY()) {
                this.mLeftAxisMin = e.getY();
            }
        } else {
            if (this.mRightAxisMax < e.getY()) {
                this.mRightAxisMax = e.getY();
            }
            if (this.mRightAxisMin > e.getY()) {
                this.mRightAxisMin = e.getY();
            }
        }
    }

    protected final void calcMinMax(@Nullable T d) {
        T t = d;
        Intrinsics.checkNotNull(t);
        if (this.yMax < t.getYMax()) {
            this.yMax = d.getYMax();
        }
        if (this.yMin > d.getYMin()) {
            this.yMin = d.getYMin();
        }
        if (this.xMax < d.getXMax()) {
            this.xMax = d.getXMax();
        }
        if (this.xMin > d.getXMin()) {
            this.xMin = d.getXMin();
        }
        if (d.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            if (this.mLeftAxisMax < d.getYMax()) {
                this.mLeftAxisMax = d.getYMax();
            }
            if (this.mLeftAxisMin > d.getYMin()) {
                this.mLeftAxisMin = d.getYMin();
            }
        } else {
            if (this.mRightAxisMax < d.getYMax()) {
                this.mRightAxisMax = d.getYMax();
            }
            if (this.mRightAxisMin > d.getYMin()) {
                this.mRightAxisMin = d.getYMin();
            }
        }
    }

    public boolean removeEntry(@Nullable Entry entry, int dataSetIndex) {
        block5: {
            block4: {
                if (entry == null) break block4;
                List<T> list = this.getDataSets();
                Intrinsics.checkNotNull(list);
                if (dataSetIndex < list.size()) break block5;
            }
            return false;
        }
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        IDataSet set = (IDataSet)list.get(dataSetIndex);
        Intrinsics.checkNotNull((Object)set, (String)"null cannot be cast to non-null type com.github.mikephil.charting.interfaces.datasets.IDataSet<com.github.mikephil.charting.data.Entry>");
        IDataSet dataSet = set;
        boolean removed = dataSet.removeEntry(entry);
        if (removed) {
            this.notifyDataChanged();
        }
        return removed;
    }

    public boolean removeEntry(float xValue, int dataSetIndex) {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        if (dataSetIndex >= list.size()) {
            return false;
        }
        List<T> list2 = this.getDataSets();
        Intrinsics.checkNotNull(list2);
        IDataSet dataSet = (IDataSet)list2.get(dataSetIndex);
        Object t = dataSet.getEntryForXValue(xValue, Float.NaN);
        if (t == null) {
            return false;
        }
        Object entry = t;
        return this.removeEntry((Entry)entry, dataSetIndex);
    }

    @Nullable
    public final T getDataSetForEntry(@Nullable Entry e) {
        if (e == null) {
            return null;
        }
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            List<T> list2 = this.getDataSets();
            Intrinsics.checkNotNull(list2);
            IDataSet set = (IDataSet)list2.get(i);
            int n2 = set.getEntryCount();
            for (int j = 0; j < n2; ++j) {
                if (!e.equalTo((Entry)set.getEntryForXValue(e.getX(), e.getY()))) continue;
                return (T)set;
            }
        }
        return null;
    }

    @Nullable
    public final int[] getColors() {
        if (this.getDataSets() == null) {
            return null;
        }
        int clrCount = 0;
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            List<T> list2 = this.getDataSets();
            Intrinsics.checkNotNull(list2);
            clrCount += ((IDataSet)list2.get(i)).getColors().size();
        }
        int[] colors = new int[clrCount];
        int cnt = 0;
        List<T> list3 = this.getDataSets();
        Intrinsics.checkNotNull(list3);
        int n2 = ((Collection)list3).size();
        for (int i = 0; i < n2; ++i) {
            List<T> list4 = this.getDataSets();
            Intrinsics.checkNotNull(list4);
            List<Integer> clrs = ((IDataSet)list4.get(i)).getColors();
            Iterator<Integer> iterator = clrs.iterator();
            while (iterator.hasNext()) {
                int clr;
                colors[cnt] = clr = ((Number)iterator.next()).intValue();
                ++cnt;
            }
        }
        return colors;
    }

    public final int getIndexOfDataSet(@Nullable T dataSet) {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        return CollectionsKt.indexOf(list, dataSet);
    }

    @Nullable
    protected final T getFirstLeft(@NotNull List<T> sets) {
        Intrinsics.checkNotNullParameter(sets, (String)"sets");
        for (IDataSet dataSet : sets) {
            if (dataSet.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
            return (T)dataSet;
        }
        return null;
    }

    @Nullable
    public final T getFirstRight(@NotNull List<T> sets) {
        Intrinsics.checkNotNullParameter(sets, (String)"sets");
        for (IDataSet dataSet : sets) {
            if (dataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
            return (T)dataSet;
        }
        return null;
    }

    public final void setValueFormatter(@NotNull IValueFormatter f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            set.setValueFormatter(f);
        }
    }

    public final void setValueTextColor(int color) {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            set.setSingleValueTextColor(color);
        }
    }

    public final void setValueTextColors(@NotNull List<Integer> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            set.setValueTextColors(colors);
        }
    }

    public final void setValueTypeface(@Nullable Typeface tf) {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            set.setValueTypeface(tf);
        }
    }

    public final void setValueTextSize(float size) {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            set.setValueTextSize(size);
        }
    }

    public final void setDrawValues(boolean enabled) {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            set.setDrawValues(enabled);
        }
    }

    public final boolean isHighlightEnabled() {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            if (set.isHighlightEnabled()) continue;
            return false;
        }
        return true;
    }

    public final void setHighlightEnabled(boolean enabled) {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            set.setHighlightEnabled(enabled);
        }
    }

    public final void clearValues() {
        if (this.getDataSets() != null) {
            List<T> list = this.getDataSets();
            Intrinsics.checkNotNull(list);
            list.clear();
        }
        this.notifyDataChanged();
    }

    public final boolean contains(@Nullable T dataSet) {
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            if (!Intrinsics.areEqual((Object)set, dataSet)) continue;
            return true;
        }
        return false;
    }

    public final int getEntryCount() {
        int count = 0;
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        for (IDataSet set : list) {
            count += set.getEntryCount();
        }
        return count;
    }

    @Nullable
    public final T getMaxEntryCountSet() {
        block4: {
            block3: {
                if (this.getDataSets() == null) break block3;
                List<T> list = this.getDataSets();
                Intrinsics.checkNotNull(list);
                if (!list.isEmpty()) break block4;
            }
            return null;
        }
        List<T> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        IDataSet max = (IDataSet)list.get(0);
        for (IDataSet set : this.getDataSets()) {
            if (set.getEntryCount() <= max.getEntryCount()) continue;
            max = set;
        }
        return (T)max;
    }
}

