/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.github.mikephil.charting.animation.Easing;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.RadarChart;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.github.mikephil.charting.listener.ChartTouchListener;
import com.github.mikephil.charting.listener.PieRadarChartTouchListener;
import com.github.mikephil.charting.renderer.LegendRenderer;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.UtilsKtKt;
import com.github.mikephil.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0018\b\u0000\u0010\u0001*\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0005B\u0013\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001d\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\b\u0010\fB%\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\b\u0010\u000fJ\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020 H\u0014J\u0012\u0010%\u001a\u00020\u00172\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020 H\u0016J\b\u0010)\u001a\u00020 H\u0016J\b\u0010*\u001a\u00020 H\u0016J\u0016\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0011J\u001e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011J&\u0010.\u001a\u00020 2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020/J\u0016\u00104\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0011J\u0010\u00105\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u0011H&J*\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u00112\u0006\u0010H\u001a\u00020\u00112\b\u0010I\u001a\u0004\u0018\u00010JH\u0007R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\"\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R$\u00106\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b7\u0010\u0015\"\u0004\b8\u0010\u001eR\u0011\u00109\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0015R\u0012\u0010;\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0015R\u0012\u0010=\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u0015R\u0012\u0010?\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0015R\u0014\u0010A\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0015R\u0014\u0010C\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u0015\u00a8\u0006K"}, d2={"Lcom/github/mikephil/charting/charts/PieRadarChartBase;", "T", "Lcom/github/mikephil/charting/data/ChartData;", "Lcom/github/mikephil/charting/interfaces/datasets/IDataSet;", "Lcom/github/mikephil/charting/data/Entry;", "Lcom/github/mikephil/charting/charts/Chart;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mRotationAngle", "", "value", "rawRotationAngle", "getRawRotationAngle", "()F", "isRotationEnabled", "", "()Z", "setRotationEnabled", "(Z)V", "minOffset", "getMinOffset", "setMinOffset", "(F)V", "init", "", "calcMinMax", "maxVisibleCount", "getMaxVisibleCount", "()I", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "computeScroll", "notifyDataSetChanged", "calculateOffsets", "getAngleForPoint", "x", "y", "getPosition", "Lcom/github/mikephil/charting/utils/MPPointF;", "center", "dist", "angle", "outputPoint", "distanceToCenter", "getIndexForAngle", "rotationAngle", "getRotationAngle", "setRotationAngle", "diameter", "getDiameter", "radius", "getRadius", "requiredLegendOffset", "getRequiredLegendOffset", "requiredBaseOffset", "getRequiredBaseOffset", "yChartMax", "getYChartMax", "yChartMin", "getYChartMin", "spin", "durationMillis", "fromAngle", "toAngle", "easing", "Lcom/github/mikephil/charting/animation/Easing$EasingFunction;", "MPChartLib_release"})
public abstract class PieRadarChartBase<T extends ChartData<? extends IDataSet<? extends Entry>>>
extends Chart<T> {
    private float mRotationAngle = 270.0f;
    private float rawRotationAngle = 270.0f;
    private boolean isRotationEnabled = true;
    private float minOffset;

    public final float getRawRotationAngle() {
        return this.rawRotationAngle;
    }

    public final boolean isRotationEnabled() {
        return this.isRotationEnabled;
    }

    public final void setRotationEnabled(boolean bl) {
        this.isRotationEnabled = bl;
    }

    public final float getMinOffset() {
        return this.minOffset;
    }

    public final void setMinOffset(float f) {
        this.minOffset = f;
    }

    public PieRadarChartBase(@Nullable Context context) {
        super(context);
    }

    public PieRadarChartBase(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PieRadarChartBase(@Nullable Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.setChartTouchListener(new PieRadarChartTouchListener(this));
    }

    @Override
    protected void calcMinMax() {
    }

    @Override
    public int getMaxVisibleCount() {
        ChartData chartData = this.mData;
        Intrinsics.checkNotNull((Object)chartData);
        return chartData.getEntryCount();
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        boolean bl;
        if (this.mTouchEnabled && this.getChartTouchListener() != null) {
            ChartTouchListener<?> chartTouchListener = this.getChartTouchListener();
            Intrinsics.checkNotNull(chartTouchListener);
            bl = chartTouchListener.onTouch((View)this, event);
        } else {
            bl = super.onTouchEvent(event);
        }
        return bl;
    }

    public void computeScroll() {
        if (this.getChartTouchListener() instanceof PieRadarChartTouchListener) {
            ChartTouchListener<?> chartTouchListener = this.getChartTouchListener();
            Intrinsics.checkNotNull(chartTouchListener, (String)"null cannot be cast to non-null type com.github.mikephil.charting.listener.PieRadarChartTouchListener");
            ((PieRadarChartTouchListener)chartTouchListener).computeScroll();
        }
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.mData == null) {
            return;
        }
        this.calcMinMax();
        if (this.getLegend() != null) {
            LegendRenderer legendRenderer = this.getLegendRenderer();
            if (legendRenderer != null) {
                ChartData chartData = this.mData;
                Intrinsics.checkNotNull((Object)chartData);
                legendRenderer.computeLegend(chartData);
            }
        }
        this.calculateOffsets();
    }

    @Override
    public void calculateOffsets() {
        XAxis x;
        float legendLeft = 0.0f;
        float legendRight = 0.0f;
        float legendBottom = 0.0f;
        float legendTop = 0.0f;
        Legend legend = this.getLegend();
        if (legend != null) {
            float fullLegendWidth;
            Legend legend2 = legend;
            boolean bl = false;
            if (legend2.isEnabled() && !legend2.isDrawInsideEnabled()) {
                fullLegendWidth = Math.min(legend2.neededWidth, this.getViewPortHandler().getChartWidth() * legend2.getMaxSizePercent());
                float fullLegendHeight = Math.min(legend2.neededHeight, this.getViewPortHandler().getChartHeight() * legend2.getMaxSizePercent());
                block0 : switch (WhenMappings.$EnumSwitchMapping$2[legend2.getOrientation().ordinal()]) {
                    case 1: {
                        switch (WhenMappings.$EnumSwitchMapping$0[legend2.getHorizontalAlignment().ordinal()]) {
                            case 1: {
                                legendLeft = fullLegendWidth;
                                break block0;
                            }
                            case 2: {
                                legendRight = fullLegendWidth;
                                break block0;
                            }
                            case 3: {
                                break block0;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    case 2: {
                        switch (WhenMappings.$EnumSwitchMapping$1[legend2.getVerticalAlignment().ordinal()]) {
                            case 1: {
                                legendTop = fullLegendHeight;
                                break block0;
                            }
                            case 2: {
                                legendBottom = fullLegendHeight;
                                break block0;
                            }
                            case 3: {
                                break block0;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (legend2.isEnabled() && !legend2.isDrawInsideEnabled()) {
                fullLegendWidth = Math.min(legend2.neededWidth, this.getViewPortHandler().getChartWidth() * legend2.getMaxSizePercent());
                block14 : switch (WhenMappings.$EnumSwitchMapping$2[legend2.getOrientation().ordinal()]) {
                    case 1: {
                        float xLegendOffset = 0.0f;
                        if (legend2.getHorizontalAlignment() == Legend.LegendHorizontalAlignment.LEFT || legend2.getHorizontalAlignment() == Legend.LegendHorizontalAlignment.RIGHT) {
                            if (legend2.getVerticalAlignment() == Legend.LegendVerticalAlignment.CENTER) {
                                float spacing = UtilsKtKt.convertDpToPixel(13.0f);
                                xLegendOffset = fullLegendWidth + spacing;
                            } else {
                                float spacing = UtilsKtKt.convertDpToPixel(8.0f);
                                float legendWidth = fullLegendWidth + spacing;
                                float legendHeight = legend2.neededHeight + legend2.mTextHeightMax;
                                float bottomX = legend2.getHorizontalAlignment() == Legend.LegendHorizontalAlignment.RIGHT ? (float)this.getWidth() - legendWidth + 15.0f : legendWidth - 15.0f;
                                float bottomY = legendHeight + 15.0f;
                                float distLegend = this.distanceToCenter(bottomX, bottomY);
                                MPPointF reference = this.getPosition(this.getCenter(), this.getRadius(), this.getAngleForPoint(bottomX, bottomY));
                                float distReference = this.distanceToCenter(reference.getX(), reference.getY());
                                float minOffset = UtilsKtKt.convertDpToPixel(5.0f);
                                if (bottomY >= this.getCenter().getY() && (float)this.getHeight() - legendWidth > (float)this.getWidth()) {
                                    xLegendOffset = legendWidth;
                                } else if (distLegend < distReference) {
                                    float diff = distReference - distLegend;
                                    xLegendOffset = minOffset + diff;
                                }
                                MPPointF.Companion.recycleInstance(this.getCenter());
                                MPPointF.Companion.recycleInstance(reference);
                            }
                        }
                        switch (WhenMappings.$EnumSwitchMapping$0[legend2.getHorizontalAlignment().ordinal()]) {
                            case 1: {
                                legendLeft = xLegendOffset;
                                break block14;
                            }
                            case 2: {
                                legendRight = xLegendOffset;
                                break block14;
                            }
                            case 3: {
                                switch (WhenMappings.$EnumSwitchMapping$1[legend2.getVerticalAlignment().ordinal()]) {
                                    case 1: {
                                        legendTop = Math.min(legend2.neededHeight, this.getViewPortHandler().getChartHeight() * legend2.getMaxSizePercent());
                                        break block14;
                                    }
                                    case 2: {
                                        legendBottom = Math.min(legend2.neededHeight, this.getViewPortHandler().getChartHeight() * legend2.getMaxSizePercent());
                                        break block14;
                                    }
                                    case 3: {
                                        Timber.Forest.e("LegendCenter/VerticalCenter not supported for PieRadarChart", new Object[0]);
                                        break block14;
                                    }
                                }
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    case 2: {
                        float yLegendOffset = 0.0f;
                        if (legend2.getVerticalAlignment() != Legend.LegendVerticalAlignment.TOP && legend2.getVerticalAlignment() != Legend.LegendVerticalAlignment.BOTTOM) break;
                        float yOffset = this.getRequiredLegendOffset();
                        yLegendOffset = Math.min(legend2.neededHeight + yOffset, this.getViewPortHandler().getChartHeight() * legend2.getMaxSizePercent());
                        switch (WhenMappings.$EnumSwitchMapping$1[legend2.getVerticalAlignment().ordinal()]) {
                            case 1: {
                                legendTop = yLegendOffset;
                                break block14;
                            }
                            case 2: {
                                legendBottom = yLegendOffset;
                                break block14;
                            }
                            case 3: {
                                Timber.Forest.e("LegendCenter/HorizontalCenter not supported for PieRadarChart", new Object[0]);
                                break block14;
                            }
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                legendLeft += this.getRequiredBaseOffset();
                legendRight += this.getRequiredBaseOffset();
                legendTop += this.getRequiredBaseOffset();
                legendBottom += this.getRequiredBaseOffset();
            }
        }
        float minOffset = UtilsKtKt.convertDpToPixel(this.minOffset);
        if (this instanceof RadarChart && (x = ((RadarChart)this).getXAxis()).isEnabled() && x.isDrawLabelsEnabled()) {
            minOffset = Math.max(minOffset, (float)x.mLabelWidth);
        }
        float offsetLeft = Math.max(minOffset, legendLeft += this.getExtraLeftOffset());
        float offsetTop = Math.max(minOffset, legendTop += this.getExtraTopOffset());
        float offsetRight = Math.max(minOffset, legendRight += this.getExtraRightOffset());
        float offsetBottom = Math.max(minOffset, Math.max(this.getRequiredBaseOffset(), legendBottom += this.getExtraBottomOffset()));
        ViewPortHandler.restrainViewPort$default(this.getViewPortHandler(), offsetLeft, offsetTop, offsetRight, offsetBottom, false, 16, null);
        if (this.isLogEnabled()) {
            Timber.Forest.i("offsetLeft: " + offsetLeft + ", offsetTop: " + offsetTop + ", offsetRight: " + offsetRight + ", offsetBottom: " + offsetBottom, new Object[0]);
        }
    }

    public final float getAngleForPoint(float x, float y) {
        MPPointF c = this.getCenterOffsets();
        boolean bl = false;
        double tx = x - c.getX();
        double ty = y - c.getY();
        double length = Math.sqrt(tx * tx + ty * ty);
        double r = Math.acos(ty / length);
        float angle = (float)Math.toDegrees(r);
        if (x > c.getX()) {
            angle = 360.0f - angle;
        }
        if ((angle += 90.0f) > 360.0f) {
            angle -= 360.0f;
        }
        MPPointF.Companion.recycleInstance(c);
        return angle;
    }

    @NotNull
    public final MPPointF getPosition(@NotNull MPPointF center, float dist, float angle) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        MPPointF p = MPPointF.Companion.getInstance(0.0f, 0.0f);
        this.getPosition(center, dist, angle, p);
        return p;
    }

    public final void getPosition(@NotNull MPPointF center, float dist, float angle, @NotNull MPPointF outputPoint) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)outputPoint, (String)"outputPoint");
        outputPoint.setX((float)((double)center.getX() + (double)dist * Math.cos(Math.toRadians(angle))));
        outputPoint.setY((float)((double)center.getY() + (double)dist * Math.sin(Math.toRadians(angle))));
    }

    public final float distanceToCenter(float x, float y) {
        MPPointF c = this.getCenterOffsets();
        boolean bl = false;
        float dist = 0.0f;
        float xDist = x > c.getX() ? x - c.getX() : c.getX() - x;
        float yDist = y > c.getY() ? y - c.getY() : c.getY() - y;
        dist = (float)Math.sqrt(Math.pow(xDist, 2.0) + Math.pow(yDist, 2.0));
        MPPointF.Companion.recycleInstance(c);
        return dist;
    }

    public abstract int getIndexForAngle(float var1);

    public final float getRotationAngle() {
        return this.mRotationAngle;
    }

    public final void setRotationAngle(float angle) {
        this.rawRotationAngle = angle;
        this.mRotationAngle = Utils.INSTANCE.getNormalizedAngle(this.rawRotationAngle);
    }

    public final float getDiameter() {
        RectF content = this.getViewPortHandler().getContentRect();
        content.left += this.getExtraLeftOffset();
        content.top += this.getExtraTopOffset();
        content.right -= this.getExtraRightOffset();
        content.bottom -= this.getExtraBottomOffset();
        return Math.min(content.width(), content.height());
    }

    public abstract float getRadius();

    protected abstract float getRequiredLegendOffset();

    protected abstract float getRequiredBaseOffset();

    @Override
    public float getYChartMax() {
        return 0.0f;
    }

    @Override
    public float getYChartMin() {
        return 0.0f;
    }

    @SuppressLint(value={"NewApi"})
    public final void spin(int durationMillis, float fromAngle, float toAngle, @Nullable Easing.EasingFunction easing) {
        this.setRotationAngle(fromAngle);
        float[] fArray = new float[]{fromAngle, toAngle};
        ObjectAnimator spinAnimator = ObjectAnimator.ofFloat((Object)this, (String)"rotationAngle", (float[])fArray);
        spinAnimator.setDuration((long)durationMillis);
        spinAnimator.setInterpolator((TimeInterpolator)easing);
        spinAnimator.addUpdateListener(arg_0 -> PieRadarChartBase.spin$lambda$0(this, arg_0));
        spinAnimator.start();
    }

    private static final void spin$lambda$0(PieRadarChartBase this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.postInvalidate();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[Legend.LegendHorizontalAlignment.values().length];
            try {
                nArray[Legend.LegendHorizontalAlignment.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendHorizontalAlignment.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendHorizontalAlignment.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Legend.LegendVerticalAlignment.values().length];
            try {
                nArray[Legend.LegendVerticalAlignment.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendVerticalAlignment.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendVerticalAlignment.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Legend.LegendOrientation.values().length];
            try {
                nArray[Legend.LegendOrientation.VERTICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendOrientation.HORIZONTAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

