/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.util.AttributeSet;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.formatter.IAxisValueFormatter;
import com.github.mikephil.charting.interfaces.dataprovider.LineDataProvider;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LineChartRenderer;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0006\u0010\nB%\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0006\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0016\u001a\u00020\u000fH\u0016R$\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/github/mikephil/charting/charts/LineChart;", "Lcom/github/mikephil/charting/charts/BarLineChartBase;", "Lcom/github/mikephil/charting/data/LineData;", "Lcom/github/mikephil/charting/interfaces/dataprovider/LineDataProvider;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "init", "", "value", "lineData", "getLineData", "()Lcom/github/mikephil/charting/data/LineData;", "setLineData", "(Lcom/github/mikephil/charting/data/LineData;)V", "onDetachedFromWindow", "accessibilityDescription", "", "getAccessibilityDescription", "()Ljava/lang/String;", "MPChartLib_release"})
public class LineChart
extends BarLineChartBase<LineData>
implements LineDataProvider {
    public LineChart(@Nullable Context context) {
        super(context);
    }

    public LineChart(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public LineChart(@Nullable Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.mRenderer = new LineChartRenderer(this, this.getMAnimator(), this.getViewPortHandler());
    }

    @Override
    @NotNull
    public LineData getLineData() {
        LineData lineData = (LineData)this.mData;
        if (lineData == null) {
            LineChart $this$_get_lineData__u24lambda_u240 = this;
            boolean bl = false;
            lineData = new LineData();
        }
        return lineData;
    }

    public void setLineData(@NotNull LineData value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.mData = value;
        this.notifyDataSetChanged();
    }

    @Override
    public void onDetachedFromWindow() {
        if (this.mRenderer != null && this.mRenderer instanceof LineChartRenderer) {
            DataRenderer dataRenderer = this.mRenderer;
            Intrinsics.checkNotNull((Object)dataRenderer, (String)"null cannot be cast to non-null type com.github.mikephil.charting.renderer.LineChartRenderer");
            ((LineChartRenderer)dataRenderer).releaseBitmap();
        }
        super.onDetachedFromWindow();
    }

    @Override
    @NotNull
    public String getAccessibilityDescription() {
        IAxisValueFormatter xAxisValueFormatter;
        IAxisValueFormatter yAxisValueFormatter;
        LineData lineData = this.getLineData();
        int numberOfPoints = lineData.getEntryCount();
        IAxisValueFormatter iAxisValueFormatter = yAxisValueFormatter = this.getAxisLeft().getValueFormatter();
        String minVal = iAxisValueFormatter != null ? iAxisValueFormatter.getFormattedValue(lineData.getYMin(), null) : null;
        IAxisValueFormatter iAxisValueFormatter2 = yAxisValueFormatter;
        String maxVal = iAxisValueFormatter2 != null ? iAxisValueFormatter2.getFormattedValue(lineData.getYMax(), null) : null;
        IAxisValueFormatter iAxisValueFormatter3 = xAxisValueFormatter = this.getXAxis().getValueFormatter();
        String minRange = iAxisValueFormatter3 != null ? iAxisValueFormatter3.getFormattedValue(lineData.getXMin(), null) : null;
        IAxisValueFormatter iAxisValueFormatter4 = xAxisValueFormatter;
        String maxRange = iAxisValueFormatter4 != null ? iAxisValueFormatter4.getFormattedValue(lineData.getXMax(), null) : null;
        String entries = numberOfPoints == 1 ? "entry" : "entries";
        Locale locale = Locale.getDefault();
        String string = "The line chart has %d %s. The minimum value is %s and maximum value is %s.Data ranges from %s to %s.";
        Object[] objectArray = new Object[]{numberOfPoints, entries, minVal, maxVal, minRange, maxRange};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

