package com.github.mikephil.charting.highlight

import com.github.mikephil.charting.data.BarData
import com.github.mikephil.charting.data.ChartData
import com.github.mikephil.charting.data.DataSet
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider
import com.github.mikephil.charting.interfaces.dataprovider.CombinedDataProvider

open class CombinedHighlighter(dataProvider: CombinedDataProvider, barChart: BarDataProvider) : ChartHighlighter<CombinedDataProvider>(dataProvider), IHighlighter {
    /**
     * bar highlighter for supporting stacked highlighting
     */
    protected var barHighlighter: BarHighlighter?

    init {
        // if there is BarData, create a BarHighlighter
        barChart.barData
        barHighlighter = BarHighlighter(barChart)
    }

    override fun getHighlightsAtXValue(xVal: Float, x: Float, y: Float): MutableList<Highlight>? {
        highlightBuffer.clear()

        val dataObjects = provider.combinedData!!.allData

        for (i in dataObjects.indices) {
            val dataObject: ChartData<*> = dataObjects[i]

            // in case of BarData, let the BarHighlighter take over
            if (barHighlighter != null && dataObject is BarData) {
                val high = barHighlighter!!.getHighlight(x, y)

                if (high != null) {
                    high.dataIndex = i
                    highlightBuffer.add(high)
                }
            } else {
                var j = 0
                val dataSetCount = dataObject.dataSetCount
                while (j < dataSetCount) {
                    val dataSet = dataObjects[i].getDataSetByIndex(j)

                    dataSet?.let {
                        // don't include datasets that cannot be highlighted
                        if (!it.isHighlightEnabled) {
                            j++
                            continue
                        }

                        val highs = buildHighlights(it, j, xVal, DataSet.Rounding.CLOSEST)
                        for (high in highs) {
                            high.dataIndex = i
                            highlightBuffer.add(high)
                        }
                    }
                    j++
                }
            }
        }

        return highlightBuffer
    }
}
