/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.Log;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.ScatterDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IScatterDataSet;
import com.github.mikephil.charting.renderer.LineScatterCandleRadarRenderer;
import com.github.mikephil.charting.renderer.scatter.IShapeRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.MPPointF;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0015\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J#\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001eR\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/github/mikephil/charting/renderer/ScatterChartRenderer;", "Lcom/github/mikephil/charting/renderer/LineScatterCandleRadarRenderer;", "chart", "Lcom/github/mikephil/charting/interfaces/dataprovider/ScatterDataProvider;", "animator", "Lcom/github/mikephil/charting/animation/ChartAnimator;", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "<init>", "(Lcom/github/mikephil/charting/interfaces/dataprovider/ScatterDataProvider;Lcom/github/mikephil/charting/animation/ChartAnimator;Lcom/github/mikephil/charting/utils/ViewPortHandler;)V", "initBuffers", "", "drawData", "c", "Landroid/graphics/Canvas;", "pixelBuffer", "", "getPixelBuffer", "()[F", "setPixelBuffer", "([F)V", "drawDataSet", "dataSet", "Lcom/github/mikephil/charting/interfaces/datasets/IScatterDataSet;", "drawValues", "drawExtras", "drawHighlighted", "indices", "", "Lcom/github/mikephil/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Lcom/github/mikephil/charting/highlight/Highlight;)V", "MPChartLib_release"})
public class ScatterChartRenderer
extends LineScatterCandleRadarRenderer {
    @JvmField
    @NotNull
    public ScatterDataProvider chart;
    @NotNull
    private float[] pixelBuffer;

    public ScatterChartRenderer(@NotNull ScatterDataProvider chart, @Nullable ChartAnimator animator, @Nullable ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super(animator, viewPortHandler);
        this.chart = chart;
        this.pixelBuffer = new float[2];
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        ScatterData scatterData = this.chart.getScatterData();
        for (IScatterDataSet set : scatterData.getDataSets()) {
            if (!set.isVisible()) continue;
            Intrinsics.checkNotNull((Object)set);
            this.drawDataSet(c, set);
        }
    }

    @NotNull
    public final float[] getPixelBuffer() {
        return this.pixelBuffer;
    }

    public final void setPixelBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.pixelBuffer = fArray;
    }

    protected final void drawDataSet(@Nullable Canvas c, @NotNull IScatterDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        if (dataSet.getEntryCount() < 1) {
            return;
        }
        ViewPortHandler viewPortHandler = this.viewPortHandler;
        Transformer trans = this.chart.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.animator.getPhaseY();
        IShapeRenderer renderer = dataSet.getShapeRenderer();
        if (renderer == null) {
            Log.i((String)"MISSING", (String)"There's no IShapeRenderer specified for ScatterDataSet");
            return;
        }
        int max = (int)Math.min(Math.ceil((float)dataSet.getEntryCount() * this.animator.getPhaseX()), (double)dataSet.getEntryCount());
        for (int i = 0; i < max; ++i) {
            Object e = dataSet.getEntryForIndex(i);
            this.pixelBuffer[0] = ((Entry)e).getX();
            this.pixelBuffer[1] = ((BaseEntry)e).getY() * phaseY;
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            transformer.pointValuesToPixel(this.pixelBuffer);
            if (!viewPortHandler.isInBoundsRight(this.pixelBuffer[0])) break;
            if (!viewPortHandler.isInBoundsLeft(this.pixelBuffer[0]) || !viewPortHandler.isInBoundsY(this.pixelBuffer[1])) continue;
            this.getPaintRender().setColor(dataSet.getColor(i / 2));
            renderer.renderShape(c, dataSet, this.viewPortHandler, this.pixelBuffer[0], this.pixelBuffer[1], this.getPaintRender());
        }
    }

    @Override
    public void drawValues(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (this.isDrawingValuesAllowed(this.chart)) {
            List dataSets = this.chart.getScatterData().getDataSets();
            int n = this.chart.getScatterData().getDataSetCount();
            for (int i = 0; i < n; ++i) {
                IScatterDataSet dataSet = (IScatterDataSet)dataSets.get(i);
                if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                Intrinsics.checkNotNull((Object)dataSet);
                this.applyValueTextStyle(dataSet);
                this.xBounds.set(this.chart, dataSet);
                Transformer transformer = this.chart.getTransformer(dataSet.getAxisDependency());
                Intrinsics.checkNotNull((Object)transformer);
                float[] positions = transformer.generateTransformedValuesScatter(dataSet, this.animator.getPhaseX(), this.animator.getPhaseY(), this.xBounds.min, this.xBounds.max);
                float shapeSize = Utils.convertDpToPixel(dataSet.getScatterShapeSize());
                MPPointF iconsOffset = MPPointF.getInstance(dataSet.getIconsOffset());
                iconsOffset.x = Utils.convertDpToPixel(iconsOffset.x);
                iconsOffset.y = Utils.convertDpToPixel(iconsOffset.y);
                int j = 0;
                while (j < positions.length && this.viewPortHandler.isInBoundsRight(positions[j])) {
                    if (!this.viewPortHandler.isInBoundsLeft(positions[j]) || !this.viewPortHandler.isInBoundsY(positions[j + 1])) {
                        j += 2;
                        continue;
                    }
                    Object entry = dataSet.getEntryForIndex(j / 2 + this.xBounds.min);
                    if (dataSet.isDrawValuesEnabled()) {
                        IValueFormatter iValueFormatter = dataSet.getValueFormatter();
                        Intrinsics.checkNotNullExpressionValue((Object)iValueFormatter, (String)"getValueFormatter(...)");
                        this.drawValue(c, iValueFormatter, ((BaseEntry)entry).getY(), (Entry)entry, i, positions[j], positions[j + 1] - shapeSize, dataSet.getValueTextColor(j / 2 + this.xBounds.min));
                    }
                    if (((BaseEntry)entry).getIcon() != null && dataSet.isDrawIconsEnabled()) {
                        Drawable icon = ((BaseEntry)entry).getIcon();
                        int n2 = (int)(positions[j] + iconsOffset.x);
                        int n3 = (int)(positions[j + 1] + iconsOffset.y);
                        Drawable drawable = icon;
                        Intrinsics.checkNotNull((Object)drawable);
                        Utils.drawImage(c, icon, n2, n3, drawable.getIntrinsicWidth(), icon.getIntrinsicHeight());
                    }
                    j += 2;
                }
                MPPointF.recycleInstance(iconsOffset);
            }
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
    }

    @Override
    public void drawHighlighted(@NotNull Canvas c, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        ScatterData scatterData = this.chart.getScatterData();
        for (Highlight high : indices) {
            Object e;
            IScatterDataSet set = (IScatterDataSet)scatterData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX((Entry)(e = set.getEntryForXValue(high.getX(), high.getY())), set)) continue;
            Transformer transformer = this.chart.getTransformer(set.getAxisDependency());
            Intrinsics.checkNotNull((Object)transformer);
            MPPointD pix = transformer.getPixelForValues(((Entry)e).getX(), ((BaseEntry)e).getY() * this.animator.getPhaseY());
            high.setDraw((float)pix.x, (float)pix.y);
            this.drawHighlightLines(c, (float)pix.x, (float)pix.y, set);
        }
    }
}

