package com.github.mikephil.charting.formatter

import com.github.mikephil.charting.data.Entry
import com.github.mikephil.charting.interfaces.datasets.IDataSet

/**
 * Interface that can be used to return a customized color instead of setting colors via the setColor(...) method of the DataSet.
 */
interface ColorFormatter {
    /**
     * Returns the color to be used for the given Entry at the given index (in the entries array)
     *
     * @param index index in the entries array
     * @param e     the entry to color
     * @param set   the DataSet the entry belongs to
     * @return
     */
    fun getColor(index: Int, entry: Entry?, set: IDataSet<*>?): Int
}
