/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.formatter;

import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.formatter.IValueFormatter;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ,\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/mikephil/charting/formatter/StackedValueFormatter;", "Lcom/github/mikephil/charting/formatter/IValueFormatter;", "drawWholeStack", "", "appendix", "", "decimals", "", "<init>", "(ZLjava/lang/String;I)V", "decimalFormat", "Ljava/text/DecimalFormat;", "getFormattedValue", "value", "", "entry", "Lcom/github/mikephil/charting/data/Entry;", "dataSetIndex", "viewPortHandler", "Lcom/github/mikephil/charting/utils/ViewPortHandler;", "MPChartLib_release"})
public class StackedValueFormatter
implements IValueFormatter {
    private final boolean drawWholeStack;
    @NotNull
    private final String appendix;
    @NotNull
    private final DecimalFormat decimalFormat;

    public StackedValueFormatter(boolean drawWholeStack, @NotNull String appendix, int decimals) {
        Intrinsics.checkNotNullParameter((Object)appendix, (String)"appendix");
        this.drawWholeStack = drawWholeStack;
        this.appendix = appendix;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < decimals; ++i) {
            if (i == 0) {
                b.append(".");
            }
            b.append("0");
        }
        this.decimalFormat = new DecimalFormat("###,###,###,##0" + b);
    }

    @Override
    @NotNull
    public String getFormattedValue(float value, @Nullable Entry entry, int dataSetIndex, @Nullable ViewPortHandler viewPortHandler) {
        Entry barEntry;
        float[] vals;
        if (!this.drawWholeStack && entry instanceof BarEntry && (vals = ((BarEntry)(barEntry = entry)).getYVals()) != null) {
            return vals[vals.length - 1] == value ? this.decimalFormat.format(((BarEntry)barEntry).getY()) + this.appendix : "";
        }
        return this.decimalFormat.format(value) + this.appendix;
    }
}

