/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.buffer.BarBuffer;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.highlight.Range;
import com.github.mikephil.charting.interfaces.dataprovider.BarDataProvider;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;

public class RoundedBarChartRenderer
extends BarChartRenderer {
    private final RectF mBarShadowRectBuffer = new RectF();
    private final float mRadius = 20.0f;
    private float roundedShadowRadius = 0.0f;
    private float roundedPositiveDataSetRadius = 0.0f;
    private float roundedNegativeDataSetRadius = 0.0f;

    public RoundedBarChartRenderer(BarDataProvider chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(chart, animator, viewPortHandler);
    }

    public void setRoundedNegativeDataSetRadius(float roundedNegativeDataSet) {
        this.roundedNegativeDataSetRadius = roundedNegativeDataSet;
    }

    public void setRoundedShadowRadius(float roundedShadow) {
        this.roundedShadowRadius = roundedShadow;
    }

    public void setRoundedPositiveDataSetRadius(float roundedPositiveDataSet) {
        this.roundedPositiveDataSetRadius = roundedPositiveDataSet;
    }

    @Override
    protected void drawDataSet(Canvas c, IBarDataSet dataSet, int index) {
        boolean isSingleColor;
        this.initBuffers();
        Transformer trans = this.mChart.getTransformer(dataSet.getAxisDependency());
        this.mBarBorderPaint.setColor(dataSet.getBarBorderColor());
        this.mBarBorderPaint.setStrokeWidth(Utils.convertDpToPixel(dataSet.getBarBorderWidth()));
        this.mShadowPaint.setColor(dataSet.getBarShadowColor());
        boolean drawBorder = dataSet.getBarBorderWidth() > 0.0f;
        float phaseX = this.mAnimator.getPhaseX();
        float phaseY = this.mAnimator.getPhaseY();
        if (this.mChart.isDrawBarShadowEnabled()) {
            this.mShadowPaint.setColor(dataSet.getBarShadowColor());
            BarData barData = this.mChart.getBarData();
            float barWidth = barData.getBarWidth();
            float barWidthHalf = barWidth / 2.0f;
            int i = 0;
            double count = Math.min((double)((int)((float)dataSet.getEntryCount() * phaseX)), (double)dataSet.getEntryCount());
            while ((double)i < count) {
                BarEntry e = (BarEntry)dataSet.getEntryForIndex(i);
                float x = e.getX();
                this.mBarShadowRectBuffer.left = x - barWidthHalf;
                this.mBarShadowRectBuffer.right = x + barWidthHalf;
                trans.rectValueToPixel(this.mBarShadowRectBuffer);
                if (!this.mViewPortHandler.isInBoundsLeft(this.mBarShadowRectBuffer.right)) {
                    ++i;
                    continue;
                }
                if (!this.mViewPortHandler.isInBoundsRight(this.mBarShadowRectBuffer.left)) break;
                this.mBarShadowRectBuffer.top = this.mViewPortHandler.contentTop();
                this.mBarShadowRectBuffer.bottom = this.mViewPortHandler.contentBottom();
                if (this.roundedShadowRadius > 0.0f) {
                    c.drawRoundRect(this.mBarRect, this.roundedShadowRadius, this.roundedShadowRadius, this.mShadowPaint);
                } else {
                    c.drawRect(this.mBarShadowRectBuffer, this.mShadowPaint);
                }
                ++i;
            }
        }
        BarBuffer buffer = this.mBarBuffers[index];
        buffer.setPhases(phaseX, phaseY);
        buffer.setDataSet(index);
        buffer.setInverted(this.mChart.isInverted(dataSet.getAxisDependency()));
        buffer.setBarWidth(this.mChart.getBarData().getBarWidth());
        buffer.feed(dataSet);
        trans.pointValuesToPixel(buffer.buffer);
        if (dataSet.getColors().size() > 1) {
            for (j = 0; j < buffer.size(); j += 4) {
                if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) continue;
                if (this.mViewPortHandler.isInBoundsRight(buffer.buffer[j])) {
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        if (this.roundedShadowRadius > 0.0f) {
                            c.drawRoundRect(new RectF(buffer.buffer[j], this.mViewPortHandler.contentTop(), buffer.buffer[j + 2], this.mViewPortHandler.contentBottom()), this.roundedShadowRadius, this.roundedShadowRadius, this.mShadowPaint);
                        } else {
                            c.drawRect(buffer.buffer[j], this.mViewPortHandler.contentTop(), buffer.buffer[j + 2], this.mViewPortHandler.contentBottom(), this.mShadowPaint);
                        }
                    }
                    this.mRenderPaint.setColor(dataSet.getColor(j / 4));
                    if (this.roundedPositiveDataSetRadius > 0.0f) {
                        c.drawRoundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, this.mRenderPaint);
                        continue;
                    }
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
                    continue;
                }
                break;
            }
        } else {
            this.mRenderPaint.setColor(dataSet.getColor());
            for (j = 0; j < buffer.size(); j += 4) {
                if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) continue;
                if (this.mViewPortHandler.isInBoundsRight(buffer.buffer[j])) {
                    if (this.mChart.isDrawBarShadowEnabled()) {
                        if (this.roundedShadowRadius > 0.0f) {
                            c.drawRoundRect(new RectF(buffer.buffer[j], this.mViewPortHandler.contentTop(), buffer.buffer[j + 2], this.mViewPortHandler.contentBottom()), this.roundedShadowRadius, this.roundedShadowRadius, this.mShadowPaint);
                        } else {
                            c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
                        }
                    }
                    if (this.roundedPositiveDataSetRadius > 0.0f) {
                        c.drawRoundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, this.mRenderPaint);
                        continue;
                    }
                    c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
                    continue;
                }
                break;
            }
        }
        boolean bl = isSingleColor = dataSet.getColors().size() == 1;
        if (isSingleColor) {
            this.mRenderPaint.setColor(dataSet.getColor(index));
        }
        int j = 0;
        while (j < buffer.size()) {
            if (!this.mViewPortHandler.isInBoundsLeft(buffer.buffer[j + 2])) {
                j += 4;
                continue;
            }
            if (!this.mViewPortHandler.isInBoundsRight(buffer.buffer[j])) break;
            if (!isSingleColor) {
                this.mRenderPaint.setColor(dataSet.getColor(j / 4));
            }
            this.mRenderPaint.setShader((Shader)new LinearGradient(buffer.buffer[j], buffer.buffer[j + 3], buffer.buffer[j], buffer.buffer[j + 1], dataSet.getColor(j / 4), dataSet.getColor(j / 4), Shader.TileMode.MIRROR));
            this.mRenderPaint.setShader((Shader)new LinearGradient(buffer.buffer[j], buffer.buffer[j + 3], buffer.buffer[j], buffer.buffer[j + 1], dataSet.getColor(j / 4), dataSet.getColor(j / 4), Shader.TileMode.MIRROR));
            if (((BarEntry)dataSet.getEntryForIndex(j / 4)).getY() < 0.0f && this.roundedNegativeDataSetRadius > 0.0f) {
                Path path2 = this.roundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedNegativeDataSetRadius, this.roundedNegativeDataSetRadius, true, true, true, true);
                c.drawPath(path2, this.mRenderPaint);
            } else if (((BarEntry)dataSet.getEntryForIndex(j / 4)).getY() > 0.0f && this.roundedPositiveDataSetRadius > 0.0f) {
                Path path2 = this.roundRect(new RectF(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3]), this.roundedPositiveDataSetRadius, this.roundedPositiveDataSetRadius, true, true, true, true);
                c.drawPath(path2, this.mRenderPaint);
            } else {
                c.drawRect(buffer.buffer[j], buffer.buffer[j + 1], buffer.buffer[j + 2], buffer.buffer[j + 3], this.mRenderPaint);
            }
            j += 4;
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        BarData barData = this.mChart.getBarData();
        for (Highlight high : indices) {
            float y2;
            float y1;
            boolean isStack;
            BarEntry e;
            IBarDataSet set = (IBarDataSet)barData.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled() || !this.isInBoundsX(e = (BarEntry)set.getEntryForXValue(high.getX(), high.getY()), set)) continue;
            Transformer trans = this.mChart.getTransformer(set.getAxisDependency());
            this.mHighlightPaint.setColor(set.getHighLightColor());
            this.mHighlightPaint.setAlpha(set.getHighLightAlpha());
            boolean bl = isStack = high.getStackIndex() >= 0 && e.isStacked();
            if (isStack) {
                if (this.mChart.isHighlightFullBarEnabled()) {
                    y1 = e.getPositiveSum();
                    y2 = -e.getNegativeSum();
                } else {
                    Range range = e.getRanges()[high.getStackIndex()];
                    y1 = range.from;
                    y2 = range.to;
                }
            } else {
                y1 = e.getY();
                y2 = 0.0f;
            }
            this.prepareBarHighlight(e.getX(), y1, y2, barData.getBarWidth() / 2.0f, trans);
            this.setHighlightDrawPos(high, this.mBarRect);
            Path path2 = this.roundRect(new RectF(this.mBarRect.left, this.mBarRect.top, this.mBarRect.right, this.mBarRect.bottom), 20.0f, 20.0f, true, true, true, true);
            c.drawPath(path2, this.mHighlightPaint);
        }
    }

    private Path roundRect(RectF rect, float rx, float ry, boolean tl, boolean tr, boolean br, boolean bl) {
        float top = rect.top;
        float left = rect.left;
        float right = rect.right;
        float bottom = rect.bottom;
        Path path = new Path();
        if (rx < 0.0f) {
            rx = 0.0f;
        }
        if (ry < 0.0f) {
            ry = 0.0f;
        }
        float width = right - left;
        float height = bottom - top;
        if (rx > width / 2.0f) {
            rx = width / 2.0f;
        }
        if (ry > height / 2.0f) {
            ry = height / 2.0f;
        }
        float widthMinusCorners = width - 2.0f * rx;
        float heightMinusCorners = height - 2.0f * ry;
        path.moveTo(right, top + ry);
        if (tr) {
            path.rQuadTo(0.0f, -ry, -rx, -ry);
        } else {
            path.rLineTo(0.0f, -ry);
            path.rLineTo(-rx, 0.0f);
        }
        path.rLineTo(-widthMinusCorners, 0.0f);
        if (tl) {
            path.rQuadTo(-rx, 0.0f, -rx, ry);
        } else {
            path.rLineTo(-rx, 0.0f);
            path.rLineTo(0.0f, ry);
        }
        path.rLineTo(0.0f, heightMinusCorners);
        if (bl) {
            path.rQuadTo(0.0f, ry, rx, ry);
        } else {
            path.rLineTo(0.0f, ry);
            path.rLineTo(rx, 0.0f);
        }
        path.rLineTo(widthMinusCorners, 0.0f);
        if (br) {
            path.rQuadTo(rx, 0.0f, rx, -ry);
        } else {
            path.rLineTo(rx, 0.0f);
            path.rLineTo(0.0f, -ry);
        }
        path.rLineTo(0.0f, -heightMinusCorners);
        path.close();
        return path;
    }
}

