/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import androidx.annotation.Nullable;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.PieEntry;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class PieDataSet
extends DataSet<PieEntry>
implements IPieDataSet {
    private float mSliceSpace = 0.0f;
    private boolean mAutomaticallyDisableSliceSpacing;
    private float mShift = 18.0f;
    private ValuePosition mXValuePosition = ValuePosition.INSIDE_SLICE;
    private ValuePosition mYValuePosition = ValuePosition.INSIDE_SLICE;
    private int mValueLineColor = -16777216;
    private boolean mUseValueColorForLine = false;
    private float mValueLineWidth = 1.0f;
    private float mValueLinePart1OffsetPercentage = 75.0f;
    private float mValueLinePart1Length = 0.3f;
    private float mValueLinePart2Length = 0.4f;
    private boolean mValueLineVariableLength = true;
    private Integer mHighlightColor = null;

    public PieDataSet(List<PieEntry> yVals, String label) {
        super(yVals, label);
    }

    @Override
    public DataSet<PieEntry> copy() {
        ArrayList<PieEntry> entries = new ArrayList<PieEntry>();
        for (int i = 0; i < this.mEntries.size(); ++i) {
            entries.add(((PieEntry)this.mEntries.get(i)).copy());
        }
        PieDataSet copied = new PieDataSet((List<PieEntry>)entries, this.getLabel());
        this.copy(copied);
        return copied;
    }

    protected void copy(PieDataSet pieDataSet) {
        super.copy(pieDataSet);
    }

    @Override
    protected void calcMinMax(PieEntry e) {
        if (e == null) {
            return;
        }
        this.calcMinMaxY(e);
    }

    public void setSliceSpace(float spaceDp) {
        if (spaceDp > 20.0f) {
            spaceDp = 20.0f;
        }
        if (spaceDp < 0.0f) {
            spaceDp = 0.0f;
        }
        this.mSliceSpace = Utils.convertDpToPixel(spaceDp);
    }

    @Override
    public float getSliceSpace() {
        return this.mSliceSpace;
    }

    public void setAutomaticallyDisableSliceSpacing(boolean autoDisable) {
        this.mAutomaticallyDisableSliceSpacing = autoDisable;
    }

    @Override
    public boolean isAutomaticallyDisableSliceSpacingEnabled() {
        return this.mAutomaticallyDisableSliceSpacing;
    }

    public void setSelectionShift(float shift) {
        this.mShift = Utils.convertDpToPixel(shift);
    }

    @Override
    public float getSelectionShift() {
        return this.mShift;
    }

    @Override
    public ValuePosition getXValuePosition() {
        return this.mXValuePosition;
    }

    public void setXValuePosition(ValuePosition xValuePosition) {
        this.mXValuePosition = xValuePosition;
    }

    @Override
    public ValuePosition getYValuePosition() {
        return this.mYValuePosition;
    }

    public void setYValuePosition(ValuePosition yValuePosition) {
        this.mYValuePosition = yValuePosition;
    }

    @Deprecated
    public boolean isUsingSliceColorAsValueLineColor() {
        return this.isUseValueColorForLineEnabled();
    }

    @Deprecated
    public void setUsingSliceColorAsValueLineColor(boolean enabled) {
        this.setUseValueColorForLine(enabled);
    }

    @Override
    public int getValueLineColor() {
        return this.mValueLineColor;
    }

    public void setValueLineColor(int valueLineColor) {
        this.mValueLineColor = valueLineColor;
    }

    @Override
    public boolean isUseValueColorForLineEnabled() {
        return this.mUseValueColorForLine;
    }

    public void setUseValueColorForLine(boolean enabled) {
        this.mUseValueColorForLine = enabled;
    }

    @Override
    public float getValueLineWidth() {
        return this.mValueLineWidth;
    }

    public void setValueLineWidth(float valueLineWidth) {
        this.mValueLineWidth = valueLineWidth;
    }

    @Override
    public float getValueLinePart1OffsetPercentage() {
        return this.mValueLinePart1OffsetPercentage;
    }

    public void setValueLinePart1OffsetPercentage(float valueLinePart1OffsetPercentage) {
        this.mValueLinePart1OffsetPercentage = valueLinePart1OffsetPercentage;
    }

    @Override
    public float getValueLinePart1Length() {
        return this.mValueLinePart1Length;
    }

    public void setValueLinePart1Length(float valueLinePart1Length) {
        this.mValueLinePart1Length = valueLinePart1Length;
    }

    @Override
    public float getValueLinePart2Length() {
        return this.mValueLinePart2Length;
    }

    public void setValueLinePart2Length(float valueLinePart2Length) {
        this.mValueLinePart2Length = valueLinePart2Length;
    }

    @Override
    public boolean isValueLineVariableLength() {
        return this.mValueLineVariableLength;
    }

    public void setValueLineVariableLength(boolean valueLineVariableLength) {
        this.mValueLineVariableLength = valueLineVariableLength;
    }

    @Override
    @Nullable
    public Integer getHighlightColor() {
        return this.mHighlightColor;
    }

    public void setHighlightColor(@Nullable Integer color) {
        this.mHighlightColor = color;
    }

    public static enum ValuePosition {
        INSIDE_SLICE,
        OUTSIDE_SLICE;

    }
}

