/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.formatter;

import com.github.mikephil.charting.components.AxisBase;
import com.github.mikephil.charting.formatter.IAxisValueFormatter;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/github/mikephil/charting/formatter/DefaultAxisValueFormatter;", "Lcom/github/mikephil/charting/formatter/IAxisValueFormatter;", "digits", "", "(I)V", "<set-?>", "decimalDigits", "getDecimalDigits", "()I", "setDecimalDigits", "decimalFormat", "Ljava/text/DecimalFormat;", "getDecimalFormat", "()Ljava/text/DecimalFormat;", "setDecimalFormat", "(Ljava/text/DecimalFormat;)V", "getFormattedValue", "", "value", "", "axis", "Lcom/github/mikephil/charting/components/AxisBase;", "MPChartLib_release"})
public class DefaultAxisValueFormatter
implements IAxisValueFormatter {
    @NotNull
    private DecimalFormat decimalFormat;
    private int decimalDigits;

    public DefaultAxisValueFormatter(int digits) {
        this.decimalDigits = digits;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < digits; ++i) {
            if (i == 0) {
                b.append(".");
            }
            b.append("0");
        }
        this.decimalFormat = new DecimalFormat("###,###,###,##0" + b);
    }

    @NotNull
    protected final DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    protected final void setDecimalFormat(@NotNull DecimalFormat decimalFormat) {
        Intrinsics.checkNotNullParameter((Object)decimalFormat, (String)"<set-?>");
        this.decimalFormat = decimalFormat;
    }

    public final int getDecimalDigits() {
        return this.decimalDigits;
    }

    protected final void setDecimalDigits(int n) {
        this.decimalDigits = n;
    }

    @Override
    @Nullable
    public String getFormattedValue(float value, @Nullable AxisBase axis) {
        return this.decimalFormat.format(value);
    }
}

