/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import com.github.mikephil.charting.components.LimitLine;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.renderer.AxisRenderer;
import com.github.mikephil.charting.utils.MPPointD;
import com.github.mikephil.charting.utils.Transformer;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.List;

public class YAxisRenderer
extends AxisRenderer {
    protected YAxis mYAxis;
    protected Paint mZeroLinePaint;
    protected Path mRenderGridLinesPath = new Path();
    protected RectF mGridClippingRect = new RectF();
    protected float[] mGetTransformedPositionsBuffer = new float[2];
    protected Path mDrawZeroLinePath = new Path();
    protected RectF mZeroLineClippingRect = new RectF();
    protected Path mRenderLimitLines = new Path();
    protected float[] mRenderLimitLinesBuffer = new float[2];
    protected RectF mLimitLineClippingRect = new RectF();

    public YAxisRenderer(ViewPortHandler viewPortHandler, YAxis yAxis, Transformer trans) {
        super(viewPortHandler, trans, yAxis);
        this.mYAxis = yAxis;
        if (this.mViewPortHandler != null) {
            this.mAxisLabelPaint.setColor(-16777216);
            this.mAxisLabelPaint.setTextSize(Utils.convertDpToPixel(10.0f));
            this.mZeroLinePaint = new Paint(1);
            this.mZeroLinePaint.setColor(-7829368);
            this.mZeroLinePaint.setStrokeWidth(1.0f);
            this.mZeroLinePaint.setStyle(Paint.Style.STROKE);
        }
    }

    private float calculateAxisLabelsXPosition(YAxis.AxisDependency dependency, YAxis.YAxisLabelPosition labelPosition) {
        float viewPortBase = dependency == YAxis.AxisDependency.LEFT ? this.mViewPortHandler.offsetLeft() : this.mViewPortHandler.contentRight();
        float xOffset = this.mYAxis.getXOffset() * (float)(labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART ? -1 : 1);
        return viewPortBase + xOffset;
    }

    private Paint.Align getAxisLabelTextAlign(YAxis.AxisDependency dependency, YAxis.YAxisLabelPosition labelPosition) {
        if (dependency == YAxis.AxisDependency.LEFT ^ labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART) {
            return Paint.Align.LEFT;
        }
        return Paint.Align.RIGHT;
    }

    @Override
    public void renderAxisLabels(Canvas c) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawLabelsEnabled()) {
            return;
        }
        float[] positions = this.getTransformedPositions();
        this.mAxisLabelPaint.setTypeface(this.mYAxis.getTypeface());
        this.mAxisLabelPaint.setTextSize(this.mYAxis.getTextSize());
        this.mAxisLabelPaint.setColor(this.mYAxis.getTextColor());
        float yOffset = (float)Utils.calcTextHeight(this.mAxisLabelPaint, "A") / 2.5f + this.mYAxis.getYOffset();
        YAxis.AxisDependency dependency = this.mYAxis.getAxisDependency();
        YAxis.YAxisLabelPosition labelPosition = this.mYAxis.getLabelPosition();
        float xPos = this.calculateAxisLabelsXPosition(dependency, labelPosition);
        this.mAxisLabelPaint.setTextAlign(this.getAxisLabelTextAlign(dependency, labelPosition));
        this.drawYLabels(c, xPos, positions, yOffset);
    }

    @Override
    public void renderAxisLine(Canvas c) {
        if (!this.mYAxis.isEnabled() || !this.mYAxis.isDrawAxisLineEnabled()) {
            return;
        }
        this.mAxisLinePaint.setColor(this.mYAxis.getAxisLineColor());
        this.mAxisLinePaint.setStrokeWidth(this.mYAxis.getAxisLineWidth());
        if (this.mYAxis.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            c.drawLine(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        } else {
            c.drawLine(this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentTop(), this.mViewPortHandler.contentRight(), this.mViewPortHandler.contentBottom(), this.mAxisLinePaint);
        }
    }

    protected void drawYLabels(Canvas c, float fixedPosition, float[] positions, float offset) {
        int to;
        if (this.mYAxis.isShowSpecificPositions()) {
            from = 0;
            to = this.mYAxis.isDrawTopYLabelEntryEnabled() ? this.mYAxis.getSpecificPositions().length : this.mYAxis.getSpecificPositions().length - 1;
        } else {
            from = this.mYAxis.isDrawBottomYLabelEntryEnabled() ? 0 : 1;
            to = this.mYAxis.isDrawTopYLabelEntryEnabled() ? this.mYAxis.mEntryCount : this.mYAxis.mEntryCount - 1;
        }
        float xOffset = this.mYAxis.getLabelXOffset();
        for (int i = from; i < to; ++i) {
            String text = this.mYAxis.isShowSpecificPositions() ? this.mYAxis.getValueFormatter().getFormattedValue(this.mYAxis.getSpecificPositions()[i], this.mYAxis) : this.mYAxis.getFormattedLabel(i);
            c.drawText(text, fixedPosition + xOffset, positions[i * 2 + 1] + offset, this.mAxisLabelPaint);
        }
    }

    @Override
    public void renderGridLines(Canvas c) {
        if (!this.mYAxis.isEnabled()) {
            return;
        }
        if (this.mYAxis.isDrawGridLinesEnabled()) {
            int clipRestoreCount = c.save();
            c.clipRect(this.getGridClippingRect());
            float[] positions = this.getTransformedPositions();
            this.mGridPaint.setColor(this.mYAxis.getGridColor());
            this.mGridPaint.setStrokeWidth(this.mYAxis.getGridLineWidth());
            this.mGridPaint.setPathEffect((PathEffect)this.mYAxis.getGridDashPathEffect());
            Path gridLinePath = this.mRenderGridLinesPath;
            gridLinePath.reset();
            for (int i = 0; i < positions.length; i += 2) {
                c.drawPath(this.linePath(gridLinePath, i, positions), this.mGridPaint);
                gridLinePath.reset();
            }
            c.restoreToCount(clipRestoreCount);
        }
        if (this.mYAxis.isDrawZeroLineEnabled()) {
            this.drawZeroLine(c);
        }
    }

    public RectF getGridClippingRect() {
        this.mGridClippingRect.set(this.mViewPortHandler.getContentRect());
        this.mGridClippingRect.inset(0.0f, -this.mAxis.getGridLineWidth());
        return this.mGridClippingRect;
    }

    protected Path linePath(Path p, int i, float[] positions) {
        p.moveTo(this.mViewPortHandler.offsetLeft(), positions[i + 1]);
        p.lineTo(this.mViewPortHandler.contentRight(), positions[i + 1]);
        return p;
    }

    protected float[] getTransformedPositions() {
        if (this.mYAxis.isShowSpecificPositions()) {
            if (this.mGetTransformedPositionsBuffer.length != this.mYAxis.getSpecificPositions().length * 2) {
                this.mGetTransformedPositionsBuffer = new float[this.mYAxis.getSpecificPositions().length * 2];
            }
        } else if (this.mGetTransformedPositionsBuffer.length != this.mYAxis.mEntryCount * 2) {
            this.mGetTransformedPositionsBuffer = new float[this.mYAxis.mEntryCount * 2];
        }
        float[] positions = this.mGetTransformedPositionsBuffer;
        for (int i = 0; i < positions.length; i += 2) {
            positions[i + 1] = this.mYAxis.isShowSpecificPositions() ? this.mYAxis.getSpecificPositions()[i / 2] : this.mYAxis.mEntries[i / 2];
        }
        this.mTrans.pointValuesToPixel(positions);
        return positions;
    }

    protected void drawZeroLine(Canvas c) {
        int clipRestoreCount = c.save();
        this.mZeroLineClippingRect.set(this.mViewPortHandler.getContentRect());
        this.mZeroLineClippingRect.inset(0.0f, -this.mYAxis.getZeroLineWidth());
        c.clipRect(this.mZeroLineClippingRect);
        MPPointD pos = this.mTrans.getPixelForValues(0.0f, 0.0f);
        this.mZeroLinePaint.setColor(this.mYAxis.getZeroLineColor());
        this.mZeroLinePaint.setStrokeWidth(this.mYAxis.getZeroLineWidth());
        Path zeroLinePath = this.mDrawZeroLinePath;
        zeroLinePath.reset();
        zeroLinePath.moveTo(this.mViewPortHandler.contentLeft(), (float)pos.y);
        zeroLinePath.lineTo(this.mViewPortHandler.contentRight(), (float)pos.y);
        c.drawPath(zeroLinePath, this.mZeroLinePaint);
        c.restoreToCount(clipRestoreCount);
    }

    @Override
    public void renderLimitLines(Canvas c) {
        List<LimitLine> limitLines = this.mYAxis.getLimitLines();
        if (limitLines == null || limitLines.size() <= 0) {
            return;
        }
        float[] pts = this.mRenderLimitLinesBuffer;
        pts[0] = 0.0f;
        pts[1] = 0.0f;
        Path limitLinePath = this.mRenderLimitLines;
        limitLinePath.reset();
        for (int i = 0; i < limitLines.size(); ++i) {
            LimitLine l = limitLines.get(i);
            if (!l.isEnabled()) continue;
            int clipRestoreCount = c.save();
            this.mLimitLineClippingRect.set(this.mViewPortHandler.getContentRect());
            this.mLimitLineClippingRect.inset(0.0f, -l.getLineWidth());
            c.clipRect(this.mLimitLineClippingRect);
            this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
            this.mLimitLinePaint.setColor(l.getLineColor());
            this.mLimitLinePaint.setStrokeWidth(l.getLineWidth());
            this.mLimitLinePaint.setPathEffect((PathEffect)l.getDashPathEffect());
            pts[1] = l.getLimit();
            this.mTrans.pointValuesToPixel(pts);
            limitLinePath.moveTo(this.mViewPortHandler.contentLeft(), pts[1]);
            limitLinePath.lineTo(this.mViewPortHandler.contentRight(), pts[1]);
            c.drawPath(limitLinePath, this.mLimitLinePaint);
            limitLinePath.reset();
            String label = l.getLabel();
            if (label != null && !label.equals("")) {
                this.mLimitLinePaint.setStyle(l.getTextStyle());
                this.mLimitLinePaint.setPathEffect(null);
                this.mLimitLinePaint.setColor(l.getTextColor());
                this.mLimitLinePaint.setTypeface(l.getTypeface());
                this.mLimitLinePaint.setStrokeWidth(0.5f);
                this.mLimitLinePaint.setTextSize(l.getTextSize());
                float labelLineHeight = Utils.calcTextHeight(this.mLimitLinePaint, label);
                float xOffset = Utils.convertDpToPixel(4.0f) + l.getXOffset();
                float yOffset = l.getLineWidth() + labelLineHeight + l.getYOffset();
                LimitLine.LimitLabelPosition position = l.getLabelPosition();
                if (position == LimitLine.LimitLabelPosition.RIGHT_TOP) {
                    this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                    c.drawText(label, this.mViewPortHandler.contentRight() - xOffset, pts[1] - yOffset + labelLineHeight, this.mLimitLinePaint);
                } else if (position == LimitLine.LimitLabelPosition.RIGHT_BOTTOM) {
                    this.mLimitLinePaint.setTextAlign(Paint.Align.RIGHT);
                    c.drawText(label, this.mViewPortHandler.contentRight() - xOffset, pts[1] + yOffset, this.mLimitLinePaint);
                } else if (position == LimitLine.LimitLabelPosition.LEFT_TOP) {
                    this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                    c.drawText(label, this.mViewPortHandler.contentLeft() + xOffset, pts[1] - yOffset + labelLineHeight, this.mLimitLinePaint);
                } else {
                    this.mLimitLinePaint.setTextAlign(Paint.Align.LEFT);
                    c.drawText(label, this.mViewPortHandler.offsetLeft() + xOffset, pts[1] + yOffset, this.mLimitLinePaint);
                }
            }
            c.restoreToCount(clipRestoreCount);
        }
    }
}

