/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data.filter;

import java.util.ArrayList;

public class ApproximatorN {
    public float[] reduceWithDouglasPeucker(float[] points, float resultCount) {
        int pointCount = points.length / 2;
        if (resultCount <= 2.0f || resultCount >= (float)pointCount) {
            return points;
        }
        boolean[] keep = new boolean[pointCount];
        keep[0] = true;
        keep[pointCount - 1] = true;
        int currentStoredPoints = 2;
        ArrayList<Line> queue = new ArrayList<Line>();
        Line line = new Line(0, pointCount - 1, points);
        queue.add(line);
        do {
            line = (Line)queue.remove(queue.size() - 1);
            keep[line.index] = true;
            if ((float)(++currentStoredPoints) == resultCount) break;
            Line left = new Line(line.start, line.index, points);
            if (left.index > 0) {
                int insertionIndex = ApproximatorN.insertionIndex(left, queue);
                queue.add(insertionIndex, left);
            }
            Line right = new Line(line.index, line.end, points);
            if (right.index <= 0) continue;
            int insertionIndex = ApproximatorN.insertionIndex(right, queue);
            queue.add(insertionIndex, right);
        } while (queue.isEmpty());
        float[] reducedEntries = new float[currentStoredPoints * 2];
        int i = 0;
        int i2 = 0;
        int r2 = 0;
        while (i < currentStoredPoints) {
            if (keep[i]) {
                reducedEntries[i2++] = points[r2];
                reducedEntries[i2++] = points[r2 + 1];
            }
            ++i;
            r2 += 2;
        }
        return reducedEntries;
    }

    private static float distanceToLine(float ptX, float ptY, float[] fromLinePoint1, float[] fromLinePoint2) {
        float dx = fromLinePoint2[0] - fromLinePoint1[0];
        float dy = fromLinePoint2[1] - fromLinePoint1[1];
        float dividend = Math.abs(dy * ptX - dx * ptY - fromLinePoint1[0] * fromLinePoint2[1] + fromLinePoint2[0] * fromLinePoint1[1]);
        double divisor = Math.sqrt(dx * dx + dy * dy);
        return (float)((double)dividend / divisor);
    }

    private static int insertionIndex(Line line, ArrayList<Line> queue) {
        int min = 0;
        int max = queue.size();
        while (!queue.isEmpty()) {
            int midIndex = min + (max - min) / 2;
            Line midLine = queue.get(midIndex);
            if (midLine.equals(line)) {
                return midIndex;
            }
            if (line.lessThan(midLine)) {
                max = midIndex;
                continue;
            }
            min = midIndex + 1;
        }
        return min;
    }

    private static class Line {
        int start;
        int end;
        float distance = 0.0f;
        int index = 0;

        Line(int start, int end, float[] points) {
            this.start = start;
            this.end = end;
            float[] startPoint = new float[]{points[start * 2], points[start * 2 + 1]};
            float[] endPoint = new float[]{points[end * 2], points[end * 2 + 1]};
            if (end <= start + 1) {
                return;
            }
            int i = start + 1;
            int i2 = i * 2;
            while (i < end) {
                float distance = ApproximatorN.distanceToLine(points[i2], points[i2 + 1], startPoint, endPoint);
                if (distance > this.distance) {
                    this.index = i;
                    this.distance = distance;
                }
                ++i;
                i2 += 2;
            }
        }

        boolean equals(Line rhs) {
            return this.start == rhs.start && this.end == rhs.end && this.index == rhs.index;
        }

        boolean lessThan(Line rhs) {
            return this.distance < rhs.distance;
        }
    }
}

