/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Typeface;
import com.github.mikephil.charting.components.Legend;
import com.github.mikephil.charting.components.LegendEntry;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.PieEntry;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.interfaces.datasets.ICandleDataSet;
import com.github.mikephil.charting.interfaces.datasets.IPieDataSet;
import com.github.mikephil.charting.renderer.Renderer;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LegendRenderer
extends Renderer {
    protected Paint mLegendLabelPaint;
    protected Paint mLegendFormPaint;
    protected Legend mLegend;
    protected List<LegendEntry> computedEntries = new ArrayList<LegendEntry>(16);
    protected Paint.FontMetrics legendFontMetrics = new Paint.FontMetrics();
    private Path mLineFormPath = new Path();

    public LegendRenderer(ViewPortHandler viewPortHandler, Legend legend) {
        super(viewPortHandler);
        this.mLegend = legend;
        this.mLegendLabelPaint = new Paint(1);
        this.mLegendLabelPaint.setTextSize(Utils.convertDpToPixel(9.0f));
        this.mLegendLabelPaint.setTextAlign(Paint.Align.LEFT);
        this.mLegendFormPaint = new Paint(1);
        this.mLegendFormPaint.setStyle(Paint.Style.FILL);
    }

    public Paint getLabelPaint() {
        return this.mLegendLabelPaint;
    }

    public Paint getFormPaint() {
        return this.mLegendFormPaint;
    }

    public void computeLegend(ChartData<?> data) {
        Typeface tf;
        if (!this.mLegend.isLegendCustom()) {
            this.computedEntries.clear();
            for (int i = 0; i < data.getDataSetCount(); ++i) {
                Object dataSet = data.getDataSetByIndex(i);
                List<Integer> clrs = dataSet.getColors();
                int entryCount = dataSet.getEntryCount();
                if (dataSet instanceof IBarDataSet && ((IBarDataSet)dataSet).isStacked()) {
                    IBarDataSet bds = (IBarDataSet)dataSet;
                    String[] sLabels = bds.getStackLabels();
                    for (int j = 0; j < clrs.size() && j < bds.getStackSize(); ++j) {
                        this.computedEntries.add(new LegendEntry(sLabels[j % sLabels.length], dataSet.getForm(), dataSet.getFormSize(), dataSet.getFormLineWidth(), dataSet.getFormLineDashEffect(), clrs.get(j)));
                    }
                    if (bds.getLabel() == null) continue;
                    this.computedEntries.add(new LegendEntry(dataSet.getLabel(), Legend.LegendForm.NONE, Float.NaN, Float.NaN, null, 0x112233));
                    continue;
                }
                if (dataSet instanceof IPieDataSet) {
                    IPieDataSet pds = (IPieDataSet)dataSet;
                    for (int j = 0; j < clrs.size() && j < entryCount; ++j) {
                        this.computedEntries.add(new LegendEntry(((PieEntry)pds.getEntryForIndex(j)).getLabel(), dataSet.getForm(), dataSet.getFormSize(), dataSet.getFormLineWidth(), dataSet.getFormLineDashEffect(), clrs.get(j)));
                    }
                    if (pds.getLabel() == null) continue;
                    this.computedEntries.add(new LegendEntry(dataSet.getLabel(), Legend.LegendForm.NONE, Float.NaN, Float.NaN, null, 0x112233));
                    continue;
                }
                if (dataSet instanceof ICandleDataSet && ((ICandleDataSet)dataSet).getDecreasingColor() != 0x112233) {
                    int decreasingColor = ((ICandleDataSet)dataSet).getDecreasingColor();
                    int increasingColor = ((ICandleDataSet)dataSet).getIncreasingColor();
                    this.computedEntries.add(new LegendEntry(null, dataSet.getForm(), dataSet.getFormSize(), dataSet.getFormLineWidth(), dataSet.getFormLineDashEffect(), decreasingColor));
                    this.computedEntries.add(new LegendEntry(dataSet.getLabel(), dataSet.getForm(), dataSet.getFormSize(), dataSet.getFormLineWidth(), dataSet.getFormLineDashEffect(), increasingColor));
                    continue;
                }
                for (int j = 0; j < clrs.size() && j < entryCount; ++j) {
                    String label = j < clrs.size() - 1 && j < entryCount - 1 ? null : data.getDataSetByIndex(i).getLabel();
                    this.computedEntries.add(new LegendEntry(label, dataSet.getForm(), dataSet.getFormSize(), dataSet.getFormLineWidth(), dataSet.getFormLineDashEffect(), clrs.get(j)));
                }
            }
            if (this.mLegend.getExtraEntries() != null) {
                Collections.addAll(this.computedEntries, this.mLegend.getExtraEntries());
            }
            this.mLegend.setEntries(this.computedEntries);
        }
        if ((tf = this.mLegend.getTypeface()) != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        this.mLegend.calculateDimensions(this.mLegendLabelPaint, this.mViewPortHandler);
    }

    public void renderLegend(Canvas c) {
        if (!this.mLegend.isEnabled()) {
            return;
        }
        Typeface tf = this.mLegend.getTypeface();
        if (tf != null) {
            this.mLegendLabelPaint.setTypeface(tf);
        }
        this.mLegendLabelPaint.setTextSize(this.mLegend.getTextSize());
        this.mLegendLabelPaint.setColor(this.mLegend.getTextColor());
        float labelLineHeight = Utils.getLineHeight(this.mLegendLabelPaint, this.legendFontMetrics);
        float labelLineSpacing = Utils.getLineSpacing(this.mLegendLabelPaint, this.legendFontMetrics) + Utils.convertDpToPixel(this.mLegend.getYEntrySpace());
        float formYOffset = labelLineHeight - (float)Utils.calcTextHeight(this.mLegendLabelPaint, "ABC") / 2.0f;
        LegendEntry[] entries = this.mLegend.getEntries();
        float formToTextSpace = Utils.convertDpToPixel(this.mLegend.getFormToTextSpace());
        float xEntrySpace = Utils.convertDpToPixel(this.mLegend.getXEntrySpace());
        Legend.LegendOrientation orientation = this.mLegend.getOrientation();
        Legend.LegendHorizontalAlignment horizontalAlignment = this.mLegend.getHorizontalAlignment();
        Legend.LegendVerticalAlignment verticalAlignment = this.mLegend.getVerticalAlignment();
        Legend.LegendDirection direction = this.mLegend.getDirection();
        float defaultFormSize = Utils.convertDpToPixel(this.mLegend.getFormSize());
        float stackSpace = Utils.convertDpToPixel(this.mLegend.getStackSpace());
        float yoffset = this.mLegend.getYOffset();
        float xoffset = this.mLegend.getXOffset();
        float originPosX = 0.0f;
        switch (horizontalAlignment) {
            case LEFT: {
                originPosX = orientation == Legend.LegendOrientation.VERTICAL ? xoffset : this.mViewPortHandler.contentLeft() + xoffset;
                if (direction != Legend.LegendDirection.RIGHT_TO_LEFT) break;
                originPosX += this.mLegend.mNeededWidth;
                break;
            }
            case RIGHT: {
                originPosX = orientation == Legend.LegendOrientation.VERTICAL ? this.mViewPortHandler.getChartWidth() - xoffset : this.mViewPortHandler.contentRight() - xoffset;
                if (direction != Legend.LegendDirection.LEFT_TO_RIGHT) break;
                originPosX -= this.mLegend.mNeededWidth;
                break;
            }
            case CENTER: {
                originPosX = orientation == Legend.LegendOrientation.VERTICAL ? this.mViewPortHandler.getChartWidth() / 2.0f : this.mViewPortHandler.contentLeft() + this.mViewPortHandler.contentWidth() / 2.0f;
                originPosX += direction == Legend.LegendDirection.LEFT_TO_RIGHT ? xoffset : -xoffset;
                if (orientation != Legend.LegendOrientation.VERTICAL) break;
                originPosX = (float)((double)originPosX + (direction == Legend.LegendDirection.LEFT_TO_RIGHT ? (double)(-this.mLegend.mNeededWidth) / 2.0 + (double)xoffset : (double)this.mLegend.mNeededWidth / 2.0 - (double)xoffset));
            }
        }
        switch (orientation) {
            case HORIZONTAL: {
                List<FSize> calculatedLineSizes = this.mLegend.getCalculatedLineSizes();
                List<FSize> calculatedLabelSizes = this.mLegend.getCalculatedLabelSizes();
                List<Boolean> calculatedLabelBreakPoints = this.mLegend.getCalculatedLabelBreakPoints();
                float posX = originPosX;
                float posY = 0.0f;
                switch (verticalAlignment) {
                    case TOP: {
                        posY = yoffset;
                        break;
                    }
                    case BOTTOM: {
                        posY = this.mViewPortHandler.getChartHeight() - yoffset - this.mLegend.mNeededHeight;
                        break;
                    }
                    case CENTER: {
                        posY = (this.mViewPortHandler.getChartHeight() - this.mLegend.mNeededHeight) / 2.0f + yoffset;
                    }
                }
                int lineIndex = 0;
                int count = entries.length;
                for (int i = 0; i < count; ++i) {
                    boolean isStacked;
                    float formSize;
                    LegendEntry e = entries[i];
                    boolean drawingForm = e.form != Legend.LegendForm.NONE;
                    float f = formSize = Float.isNaN(e.formSize) ? defaultFormSize : Utils.convertDpToPixel(e.formSize);
                    if (i < calculatedLabelBreakPoints.size() && calculatedLabelBreakPoints.get(i).booleanValue()) {
                        posX = originPosX;
                        posY += labelLineHeight + labelLineSpacing;
                    }
                    if (posX == originPosX && horizontalAlignment == Legend.LegendHorizontalAlignment.CENTER && lineIndex < calculatedLineSizes.size()) {
                        posX += (direction == Legend.LegendDirection.RIGHT_TO_LEFT ? calculatedLineSizes.get((int)lineIndex).width : -calculatedLineSizes.get((int)lineIndex).width) / 2.0f;
                        ++lineIndex;
                    }
                    boolean bl = isStacked = e.label == null;
                    if (drawingForm) {
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= formSize;
                        }
                        this.drawForm(c, posX, posY + formYOffset, e, this.mLegend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += formSize;
                        }
                    }
                    if (!isStacked) {
                        if (drawingForm) {
                            posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -formToTextSpace : formToTextSpace;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= calculatedLabelSizes.get((int)i).width;
                        }
                        this.drawLabel(c, posX, posY + labelLineHeight, e.label);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += calculatedLabelSizes.get((int)i).width;
                        }
                        posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -xEntrySpace : xEntrySpace;
                        continue;
                    }
                    posX += direction == Legend.LegendDirection.RIGHT_TO_LEFT ? -stackSpace : stackSpace;
                }
                break;
            }
            case VERTICAL: {
                float stack = 0.0f;
                boolean wasStacked = false;
                float posY = 0.0f;
                switch (verticalAlignment) {
                    case TOP: {
                        posY = horizontalAlignment == Legend.LegendHorizontalAlignment.CENTER ? 0.0f : this.mViewPortHandler.contentTop();
                        posY += yoffset;
                        break;
                    }
                    case BOTTOM: {
                        posY = horizontalAlignment == Legend.LegendHorizontalAlignment.CENTER ? this.mViewPortHandler.getChartHeight() : this.mViewPortHandler.contentBottom();
                        posY -= this.mLegend.mNeededHeight + yoffset;
                        break;
                    }
                    case CENTER: {
                        posY = this.mViewPortHandler.getChartHeight() / 2.0f - this.mLegend.mNeededHeight / 2.0f + this.mLegend.getYOffset();
                    }
                }
                for (int i = 0; i < entries.length; ++i) {
                    LegendEntry e = entries[i];
                    boolean drawingForm = e.form != Legend.LegendForm.NONE;
                    float formSize = Float.isNaN(e.formSize) ? defaultFormSize : Utils.convertDpToPixel(e.formSize);
                    float posX = originPosX;
                    if (drawingForm) {
                        posX = direction == Legend.LegendDirection.LEFT_TO_RIGHT ? (posX += stack) : (posX -= formSize - stack);
                        this.drawForm(c, posX, posY + formYOffset, e, this.mLegend);
                        if (direction == Legend.LegendDirection.LEFT_TO_RIGHT) {
                            posX += formSize;
                        }
                    }
                    if (e.label != null) {
                        if (drawingForm && !wasStacked) {
                            posX += direction == Legend.LegendDirection.LEFT_TO_RIGHT ? formToTextSpace : -formToTextSpace;
                        } else if (wasStacked) {
                            posX = originPosX;
                        }
                        if (direction == Legend.LegendDirection.RIGHT_TO_LEFT) {
                            posX -= (float)Utils.calcTextWidth(this.mLegendLabelPaint, e.label);
                        }
                        if (!wasStacked) {
                            this.drawLabel(c, posX, posY + labelLineHeight, e.label);
                        } else {
                            this.drawLabel(c, posX, (posY += labelLineHeight + labelLineSpacing) + labelLineHeight, e.label);
                        }
                        posY += labelLineHeight + labelLineSpacing;
                        stack = 0.0f;
                        continue;
                    }
                    stack += formSize + stackSpace;
                    wasStacked = true;
                }
                break;
            }
        }
    }

    protected void drawForm(Canvas c, float x, float y, LegendEntry entry, Legend legend) {
        if (entry.formColor == 1122868 || entry.formColor == 0x112233 || entry.formColor == 0) {
            return;
        }
        int restoreCount = c.save();
        Legend.LegendForm form = entry.form;
        if (form == Legend.LegendForm.DEFAULT) {
            form = legend.getForm();
        }
        this.mLegendFormPaint.setColor(entry.formColor);
        float formSize = Utils.convertDpToPixel(Float.isNaN(entry.formSize) ? legend.getFormSize() : entry.formSize);
        float half = formSize / 2.0f;
        switch (form) {
            case NONE: {
                break;
            }
            case EMPTY: {
                break;
            }
            case DEFAULT: 
            case CIRCLE: {
                this.mLegendFormPaint.setStyle(Paint.Style.FILL);
                c.drawCircle(x + half, y, half, this.mLegendFormPaint);
                break;
            }
            case SQUARE: {
                this.mLegendFormPaint.setStyle(Paint.Style.FILL);
                c.drawRect(x, y - half, x + formSize, y + half, this.mLegendFormPaint);
                break;
            }
            case LINE: {
                float formLineWidth = Utils.convertDpToPixel(Float.isNaN(entry.formLineWidth) ? legend.getFormLineWidth() : entry.formLineWidth);
                DashPathEffect formLineDashEffect = entry.formLineDashEffect == null ? legend.getFormLineDashEffect() : entry.formLineDashEffect;
                this.mLegendFormPaint.setStyle(Paint.Style.STROKE);
                this.mLegendFormPaint.setStrokeWidth(formLineWidth);
                this.mLegendFormPaint.setPathEffect((PathEffect)formLineDashEffect);
                this.mLineFormPath.reset();
                this.mLineFormPath.moveTo(x, y);
                this.mLineFormPath.lineTo(x + formSize, y);
                c.drawPath(this.mLineFormPath, this.mLegendFormPaint);
            }
        }
        c.restoreToCount(restoreCount);
    }

    protected void drawLabel(Canvas c, float x, float y, String label) {
        c.drawText(label, x, y, this.mLegendLabelPaint);
    }
}

