/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.util.Log;
import com.github.mikephil.charting.animation.ChartAnimator;
import com.github.mikephil.charting.charts.Chart;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.renderer.BarChartRenderer;
import com.github.mikephil.charting.renderer.BubbleChartRenderer;
import com.github.mikephil.charting.renderer.CandleStickChartRenderer;
import com.github.mikephil.charting.renderer.DataRenderer;
import com.github.mikephil.charting.renderer.LineChartRenderer;
import com.github.mikephil.charting.renderer.ScatterChartRenderer;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class CombinedChartRenderer
extends DataRenderer {
    protected List<DataRenderer> mRenderers = new ArrayList<DataRenderer>(5);
    protected WeakReference<Chart> mChart;
    protected List<Highlight> mHighlightBuffer = new ArrayList<Highlight>();

    public CombinedChartRenderer(CombinedChart chart, ChartAnimator animator, ViewPortHandler viewPortHandler) {
        super(animator, viewPortHandler);
        this.mChart = new WeakReference<CombinedChart>(chart);
        this.createRenderers();
    }

    public void createRenderers() {
        CombinedChart.DrawOrder[] orders;
        this.mRenderers.clear();
        CombinedChart chart = (CombinedChart)this.mChart.get();
        if (chart == null) {
            return;
        }
        block7: for (CombinedChart.DrawOrder order : orders = chart.getDrawOrder()) {
            switch (order) {
                case BAR: {
                    if (chart.getBarData() == null) continue block7;
                    this.mRenderers.add(new BarChartRenderer(chart, this.mAnimator, this.mViewPortHandler));
                    continue block7;
                }
                case BUBBLE: {
                    if (chart.getBubbleData() == null) continue block7;
                    this.mRenderers.add(new BubbleChartRenderer(chart, this.mAnimator, this.mViewPortHandler));
                    continue block7;
                }
                case LINE: {
                    if (chart.getLineData() == null) continue block7;
                    this.mRenderers.add(new LineChartRenderer(chart, this.mAnimator, this.mViewPortHandler));
                    continue block7;
                }
                case CANDLE: {
                    if (chart.getCandleData() == null) continue block7;
                    this.mRenderers.add(new CandleStickChartRenderer(chart, this.mAnimator, this.mViewPortHandler));
                    continue block7;
                }
                case SCATTER: {
                    if (chart.getScatterData() == null) continue block7;
                    this.mRenderers.add(new ScatterChartRenderer(chart, this.mAnimator, this.mViewPortHandler));
                }
            }
        }
    }

    @Override
    public void initBuffers() {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.initBuffers();
        }
    }

    @Override
    public void drawData(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawData(c);
        }
    }

    @Override
    public void drawValue(Canvas c, String valueText, float x, float y, int color) {
        Log.e((String)"MPAndroidChart", (String)"Erroneous call to drawValue() in CombinedChartRenderer!");
    }

    @Override
    public void drawValues(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawValues(c);
        }
    }

    @Override
    public void drawExtras(Canvas c) {
        for (DataRenderer renderer : this.mRenderers) {
            renderer.drawExtras(c);
        }
    }

    @Override
    public void drawHighlighted(Canvas c, Highlight[] indices) {
        Chart chart = (Chart)this.mChart.get();
        if (chart == null) {
            return;
        }
        for (DataRenderer renderer : this.mRenderers) {
            BarLineScatterCandleBubbleData data = null;
            if (renderer instanceof BarChartRenderer) {
                data = ((BarChartRenderer)renderer).mChart.getBarData();
            } else if (renderer instanceof LineChartRenderer) {
                data = ((LineChartRenderer)renderer).mChart.getLineData();
            } else if (renderer instanceof CandleStickChartRenderer) {
                data = ((CandleStickChartRenderer)renderer).mChart.getCandleData();
            } else if (renderer instanceof ScatterChartRenderer) {
                data = ((ScatterChartRenderer)renderer).mChart.getScatterData();
            } else if (renderer instanceof BubbleChartRenderer) {
                data = ((BubbleChartRenderer)renderer).mChart.getBubbleData();
            }
            int dataIndex = data == null ? -1 : ((CombinedData)chart.getData()).getAllData().indexOf(data);
            this.mHighlightBuffer.clear();
            for (Highlight h : indices) {
                if (h.getDataIndex() != dataIndex && h.getDataIndex() != -1) continue;
                this.mHighlightBuffer.add(h);
            }
            renderer.drawHighlighted(c, this.mHighlightBuffer.toArray(new Highlight[this.mHighlightBuffer.size()]));
        }
    }

    public DataRenderer getSubRenderer(int index) {
        if (index >= this.mRenderers.size() || index < 0) {
            return null;
        }
        return this.mRenderers.get(index);
    }

    public List<DataRenderer> getSubRenderers() {
        return this.mRenderers;
    }

    public void setSubRenderers(List<DataRenderer> renderers) {
        this.mRenderers = renderers;
    }
}

