/*
 * Decompiled with CFR 0.152.
 */
package com.sothree.slidinguppanel.canvasSaveProxy;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.util.Log;
import com.sothree.slidinguppanel.canvasSaveProxy.CanvasSaveProxy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/sothree/slidinguppanel/canvasSaveProxy/LegacyCanvasSaveProxy;", "Lcom/sothree/slidinguppanel/canvasSaveProxy/CanvasSaveProxy;", "canvas", "Landroid/graphics/Canvas;", "(Landroid/graphics/Canvas;)V", "clipSaveFlag", "", "clipSaveFlagValue", "getClipSaveFlagValue", "()I", "saveMethod", "Ljava/lang/reflect/Method;", "findSaveMethod", "invokeSave", "isFor", "", "save", "Companion", "library_release"})
public final class LegacyCanvasSaveProxy
implements CanvasSaveProxy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Canvas canvas;
    @NotNull
    private final Method saveMethod;
    private final int clipSaveFlag;
    private static final String TAG = CanvasSaveProxy.class.getSimpleName();
    @NotNull
    private static final String METHOD_NAME = "save";
    @NotNull
    private static final String FIELD_NAME = "CLIP_SAVE_FLAG";

    public LegacyCanvasSaveProxy(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.canvas = canvas;
        Log.d((String)TAG, (String)"New LegacyCanvasSaveProxy");
        this.saveMethod = this.findSaveMethod();
        this.clipSaveFlag = this.getClipSaveFlagValue();
    }

    @Override
    public int save() {
        return this.invokeSave();
    }

    @Override
    public boolean isFor(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        return canvas == this.canvas;
    }

    @SuppressLint(value={"DiscouragedPrivateApi"})
    private final int getClipSaveFlagValue() {
        int n;
        Field constantField = null;
        try {
            Field field = Canvas.class.getDeclaredField(FIELD_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"Canvas::class.java.getDeclaredField(FIELD_NAME)");
            constantField = field;
            Object object = constantField.get(null);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            n = (Integer)object;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Failed to get value of CLIP_SAVE_FLAG - NoSuchFieldException", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to get value of CLIP_SAVE_FLAG - IllegalAccessException", e);
        }
        return n;
    }

    private final Method findSaveMethod() {
        Method method;
        try {
            Class[] classArray = new Class[]{Integer.TYPE};
            method = Canvas.class.getMethod(METHOD_NAME, classArray);
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"{\n            Canvas::cl\u2026aPrimitiveType)\n        }");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Canvas does not contain a method with signature save(int)");
        }
        return method;
    }

    private final int invokeSave() {
        int n;
        try {
            Object[] objectArray = new Object[]{this.clipSaveFlag};
            Object object = this.saveMethod.invoke((Object)this.canvas, objectArray);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            n = (Integer)object;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to execute save(int) - IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Failed to execute save(int) - InvocationTargetException", e);
        }
        return n;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/sothree/slidinguppanel/canvasSaveProxy/LegacyCanvasSaveProxy$Companion;", "", "()V", "FIELD_NAME", "", "METHOD_NAME", "TAG", "kotlin.jvm.PlatformType", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

