/*
 * Decompiled with CFR 0.152.
 */
package hani.momanii.supernova_emoji_library.Helper;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import hani.momanii.supernova_emoji_library.Helper.EmojiconGridView;
import hani.momanii.supernova_emoji_library.Helper.EmojiconRecents;
import hani.momanii.supernova_emoji_library.Helper.EmojiconRecentsGridView;
import hani.momanii.supernova_emoji_library.Helper.EmojiconRecentsManager;
import hani.momanii.supernova_emoji_library.R;
import hani.momanii.supernova_emoji_library.emoji.Cars;
import hani.momanii.supernova_emoji_library.emoji.Electr;
import hani.momanii.supernova_emoji_library.emoji.Emojicon;
import hani.momanii.supernova_emoji_library.emoji.Food;
import hani.momanii.supernova_emoji_library.emoji.Nature;
import hani.momanii.supernova_emoji_library.emoji.People;
import hani.momanii.supernova_emoji_library.emoji.Sport;
import hani.momanii.supernova_emoji_library.emoji.Symbols;
import java.util.Arrays;
import java.util.List;

public class EmojiconsPopup
extends PopupWindow
implements ViewPager.OnPageChangeListener,
EmojiconRecents {
    private int mEmojiTabLastSelectedIndex = -1;
    private View[] mEmojiTabs;
    private PagerAdapter mEmojisAdapter;
    private EmojiconRecentsManager mRecentsManager;
    private int keyBoardHeight = 0;
    private Boolean pendingOpen = false;
    private Boolean isOpened = false;
    public EmojiconGridView.OnEmojiconClickedListener onEmojiconClickedListener;
    OnEmojiconBackspaceClickedListener onEmojiconBackspaceClickedListener;
    OnSoftKeyboardOpenCloseListener onSoftKeyboardOpenCloseListener;
    View rootView;
    Context mContext;
    boolean mUseSystemDefault = false;
    View view;
    int positionPager = 0;
    boolean setColor = false;
    String iconPressedColor = "#495C66";
    String tabsColor = "#DCE1E2";
    String backgroundColor = "#E6EBEF";
    private ViewPager emojisPager;

    public EmojiconsPopup(View rootView, Context mContext, boolean useSystemDefault, String iconPressedColor, String tabsColor, String backgroundColor) {
        super(mContext);
        this.setColor = true;
        this.backgroundColor = backgroundColor;
        this.iconPressedColor = iconPressedColor;
        this.tabsColor = tabsColor;
        this.mUseSystemDefault = useSystemDefault;
        this.mContext = mContext;
        this.rootView = rootView;
        View customView = this.createCustomView();
        this.setContentView(customView);
        this.setSoftInputMode(5);
        this.setSize(-1, 255);
        this.setBackgroundDrawable(null);
    }

    public EmojiconsPopup(View rootView, Context mContext, boolean useSystemDefault) {
        super(mContext);
        this.mUseSystemDefault = useSystemDefault;
        this.mContext = mContext;
        this.rootView = rootView;
        View customView = this.createCustomView();
        this.setContentView(customView);
        this.setSoftInputMode(5);
        this.setSize(-1, 255);
        this.setBackgroundDrawable(null);
    }

    public void setOnSoftKeyboardOpenCloseListener(OnSoftKeyboardOpenCloseListener listener) {
        this.onSoftKeyboardOpenCloseListener = listener;
    }

    public void setOnEmojiconClickedListener(EmojiconGridView.OnEmojiconClickedListener listener) {
        this.onEmojiconClickedListener = listener;
    }

    public void setOnEmojiconBackspaceClickedListener(OnEmojiconBackspaceClickedListener listener) {
        this.onEmojiconBackspaceClickedListener = listener;
    }

    public void showAtBottom() {
        this.showAtLocation(this.rootView, 80, 0, 0);
    }

    public void showAtBottomPending() {
        if (this.isKeyBoardOpen().booleanValue()) {
            this.showAtBottom();
        } else {
            this.pendingOpen = true;
        }
    }

    public Boolean isKeyBoardOpen() {
        return this.isOpened;
    }

    public void dismiss() {
        super.dismiss();
        EmojiconRecentsManager.getInstance(this.mContext).saveRecents();
    }

    public void setSizeForSoftKeyboard() {
        this.rootView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                Rect r = new Rect();
                EmojiconsPopup.this.rootView.getWindowVisibleDisplayFrame(r);
                int screenHeight = EmojiconsPopup.this.getUsableScreenHeight();
                int heightDifference = screenHeight - (r.bottom - r.top);
                int resourceId = EmojiconsPopup.this.mContext.getResources().getIdentifier("status_bar_height", "dimen", "android");
                if (resourceId > 0) {
                    heightDifference -= EmojiconsPopup.this.mContext.getResources().getDimensionPixelSize(resourceId);
                }
                if (heightDifference > 100) {
                    EmojiconsPopup.this.keyBoardHeight = heightDifference;
                    EmojiconsPopup.this.setSize(-1, EmojiconsPopup.this.keyBoardHeight);
                    if (!EmojiconsPopup.this.isOpened.booleanValue() && EmojiconsPopup.this.onSoftKeyboardOpenCloseListener != null) {
                        EmojiconsPopup.this.onSoftKeyboardOpenCloseListener.onKeyboardOpen(EmojiconsPopup.this.keyBoardHeight);
                    }
                    EmojiconsPopup.this.isOpened = true;
                    if (EmojiconsPopup.this.pendingOpen.booleanValue()) {
                        EmojiconsPopup.this.showAtBottom();
                        EmojiconsPopup.this.pendingOpen = false;
                    }
                } else {
                    EmojiconsPopup.this.isOpened = false;
                    if (EmojiconsPopup.this.onSoftKeyboardOpenCloseListener != null) {
                        EmojiconsPopup.this.onSoftKeyboardOpenCloseListener.onKeyboardClose();
                    }
                }
            }
        });
    }

    private int getUsableScreenHeight() {
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayMetrics metrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(metrics);
            return metrics.heightPixels;
        }
        return this.rootView.getRootView().getHeight();
    }

    public void setSize(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public void updateUseSystemDefault(boolean mUseSystemDefault) {
        if (this.view != null) {
            this.mEmojisAdapter = null;
            this.positionPager = this.emojisPager.getCurrentItem();
            this.dismiss();
            this.mUseSystemDefault = mUseSystemDefault;
            this.setContentView(this.createCustomView());
            this.mEmojiTabs[this.positionPager].setSelected(true);
            this.emojisPager.setCurrentItem(this.positionPager);
            this.onPageSelected(this.positionPager);
            if (!this.isShowing()) {
                if (this.isKeyBoardOpen().booleanValue()) {
                    this.showAtBottom();
                } else {
                    this.showAtBottomPending();
                }
            }
        }
    }

    private View createCustomView() {
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.view = inflater.inflate(R.layout.emojicons, null, false);
        this.emojisPager = (ViewPager)this.view.findViewById(R.id.emojis_pager);
        LinearLayout tabs = (LinearLayout)this.view.findViewById(R.id.emojis_tab);
        this.emojisPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        EmojiconsPopup recents = this;
        this.mEmojisAdapter = new EmojisPagerAdapter(Arrays.asList(new EmojiconRecentsGridView(this.mContext, null, null, this, this.mUseSystemDefault), new EmojiconGridView(this.mContext, People.DATA, recents, this, this.mUseSystemDefault), new EmojiconGridView(this.mContext, Nature.DATA, recents, this, this.mUseSystemDefault), new EmojiconGridView(this.mContext, Food.DATA, recents, this, this.mUseSystemDefault), new EmojiconGridView(this.mContext, Sport.DATA, recents, this, this.mUseSystemDefault), new EmojiconGridView(this.mContext, Cars.DATA, recents, this, this.mUseSystemDefault), new EmojiconGridView(this.mContext, Electr.DATA, recents, this, this.mUseSystemDefault), new EmojiconGridView(this.mContext, Symbols.DATA, recents, this, this.mUseSystemDefault)));
        this.emojisPager.setAdapter(this.mEmojisAdapter);
        this.mEmojiTabs = new View[8];
        this.mEmojiTabs[0] = this.view.findViewById(R.id.emojis_tab_0_recents);
        this.mEmojiTabs[1] = this.view.findViewById(R.id.emojis_tab_1_people);
        this.mEmojiTabs[2] = this.view.findViewById(R.id.emojis_tab_2_nature);
        this.mEmojiTabs[3] = this.view.findViewById(R.id.emojis_tab_3_food);
        this.mEmojiTabs[4] = this.view.findViewById(R.id.emojis_tab_4_sport);
        this.mEmojiTabs[5] = this.view.findViewById(R.id.emojis_tab_5_cars);
        this.mEmojiTabs[6] = this.view.findViewById(R.id.emojis_tab_6_elec);
        this.mEmojiTabs[7] = this.view.findViewById(R.id.emojis_tab_7_sym);
        for (int i = 0; i < this.mEmojiTabs.length; ++i) {
            final int position = i;
            this.mEmojiTabs[i].setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    EmojiconsPopup.this.emojisPager.setCurrentItem(position);
                }
            });
        }
        this.emojisPager.setBackgroundColor(Color.parseColor((String)this.backgroundColor));
        tabs.setBackgroundColor(Color.parseColor((String)this.tabsColor));
        for (int x = 0; x < this.mEmojiTabs.length; ++x) {
            ImageButton btn = (ImageButton)this.mEmojiTabs[x];
            btn.setColorFilter(Color.parseColor((String)this.iconPressedColor));
        }
        ImageButton imgBtn = (ImageButton)this.view.findViewById(R.id.emojis_backspace);
        imgBtn.setColorFilter(Color.parseColor((String)this.iconPressedColor));
        imgBtn.setBackgroundColor(Color.parseColor((String)this.backgroundColor));
        this.view.findViewById(R.id.emojis_backspace).setOnTouchListener((View.OnTouchListener)new RepeatListener(500, 50, new View.OnClickListener(){

            public void onClick(View v) {
                if (EmojiconsPopup.this.onEmojiconBackspaceClickedListener != null) {
                    EmojiconsPopup.this.onEmojiconBackspaceClickedListener.onEmojiconBackspaceClicked(v);
                }
            }
        }));
        this.mRecentsManager = EmojiconRecentsManager.getInstance(this.view.getContext());
        int page = this.mRecentsManager.getRecentPage();
        if (page == 0 && this.mRecentsManager.size() == 0) {
            page = 1;
        }
        if (page == 0) {
            this.onPageSelected(page);
        } else {
            this.emojisPager.setCurrentItem(page, false);
        }
        return this.view;
    }

    @Override
    public void addRecentEmoji(Context context, Emojicon emojicon) {
        EmojiconRecentsGridView fragment = ((EmojisPagerAdapter)this.emojisPager.getAdapter()).getRecentFragment();
        fragment.addRecentEmoji(context, emojicon);
    }

    public void onPageScrolled(int i, float v, int i2) {
    }

    public void onPageSelected(int i) {
        if (this.mEmojiTabLastSelectedIndex == i) {
            return;
        }
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (this.mEmojiTabLastSelectedIndex >= 0 && this.mEmojiTabLastSelectedIndex < this.mEmojiTabs.length) {
                    this.mEmojiTabs[this.mEmojiTabLastSelectedIndex].setSelected(false);
                }
                this.mEmojiTabs[i].setSelected(true);
                this.mEmojiTabLastSelectedIndex = i;
                this.mRecentsManager.setRecentPage(i);
            }
        }
    }

    public void onPageScrollStateChanged(int i) {
    }

    public static interface OnSoftKeyboardOpenCloseListener {
        public void onKeyboardOpen(int var1);

        public void onKeyboardClose();
    }

    public static interface OnEmojiconBackspaceClickedListener {
        public void onEmojiconBackspaceClicked(View var1);
    }

    public static class RepeatListener
    implements View.OnTouchListener {
        private Handler handler = new Handler();
        private int initialInterval;
        private final int normalInterval;
        private final View.OnClickListener clickListener;
        private Runnable handlerRunnable = new Runnable(){

            @Override
            public void run() {
                if (RepeatListener.this.downView == null) {
                    return;
                }
                RepeatListener.this.handler.removeCallbacksAndMessages((Object)RepeatListener.this.downView);
                RepeatListener.this.handler.postAtTime((Runnable)this, (Object)RepeatListener.this.downView, SystemClock.uptimeMillis() + (long)RepeatListener.this.normalInterval);
                RepeatListener.this.clickListener.onClick(RepeatListener.this.downView);
            }
        };
        private View downView;

        public RepeatListener(int initialInterval, int normalInterval, View.OnClickListener clickListener) {
            if (clickListener == null) {
                throw new IllegalArgumentException("null runnable");
            }
            if (initialInterval < 0 || normalInterval < 0) {
                throw new IllegalArgumentException("negative interval");
            }
            this.initialInterval = initialInterval;
            this.normalInterval = normalInterval;
            this.clickListener = clickListener;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            switch (motionEvent.getAction()) {
                case 0: {
                    this.downView = view;
                    this.handler.removeCallbacks(this.handlerRunnable);
                    this.handler.postAtTime(this.handlerRunnable, (Object)this.downView, SystemClock.uptimeMillis() + (long)this.initialInterval);
                    this.clickListener.onClick(view);
                    return true;
                }
                case 1: 
                case 3: 
                case 4: {
                    this.handler.removeCallbacksAndMessages((Object)this.downView);
                    this.downView = null;
                    return true;
                }
            }
            return false;
        }
    }

    private static class EmojisPagerAdapter
    extends PagerAdapter {
        private List<EmojiconGridView> views;

        public EmojiconRecentsGridView getRecentFragment() {
            for (EmojiconGridView it : this.views) {
                if (!(it instanceof EmojiconRecentsGridView)) continue;
                return (EmojiconRecentsGridView)it;
            }
            return null;
        }

        public EmojisPagerAdapter(List<EmojiconGridView> views) {
            this.views = views;
        }

        public int getCount() {
            return this.views.size();
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View v = this.views.get((int)position).rootView;
            ((ViewPager)container).addView(v, 0);
            return v;
        }

        public void destroyItem(ViewGroup container, int position, Object view) {
            ((ViewPager)container).removeView((View)view);
        }

        public boolean isViewFromObject(View view, Object key) {
            return key == view;
        }
    }
}

