/*
 * Decompiled with CFR 0.152.
 */
package hani.momanii.supernova_emoji_library.Helper;

import android.content.Context;
import android.text.Spannable;
import android.util.SparseIntArray;
import hani.momanii.supernova_emoji_library.Helper.EmojiconSpan;
import hani.momanii.supernova_emoji_library.R;
import java.util.HashMap;
import java.util.Map;

public final class EmojiconHandler {
    private static final SparseIntArray sEmojisMap = new SparseIntArray(1029);
    private static final SparseIntArray sSoftbanksMap = new SparseIntArray(471);
    private static Map<String, Integer> sEmojisModifiedMap = new HashMap<String, Integer>();

    private EmojiconHandler() {
    }

    private static boolean isSoftBankEmoji(char c) {
        return c >> 12 == 14;
    }

    private static int getEmojiResource(Context context, int codePoint) {
        return sEmojisMap.get(codePoint);
    }

    private static int getSoftbankEmojiResource(char c) {
        return sSoftbanksMap.get((int)c);
    }

    public static void addEmojis(Context context, Spannable text, int emojiSize, int emojiAlignment, int textSize) {
        EmojiconHandler.addEmojis(context, text, emojiSize, emojiAlignment, textSize, 0, -1, false);
    }

    public static void addEmojis(Context context, Spannable text, int emojiSize, int emojiAlignment, int textSize, int index, int length) {
        EmojiconHandler.addEmojis(context, text, emojiSize, emojiAlignment, textSize, index, length, false);
    }

    public static void addEmojis(Context context, Spannable text, int emojiSize, int emojiAlignment, int textSize, boolean useSystemDefault) {
        EmojiconHandler.addEmojis(context, text, emojiSize, emojiAlignment, textSize, 0, -1, useSystemDefault);
    }

    public static void addEmojis(Context context, Spannable text, int emojiSize, int emojiAlignment, int textSize, int index, int length, boolean useSystemDefault) {
        int skip;
        if (useSystemDefault) {
            return;
        }
        int textLength = text.length();
        int textLengthToProcessMax = textLength - index;
        int textLengthToProcess = length < 0 || length >= textLengthToProcessMax ? textLength : length + index;
        EmojiconSpan[] oldSpans = (EmojiconSpan[])text.getSpans(0, textLength, EmojiconSpan.class);
        for (int i = 0; i < oldSpans.length; ++i) {
            text.removeSpan((Object)oldSpans[i]);
        }
        for (int i = index; i < textLengthToProcess; i += skip) {
            skip = 0;
            int icon = 0;
            char c = text.charAt(i);
            if (EmojiconHandler.isSoftBankEmoji(c)) {
                icon = EmojiconHandler.getSoftbankEmojiResource(c);
                int n = skip = icon == 0 ? 0 : 1;
            }
            if (icon == 0) {
                int unicode = Character.codePointAt((CharSequence)text, i);
                skip = Character.charCount(unicode);
                if (unicode > 255) {
                    icon = EmojiconHandler.getEmojiResource(context, unicode);
                }
                if (i + skip < textLengthToProcess) {
                    int followSkip;
                    int followUnicode = Character.codePointAt((CharSequence)text, i + skip);
                    if (followUnicode == 65039) {
                        int nextFollowUnicode;
                        followSkip = Character.charCount(followUnicode);
                        if (i + skip + followSkip < textLengthToProcess && (nextFollowUnicode = Character.codePointAt((CharSequence)text, i + skip + followSkip)) == 8419) {
                            int nextFollowSkip = Character.charCount(nextFollowUnicode);
                            int tempIcon = EmojiconHandler.getKeyCapEmoji(unicode);
                            if (tempIcon == 0) {
                                followSkip = 0;
                                nextFollowSkip = 0;
                            } else {
                                icon = tempIcon;
                            }
                            skip += followSkip + nextFollowSkip;
                        }
                    } else if (followUnicode == 8419) {
                        followSkip = Character.charCount(followUnicode);
                        int tempIcon = EmojiconHandler.getKeyCapEmoji(unicode);
                        if (tempIcon == 0) {
                            followSkip = 0;
                        } else {
                            icon = tempIcon;
                        }
                        skip += followSkip;
                    } else {
                        followSkip = Character.charCount(followUnicode);
                        String hexUnicode = Integer.toHexString(unicode);
                        String hexFollowUnicode = Integer.toHexString(followUnicode);
                        String resourceName = "emoji_" + hexUnicode + "_" + hexFollowUnicode;
                        int resourceId = 0;
                        if (sEmojisModifiedMap.containsKey(resourceName)) {
                            resourceId = sEmojisModifiedMap.get(resourceName);
                        } else {
                            resourceId = context.getResources().getIdentifier(resourceName, "drawable", context.getApplicationContext().getPackageName());
                            if (resourceId != 0) {
                                sEmojisModifiedMap.put(resourceName, resourceId);
                            }
                        }
                        if (resourceId == 0) {
                            followSkip = 0;
                        } else {
                            icon = resourceId;
                        }
                        skip += followSkip;
                    }
                }
            }
            if (icon <= 0) continue;
            text.setSpan((Object)new EmojiconSpan(context, icon, emojiSize), i, i + skip, 33);
        }
    }

    private static int getKeyCapEmoji(int unicode) {
        int icon = 0;
        switch (unicode) {
            case 35: {
                icon = R.drawable.emoji_0023;
                break;
            }
            case 42: {
                icon = R.drawable.emoji_002a_20e3;
                break;
            }
            case 48: {
                icon = R.drawable.emoji_0030;
                break;
            }
            case 49: {
                icon = R.drawable.emoji_0031;
                break;
            }
            case 50: {
                icon = R.drawable.emoji_0032;
                break;
            }
            case 51: {
                icon = R.drawable.emoji_0033;
                break;
            }
            case 52: {
                icon = R.drawable.emoji_0034;
                break;
            }
            case 53: {
                icon = R.drawable.emoji_0035;
                break;
            }
            case 54: {
                icon = R.drawable.emoji_0036;
                break;
            }
            case 55: {
                icon = R.drawable.emoji_0037;
                break;
            }
            case 56: {
                icon = R.drawable.emoji_0038;
                break;
            }
            case 57: {
                icon = R.drawable.emoji_0039;
                break;
            }
        }
        return icon;
    }

    static {
        sEmojisMap.put(128512, R.drawable.emoji_1f600);
        sEmojisMap.put(128556, R.drawable.emoji_1f62c);
        sEmojisMap.put(128513, R.drawable.emoji_1f601);
        sEmojisMap.put(128514, R.drawable.emoji_1f602);
        sEmojisMap.put(128515, R.drawable.emoji_1f603);
        sEmojisMap.put(128516, R.drawable.emoji_1f604);
        sEmojisMap.put(128517, R.drawable.emoji_1f605);
        sEmojisMap.put(128518, R.drawable.emoji_1f606);
        sEmojisMap.put(128519, R.drawable.emoji_1f607);
        sEmojisMap.put(128521, R.drawable.emoji_1f609);
        sEmojisMap.put(128522, R.drawable.emoji_1f60a);
        sEmojisMap.put(128578, R.drawable.emoji_1f642);
        sEmojisMap.put(128579, R.drawable.emoji_1f643);
        sEmojisMap.put(9786, R.drawable.emoji_263a);
        sEmojisMap.put(128523, R.drawable.emoji_1f60b);
        sEmojisMap.put(128524, R.drawable.emoji_1f60c);
        sEmojisMap.put(128525, R.drawable.emoji_1f60d);
        sEmojisMap.put(128536, R.drawable.emoji_1f618);
        sEmojisMap.put(128535, R.drawable.emoji_1f617);
        sEmojisMap.put(128537, R.drawable.emoji_1f619);
        sEmojisMap.put(128538, R.drawable.emoji_1f61a);
        sEmojisMap.put(128540, R.drawable.emoji_1f61c);
        sEmojisMap.put(128541, R.drawable.emoji_1f61d);
        sEmojisMap.put(128539, R.drawable.emoji_1f61b);
        sEmojisMap.put(129297, R.drawable.emoji_1f911);
        sEmojisMap.put(129299, R.drawable.emoji_1f913);
        sEmojisMap.put(128526, R.drawable.emoji_1f60e);
        sEmojisMap.put(129303, R.drawable.emoji_1f917);
        sEmojisMap.put(128527, R.drawable.emoji_1f60f);
        sEmojisMap.put(128566, R.drawable.emoji_1f636);
        sEmojisMap.put(128528, R.drawable.emoji_1f610);
        sEmojisMap.put(128529, R.drawable.emoji_1f611);
        sEmojisMap.put(128530, R.drawable.emoji_1f612);
        sEmojisMap.put(128580, R.drawable.emoji_1f644);
        sEmojisMap.put(129300, R.drawable.emoji_1f914);
        sEmojisMap.put(128563, R.drawable.emoji_1f633);
        sEmojisMap.put(128542, R.drawable.emoji_1f61e);
        sEmojisMap.put(128543, R.drawable.emoji_1f61f);
        sEmojisMap.put(128544, R.drawable.emoji_1f620);
        sEmojisMap.put(128545, R.drawable.emoji_1f621);
        sEmojisMap.put(128532, R.drawable.emoji_1f614);
        sEmojisMap.put(128533, R.drawable.emoji_1f615);
        sEmojisMap.put(128577, R.drawable.emoji_1f641);
        sEmojisMap.put(9785, R.drawable.emoji_2639);
        sEmojisMap.put(128547, R.drawable.emoji_1f623);
        sEmojisMap.put(128534, R.drawable.emoji_1f616);
        sEmojisMap.put(128555, R.drawable.emoji_1f62b);
        sEmojisMap.put(128553, R.drawable.emoji_1f629);
        sEmojisMap.put(128548, R.drawable.emoji_1f624);
        sEmojisMap.put(128558, R.drawable.emoji_1f62e);
        sEmojisMap.put(128561, R.drawable.emoji_1f631);
        sEmojisMap.put(128552, R.drawable.emoji_1f628);
        sEmojisMap.put(128560, R.drawable.emoji_1f630);
        sEmojisMap.put(128559, R.drawable.emoji_1f62f);
        sEmojisMap.put(128550, R.drawable.emoji_1f626);
        sEmojisMap.put(128551, R.drawable.emoji_1f627);
        sEmojisMap.put(128546, R.drawable.emoji_1f622);
        sEmojisMap.put(128549, R.drawable.emoji_1f625);
        sEmojisMap.put(128554, R.drawable.emoji_1f62a);
        sEmojisMap.put(128531, R.drawable.emoji_1f613);
        sEmojisMap.put(128557, R.drawable.emoji_1f62d);
        sEmojisMap.put(128565, R.drawable.emoji_1f635);
        sEmojisMap.put(128562, R.drawable.emoji_1f632);
        sEmojisMap.put(129296, R.drawable.emoji_1f910);
        sEmojisMap.put(128567, R.drawable.emoji_1f637);
        sEmojisMap.put(129298, R.drawable.emoji_1f912);
        sEmojisMap.put(129301, R.drawable.emoji_1f915);
        sEmojisMap.put(128564, R.drawable.emoji_1f634);
        sEmojisMap.put(128164, R.drawable.emoji_1f4a4);
        sEmojisMap.put(128169, R.drawable.emoji_1f4a9);
        sEmojisMap.put(128520, R.drawable.emoji_1f608);
        sEmojisMap.put(128127, R.drawable.emoji_1f47f);
        sEmojisMap.put(128121, R.drawable.emoji_1f479);
        sEmojisMap.put(128122, R.drawable.emoji_1f47a);
        sEmojisMap.put(128128, R.drawable.emoji_1f480);
        sEmojisMap.put(128123, R.drawable.emoji_1f47b);
        sEmojisMap.put(128125, R.drawable.emoji_1f47d);
        sEmojisMap.put(129302, R.drawable.emoji_1f916);
        sEmojisMap.put(128570, R.drawable.emoji_1f63a);
        sEmojisMap.put(128568, R.drawable.emoji_1f638);
        sEmojisMap.put(128569, R.drawable.emoji_1f639);
        sEmojisMap.put(128571, R.drawable.emoji_1f63b);
        sEmojisMap.put(128572, R.drawable.emoji_1f63c);
        sEmojisMap.put(128573, R.drawable.emoji_1f63d);
        sEmojisMap.put(128576, R.drawable.emoji_1f640);
        sEmojisMap.put(128575, R.drawable.emoji_1f63f);
        sEmojisMap.put(128574, R.drawable.emoji_1f63e);
        sEmojisMap.put(128588, R.drawable.emoji_1f64c_1f3fb);
        sEmojisMap.put(128079, R.drawable.emoji_1f44f_1f3fb);
        sEmojisMap.put(128075, R.drawable.emoji_1f44b_1f3fb);
        sEmojisMap.put(128077, R.drawable.emoji_1f44d_1f3fb);
        sEmojisMap.put(128078, R.drawable.emoji_1f44e_1f3fb);
        sEmojisMap.put(128074, R.drawable.emoji_1f44a_1f3fb);
        sEmojisMap.put(9994, R.drawable.emoji_270a_1f3fb);
        sEmojisMap.put(9996, R.drawable.emoji_270c_1f3fb);
        sEmojisMap.put(128076, R.drawable.emoji_1f44c_1f3fb);
        sEmojisMap.put(9995, R.drawable.emoji_270b_1f3fb);
        sEmojisMap.put(128080, R.drawable.emoji_1f450_1f3fb);
        sEmojisMap.put(128170, R.drawable.emoji_1f4aa_1f3fb);
        sEmojisMap.put(128591, R.drawable.emoji_1f64f_1f3fb);
        sEmojisMap.put(9757, R.drawable.emoji_261d_1f3fb);
        sEmojisMap.put(128070, R.drawable.emoji_1f446_1f3fb);
        sEmojisMap.put(128071, R.drawable.emoji_1f447_1f3fb);
        sEmojisMap.put(128072, R.drawable.emoji_1f448_1f3fb);
        sEmojisMap.put(128073, R.drawable.emoji_1f449_1f3fb);
        sEmojisMap.put(128405, R.drawable.emoji_1f595_1f3fb);
        sEmojisMap.put(128400, R.drawable.emoji_1f590_1f3fb);
        sEmojisMap.put(129304, R.drawable.emoji_1f918_1f3fb);
        sEmojisMap.put(9997, R.drawable.emoji_270d_1f3fb);
        sEmojisMap.put(128133, R.drawable.emoji_1f485_1f3fb);
        sEmojisMap.put(128068, R.drawable.emoji_1f444);
        sEmojisMap.put(128069, R.drawable.emoji_1f445);
        sEmojisMap.put(128066, R.drawable.emoji_1f442_1f3fb);
        sEmojisMap.put(128067, R.drawable.emoji_1f443_1f3fb);
        sEmojisMap.put(128065, R.drawable.emoji_1f441);
        sEmojisMap.put(128064, R.drawable.emoji_1f440);
        sEmojisMap.put(128100, R.drawable.emoji_1f464);
        sEmojisMap.put(128101, R.drawable.emoji_1f465);
        sEmojisMap.put(128483, R.drawable.emoji_1f5e3);
        sEmojisMap.put(128118, R.drawable.emoji_1f476_1f3fb);
        sEmojisMap.put(128102, R.drawable.emoji_1f466_1f3fb);
        sEmojisMap.put(128103, R.drawable.emoji_1f467_1f3fb);
        sEmojisMap.put(128104, R.drawable.emoji_1f468_1f3fb);
        sEmojisMap.put(128105, R.drawable.emoji_1f469_1f3fb);
        sEmojisMap.put(128113, R.drawable.emoji_1f471_1f3fb);
        sEmojisMap.put(128116, R.drawable.emoji_1f474_1f3fb);
        sEmojisMap.put(128117, R.drawable.emoji_1f475_1f3fb);
        sEmojisMap.put(128114, R.drawable.emoji_1f472_1f3fb);
        sEmojisMap.put(128115, R.drawable.emoji_1f473_1f3fb);
        sEmojisMap.put(128110, R.drawable.emoji_1f46e_1f3fb);
        sEmojisMap.put(128119, R.drawable.emoji_1f477_1f3fb);
        sEmojisMap.put(128130, R.drawable.emoji_1f482_1f3fb);
        sEmojisMap.put(128373, R.drawable.emoji_1f575);
        sEmojisMap.put(127877, R.drawable.emoji_1f385_1f3fb);
        sEmojisMap.put(128124, R.drawable.emoji_1f47c_1f3fb);
        sEmojisMap.put(128120, R.drawable.emoji_1f478_1f3fb);
        sEmojisMap.put(128112, R.drawable.emoji_1f470_1f3fb);
        sEmojisMap.put(128694, R.drawable.emoji_1f6b6_1f3fb);
        sEmojisMap.put(127939, R.drawable.emoji_1f3c3_1f3fb);
        sEmojisMap.put(128131, R.drawable.emoji_1f483_1f3fb);
        sEmojisMap.put(128111, R.drawable.emoji_1f46f);
        sEmojisMap.put(10024, R.drawable.emoji_2728);
        sEmojisMap.put(127775, R.drawable.emoji_1f31f);
        sEmojisMap.put(128171, R.drawable.emoji_1f4ab);
        sEmojisMap.put(128162, R.drawable.emoji_1f4a2);
        sEmojisMap.put(128107, R.drawable.emoji_1f46b);
        sEmojisMap.put(128108, R.drawable.emoji_1f46c);
        sEmojisMap.put(128109, R.drawable.emoji_1f46d);
        sEmojisMap.put(128583, R.drawable.emoji_1f647_1f3fb);
        sEmojisMap.put(128129, R.drawable.emoji_1f481_1f3fb);
        sEmojisMap.put(128581, R.drawable.emoji_1f645_1f3fb);
        sEmojisMap.put(128582, R.drawable.emoji_1f646_1f3fb);
        sEmojisMap.put(128587, R.drawable.emoji_1f64b_1f3fb);
        sEmojisMap.put(128590, R.drawable.emoji_1f64e_1f3fb);
        sEmojisMap.put(128589, R.drawable.emoji_1f64d_1f3fb);
        sEmojisMap.put(128135, R.drawable.emoji_1f487_1f3fb);
        sEmojisMap.put(128134, R.drawable.emoji_1f486_1f3fb);
        sEmojisMap.put(128145, R.drawable.emoji_1f491);
        sEmojisMap.put(128143, R.drawable.emoji_1f48f);
        sEmojisMap.put(128106, R.drawable.emoji_1f46a);
        sEmojisMap.put(128090, R.drawable.emoji_1f45a);
        sEmojisMap.put(128085, R.drawable.emoji_1f455);
        sEmojisMap.put(128086, R.drawable.emoji_1f456);
        sEmojisMap.put(128084, R.drawable.emoji_1f454);
        sEmojisMap.put(128087, R.drawable.emoji_1f457);
        sEmojisMap.put(128089, R.drawable.emoji_1f459);
        sEmojisMap.put(128088, R.drawable.emoji_1f458);
        sEmojisMap.put(128132, R.drawable.emoji_1f484);
        sEmojisMap.put(128139, R.drawable.emoji_1f48b);
        sEmojisMap.put(128099, R.drawable.emoji_1f463);
        sEmojisMap.put(128096, R.drawable.emoji_1f460);
        sEmojisMap.put(128097, R.drawable.emoji_1f461);
        sEmojisMap.put(128098, R.drawable.emoji_1f462);
        sEmojisMap.put(128094, R.drawable.emoji_1f45e);
        sEmojisMap.put(128095, R.drawable.emoji_1f45f);
        sEmojisMap.put(128082, R.drawable.emoji_1f452);
        sEmojisMap.put(127913, R.drawable.emoji_1f3a9);
        sEmojisMap.put(127891, R.drawable.emoji_1f393);
        sEmojisMap.put(128081, R.drawable.emoji_1f451);
        sEmojisMap.put(9937, R.drawable.emoji_26d1);
        sSoftbanksMap.put(58426, R.drawable.emoji_1f392);
        sEmojisMap.put(128093, R.drawable.emoji_1f45d);
        sEmojisMap.put(128091, R.drawable.emoji_1f45b);
        sEmojisMap.put(128092, R.drawable.emoji_1f45c);
        sEmojisMap.put(128188, R.drawable.emoji_1f4bc);
        sEmojisMap.put(128083, R.drawable.emoji_1f453);
        sEmojisMap.put(128374, R.drawable.emoji_1f576);
        sEmojisMap.put(128141, R.drawable.emoji_1f48d);
        sEmojisMap.put(127746, R.drawable.emoji_1f302);
        sEmojisMap.put(128054, R.drawable.emoji_1f436);
        sEmojisMap.put(128049, R.drawable.emoji_1f431);
        sEmojisMap.put(128045, R.drawable.emoji_1f42d);
        sEmojisMap.put(128057, R.drawable.emoji_1f439);
        sEmojisMap.put(128048, R.drawable.emoji_1f430);
        sEmojisMap.put(128059, R.drawable.emoji_1f43b);
        sEmojisMap.put(128060, R.drawable.emoji_1f43c);
        sEmojisMap.put(128040, R.drawable.emoji_1f428);
        sEmojisMap.put(128047, R.drawable.emoji_1f42f);
        sEmojisMap.put(129409, R.drawable.emoji_1f981);
        sEmojisMap.put(128046, R.drawable.emoji_1f42e);
        sEmojisMap.put(128055, R.drawable.emoji_1f437);
        sEmojisMap.put(128061, R.drawable.emoji_1f43d);
        sEmojisMap.put(128056, R.drawable.emoji_1f438);
        sEmojisMap.put(128025, R.drawable.emoji_1f419);
        sEmojisMap.put(128053, R.drawable.emoji_1f435);
        sEmojisMap.put(128584, R.drawable.emoji_1f648);
        sEmojisMap.put(128585, R.drawable.emoji_1f649);
        sEmojisMap.put(128586, R.drawable.emoji_1f64a);
        sEmojisMap.put(128018, R.drawable.emoji_1f412);
        sEmojisMap.put(128020, R.drawable.emoji_1f414);
        sEmojisMap.put(128039, R.drawable.emoji_1f427);
        sEmojisMap.put(128038, R.drawable.emoji_1f426);
        sEmojisMap.put(128036, R.drawable.emoji_1f424);
        sEmojisMap.put(128035, R.drawable.emoji_1f423);
        sEmojisMap.put(128037, R.drawable.emoji_1f425);
        sEmojisMap.put(128058, R.drawable.emoji_1f43a);
        sEmojisMap.put(128023, R.drawable.emoji_1f417);
        sEmojisMap.put(128052, R.drawable.emoji_1f434);
        sEmojisMap.put(129412, R.drawable.emoji_1f984);
        sEmojisMap.put(128029, R.drawable.emoji_1f41d);
        sEmojisMap.put(128027, R.drawable.emoji_1f41b);
        sEmojisMap.put(128012, R.drawable.emoji_1f40c);
        sEmojisMap.put(128030, R.drawable.emoji_1f41e);
        sEmojisMap.put(128028, R.drawable.emoji_1f41c);
        sEmojisMap.put(128375, R.drawable.emoji_1f577);
        sEmojisMap.put(129410, R.drawable.emoji_1f982);
        sEmojisMap.put(129408, R.drawable.emoji_1f980);
        sEmojisMap.put(128013, R.drawable.emoji_1f40d);
        sEmojisMap.put(128034, R.drawable.emoji_1f422);
        sEmojisMap.put(128032, R.drawable.emoji_1f420);
        sEmojisMap.put(128031, R.drawable.emoji_1f41f);
        sEmojisMap.put(128033, R.drawable.emoji_1f421);
        sEmojisMap.put(128044, R.drawable.emoji_1f42c);
        sEmojisMap.put(128051, R.drawable.emoji_1f433);
        sEmojisMap.put(128011, R.drawable.emoji_1f40b);
        sEmojisMap.put(128010, R.drawable.emoji_1f40a);
        sEmojisMap.put(128006, R.drawable.emoji_1f406);
        sEmojisMap.put(128005, R.drawable.emoji_1f405);
        sEmojisMap.put(128003, R.drawable.emoji_1f403);
        sEmojisMap.put(128002, R.drawable.emoji_1f402);
        sEmojisMap.put(128004, R.drawable.emoji_1f404);
        sEmojisMap.put(128042, R.drawable.emoji_1f42a);
        sEmojisMap.put(128043, R.drawable.emoji_1f42b);
        sEmojisMap.put(128024, R.drawable.emoji_1f418);
        sEmojisMap.put(128016, R.drawable.emoji_1f410);
        sEmojisMap.put(128015, R.drawable.emoji_1f40f);
        sEmojisMap.put(128017, R.drawable.emoji_1f411);
        sEmojisMap.put(128014, R.drawable.emoji_1f40e);
        sEmojisMap.put(128022, R.drawable.emoji_1f416);
        sEmojisMap.put(128000, R.drawable.emoji_1f400);
        sEmojisMap.put(128001, R.drawable.emoji_1f401);
        sEmojisMap.put(128019, R.drawable.emoji_1f413);
        sEmojisMap.put(129411, R.drawable.emoji_1f983);
        sEmojisMap.put(128330, R.drawable.emoji_1f54a);
        sEmojisMap.put(128021, R.drawable.emoji_1f415);
        sEmojisMap.put(128041, R.drawable.emoji_1f429);
        sEmojisMap.put(128008, R.drawable.emoji_1f408);
        sEmojisMap.put(128007, R.drawable.emoji_1f407);
        sEmojisMap.put(128063, R.drawable.emoji_1f43f);
        sEmojisMap.put(128062, R.drawable.emoji_1f43e);
        sEmojisMap.put(128009, R.drawable.emoji_1f409);
        sEmojisMap.put(128050, R.drawable.emoji_1f432);
        sEmojisMap.put(127797, R.drawable.emoji_1f335);
        sSoftbanksMap.put(57395, R.drawable.emoji_1f384);
        sEmojisMap.put(127794, R.drawable.emoji_1f332);
        sEmojisMap.put(127795, R.drawable.emoji_1f333);
        sEmojisMap.put(127796, R.drawable.emoji_1f334);
        sSoftbanksMap.put(57616, R.drawable.emoji_1f331);
        sEmojisMap.put(127807, R.drawable.emoji_1f33f);
        sEmojisMap.put(127808, R.drawable.emoji_1f340);
        sEmojisMap.put(127885, R.drawable.emoji_1f38d);
        sEmojisMap.put(127883, R.drawable.emoji_1f38b);
        sEmojisMap.put(127811, R.drawable.emoji_1f343);
        sEmojisMap.put(127810, R.drawable.emoji_1f342);
        sEmojisMap.put(127809, R.drawable.emoji_1f341);
        sEmojisMap.put(127806, R.drawable.emoji_1f33e);
        sEmojisMap.put(127802, R.drawable.emoji_1f33a);
        sEmojisMap.put(127803, R.drawable.emoji_1f33b);
        sEmojisMap.put(127801, R.drawable.emoji_1f339);
        sEmojisMap.put(127799, R.drawable.emoji_1f337);
        sEmojisMap.put(127804, R.drawable.emoji_1f33c);
        sEmojisMap.put(127800, R.drawable.emoji_1f338);
        sEmojisMap.put(128144, R.drawable.emoji_1f490);
        sEmojisMap.put(127812, R.drawable.emoji_1f344);
        sEmojisMap.put(127792, R.drawable.emoji_1f330);
        sEmojisMap.put(127875, R.drawable.emoji_1f383);
        sEmojisMap.put(128026, R.drawable.emoji_1f41a);
        sEmojisMap.put(128376, R.drawable.emoji_1f578);
        sEmojisMap.put(127757, R.drawable.emoji_1f30d);
        sEmojisMap.put(127758, R.drawable.emoji_1f30e);
        sEmojisMap.put(127759, R.drawable.emoji_1f30f);
        sEmojisMap.put(127765, R.drawable.emoji_1f315);
        sEmojisMap.put(127766, R.drawable.emoji_1f316);
        sEmojisMap.put(127767, R.drawable.emoji_1f317);
        sEmojisMap.put(127768, R.drawable.emoji_1f318);
        sEmojisMap.put(127761, R.drawable.emoji_1f311);
        sEmojisMap.put(127762, R.drawable.emoji_1f312);
        sEmojisMap.put(127763, R.drawable.emoji_1f313);
        sEmojisMap.put(127764, R.drawable.emoji_1f314);
        sEmojisMap.put(127770, R.drawable.emoji_1f31a);
        sEmojisMap.put(127773, R.drawable.emoji_1f31d);
        sEmojisMap.put(127771, R.drawable.emoji_1f31b);
        sEmojisMap.put(127772, R.drawable.emoji_1f31c);
        sEmojisMap.put(127774, R.drawable.emoji_1f31e);
        sEmojisMap.put(127769, R.drawable.emoji_1f319);
        sEmojisMap.put(11088, R.drawable.emoji_2b50);
        sSoftbanksMap.put(58165, R.drawable.emoji_1f31f);
        sSoftbanksMap.put(58158, R.drawable.emoji_2728);
        sEmojisMap.put(9732, R.drawable.emoji_2604);
        sEmojisMap.put(9728, R.drawable.emoji_2600);
        sEmojisMap.put(127780, R.drawable.emoji_1f324);
        sEmojisMap.put(9925, R.drawable.emoji_26c5);
        sEmojisMap.put(127781, R.drawable.emoji_1f325);
        sEmojisMap.put(127782, R.drawable.emoji_1f326);
        sEmojisMap.put(9729, R.drawable.emoji_2601);
        sEmojisMap.put(127783, R.drawable.emoji_1f327);
        sEmojisMap.put(9928, R.drawable.emoji_26c8);
        sEmojisMap.put(127785, R.drawable.emoji_1f329);
        sEmojisMap.put(9889, R.drawable.emoji_26a1);
        sSoftbanksMap.put(57629, R.drawable.emoji_1f525);
        sEmojisMap.put(128165, R.drawable.emoji_1f4a5);
        sEmojisMap.put(10052, R.drawable.emoji_2744);
        sEmojisMap.put(127784, R.drawable.emoji_1f328);
        sEmojisMap.put(9731, R.drawable.emoji_2603);
        sEmojisMap.put(9924, R.drawable.emoji_26c4);
        sEmojisMap.put(127788, R.drawable.emoji_1f32c);
        sEmojisMap.put(128168, R.drawable.emoji_1f4a8);
        sEmojisMap.put(127786, R.drawable.emoji_1f32a);
        sEmojisMap.put(127787, R.drawable.emoji_1f32b);
        sEmojisMap.put(9730, R.drawable.emoji_2602);
        sEmojisMap.put(9748, R.drawable.emoji_2614);
        sEmojisMap.put(128166, R.drawable.emoji_1f4a6);
        sEmojisMap.put(128167, R.drawable.emoji_1f4a7);
        sEmojisMap.put(127754, R.drawable.emoji_1f30a);
        sEmojisMap.put(127823, R.drawable.emoji_1f34f);
        sEmojisMap.put(127822, R.drawable.emoji_1f34e);
        sEmojisMap.put(127824, R.drawable.emoji_1f350);
        sEmojisMap.put(127818, R.drawable.emoji_1f34a);
        sEmojisMap.put(127819, R.drawable.emoji_1f34b);
        sEmojisMap.put(127820, R.drawable.emoji_1f34c);
        sEmojisMap.put(127817, R.drawable.emoji_1f349);
        sEmojisMap.put(127815, R.drawable.emoji_1f347);
        sEmojisMap.put(127827, R.drawable.emoji_1f353);
        sEmojisMap.put(127816, R.drawable.emoji_1f348);
        sEmojisMap.put(127826, R.drawable.emoji_1f352);
        sEmojisMap.put(127825, R.drawable.emoji_1f351);
        sEmojisMap.put(127821, R.drawable.emoji_1f34d);
        sEmojisMap.put(127813, R.drawable.emoji_1f345);
        sEmojisMap.put(127814, R.drawable.emoji_1f346);
        sEmojisMap.put(127798, R.drawable.emoji_1f336);
        sEmojisMap.put(127805, R.drawable.emoji_1f33d);
        sEmojisMap.put(127840, R.drawable.emoji_1f360);
        sEmojisMap.put(127855, R.drawable.emoji_1f36f);
        sEmojisMap.put(127838, R.drawable.emoji_1f35e);
        sEmojisMap.put(129472, R.drawable.emoji_1f9c0);
        sEmojisMap.put(127831, R.drawable.emoji_1f357);
        sEmojisMap.put(127830, R.drawable.emoji_1f356);
        sEmojisMap.put(127844, R.drawable.emoji_1f364);
        sEmojisMap.put(127859, R.drawable.emoji_1f373);
        sEmojisMap.put(127828, R.drawable.emoji_1f354);
        sEmojisMap.put(127839, R.drawable.emoji_1f35f);
        sEmojisMap.put(127789, R.drawable.emoji_1f32d);
        sEmojisMap.put(127829, R.drawable.emoji_1f355);
        sEmojisMap.put(127837, R.drawable.emoji_1f35d);
        sEmojisMap.put(127790, R.drawable.emoji_1f32e);
        sEmojisMap.put(127791, R.drawable.emoji_1f32f);
        sEmojisMap.put(127836, R.drawable.emoji_1f35c);
        sEmojisMap.put(127858, R.drawable.emoji_1f372);
        sEmojisMap.put(127845, R.drawable.emoji_1f365);
        sEmojisMap.put(127843, R.drawable.emoji_1f363);
        sEmojisMap.put(127857, R.drawable.emoji_1f371);
        sEmojisMap.put(127835, R.drawable.emoji_1f35b);
        sEmojisMap.put(127833, R.drawable.emoji_1f359);
        sEmojisMap.put(127834, R.drawable.emoji_1f35a);
        sEmojisMap.put(127832, R.drawable.emoji_1f358);
        sEmojisMap.put(127842, R.drawable.emoji_1f362);
        sEmojisMap.put(127841, R.drawable.emoji_1f361);
        sEmojisMap.put(127847, R.drawable.emoji_1f367);
        sEmojisMap.put(127848, R.drawable.emoji_1f368);
        sEmojisMap.put(127846, R.drawable.emoji_1f366);
        sEmojisMap.put(127856, R.drawable.emoji_1f370);
        sEmojisMap.put(127874, R.drawable.emoji_1f382);
        sEmojisMap.put(127854, R.drawable.emoji_1f36e);
        sEmojisMap.put(127852, R.drawable.emoji_1f36c);
        sEmojisMap.put(127853, R.drawable.emoji_1f36d);
        sEmojisMap.put(127851, R.drawable.emoji_1f36b);
        sEmojisMap.put(127871, R.drawable.emoji_1f37f);
        sEmojisMap.put(127849, R.drawable.emoji_1f369);
        sEmojisMap.put(127850, R.drawable.emoji_1f36a);
        sEmojisMap.put(127866, R.drawable.emoji_1f37a);
        sEmojisMap.put(127867, R.drawable.emoji_1f37b);
        sEmojisMap.put(127863, R.drawable.emoji_1f377);
        sEmojisMap.put(127864, R.drawable.emoji_1f378);
        sEmojisMap.put(127865, R.drawable.emoji_1f379);
        sEmojisMap.put(127870, R.drawable.emoji_1f37e);
        sEmojisMap.put(127862, R.drawable.emoji_1f376);
        sEmojisMap.put(127861, R.drawable.emoji_1f375);
        sEmojisMap.put(9749, R.drawable.emoji_2615);
        sEmojisMap.put(127868, R.drawable.emoji_1f37c);
        sEmojisMap.put(127860, R.drawable.emoji_1f374);
        sEmojisMap.put(127869, R.drawable.emoji_1f37d);
        sEmojisMap.put(9917, R.drawable.emoji_26bd);
        sEmojisMap.put(127936, R.drawable.emoji_1f3c0);
        sEmojisMap.put(127944, R.drawable.emoji_1f3c8);
        sEmojisMap.put(9918, R.drawable.emoji_26be);
        sEmojisMap.put(127934, R.drawable.emoji_1f3be);
        sEmojisMap.put(127952, R.drawable.emoji_1f3d0);
        sEmojisMap.put(127945, R.drawable.emoji_1f3c9);
        sEmojisMap.put(127921, R.drawable.emoji_1f3b1);
        sEmojisMap.put(9971, R.drawable.emoji_26f3);
        sEmojisMap.put(127948, R.drawable.emoji_1f3cc);
        sEmojisMap.put(127955, R.drawable.emoji_1f3d3);
        sEmojisMap.put(127992, R.drawable.emoji_1f3f8);
        sEmojisMap.put(127954, R.drawable.emoji_1f3d2);
        sEmojisMap.put(127953, R.drawable.emoji_1f3d1);
        sEmojisMap.put(127951, R.drawable.emoji_1f3cf);
        sEmojisMap.put(127935, R.drawable.emoji_1f3bf);
        sEmojisMap.put(9975, R.drawable.emoji_26f7);
        sEmojisMap.put(127938, R.drawable.emoji_1f3c2);
        sEmojisMap.put(9976, R.drawable.emoji_26f8);
        sEmojisMap.put(127993, R.drawable.emoji_1f3f9);
        sEmojisMap.put(127907, R.drawable.emoji_1f3a3);
        sEmojisMap.put(128675, R.drawable.emoji_1f6a3_1f3fb);
        sEmojisMap.put(127946, R.drawable.emoji_1f3ca_1f3fb);
        sEmojisMap.put(127940, R.drawable.emoji_1f3c4_1f3fb);
        sEmojisMap.put(128704, R.drawable.emoji_1f6c0_1f3fb);
        sEmojisMap.put(9977, R.drawable.emoji_26f9_1f3fb);
        sEmojisMap.put(127947, R.drawable.emoji_1f3cb_1f3fb);
        sEmojisMap.put(128692, R.drawable.emoji_1f6b4_1f3fb);
        sEmojisMap.put(128693, R.drawable.emoji_1f6b5_1f3fb);
        sEmojisMap.put(127943, R.drawable.emoji_1f3c7_1f3fb);
        sEmojisMap.put(128372, R.drawable.emoji_1f574);
        sEmojisMap.put(127942, R.drawable.emoji_1f3c6);
        sEmojisMap.put(127933, R.drawable.emoji_1f3bd);
        sEmojisMap.put(127941, R.drawable.emoji_1f3c5);
        sEmojisMap.put(127894, R.drawable.emoji_1f396);
        sEmojisMap.put(127895, R.drawable.emoji_1f397);
        sEmojisMap.put(127989, R.drawable.emoji_1f3f5);
        sSoftbanksMap.put(57637, R.drawable.emoji_1f3ab);
        sEmojisMap.put(127903, R.drawable.emoji_1f39f);
        sEmojisMap.put(127917, R.drawable.emoji_1f3ad);
        sEmojisMap.put(127912, R.drawable.emoji_1f3a8);
        sEmojisMap.put(127914, R.drawable.emoji_1f3aa);
        sEmojisMap.put(127908, R.drawable.emoji_1f3a4);
        sEmojisMap.put(127911, R.drawable.emoji_1f3a7);
        sEmojisMap.put(127932, R.drawable.emoji_1f3bc);
        sEmojisMap.put(127929, R.drawable.emoji_1f3b9);
        sEmojisMap.put(127927, R.drawable.emoji_1f3b7);
        sEmojisMap.put(127930, R.drawable.emoji_1f3ba);
        sEmojisMap.put(127931, R.drawable.emoji_1f3bb);
        sEmojisMap.put(127928, R.drawable.emoji_1f3b8);
        sEmojisMap.put(127916, R.drawable.emoji_1f3ac);
        sEmojisMap.put(127918, R.drawable.emoji_1f3ae);
        sEmojisMap.put(128126, R.drawable.emoji_1f47e);
        sEmojisMap.put(127919, R.drawable.emoji_1f3af);
        sEmojisMap.put(127922, R.drawable.emoji_1f3b2);
        sEmojisMap.put(127920, R.drawable.emoji_1f3b0);
        sEmojisMap.put(127923, R.drawable.emoji_1f3b3);
        sEmojisMap.put(128663, R.drawable.emoji_1f697);
        sEmojisMap.put(128661, R.drawable.emoji_1f695);
        sEmojisMap.put(128665, R.drawable.emoji_1f699);
        sEmojisMap.put(128652, R.drawable.emoji_1f68c);
        sEmojisMap.put(128654, R.drawable.emoji_1f68e);
        sEmojisMap.put(127950, R.drawable.emoji_1f3ce);
        sEmojisMap.put(128659, R.drawable.emoji_1f693);
        sEmojisMap.put(128657, R.drawable.emoji_1f691);
        sEmojisMap.put(128658, R.drawable.emoji_1f692);
        sEmojisMap.put(128656, R.drawable.emoji_1f690);
        sEmojisMap.put(128666, R.drawable.emoji_1f69a);
        sEmojisMap.put(128667, R.drawable.emoji_1f69b);
        sEmojisMap.put(128668, R.drawable.emoji_1f69c);
        sEmojisMap.put(127949, R.drawable.emoji_1f3cd);
        sEmojisMap.put(128690, R.drawable.emoji_1f6b2);
        sEmojisMap.put(128680, R.drawable.emoji_1f6a8);
        sEmojisMap.put(128660, R.drawable.emoji_1f694);
        sEmojisMap.put(128653, R.drawable.emoji_1f68d);
        sEmojisMap.put(128664, R.drawable.emoji_1f698);
        sEmojisMap.put(128662, R.drawable.emoji_1f696);
        sEmojisMap.put(128673, R.drawable.emoji_1f6a1);
        sEmojisMap.put(128672, R.drawable.emoji_1f6a0);
        sEmojisMap.put(128671, R.drawable.emoji_1f69f);
        sEmojisMap.put(128651, R.drawable.emoji_1f68b);
        sEmojisMap.put(128643, R.drawable.emoji_1f683);
        sEmojisMap.put(128669, R.drawable.emoji_1f69d);
        sEmojisMap.put(128644, R.drawable.emoji_1f684);
        sEmojisMap.put(128645, R.drawable.emoji_1f685);
        sEmojisMap.put(128648, R.drawable.emoji_1f688);
        sEmojisMap.put(128670, R.drawable.emoji_1f69e);
        sEmojisMap.put(128642, R.drawable.emoji_1f682);
        sEmojisMap.put(128646, R.drawable.emoji_1f686);
        sEmojisMap.put(128647, R.drawable.emoji_1f687);
        sEmojisMap.put(128650, R.drawable.emoji_1f68a);
        sEmojisMap.put(128649, R.drawable.emoji_1f689);
        sEmojisMap.put(128641, R.drawable.emoji_1f681);
        sEmojisMap.put(128745, R.drawable.emoji_1f6e9);
        sEmojisMap.put(9992, R.drawable.emoji_2708);
        sEmojisMap.put(128747, R.drawable.emoji_1f6eb);
        sEmojisMap.put(128748, R.drawable.emoji_1f6ec);
        sEmojisMap.put(9973, R.drawable.emoji_26f5);
        sEmojisMap.put(128741, R.drawable.emoji_1f6e5);
        sEmojisMap.put(128676, R.drawable.emoji_1f6a4);
        sEmojisMap.put(9972, R.drawable.emoji_26f4);
        sEmojisMap.put(128755, R.drawable.emoji_1f6f3);
        sEmojisMap.put(128640, R.drawable.emoji_1f680);
        sEmojisMap.put(128752, R.drawable.emoji_1f6f0);
        sEmojisMap.put(128186, R.drawable.emoji_1f4ba);
        sEmojisMap.put(9875, R.drawable.emoji_2693);
        sEmojisMap.put(128679, R.drawable.emoji_1f6a7);
        sEmojisMap.put(9981, R.drawable.emoji_26fd);
        sEmojisMap.put(128655, R.drawable.emoji_1f68f);
        sEmojisMap.put(128678, R.drawable.emoji_1f6a6);
        sEmojisMap.put(128677, R.drawable.emoji_1f6a5);
        sEmojisMap.put(127937, R.drawable.emoji_1f3c1);
        sEmojisMap.put(128674, R.drawable.emoji_1f6a2);
        sEmojisMap.put(127906, R.drawable.emoji_1f3a2);
        sEmojisMap.put(127904, R.drawable.emoji_1f3a0);
        sEmojisMap.put(127959, R.drawable.emoji_1f3d7);
        sEmojisMap.put(127745, R.drawable.emoji_1f301);
        sEmojisMap.put(128508, R.drawable.emoji_1f5fc);
        sEmojisMap.put(127981, R.drawable.emoji_1f3ed);
        sEmojisMap.put(9970, R.drawable.emoji_26f2);
        sSoftbanksMap.put(58438, R.drawable.emoji_1f391);
        sEmojisMap.put(9968, R.drawable.emoji_26f0);
        sEmojisMap.put(127956, R.drawable.emoji_1f3d4);
        sEmojisMap.put(128507, R.drawable.emoji_1f5fb);
        sEmojisMap.put(127755, R.drawable.emoji_1f30b);
        sEmojisMap.put(128510, R.drawable.emoji_1f5fe);
        sEmojisMap.put(127957, R.drawable.emoji_1f3d5);
        sEmojisMap.put(9978, R.drawable.emoji_26fa);
        sEmojisMap.put(127966, R.drawable.emoji_1f3de);
        sEmojisMap.put(128739, R.drawable.emoji_1f6e3);
        sEmojisMap.put(128740, R.drawable.emoji_1f6e4);
        sEmojisMap.put(127749, R.drawable.emoji_1f305);
        sEmojisMap.put(127748, R.drawable.emoji_1f304);
        sEmojisMap.put(127964, R.drawable.emoji_1f3dc);
        sEmojisMap.put(127958, R.drawable.emoji_1f3d6);
        sEmojisMap.put(127965, R.drawable.emoji_1f3dd);
        sEmojisMap.put(127751, R.drawable.emoji_1f307);
        sEmojisMap.put(127750, R.drawable.emoji_1f306);
        sEmojisMap.put(127961, R.drawable.emoji_1f3d9);
        sEmojisMap.put(127776, R.drawable.emoji_1f303);
        sEmojisMap.put(127753, R.drawable.emoji_1f309);
        sEmojisMap.put(127756, R.drawable.emoji_1f30c);
        sEmojisMap.put(127878, R.drawable.emoji_1f386);
        sEmojisMap.put(127879, R.drawable.emoji_1f387);
        sSoftbanksMap.put(58444, R.drawable.emoji_1f308);
        sEmojisMap.put(127960, R.drawable.emoji_1f3d8);
        sEmojisMap.put(127984, R.drawable.emoji_1f3f0);
        sEmojisMap.put(127983, R.drawable.emoji_1f3ef);
        sEmojisMap.put(127967, R.drawable.emoji_1f3df);
        sEmojisMap.put(128509, R.drawable.emoji_1f5fd);
        sEmojisMap.put(127968, R.drawable.emoji_1f3e0);
        sEmojisMap.put(127969, R.drawable.emoji_1f3e1);
        sEmojisMap.put(127962, R.drawable.emoji_1f3da);
        sEmojisMap.put(127970, R.drawable.emoji_1f3e2);
        sEmojisMap.put(127980, R.drawable.emoji_1f3ec);
        sEmojisMap.put(127971, R.drawable.emoji_1f3e3);
        sEmojisMap.put(127972, R.drawable.emoji_1f3e4);
        sEmojisMap.put(127973, R.drawable.emoji_1f3e5);
        sEmojisMap.put(127974, R.drawable.emoji_1f3e6);
        sEmojisMap.put(127976, R.drawable.emoji_1f3e8);
        sEmojisMap.put(127978, R.drawable.emoji_1f3ea);
        sEmojisMap.put(127979, R.drawable.emoji_1f3eb);
        sEmojisMap.put(127977, R.drawable.emoji_1f3e9);
        sEmojisMap.put(128146, R.drawable.emoji_1f492);
        sEmojisMap.put(127963, R.drawable.emoji_1f3db);
        sEmojisMap.put(9962, R.drawable.emoji_26ea);
        sEmojisMap.put(128332, R.drawable.emoji_1f54c);
        sEmojisMap.put(128331, R.drawable.emoji_1f54b);
        sEmojisMap.put(8986, R.drawable.emoji_231a);
        sEmojisMap.put(128241, R.drawable.emoji_1f4f1);
        sEmojisMap.put(128242, R.drawable.emoji_1f4f2);
        sEmojisMap.put(128187, R.drawable.emoji_1f4bb);
        sEmojisMap.put(9000, R.drawable.emoji_2328);
        sEmojisMap.put(128421, R.drawable.emoji_1f5a5);
        sEmojisMap.put(128424, R.drawable.emoji_1f5a8);
        sEmojisMap.put(128433, R.drawable.emoji_1f5b1);
        sEmojisMap.put(128434, R.drawable.emoji_1f5b2);
        sEmojisMap.put(128377, R.drawable.emoji_1f579);
        sEmojisMap.put(128476, R.drawable.emoji_1f5dc);
        sEmojisMap.put(128189, R.drawable.emoji_1f4bd);
        sEmojisMap.put(128190, R.drawable.emoji_1f4be);
        sEmojisMap.put(128191, R.drawable.emoji_1f4bf);
        sEmojisMap.put(128192, R.drawable.emoji_1f4c0);
        sEmojisMap.put(128252, R.drawable.emoji_1f4fc);
        sEmojisMap.put(128247, R.drawable.emoji_1f4f7);
        sEmojisMap.put(128248, R.drawable.emoji_1f4f8);
        sEmojisMap.put(128249, R.drawable.emoji_1f4f9);
        sEmojisMap.put(127909, R.drawable.emoji_1f3a5);
        sEmojisMap.put(128253, R.drawable.emoji_1f4fd);
        sEmojisMap.put(127902, R.drawable.emoji_1f39e);
        sEmojisMap.put(128222, R.drawable.emoji_1f4de);
        sEmojisMap.put(9742, R.drawable.emoji_260e);
        sEmojisMap.put(128223, R.drawable.emoji_1f4df);
        sEmojisMap.put(128224, R.drawable.emoji_1f4e0);
        sEmojisMap.put(128250, R.drawable.emoji_1f4fa);
        sEmojisMap.put(128251, R.drawable.emoji_1f4fb);
        sEmojisMap.put(127897, R.drawable.emoji_1f399);
        sEmojisMap.put(127898, R.drawable.emoji_1f39a);
        sEmojisMap.put(127899, R.drawable.emoji_1f39b);
        sEmojisMap.put(9201, R.drawable.emoji_23f1);
        sEmojisMap.put(9202, R.drawable.emoji_23f2);
        sEmojisMap.put(9200, R.drawable.emoji_23f0);
        sEmojisMap.put(128368, R.drawable.emoji_1f570);
        sEmojisMap.put(9203, R.drawable.emoji_23f3);
        sEmojisMap.put(8987, R.drawable.emoji_231b);
        sEmojisMap.put(128225, R.drawable.emoji_1f4e1);
        sEmojisMap.put(128267, R.drawable.emoji_1f50b);
        sEmojisMap.put(128268, R.drawable.emoji_1f50c);
        sEmojisMap.put(128161, R.drawable.emoji_1f4a1);
        sEmojisMap.put(128294, R.drawable.emoji_1f526);
        sEmojisMap.put(128367, R.drawable.emoji_1f56f);
        sEmojisMap.put(128465, R.drawable.emoji_1f5d1);
        sEmojisMap.put(128738, R.drawable.emoji_1f6e2);
        sEmojisMap.put(128184, R.drawable.emoji_1f4b8);
        sEmojisMap.put(128181, R.drawable.emoji_1f4b5);
        sEmojisMap.put(128180, R.drawable.emoji_1f4b4);
        sEmojisMap.put(128183, R.drawable.emoji_1f4b7);
        sEmojisMap.put(128182, R.drawable.emoji_1f4b6);
        sEmojisMap.put(128176, R.drawable.emoji_1f4b0);
        sEmojisMap.put(128179, R.drawable.emoji_1f4b3);
        sEmojisMap.put(128142, R.drawable.emoji_1f48e);
        sEmojisMap.put(9878, R.drawable.emoji_2696);
        sEmojisMap.put(128295, R.drawable.emoji_1f527);
        sEmojisMap.put(128296, R.drawable.emoji_1f528);
        sEmojisMap.put(9874, R.drawable.emoji_2692);
        sEmojisMap.put(128736, R.drawable.emoji_1f6e0);
        sEmojisMap.put(9935, R.drawable.emoji_26cf);
        sEmojisMap.put(128297, R.drawable.emoji_1f529);
        sEmojisMap.put(9881, R.drawable.emoji_2699);
        sEmojisMap.put(9939, R.drawable.emoji_26d3);
        sEmojisMap.put(128299, R.drawable.emoji_1f52b);
        sEmojisMap.put(128163, R.drawable.emoji_1f4a3);
        sEmojisMap.put(128298, R.drawable.emoji_1f52a);
        sEmojisMap.put(128481, R.drawable.emoji_1f5e1);
        sEmojisMap.put(9876, R.drawable.emoji_2694);
        sEmojisMap.put(128737, R.drawable.emoji_1f6e1);
        sEmojisMap.put(128684, R.drawable.emoji_1f6ac);
        sEmojisMap.put(9760, R.drawable.emoji_2620);
        sEmojisMap.put(9904, R.drawable.emoji_26b0);
        sEmojisMap.put(9905, R.drawable.emoji_26b1);
        sEmojisMap.put(127994, R.drawable.emoji_1f3fa);
        sEmojisMap.put(128302, R.drawable.emoji_1f52e);
        sEmojisMap.put(128255, R.drawable.emoji_1f4ff);
        sEmojisMap.put(128136, R.drawable.emoji_1f488);
        sEmojisMap.put(9879, R.drawable.emoji_2697);
        sEmojisMap.put(128300, R.drawable.emoji_1f52c);
        sEmojisMap.put(128301, R.drawable.emoji_1f52d);
        sEmojisMap.put(128371, R.drawable.emoji_1f573);
        sEmojisMap.put(128138, R.drawable.emoji_1f48a);
        sEmojisMap.put(128137, R.drawable.emoji_1f489);
        sEmojisMap.put(127777, R.drawable.emoji_1f321);
        sEmojisMap.put(127991, R.drawable.emoji_1f3f7);
        sEmojisMap.put(128278, R.drawable.emoji_1f516);
        sEmojisMap.put(128701, R.drawable.emoji_1f6bd);
        sEmojisMap.put(128703, R.drawable.emoji_1f6bf);
        sEmojisMap.put(128705, R.drawable.emoji_1f6c1);
        sEmojisMap.put(128273, R.drawable.emoji_1f511);
        sEmojisMap.put(128477, R.drawable.emoji_1f5dd);
        sEmojisMap.put(128715, R.drawable.emoji_1f6cb);
        sEmojisMap.put(128716, R.drawable.emoji_1f6cc);
        sEmojisMap.put(128719, R.drawable.emoji_1f6cf);
        sEmojisMap.put(128682, R.drawable.emoji_1f6aa);
        sEmojisMap.put(128718, R.drawable.emoji_1f6ce);
        sEmojisMap.put(128444, R.drawable.emoji_1f5bc);
        sEmojisMap.put(128506, R.drawable.emoji_1f5fa);
        sEmojisMap.put(9969, R.drawable.emoji_26f1);
        sEmojisMap.put(128511, R.drawable.emoji_1f5ff);
        sEmojisMap.put(128717, R.drawable.emoji_1f6cd);
        sEmojisMap.put(127880, R.drawable.emoji_1f388);
        sEmojisMap.put(127887, R.drawable.emoji_1f38f);
        sEmojisMap.put(127872, R.drawable.emoji_1f380);
        sEmojisMap.put(127873, R.drawable.emoji_1f381);
        sEmojisMap.put(127882, R.drawable.emoji_1f38a);
        sEmojisMap.put(127881, R.drawable.emoji_1f389);
        sSoftbanksMap.put(58424, R.drawable.emoji_1f38e);
        sEmojisMap.put(127888, R.drawable.emoji_1f390);
        sEmojisMap.put(127884, R.drawable.emoji_1f38c);
        sEmojisMap.put(127982, R.drawable.emoji_1f3ee);
        sEmojisMap.put(9993, R.drawable.emoji_2709);
        sEmojisMap.put(128233, R.drawable.emoji_1f4e9);
        sEmojisMap.put(128232, R.drawable.emoji_1f4e8);
        sEmojisMap.put(128231, R.drawable.emoji_1f4e7);
        sEmojisMap.put(128140, R.drawable.emoji_1f48c);
        sEmojisMap.put(128238, R.drawable.emoji_1f4ee);
        sEmojisMap.put(128234, R.drawable.emoji_1f4ea);
        sEmojisMap.put(128235, R.drawable.emoji_1f4eb);
        sEmojisMap.put(128236, R.drawable.emoji_1f4ec);
        sEmojisMap.put(128237, R.drawable.emoji_1f4ed);
        sEmojisMap.put(128230, R.drawable.emoji_1f4e6);
        sEmojisMap.put(128239, R.drawable.emoji_1f4ef);
        sEmojisMap.put(128229, R.drawable.emoji_1f4e5);
        sEmojisMap.put(128228, R.drawable.emoji_1f4e4);
        sEmojisMap.put(128220, R.drawable.emoji_1f4dc);
        sEmojisMap.put(128195, R.drawable.emoji_1f4c3);
        sEmojisMap.put(128209, R.drawable.emoji_1f4d1);
        sEmojisMap.put(128202, R.drawable.emoji_1f4ca);
        sEmojisMap.put(128200, R.drawable.emoji_1f4c8);
        sEmojisMap.put(128201, R.drawable.emoji_1f4c9);
        sEmojisMap.put(128196, R.drawable.emoji_1f4c4);
        sEmojisMap.put(128197, R.drawable.emoji_1f4c5);
        sEmojisMap.put(128198, R.drawable.emoji_1f4c6);
        sEmojisMap.put(128467, R.drawable.emoji_1f5d3);
        sEmojisMap.put(128199, R.drawable.emoji_1f4c7);
        sEmojisMap.put(128451, R.drawable.emoji_1f5c3);
        sEmojisMap.put(128499, R.drawable.emoji_1f5f3);
        sEmojisMap.put(128452, R.drawable.emoji_1f5c4);
        sEmojisMap.put(128203, R.drawable.emoji_1f4cb);
        sEmojisMap.put(128466, R.drawable.emoji_1f5d2);
        sEmojisMap.put(128193, R.drawable.emoji_1f4c1);
        sEmojisMap.put(128194, R.drawable.emoji_1f4c2);
        sEmojisMap.put(128450, R.drawable.emoji_1f5c2);
        sEmojisMap.put(128478, R.drawable.emoji_1f5de);
        sEmojisMap.put(128240, R.drawable.emoji_1f4f0);
        sEmojisMap.put(128211, R.drawable.emoji_1f4d3);
        sEmojisMap.put(128213, R.drawable.emoji_1f4d5);
        sEmojisMap.put(128215, R.drawable.emoji_1f4d7);
        sEmojisMap.put(128216, R.drawable.emoji_1f4d8);
        sEmojisMap.put(128217, R.drawable.emoji_1f4d9);
        sEmojisMap.put(128212, R.drawable.emoji_1f4d4);
        sEmojisMap.put(128210, R.drawable.emoji_1f4d2);
        sEmojisMap.put(128218, R.drawable.emoji_1f4da);
        sEmojisMap.put(128214, R.drawable.emoji_1f4d6);
        sEmojisMap.put(128279, R.drawable.emoji_1f517);
        sEmojisMap.put(128206, R.drawable.emoji_1f4ce);
        sEmojisMap.put(128391, R.drawable.emoji_1f587);
        sEmojisMap.put(9986, R.drawable.emoji_2702);
        sEmojisMap.put(128208, R.drawable.emoji_1f4d0);
        sEmojisMap.put(128207, R.drawable.emoji_1f4cf);
        sEmojisMap.put(128204, R.drawable.emoji_1f4cc);
        sEmojisMap.put(128205, R.drawable.emoji_1f4cd);
        sEmojisMap.put(127987, R.drawable.emoji_1f3f3);
        sEmojisMap.put(127988, R.drawable.emoji_1f3f4);
        sEmojisMap.put(128272, R.drawable.emoji_1f510);
        sEmojisMap.put(128274, R.drawable.emoji_1f512);
        sEmojisMap.put(128275, R.drawable.emoji_1f513);
        sEmojisMap.put(128271, R.drawable.emoji_1f50f);
        sEmojisMap.put(128394, R.drawable.emoji_1f58a);
        sEmojisMap.put(128395, R.drawable.emoji_1f58b);
        sEmojisMap.put(10002, R.drawable.emoji_2712);
        sEmojisMap.put(128221, R.drawable.emoji_1f4dd);
        sEmojisMap.put(9999, R.drawable.emoji_270f);
        sEmojisMap.put(128397, R.drawable.emoji_1f58d);
        sEmojisMap.put(128396, R.drawable.emoji_1f58c);
        sEmojisMap.put(128269, R.drawable.emoji_1f50d);
        sEmojisMap.put(128270, R.drawable.emoji_1f50e);
        sEmojisMap.put(10084, R.drawable.emoji_2764);
        sEmojisMap.put(128155, R.drawable.emoji_1f49b);
        sEmojisMap.put(128154, R.drawable.emoji_1f49a);
        sEmojisMap.put(128153, R.drawable.emoji_1f499);
        sEmojisMap.put(128156, R.drawable.emoji_1f49c);
        sEmojisMap.put(128148, R.drawable.emoji_1f494);
        sEmojisMap.put(10083, R.drawable.emoji_2763);
        sEmojisMap.put(128149, R.drawable.emoji_1f495);
        sEmojisMap.put(128158, R.drawable.emoji_1f49e);
        sEmojisMap.put(128147, R.drawable.emoji_1f493);
        sEmojisMap.put(128151, R.drawable.emoji_1f497);
        sEmojisMap.put(128150, R.drawable.emoji_1f496);
        sEmojisMap.put(128152, R.drawable.emoji_1f498);
        sEmojisMap.put(128157, R.drawable.emoji_1f49d);
        sEmojisMap.put(128159, R.drawable.emoji_1f49f);
        sEmojisMap.put(9774, R.drawable.emoji_262e);
        sEmojisMap.put(10013, R.drawable.emoji_271d);
        sEmojisMap.put(9770, R.drawable.emoji_262a);
        sEmojisMap.put(128329, R.drawable.emoji_1f549);
        sEmojisMap.put(9784, R.drawable.emoji_2638);
        sEmojisMap.put(128334, R.drawable.emoji_1f54e);
        sEmojisMap.put(9775, R.drawable.emoji_262f);
        sEmojisMap.put(127539, R.drawable.emoji_1f233);
        sEmojisMap.put(127545, R.drawable.emoji_1f239);
        sSoftbanksMap.put(58674, R.drawable.emoji_1f170);
        sSoftbanksMap.put(58675, R.drawable.emoji_1f171);
        sSoftbanksMap.put(58676, R.drawable.emoji_1f18e);
        sSoftbanksMap.put(58677, R.drawable.emoji_1f17e);
        sEmojisMap.put(127568, R.drawable.emoji_1f250);
        sEmojisMap.put(12953, R.drawable.emoji_3299);
        sEmojisMap.put(12951, R.drawable.emoji_3297);
        sEmojisMap.put(127540, R.drawable.emoji_1f234);
        sEmojisMap.put(127538, R.drawable.emoji_1f232);
        sEmojisMap.put(127377, R.drawable.emoji_1f191);
        sEmojisMap.put(127384, R.drawable.emoji_1f198);
        sEmojisMap.put(9940, R.drawable.emoji_26d4);
        sEmojisMap.put(128219, R.drawable.emoji_1f4db);
        sEmojisMap.put(128683, R.drawable.emoji_1f6ab);
        sEmojisMap.put(10060, R.drawable.emoji_274c);
        sEmojisMap.put(11093, R.drawable.emoji_2b55);
        sSoftbanksMap.put(58164, R.drawable.emoji_1f4a2);
        sEmojisMap.put(128286, R.drawable.emoji_1f51e);
        sEmojisMap.put(128245, R.drawable.emoji_1f4f5);
        sEmojisMap.put(128687, R.drawable.emoji_1f6af);
        sEmojisMap.put(128689, R.drawable.emoji_1f6b1);
        sEmojisMap.put(128691, R.drawable.emoji_1f6b3);
        sEmojisMap.put(128695, R.drawable.emoji_1f6b7);
        sEmojisMap.put(8252, R.drawable.emoji_203c);
        sEmojisMap.put(8265, R.drawable.emoji_2049);
        sEmojisMap.put(10071, R.drawable.emoji_2757);
        sEmojisMap.put(10067, R.drawable.emoji_2753);
        sEmojisMap.put(10069, R.drawable.emoji_2755);
        sEmojisMap.put(10068, R.drawable.emoji_2754);
        sEmojisMap.put(128175, R.drawable.emoji_1f4af);
        sSoftbanksMap.put(57938, R.drawable.emoji_26a0);
        sEmojisMap.put(128696, R.drawable.emoji_1f6b8);
        sEmojisMap.put(128262, R.drawable.emoji_1f506);
        sEmojisMap.put(128261, R.drawable.emoji_1f505);
        sEmojisMap.put(128305, R.drawable.emoji_1f531);
        sEmojisMap.put(128304, R.drawable.emoji_1f530);
        sEmojisMap.put(9851, R.drawable.emoji_267b);
        sEmojisMap.put(10035, R.drawable.emoji_2733);
        sEmojisMap.put(10055, R.drawable.emoji_2747);
        sEmojisMap.put(10062, R.drawable.emoji_274e);
        sEmojisMap.put(9989, R.drawable.emoji_2705);
        sEmojisMap.put(128185, R.drawable.emoji_1f4b9);
        sEmojisMap.put(127744, R.drawable.emoji_1f300);
        sEmojisMap.put(128702, R.drawable.emoji_1f6be);
        sEmojisMap.put(128688, R.drawable.emoji_1f6b0);
        sEmojisMap.put(127359, R.drawable.emoji_1f17f);
        sEmojisMap.put(9855, R.drawable.emoji_267f);
        sEmojisMap.put(128685, R.drawable.emoji_1f6ad);
        sEmojisMap.put(127490, R.drawable.emoji_1f202);
        sEmojisMap.put(9410, R.drawable.emoji_24c2);
        sEmojisMap.put(128706, R.drawable.emoji_1f6c2);
        sEmojisMap.put(128708, R.drawable.emoji_1f6c4);
        sEmojisMap.put(128709, R.drawable.emoji_1f6c5);
        sEmojisMap.put(128707, R.drawable.emoji_1f6c3);
        sEmojisMap.put(128697, R.drawable.emoji_1f6b9);
        sEmojisMap.put(128698, R.drawable.emoji_1f6ba);
        sEmojisMap.put(128700, R.drawable.emoji_1f6bc);
        sEmojisMap.put(128699, R.drawable.emoji_1f6bb);
        sEmojisMap.put(128686, R.drawable.emoji_1f6ae);
        sSoftbanksMap.put(57893, R.drawable.emoji_0030);
        sSoftbanksMap.put(57884, R.drawable.emoji_0031);
        sSoftbanksMap.put(57885, R.drawable.emoji_0032);
        sSoftbanksMap.put(57886, R.drawable.emoji_0033);
        sSoftbanksMap.put(57887, R.drawable.emoji_0034);
        sSoftbanksMap.put(57888, R.drawable.emoji_0035);
        sSoftbanksMap.put(57889, R.drawable.emoji_0036);
        sSoftbanksMap.put(57890, R.drawable.emoji_0037);
        sSoftbanksMap.put(57891, R.drawable.emoji_0038);
        sSoftbanksMap.put(57892, R.drawable.emoji_0039);
        sEmojisMap.put(128287, R.drawable.emoji_1f51f);
        sEmojisMap.put(128290, R.drawable.emoji_1f522);
        sEmojisMap.put(128291, R.drawable.emoji_1f523);
        sEmojisMap.put(11014, R.drawable.emoji_2b06);
        sEmojisMap.put(11015, R.drawable.emoji_2b07);
        sEmojisMap.put(11013, R.drawable.emoji_2b05);
        sEmojisMap.put(10145, R.drawable.emoji_27a1);
        sEmojisMap.put(128288, R.drawable.emoji_1f520);
        sEmojisMap.put(128289, R.drawable.emoji_1f521);
        sEmojisMap.put(128292, R.drawable.emoji_1f524);
        sEmojisMap.put(8599, R.drawable.emoji_2197);
        sEmojisMap.put(8598, R.drawable.emoji_2196);
        sEmojisMap.put(8600, R.drawable.emoji_2198);
        sEmojisMap.put(8601, R.drawable.emoji_2199);
        sEmojisMap.put(8596, R.drawable.emoji_2194);
        sEmojisMap.put(8597, R.drawable.emoji_2195);
        sEmojisMap.put(128260, R.drawable.emoji_1f504);
        sEmojisMap.put(9664, R.drawable.emoji_25c0);
        sEmojisMap.put(9654, R.drawable.emoji_25b6);
        sEmojisMap.put(128316, R.drawable.emoji_1f53c);
        sEmojisMap.put(128317, R.drawable.emoji_1f53d);
        sEmojisMap.put(8617, R.drawable.emoji_21a9);
        sEmojisMap.put(8618, R.drawable.emoji_21aa);
        sEmojisMap.put(8505, R.drawable.emoji_2139);
        sEmojisMap.put(9194, R.drawable.emoji_23ea);
        sEmojisMap.put(9193, R.drawable.emoji_23e9);
        sEmojisMap.put(9197, R.drawable.emoji_23ed);
        sEmojisMap.put(9199, R.drawable.emoji_23ef);
        sEmojisMap.put(9198, R.drawable.emoji_23ee);
        sEmojisMap.put(9208, R.drawable.emoji_23f8);
        sEmojisMap.put(9209, R.drawable.emoji_23f9);
        sEmojisMap.put(9210, R.drawable.emoji_23fa);
        sEmojisMap.put(9195, R.drawable.emoji_23eb);
        sEmojisMap.put(9196, R.drawable.emoji_23ec);
        sEmojisMap.put(10549, R.drawable.emoji_2935);
        sEmojisMap.put(10548, R.drawable.emoji_2934);
        sEmojisMap.put(127383, R.drawable.emoji_1f197);
        sEmojisMap.put(128256, R.drawable.emoji_1f500);
        sEmojisMap.put(128257, R.drawable.emoji_1f501);
        sEmojisMap.put(128258, R.drawable.emoji_1f502);
        sEmojisMap.put(127381, R.drawable.emoji_1f195);
        sEmojisMap.put(127385, R.drawable.emoji_1f199);
        sEmojisMap.put(127378, R.drawable.emoji_1f192);
        sEmojisMap.put(127379, R.drawable.emoji_1f193);
        sEmojisMap.put(127382, R.drawable.emoji_1f196);
        sEmojisMap.put(128246, R.drawable.emoji_1f4f6);
        sEmojisMap.put(127910, R.drawable.emoji_1f3a6);
        sEmojisMap.put(127489, R.drawable.emoji_1f201);
        sEmojisMap.put(128178, R.drawable.emoji_1f4b2);
        sEmojisMap.put(128177, R.drawable.emoji_1f4b1);
        sEmojisMap.put(169, R.drawable.emoji_00a9);
        sEmojisMap.put(174, R.drawable.emoji_00ae);
        sEmojisMap.put(8482, R.drawable.emoji_2122);
        sEmojisMap.put(128285, R.drawable.emoji_1f51d);
        sEmojisMap.put(128282, R.drawable.emoji_1f51a);
        sEmojisMap.put(128281, R.drawable.emoji_1f519);
        sEmojisMap.put(128283, R.drawable.emoji_1f51b);
        sEmojisMap.put(128284, R.drawable.emoji_1f51c);
        sEmojisMap.put(128259, R.drawable.emoji_1f503);
        sEmojisMap.put(10006, R.drawable.emoji_2716);
        sEmojisMap.put(10133, R.drawable.emoji_2795);
        sEmojisMap.put(10134, R.drawable.emoji_2796);
        sEmojisMap.put(10135, R.drawable.emoji_2797);
        sEmojisMap.put(10004, R.drawable.emoji_2714);
        sEmojisMap.put(9745, R.drawable.emoji_2611);
        sEmojisMap.put(128280, R.drawable.emoji_1f518);
        sEmojisMap.put(10160, R.drawable.emoji_27b0);
        sEmojisMap.put(12336, R.drawable.emoji_3030);
        sEmojisMap.put(128174, R.drawable.emoji_1f4ae);
        sEmojisMap.put(9724, R.drawable.emoji_25fc);
        sEmojisMap.put(9723, R.drawable.emoji_25fb);
        sEmojisMap.put(9726, R.drawable.emoji_25fe);
        sEmojisMap.put(9725, R.drawable.emoji_25fd);
        sEmojisMap.put(9642, R.drawable.emoji_25aa);
        sEmojisMap.put(9643, R.drawable.emoji_25ab);
        sEmojisMap.put(128314, R.drawable.emoji_1f53a);
        sEmojisMap.put(128306, R.drawable.emoji_1f532);
        sEmojisMap.put(128307, R.drawable.emoji_1f533);
        sEmojisMap.put(9899, R.drawable.emoji_26ab);
        sEmojisMap.put(9898, R.drawable.emoji_26aa);
        sEmojisMap.put(128308, R.drawable.emoji_1f534);
        sEmojisMap.put(128309, R.drawable.emoji_1f535);
        sEmojisMap.put(128315, R.drawable.emoji_1f53b);
        sEmojisMap.put(11036, R.drawable.emoji_2b1c);
        sEmojisMap.put(11035, R.drawable.emoji_2b1b);
        sEmojisMap.put(128310, R.drawable.emoji_1f536);
        sEmojisMap.put(128311, R.drawable.emoji_1f537);
        sEmojisMap.put(128312, R.drawable.emoji_1f538);
        sEmojisMap.put(128313, R.drawable.emoji_1f539);
        sEmojisMap.put(128266, R.drawable.emoji_1f50a);
        sEmojisMap.put(128265, R.drawable.emoji_1f509);
        sEmojisMap.put(128264, R.drawable.emoji_1f508);
        sEmojisMap.put(128263, R.drawable.emoji_1f507);
        sEmojisMap.put(128276, R.drawable.emoji_1f514);
        sEmojisMap.put(128277, R.drawable.emoji_1f515);
        sEmojisMap.put(128226, R.drawable.emoji_1f4e2);
        sEmojisMap.put(128227, R.drawable.emoji_1f4e3);
        sEmojisMap.put(127183, R.drawable.emoji_1f0cf);
        sEmojisMap.put(126980, R.drawable.emoji_1f004);
        sEmojisMap.put(9824, R.drawable.emoji_2660);
        sEmojisMap.put(9829, R.drawable.emoji_2665);
        sEmojisMap.put(9827, R.drawable.emoji_2663);
        sEmojisMap.put(9830, R.drawable.emoji_2666);
        sEmojisMap.put(127924, R.drawable.emoji_1f3b4);
        sEmojisMap.put(128172, R.drawable.emoji_1f4ac);
        sEmojisMap.put(128495, R.drawable.emoji_1f5ef);
        sEmojisMap.put(128173, R.drawable.emoji_1f4ad);
        sEmojisMap.put(128347, R.drawable.emoji_1f55b);
        sEmojisMap.put(128359, R.drawable.emoji_1f567);
        sEmojisMap.put(128336, R.drawable.emoji_1f550);
        sEmojisMap.put(128348, R.drawable.emoji_1f55c);
        sEmojisMap.put(128337, R.drawable.emoji_1f551);
        sEmojisMap.put(128349, R.drawable.emoji_1f55d);
        sEmojisMap.put(128338, R.drawable.emoji_1f552);
        sEmojisMap.put(128350, R.drawable.emoji_1f55e);
        sEmojisMap.put(128339, R.drawable.emoji_1f553);
        sEmojisMap.put(128351, R.drawable.emoji_1f55f);
        sEmojisMap.put(128340, R.drawable.emoji_1f554);
        sEmojisMap.put(128352, R.drawable.emoji_1f560);
        sEmojisMap.put(128341, R.drawable.emoji_1f555);
        sEmojisMap.put(128342, R.drawable.emoji_1f556);
        sEmojisMap.put(128343, R.drawable.emoji_1f557);
        sEmojisMap.put(128344, R.drawable.emoji_1f558);
        sEmojisMap.put(128345, R.drawable.emoji_1f559);
        sEmojisMap.put(128346, R.drawable.emoji_1f55a);
        sEmojisMap.put(128353, R.drawable.emoji_1f561);
        sEmojisMap.put(128354, R.drawable.emoji_1f562);
        sEmojisMap.put(128355, R.drawable.emoji_1f563);
        sEmojisMap.put(128356, R.drawable.emoji_1f564);
        sEmojisMap.put(128357, R.drawable.emoji_1f565);
        sEmojisMap.put(128358, R.drawable.emoji_1f566);
    }
}

