/*
 * Decompiled with CFR 0.152.
 */
package hani.momanii.supernova_emoji_library.Helper;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import hani.momanii.supernova_emoji_library.Helper.EmojiAdapter;
import hani.momanii.supernova_emoji_library.Helper.EmojiconRecents;
import hani.momanii.supernova_emoji_library.Helper.EmojiconsPopup;
import hani.momanii.supernova_emoji_library.R;
import hani.momanii.supernova_emoji_library.emoji.Emojicon;
import hani.momanii.supernova_emoji_library.emoji.People;
import java.util.Arrays;

public class EmojiconGridView {
    public View rootView;
    EmojiconsPopup mEmojiconPopup;
    EmojiconRecents mRecents;
    Emojicon[] mData;
    private boolean mUseSystemDefault = false;

    public EmojiconGridView(Context context, Emojicon[] emojicons, EmojiconRecents recents, EmojiconsPopup emojiconPopup, boolean useSystemDefault) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mEmojiconPopup = emojiconPopup;
        this.rootView = inflater.inflate(R.layout.emojicon_grid, null);
        this.setRecents(recents);
        GridView gridView = (GridView)this.rootView.findViewById(R.id.Emoji_GridView);
        if (emojicons == null) {
            this.mData = People.DATA;
        } else {
            Object[] o = emojicons;
            this.mData = Arrays.asList(o).toArray(new Emojicon[o.length]);
        }
        EmojiAdapter mAdapter = new EmojiAdapter(this.rootView.getContext(), this.mData, useSystemDefault);
        mAdapter.setEmojiClickListener(new OnEmojiconClickedListener(){

            @Override
            public void onEmojiconClicked(Emojicon emojicon) {
                if (EmojiconGridView.this.mEmojiconPopup.onEmojiconClickedListener != null) {
                    EmojiconGridView.this.mEmojiconPopup.onEmojiconClickedListener.onEmojiconClicked(emojicon);
                }
                if (EmojiconGridView.this.mRecents != null) {
                    EmojiconGridView.this.mRecents.addRecentEmoji(EmojiconGridView.this.rootView.getContext(), emojicon);
                }
            }
        });
        gridView.setAdapter((ListAdapter)mAdapter);
    }

    private void setRecents(EmojiconRecents recents) {
        this.mRecents = recents;
    }

    public static interface OnEmojiconClickedListener {
        public void onEmojiconClicked(Emojicon var1);
    }
}

