/*
 * Decompiled with CFR 0.152.
 */
package hani.momanii.supernova_emoji_library.Helper;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Spannable;
import android.util.AttributeSet;
import android.widget.EditText;
import hani.momanii.supernova_emoji_library.Helper.EmojiconHandler;
import hani.momanii.supernova_emoji_library.R;

public class EmojiconEditText
extends EditText {
    private int mEmojiconSize;
    private int mEmojiconAlignment;
    private int mEmojiconTextSize;
    private boolean mUseSystemDefault = false;

    public EmojiconEditText(Context context) {
        super(context);
        this.mEmojiconSize = (int)this.getTextSize();
        this.mEmojiconTextSize = (int)this.getTextSize();
    }

    public EmojiconEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public EmojiconEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.Emojicon);
        this.mEmojiconSize = (int)a.getDimension(R.styleable.Emojicon_emojiconSize, this.getTextSize());
        this.mEmojiconAlignment = a.getInt(R.styleable.Emojicon_emojiconAlignment, 1);
        this.mUseSystemDefault = a.getBoolean(R.styleable.Emojicon_emojiconUseSystemDefault, false);
        a.recycle();
        this.mEmojiconTextSize = (int)this.getTextSize();
        this.setText((CharSequence)this.getText());
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        this.updateText();
    }

    public void setEmojiconSize(int pixels) {
        this.mEmojiconSize = pixels;
        this.updateText();
    }

    private void updateText() {
        EmojiconHandler.addEmojis(this.getContext(), (Spannable)this.getText(), this.mEmojiconSize, this.mEmojiconAlignment, this.mEmojiconTextSize, this.mUseSystemDefault);
    }

    public void setUseSystemDefault(boolean useSystemDefault) {
        this.mUseSystemDefault = useSystemDefault;
    }
}

