/*
 * Decompiled with CFR 0.152.
 */
package hani.momanii.supernova_emoji_library.Actions;

import android.content.Context;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.PopupWindow;
import hani.momanii.supernova_emoji_library.Helper.EmojiconEditText;
import hani.momanii.supernova_emoji_library.Helper.EmojiconGridView;
import hani.momanii.supernova_emoji_library.Helper.EmojiconsPopup;
import hani.momanii.supernova_emoji_library.R;
import hani.momanii.supernova_emoji_library.emoji.Emojicon;

public class EmojIconActions
implements View.OnFocusChangeListener,
View.OnClickListener {
    private boolean autoHide = true;
    private boolean useSystemEmoji = false;
    private EmojiconsPopup popup;
    private Context context;
    private View rootView;
    private ImageView emojiButton;
    private EmojiconEditText emojiconEditText;
    private EmojiconEditText[] emojiconEditTexts;
    private int KeyBoardIcon = R.drawable.ic_action_keyboard;
    private int SmileyIcons = R.drawable.smiley;
    private KeyboardListener keyboardListener;

    public EmojIconActions(Context ctx, View rootView, ImageView emojiButton, EmojiconEditText ... emojiconEditText) {
        this.emojiconEditText = emojiconEditText[0];
        this.emojiconEditTexts = emojiconEditText;
        this.emojiButton = emojiButton;
        this.context = ctx;
        this.rootView = rootView;
        this.popup = new EmojiconsPopup(rootView, ctx, this.useSystemEmoji);
        this.setFocusListener();
    }

    public EmojIconActions(Context ctx, View rootView, ImageView emojiButton, String iconPressedColor, String tabsColor, String backgroundColor, EmojiconEditText ... emojiconEditText) {
        this.emojiconEditTexts = emojiconEditText;
        this.emojiButton = emojiButton;
        this.context = ctx;
        this.rootView = rootView;
        this.popup = new EmojiconsPopup(rootView, ctx, this.useSystemEmoji, iconPressedColor, tabsColor, backgroundColor);
    }

    public void setIconsIds(int keyboardIcon, int smileyIcon) {
        this.KeyBoardIcon = keyboardIcon;
        this.SmileyIcons = smileyIcon;
    }

    public void setUseSystemEmoji(boolean useSystemEmoji) {
        this.useSystemEmoji = useSystemEmoji;
        for (EmojiconEditText editText : this.emojiconEditTexts) {
            editText.setUseSystemDefault(useSystemEmoji);
            editText.setText((CharSequence)editText.getText());
        }
        this.refresh();
    }

    private void refresh() {
        this.popup.updateUseSystemDefault(this.useSystemEmoji);
    }

    public void ShowEmojicon() {
        this.popup.setSizeForSoftKeyboard();
        this.popup.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                EmojIconActions.this.changeEmojiKeyboardIcon(EmojIconActions.this.emojiButton, EmojIconActions.this.SmileyIcons);
            }
        });
        this.popup.setOnSoftKeyboardOpenCloseListener(new EmojiconsPopup.OnSoftKeyboardOpenCloseListener(){

            @Override
            public void onKeyboardOpen(int keyBoardHeight) {
                if (EmojIconActions.this.keyboardListener != null) {
                    EmojIconActions.this.keyboardListener.onKeyboardOpen();
                }
            }

            @Override
            public void onKeyboardClose() {
                if (EmojIconActions.this.keyboardListener != null) {
                    EmojIconActions.this.keyboardListener.onKeyboardClose();
                }
                if (EmojIconActions.this.popup.isShowing()) {
                    EmojIconActions.this.popup.dismiss();
                }
            }
        });
        this.popup.setOnEmojiconClickedListener(new EmojiconGridView.OnEmojiconClickedListener(){

            @Override
            public void onEmojiconClicked(Emojicon emojicon) {
                if (EmojIconActions.this.emojiconEditText == null || emojicon == null) {
                    return;
                }
                int start = EmojIconActions.this.emojiconEditText.getSelectionStart();
                int end = EmojIconActions.this.emojiconEditText.getSelectionEnd();
                if (start < 0) {
                    EmojIconActions.this.emojiconEditText.append(emojicon.getEmoji());
                } else {
                    EmojIconActions.this.emojiconEditText.getText().replace(Math.min(start, end), Math.max(start, end), (CharSequence)emojicon.getEmoji(), 0, emojicon.getEmoji().length());
                }
            }
        });
        this.popup.setOnEmojiconBackspaceClickedListener(new EmojiconsPopup.OnEmojiconBackspaceClickedListener(){

            @Override
            public void onEmojiconBackspaceClicked(View v) {
                KeyEvent event = new KeyEvent(0L, 0L, 0, 67, 0, 0, 0, 0, 6);
                EmojIconActions.this.emojiconEditText.dispatchKeyEvent(event);
            }
        });
        this.emojiButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!EmojIconActions.this.popup.isShowing()) {
                    if (EmojIconActions.this.popup.isKeyBoardOpen().booleanValue()) {
                        EmojIconActions.this.popup.showAtBottom();
                        EmojIconActions.this.changeEmojiKeyboardIcon(EmojIconActions.this.emojiButton, EmojIconActions.this.KeyBoardIcon);
                    } else {
                        EmojIconActions.this.emojiconEditText.setFocusableInTouchMode(true);
                        EmojIconActions.this.emojiconEditText.requestFocus();
                        EmojIconActions.this.popup.showAtBottomPending();
                        InputMethodManager inputMethodManager = (InputMethodManager)EmojIconActions.this.context.getSystemService("input_method");
                        inputMethodManager.showSoftInput((View)EmojIconActions.this.emojiconEditText, 1);
                        EmojIconActions.this.changeEmojiKeyboardIcon(EmojIconActions.this.emojiButton, EmojIconActions.this.KeyBoardIcon);
                    }
                } else {
                    EmojIconActions.this.popup.dismiss();
                }
            }
        });
    }

    public void closeEmojicon() {
        if (this.popup != null && this.popup.isShowing()) {
            this.popup.dismiss();
        }
    }

    private void changeEmojiKeyboardIcon(ImageView iconToBeChanged, int drawableResourceId) {
        iconToBeChanged.setImageResource(drawableResourceId);
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (v instanceof EmojiconEditText && v.hasFocus()) {
            this.emojiconEditText = (EmojiconEditText)v;
        }
    }

    public void onClick(View v) {
        if (this.autoHide && v instanceof EmojiconEditText) {
            this.closeEmojicon();
        }
    }

    public void setAutoHide(boolean auto) {
        this.autoHide = auto;
    }

    public void setKeyboardListener(KeyboardListener listener) {
        this.keyboardListener = listener;
    }

    private void setFocusListener() {
        for (EmojiconEditText editText : this.emojiconEditTexts) {
            editText.setOnFocusChangeListener(this);
            editText.setOnClickListener(this);
        }
    }

    public static interface KeyboardListener {
        public void onKeyboardOpen();

        public void onKeyboardClose();
    }
}

