/*
 * Decompiled with CFR 0.152.
 */
package hakobastvatsatryan.flowzard.router;

import android.content.Intent;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import hakobastvatsatryan.flowzard.Result;
import hakobastvatsatryan.flowzard.data.BundleDataBunch;
import hakobastvatsatryan.flowzard.data.DataBunch;
import hakobastvatsatryan.flowzard.router.Command;
import hakobastvatsatryan.flowzard.router.Navigator;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001b\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u000fH\u0014J\b\u0010\u001d\u001a\u00020\u0013H\u0002J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010!H$J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010!H$J\b\u0010%\u001a\u00020\u0013H$J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020/H\u0014J\u0010\u00100\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u000201H\u0014J\u0010\u00102\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u000203H\u0002J*\u00104\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u00105\u001a\u0004\u0018\u00010\u001f2\u0006\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u000208H\u0014J\u0010\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020;H\u0002J\u0012\u0010<\u001a\u0004\u0018\u00010#2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010=\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006>"}, d2={"Lhakobastvatsatryan/flowzard/router/SupportFragmentNavigator;", "Lhakobastvatsatryan/flowzard/router/Navigator;", "activity", "Landroid/support/v7/app/AppCompatActivity;", "containerId", "", "(Landroid/support/v7/app/AppCompatActivity;I)V", "getActivity", "()Landroid/support/v7/app/AppCompatActivity;", "fragmentManager", "Landroid/support/v4/app/FragmentManager;", "getFragmentManager", "()Landroid/support/v4/app/FragmentManager;", "stack", "Ljava/util/LinkedList;", "", "getStack", "()Ljava/util/LinkedList;", "applyCommand", "", "command", "Lhakobastvatsatryan/flowzard/router/Command;", "applyCommands", "commands", "", "([Lhakobastvatsatryan/flowzard/router/Command;)V", "backToRoot", "backToUnexisting", "screenKey", "copyStackFromFragmentManager", "createFragment", "Landroid/support/v4/app/Fragment;", "data", "", "getActivityIntent", "Landroid/content/Intent;", "id", "onExit", "processAddCommand", "Lhakobastvatsatryan/flowzard/router/Command$Add;", "processBackCommand", "Lhakobastvatsatryan/flowzard/router/Command$Back;", "processBackToCommand", "Lhakobastvatsatryan/flowzard/router/Command$BackTo;", "processEndFlowCommand", "Lhakobastvatsatryan/flowzard/router/Command$EndFlow;", "processForwardCommand", "Lhakobastvatsatryan/flowzard/router/Command$Forward;", "processReplaceCommand", "Lhakobastvatsatryan/flowzard/router/Command$Replace;", "processStartFlowCommand", "Lhakobastvatsatryan/flowzard/router/Command$StartFlow;", "processTransaction", "currentFragment", "nextFragment", "fragmentTransaction", "Landroid/support/v4/app/FragmentTransaction;", "resultToCode", "result", "Lhakobastvatsatryan/flowzard/Result;", "resultToData", "unknownScreen", "flowzard_release"})
public abstract class SupportFragmentNavigator
implements Navigator {
    @NotNull
    private final LinkedList<String> stack;
    @NotNull
    private final AppCompatActivity activity;
    private final int containerId;

    @NotNull
    protected abstract Intent getActivityIntent(@NotNull String var1, @Nullable Object var2);

    @Nullable
    protected abstract Fragment createFragment(@NotNull String var1, @Nullable Object var2);

    protected abstract void onExit();

    @NotNull
    protected final LinkedList<String> getStack() {
        return this.stack;
    }

    private final FragmentManager getFragmentManager() {
        FragmentManager fragmentManager = this.activity.getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"activity.supportFragmentManager");
        return fragmentManager;
    }

    @Override
    public void applyCommands(@NotNull Command[] commands) {
        Command[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)commands, (String)"commands");
        this.getFragmentManager().executePendingTransactions();
        this.copyStackFromFragmentManager();
        Command[] commandArray = $receiver$iv = commands;
        int n = commandArray.length;
        for (int i = 0; i < n; ++i) {
            Command element$iv;
            Command it = element$iv = commandArray[i];
            this.applyCommand(it);
        }
    }

    protected void applyCommand(@NotNull Command command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Command command2 = command;
        if (command2 instanceof Command.StartFlow) {
            this.processStartFlowCommand((Command.StartFlow)command);
        } else if (command2 instanceof Command.EndFlow) {
            this.processEndFlowCommand((Command.EndFlow)command);
        } else if (command2 instanceof Command.Forward) {
            this.processForwardCommand((Command.Forward)command);
        } else if (command2 instanceof Command.Replace) {
            this.processReplaceCommand((Command.Replace)command);
        } else if (command2 instanceof Command.BackTo) {
            this.processBackToCommand((Command.BackTo)command);
        } else if (command2 instanceof Command.Back) {
            this.processBackCommand((Command.Back)command);
        } else if (command2 instanceof Command.Add) {
            this.processAddCommand((Command.Add)command);
        }
    }

    private final void processStartFlowCommand(Command.StartFlow command) {
        Intent intent = this.getActivityIntent(command.getId(), command.getData());
        intent.putExtra("flow-id", command.getId());
        intent.putExtra("flow-instance-id", command.getInstanceId());
        if (command.getRequestCode() != null) {
            this.activity.startActivityForResult(intent, command.getRequestCode().intValue());
        } else {
            this.activity.startActivity(intent);
        }
    }

    private final void processEndFlowCommand(Command.EndFlow command) {
        if (command.getResult() != null) {
            this.activity.setResult(this.resultToCode(command.getResult()), this.resultToData(command.getResult()));
        }
        this.activity.finish();
    }

    protected void processForwardCommand(@NotNull Command.Forward command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Fragment fragment = this.createFragment(command.getScreenKey(), command.getData());
        if (fragment == null) {
            this.unknownScreen(command);
        } else {
            FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentTransaction, (String)"this.fragmentManager.beginTransaction()");
            FragmentTransaction transaction = fragmentTransaction;
            this.processTransaction(command, this.getFragmentManager().findFragmentById(this.containerId), fragment, transaction);
            transaction.replace(this.containerId, fragment).addToBackStack(command.getScreenKey()).commit();
            this.stack.add(command.getScreenKey());
        }
    }

    protected void processReplaceCommand(@NotNull Command.Replace command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Fragment fragment = this.createFragment(command.getScreenKey(), command.getData());
        if (fragment == null) {
            this.unknownScreen(command);
        } else {
            if (this.stack.size() > 0) {
                this.getFragmentManager().popBackStack();
                this.stack.pop();
            }
            FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentTransaction, (String)"this.fragmentManager.beginTransaction()");
            FragmentTransaction transaction = fragmentTransaction;
            this.processTransaction(command, this.getFragmentManager().findFragmentById(this.containerId), fragment, transaction);
            transaction.replace(this.containerId, fragment).addToBackStack(command.getScreenKey()).commit();
            this.stack.add(command.getScreenKey());
        }
    }

    protected void processAddCommand(@NotNull Command.Add command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Fragment fragment = this.createFragment(command.getScreenKey(), command.getData());
        if (fragment == null) {
            this.unknownScreen(command);
        } else {
            FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
            Intrinsics.checkExpressionValueIsNotNull((Object)fragmentTransaction, (String)"this.fragmentManager.beginTransaction()");
            FragmentTransaction transaction = fragmentTransaction;
            this.processTransaction(command, this.getFragmentManager().findFragmentById(this.containerId), fragment, transaction);
            transaction.add(this.containerId, fragment).addToBackStack(command.getScreenKey()).commit();
            this.stack.add(command.getScreenKey());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void processBackToCommand(@NotNull Command.BackTo command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        String key = command.getScreenKey();
        if (key == null) {
            this.backToRoot();
        } else {
            int index = this.stack.indexOf(key);
            int size = this.stack.size();
            if (index != -1) {
                int n = 1;
                int n2 = size - index;
                while (n < n2) {
                    void i;
                    this.stack.pop();
                    ++i;
                }
                this.getFragmentManager().popBackStack(key, 0);
            } else {
                this.backToUnexisting(command.getScreenKey());
            }
        }
    }

    protected void processBackCommand(@NotNull Command.Back command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        if (this.stack.size() > 0) {
            this.getFragmentManager().popBackStack();
            this.stack.pop();
        } else {
            this.onExit();
        }
    }

    private final void backToRoot() {
        this.getFragmentManager().popBackStack(null, 1);
        this.stack.clear();
    }

    protected void processTransaction(@NotNull Command command, @Nullable Fragment currentFragment, @NotNull Fragment nextFragment, @NotNull FragmentTransaction fragmentTransaction) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)nextFragment, (String)"nextFragment");
        Intrinsics.checkParameterIsNotNull((Object)fragmentTransaction, (String)"fragmentTransaction");
    }

    protected void unknownScreen(@NotNull Command command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        throw (Throwable)new RuntimeException("Can't create a screen for passed screenKey.");
    }

    protected void backToUnexisting(@NotNull String screenKey) {
        Intrinsics.checkParameterIsNotNull((Object)screenKey, (String)"screenKey");
        this.backToRoot();
    }

    /*
     * WARNING - void declaration
     */
    private final void copyStackFromFragmentManager() {
        int stackSize = this.getFragmentManager().getBackStackEntryCount();
        int n = 0;
        int n2 = stackSize;
        while (n < n2) {
            void i;
            FragmentManager.BackStackEntry backStackEntry = this.getFragmentManager().getBackStackEntryAt((int)i);
            Intrinsics.checkExpressionValueIsNotNull((Object)backStackEntry, (String)"this.fragmentManager.getBackStackEntryAt(i)");
            this.stack.add(backStackEntry.getName());
            ++i;
        }
    }

    private final int resultToCode(Result result) {
        int n;
        Result result2 = result;
        if (Intrinsics.areEqual((Object)result2, (Object)Result.CANCEL.INSTANCE)) {
            n = 0;
        } else if (result2 instanceof Result.SUCCESS) {
            n = -1;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final Intent resultToData(Result result) {
        Intent intent;
        Result result2 = result;
        if (!(result2 instanceof Result.SUCCESS)) {
            result2 = null;
        }
        Result.SUCCESS sUCCESS = (Result.SUCCESS)result2;
        DataBunch dataBunch = sUCCESS != null ? sUCCESS.getData() : null;
        if (!(dataBunch instanceof BundleDataBunch)) {
            dataBunch = null;
        }
        BundleDataBunch bundleDataBunch = (BundleDataBunch)dataBunch;
        if (bundleDataBunch != null) {
            BundleDataBunch bundleDataBunch2;
            BundleDataBunch it = bundleDataBunch2 = bundleDataBunch;
            intent = new Intent().putExtras(it.getBundle());
        } else {
            intent = null;
        }
        return intent;
    }

    @NotNull
    public final AppCompatActivity getActivity() {
        return this.activity;
    }

    public SupportFragmentNavigator(@NotNull AppCompatActivity activity, int containerId) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        this.activity = activity;
        this.containerId = containerId;
        this.stack = new LinkedList();
    }
}

