/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

public class PriorityQueue {
    private int n;
    private int d;
    private double[] a;
    private int[] pq;
    private int[] qp;

    private boolean less(int i, int j) {
        return this.a[this.pq[i]] < this.a[this.pq[j]];
    }

    private void swap(int i, int j) {
        int t2 = this.pq[i];
        this.pq[i] = this.pq[j];
        this.pq[j] = t2;
        this.qp[this.pq[i]] = i;
        this.qp[this.pq[j]] = j;
    }

    private void swim(int k) {
        while (k > 1 && this.less(k, (k + this.d - 2) / this.d)) {
            this.swap(k, (k + this.d - 2) / this.d);
            k = (k + this.d - 2) / this.d;
        }
    }

    private void sink(int k, int N) {
        int j;
        while ((j = this.d * (k - 1) + 2) <= N) {
            for (int i = j + 1; i < j + this.d && i <= N; ++i) {
                if (!this.less(i, j)) continue;
                j = i;
            }
            if (!this.less(j, k)) break;
            this.swap(k, j);
            k = j;
        }
    }

    public PriorityQueue(double[] a) {
        this(3, a);
    }

    public PriorityQueue(int d, double[] a) {
        this.d = d;
        this.a = a;
        this.n = 0;
        this.pq = new int[a.length + 1];
        this.qp = new int[a.length + 1];
    }

    public boolean empty() {
        return this.n == 0;
    }

    public void insert(int v) {
        this.pq[++this.n] = v;
        this.qp[v] = this.n;
        this.swim(this.n);
    }

    public int poll() {
        this.swap(1, this.n);
        this.sink(1, this.n - 1);
        return this.pq[this.n--];
    }

    public void lower(int k) {
        this.swim(this.qp[k]);
    }

    public void change(int k) {
        this.swim(this.qp[k]);
        this.sink(this.qp[k], this.n);
    }
}

