/*
 * Decompiled with CFR 0.152.
 */
package smile.data.vector;

import java.util.Arrays;
import java.util.stream.IntStream;
import smile.data.measure.Measure;
import smile.data.measure.NumericalMeasure;
import smile.data.type.StructField;
import smile.data.vector.IntVector;

class IntVectorImpl
implements IntVector {
    private String name;
    private Measure measure;
    private int[] vector;

    public IntVectorImpl(String name, int[] vector) {
        this.name = name;
        this.measure = null;
        this.vector = vector;
    }

    public IntVectorImpl(StructField field, int[] vector) {
        if (field.measure instanceof NumericalMeasure) {
            throw new IllegalArgumentException(String.format("Invalid measure %s for %s", field.measure, this.type()));
        }
        this.name = field.name;
        this.measure = field.measure;
        this.vector = vector;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Measure measure() {
        return this.measure;
    }

    @Override
    public int[] array() {
        return this.vector;
    }

    @Override
    public int[] toIntArray() {
        return this.vector;
    }

    @Override
    public int[] toIntArray(int[] a) {
        System.arraycopy(this.vector, 0, a, 0, this.vector.length);
        return this.vector;
    }

    @Override
    public double[] toDoubleArray(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.vector[i];
        }
        return a;
    }

    @Override
    public int getInt(int i) {
        return this.vector[i];
    }

    @Override
    public Integer get(int i) {
        return this.vector[i];
    }

    @Override
    public IntVector get(int ... index) {
        int[] v = new int[index.length];
        for (int i = 0; i < index.length; ++i) {
            v[i] = this.vector[index[i]];
        }
        return new IntVectorImpl(this.field(), v);
    }

    @Override
    public int size() {
        return this.vector.length;
    }

    @Override
    public IntStream stream() {
        return Arrays.stream(this.vector);
    }

    public String toString() {
        return this.toString(10);
    }
}

