/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.stream.IntStream;
import smile.data.AbstractTuple;
import smile.data.CategoricalEncoder;
import smile.data.measure.CategoricalMeasure;
import smile.data.measure.Measure;
import smile.data.type.StructField;
import smile.data.type.StructType;

public interface Tuple
extends Serializable {
    public StructType schema();

    default public int length() {
        return this.schema().length();
    }

    default public double[] toArray() {
        return this.toArray(false, CategoricalEncoder.LEVEL);
    }

    default public double[] toArray(boolean bias, CategoricalEncoder encoder) {
        int ncols = this.length();
        StructType schema = this.schema();
        int n = bias ? 1 : 0;
        for (int i = 0; i < ncols; ++i) {
            StructField field = schema.field(i);
            Measure measure = field.measure;
            if (encoder != CategoricalEncoder.LEVEL && measure instanceof CategoricalMeasure) {
                CategoricalMeasure cat = (CategoricalMeasure)measure;
                if (encoder == CategoricalEncoder.DUMMY) {
                    n += cat.size() - 1;
                    continue;
                }
                if (encoder != CategoricalEncoder.ONE_HOT) continue;
                n += cat.size();
                continue;
            }
            ++n;
        }
        double[] array = new double[n];
        int j = 0;
        if (bias) {
            array[j++] = 1.0;
        }
        for (int i = 0; i < ncols; ++i) {
            StructField field = schema.field(i);
            Measure measure = field.measure;
            if (encoder != CategoricalEncoder.LEVEL && measure instanceof CategoricalMeasure) {
                int k;
                CategoricalMeasure cat = (CategoricalMeasure)measure;
                if (encoder == CategoricalEncoder.DUMMY) {
                    k = cat.factor(this.getInt(i));
                    if (k > 0) {
                        array[j + k - 1] = 1.0;
                    }
                    j += cat.size() - 1;
                    continue;
                }
                if (encoder != CategoricalEncoder.ONE_HOT) continue;
                k = cat.factor(this.getInt(i));
                array[j + k] = 1.0;
                j += cat.size();
                continue;
            }
            array[j++] = this.getDouble(i);
        }
        return array;
    }

    default public Object apply(int i) {
        return this.get(i);
    }

    default public Object apply(String field) {
        return this.get(field);
    }

    public Object get(int var1);

    default public Object get(String field) {
        return this.get(this.fieldIndex(field));
    }

    default public boolean isNullAt(int i) {
        return this.get(i) == null;
    }

    default public boolean isNullAt(String field) {
        return this.get(field) == null;
    }

    default public boolean hasNull() {
        return IntStream.range(0, this.length()).anyMatch(i -> this.isNullAt(i));
    }

    default public boolean getBoolean(int i) {
        return (Boolean)this.getAs(i);
    }

    default public boolean getBoolean(String field) {
        return (Boolean)this.getAs(field);
    }

    default public char getChar(int i) {
        return ((Character)this.getAs(i)).charValue();
    }

    default public char getChar(String field) {
        return ((Character)this.getAs(field)).charValue();
    }

    default public byte getByte(int i) {
        return (Byte)this.getAs(i);
    }

    default public byte getByte(String field) {
        return (Byte)this.getAs(field);
    }

    default public short getShort(int i) {
        return (Short)this.getAs(i);
    }

    default public short getShort(String field) {
        return (Short)this.getAs(field);
    }

    default public int getInt(int i) {
        return (Integer)this.getAs(i);
    }

    default public int getInt(String field) {
        return (Integer)this.getAs(field);
    }

    default public long getLong(int i) {
        return (Long)this.getAs(i);
    }

    default public long getLong(String field) {
        return (Long)this.getAs(field);
    }

    default public float getFloat(int i) {
        return ((Float)this.getAs(i)).floatValue();
    }

    default public float getFloat(String field) {
        return ((Float)this.getAs(field)).floatValue();
    }

    default public double getDouble(int i) {
        return (Double)this.getAs(i);
    }

    default public double getDouble(String field) {
        return (Double)this.getAs(field);
    }

    default public String getString(int i) {
        Object obj = this.get(i);
        return obj == null ? null : this.schema().field(i).toString(obj);
    }

    default public String getString(String field) {
        return this.getString(this.fieldIndex(field));
    }

    default public String toString(int i) {
        Object o = this.get(i);
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return (String)o;
        }
        return this.schema().field(i).toString(o);
    }

    default public String toString(String field) {
        return this.toString(this.fieldIndex(field));
    }

    default public BigDecimal getDecimal(int i) {
        return (BigDecimal)this.getAs(i);
    }

    default public BigDecimal getDecimal(String field) {
        return (BigDecimal)this.getAs(field);
    }

    default public LocalDate getDate(int i) {
        return (LocalDate)this.getAs(i);
    }

    default public LocalDate getDate(String field) {
        return (LocalDate)this.getAs(field);
    }

    default public LocalTime getTime(int i) {
        return (LocalTime)this.getAs(i);
    }

    default public LocalTime getTime(String field) {
        return (LocalTime)this.getAs(field);
    }

    default public LocalDateTime getDateTime(int i) {
        return (LocalDateTime)this.getAs(i);
    }

    default public LocalDateTime getDateTime(String field) {
        return (LocalDateTime)this.getAs(field);
    }

    default public String getScale(int i) {
        int x = this.getInt(i);
        Measure measure = this.schema().field((int)i).measure;
        return measure instanceof CategoricalMeasure ? ((CategoricalMeasure)measure).toString(x) : String.valueOf(x);
    }

    default public String getScale(String field) {
        return this.getScale(this.fieldIndex(field));
    }

    default public <T> T[] getArray(int i) {
        return (Object[])this.getAs(i);
    }

    default public <T> T[] getArray(String field) {
        return (Object[])this.getAs(field);
    }

    default public Tuple getStruct(int i) {
        return (Tuple)this.getAs(i);
    }

    default public Tuple getStruct(String field) {
        return (Tuple)this.getAs(field);
    }

    default public <T> T getAs(int i) {
        return (T)this.get(i);
    }

    default public <T> T getAs(String fieldName) {
        return this.getAs(this.fieldIndex(fieldName));
    }

    default public int fieldIndex(String name) {
        return this.schema().fieldIndex(name);
    }

    default public boolean anyNull() {
        for (int i = 0; i < this.length(); ++i) {
            if (!this.isNullAt(i)) continue;
            return true;
        }
        return false;
    }

    public static Tuple of(final Object[] row, final StructType schema) {
        return new AbstractTuple(){

            @Override
            public Object get(int i) {
                return row[i];
            }

            @Override
            public StructType schema() {
                return schema;
            }
        };
    }

    public static Tuple of(final double[] row, final StructType schema) {
        return new AbstractTuple(){

            @Override
            public Object get(int i) {
                return row[i];
            }

            @Override
            public double getDouble(int i) {
                return row[i];
            }

            @Override
            public StructType schema() {
                return schema;
            }
        };
    }

    public static Tuple of(ResultSet rs, StructType schema) throws SQLException {
        Object[] row = new Object[rs.getMetaData().getColumnCount()];
        for (int i = 0; i < row.length; ++i) {
            row[i] = rs.getObject(i + 1);
            if (row[i] instanceof Date) {
                row[i] = ((Date)row[i]).toLocalDate();
                continue;
            }
            if (row[i] instanceof Time) {
                row[i] = ((Time)row[i]).toLocalTime();
                continue;
            }
            if (!(row[i] instanceof Timestamp)) continue;
            row[i] = ((Timestamp)row[i]).toLocalDateTime();
        }
        return Tuple.of(row, schema);
    }
}

