/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class WheelView
extends ScrollView {
    public static final int TEXT_SIZE = 20;
    public static final int TEXT_PADDING_TOP_BOTTOM = 8;
    public static final int TEXT_PADDING_LEFT_RIGHT = 15;
    public static final int TEXT_COLOR_FOCUS = -16611122;
    public static final int TEXT_COLOR_NORMAL = -4473925;
    public static final int LINE_ALPHA = 150;
    public static final int LINE_COLOR = -8139290;
    public static final float LINE_THICK = 1.0f;
    public static final int OFF_SET = 2;
    private static final int DELAY = 50;
    private static final int MATCH_PARENT = -1;
    private static final int WRAP_CONTENT = -2;
    private Context context;
    private LinearLayout views;
    private LinkedList<String> items = new LinkedList();
    private int offset = 2;
    private int displayItemCount;
    private int selectedIndex = 2;
    private int initialY;
    private Runnable scrollerTask = new ScrollerTask();
    private int itemHeight = 0;
    private OnWheelListener onWheelListener;
    private int textSize = 20;
    private int textColorNormal = -4473925;
    private int textColorFocus = -16611122;
    private boolean isUserScroll = false;
    private boolean cycleDisable = false;
    private float previousY = 0.0f;
    private LineConfig lineConfig;

    public WheelView(Context context) {
        super(context);
        this.init(context);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public WheelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.setFadingEdgeLength(0);
        this.setOverScrollMode(2);
        this.setVerticalScrollBarEnabled(false);
        this.views = new LinearLayout(context);
        this.views.setOrientation(1);
        this.addView((View)this.views);
    }

    private void startScrollerTask() {
        this.initialY = this.getScrollY();
        this.postDelayed(this.scrollerTask, 50L);
    }

    private void initData() {
        long startTime = System.currentTimeMillis();
        this.displayItemCount = this.offset * 2 + 1;
        this.views.removeAllViews();
        for (String item : this.items) {
            this.views.addView((View)this.createView(item));
        }
        this.refreshItemView(this.itemHeight * (this.selectedIndex - this.offset));
        long millis = System.currentTimeMillis() - startTime;
        LogUtils.verbose((Object)((Object)this), (String)("init data spent " + millis + "ms"));
    }

    private TextView createView(String item) {
        TextView tv = new TextView(this.context);
        tv.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        tv.setSingleLine(true);
        tv.setEllipsize(TextUtils.TruncateAt.END);
        tv.setText((CharSequence)item);
        tv.setTextSize((float)this.textSize);
        tv.setGravity(17);
        int paddingTopBottom = ConvertUtils.toPx((Context)this.context, (float)8.0f);
        int paddingLeftRight = ConvertUtils.toPx((Context)this.context, (float)15.0f);
        tv.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
        if (0 == this.itemHeight) {
            int wSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            int hSpec = View.MeasureSpec.makeMeasureSpec((int)0x1FFFFFFF, (int)Integer.MIN_VALUE);
            tv.measure(wSpec, hSpec);
            this.itemHeight = tv.getMeasuredHeight();
            LogUtils.verbose((Object)((Object)this), (String)("itemHeight: " + this.itemHeight));
            this.views.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.itemHeight * this.displayItemCount));
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.getLayoutParams();
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(lp.width, this.itemHeight * this.displayItemCount));
        }
        return tv;
    }

    private void refreshItemView(int y) {
        int position = y / this.itemHeight + this.offset;
        int remainder = y % this.itemHeight;
        int divided = y / this.itemHeight;
        if (remainder == 0) {
            position = divided + this.offset;
        } else if (remainder > this.itemHeight / 2) {
            position = divided + this.offset + 1;
        }
        LogUtils.verbose((String)("current scroll position : " + position));
        int childSize = this.views.getChildCount();
        for (int i = 0; i < childSize; ++i) {
            TextView itemView = (TextView)this.views.getChildAt(i);
            if (null == itemView) {
                return;
            }
            if (position == i) {
                itemView.setTextColor(this.textColorFocus);
                continue;
            }
            itemView.setTextColor(this.textColorNormal);
        }
    }

    private void onSelectedCallBack() {
        if (null != this.onWheelListener) {
            int realIndex = this.selectedIndex - this.offset;
            LogUtils.verbose((String)("isUserScroll=" + this.isUserScroll + ",selectedIndex=" + this.selectedIndex + ",realIndex=" + realIndex));
            this.onWheelListener.onSelected(this.isUserScroll, realIndex, this.items.get(this.selectedIndex));
        }
    }

    @Deprecated
    public final void setBackgroundColor(int color) {
        this.throwUnsupportedException();
    }

    @Deprecated
    public final void setBackgroundResource(int resid) {
        this.throwUnsupportedException();
    }

    @Deprecated
    public final void setBackground(Drawable background) {
        this.throwUnsupportedException();
    }

    @Deprecated
    public final void setBackgroundDrawable(Drawable background) {
        this.throwUnsupportedException();
    }

    private void throwUnsupportedException() {
        throw new UnsupportedOperationException("don't set background");
    }

    private void changeBackgroundLineDrawable(boolean isSizeChanged) {
        LogUtils.verbose((Object)((Object)this), (String)("isSizeChanged=" + isSizeChanged + ", config is " + this.lineConfig));
        super.setBackgroundDrawable((Drawable)new LineDrawable(this.lineConfig));
    }

    public void setLineConfig(@Nullable LineConfig config) {
        if (null == config) {
            LogUtils.verbose((Object)((Object)this), (String)"line config is null");
            return;
        }
        if (null == this.lineConfig) {
            config.setWidth(this.getResources().getDisplayMetrics().widthPixels);
            int[] area = new int[]{this.itemHeight * this.offset, this.itemHeight * (this.offset + 1)};
            config.setArea(area);
        }
        this.lineConfig = config;
        this.changeBackgroundLineDrawable(false);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        LogUtils.verbose((Object)((Object)this), (String)("horizontal scroll origin: " + l + ", vertical scroll origin: " + t));
        this.refreshItemView(t);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        LogUtils.verbose((Object)((Object)this), (String)("onSizeChanged viewWidth=" + w));
        if (null == this.lineConfig) {
            this.lineConfig = new LineConfig();
            this.lineConfig.setColor(-8139290);
            this.lineConfig.setWidth(w);
            this.lineConfig.setThick(ConvertUtils.toPx((Context)this.context, (float)1.0f));
        }
        this.lineConfig.setWidth(w);
        int[] area = new int[]{this.itemHeight * this.offset, this.itemHeight * (this.offset + 1)};
        this.lineConfig.setArea(area);
        this.changeBackgroundLineDrawable(true);
    }

    public void fling(int velocityY) {
        super.fling(velocityY / 3);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.isUserScroll = true;
        switch (ev.getAction()) {
            case 0: {
                this.previousY = ev.getY();
                break;
            }
            case 1: {
                LogUtils.verbose((Object)((Object)this), (String)String.format("items=%s, offset=%s", this.items.size(), this.offset));
                LogUtils.verbose((Object)((Object)this), (String)("selectedIndex=" + this.selectedIndex));
                if (this.cycleDisable) {
                    this.startScrollerTask();
                    break;
                }
                float delta = ev.getY() - this.previousY;
                LogUtils.verbose((Object)((Object)this), (String)("delta=" + delta));
                if (this.selectedIndex == this.offset && delta > 0.0f) {
                    this.setSelectedIndex(this.items.size() - this.offset * 2 - 1);
                    break;
                }
                if (this.selectedIndex == this.items.size() - this.offset - 1 && delta < 0.0f) {
                    this.setSelectedIndex(0);
                    break;
                }
                this.startScrollerTask();
            }
        }
        return super.onTouchEvent(ev);
    }

    private void _setItems(List<String> list) {
        this.items.clear();
        this.items.addAll(list);
        for (int i = 0; i < this.offset; ++i) {
            this.items.addFirst("");
            this.items.addLast("");
        }
        this.initData();
    }

    public void setItems(List<String> list) {
        this._setItems(list);
        this.setSelectedIndex(0);
    }

    public void setItems(String[] list) {
        this.setItems(Arrays.asList(list));
    }

    public void setItems(List<String> list, int index) {
        this._setItems(list);
        this.setSelectedIndex(index);
    }

    public void setItems(List<String> list, String item) {
        this._setItems(list);
        this.setSelectedItem(item);
    }

    public void setItems(String[] list, int index) {
        this.setItems(Arrays.asList(list), index);
    }

    public void setItems(String[] list, String item) {
        this.setItems(Arrays.asList(list), item);
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public int getTextColor() {
        return this.textColorFocus;
    }

    public void setTextColor(@ColorInt int textColorNormal, @ColorInt int textColorFocus) {
        this.textColorNormal = textColorNormal;
        this.textColorFocus = textColorFocus;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColorFocus = textColor;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(@IntRange(from=1L, to=3L) int offset) {
        if (offset < 1 || offset > 3) {
            throw new IllegalArgumentException("Offset must between 1 and 3");
        }
        this.offset = offset;
    }

    public void setCycleDisable(boolean cycleDisable) {
        this.cycleDisable = cycleDisable;
    }

    private void setSelectedIndex(final @IntRange(from=0L) int index) {
        this.isUserScroll = false;
        this.post(new Runnable(){

            @Override
            public void run() {
                WheelView.this.scrollTo(0, index * WheelView.this.itemHeight);
                WheelView.this.selectedIndex = index + WheelView.this.offset;
                WheelView.this.onSelectedCallBack();
                WheelView.this.refreshItemView(WheelView.this.itemHeight * index);
            }
        });
    }

    public void setSelectedItem(String item) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).equals(item)) continue;
            this.setSelectedIndex(i - this.offset);
            break;
        }
    }

    public String getSelectedItem() {
        return this.items.get(this.selectedIndex);
    }

    public int getSelectedIndex() {
        return this.selectedIndex - this.offset;
    }

    @Deprecated
    public void setOnWheelViewListener(OnWheelViewListener onWheelListener) {
        this.setOnWheelListener(onWheelListener);
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    private static class LineDrawable
    extends Drawable {
        private Paint paint;
        private LineConfig config;

        LineDrawable(LineConfig cfg) {
            this.config = cfg;
            this.paint = new Paint(1);
            this.paint.setColor(this.config.getColor());
            this.paint.setAlpha(this.config.getAlpha());
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeWidth(this.config.getThick());
        }

        public void draw(@NonNull Canvas canvas) {
            int[] area = this.config.getArea();
            int width = this.config.getWidth();
            float ratio = this.config.getRatio();
            canvas.drawLine((float)width * ratio, (float)area[0], (float)width * (1.0f - ratio), (float)area[0], this.paint);
            canvas.drawLine((float)width * ratio, (float)area[1], (float)width * (1.0f - ratio), (float)area[1], this.paint);
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter cf) {
        }

        public int getOpacity() {
            return 0;
        }
    }

    public static class LineConfig {
        private int color = -8139290;
        private int alpha = 150;
        private float ratio = 0.16666667f;
        private float thick = -1.0f;
        private int width = 0;
        private int[] area = null;

        public LineConfig() {
        }

        public LineConfig(@FloatRange(from=0.0, to=1.0) float ratio) {
            this.ratio = ratio;
        }

        @ColorInt
        public int getColor() {
            return this.color;
        }

        public void setColor(@ColorInt int color) {
            this.color = color;
        }

        @IntRange(from=1L, to=255L)
        public int getAlpha() {
            return this.alpha;
        }

        public void setAlpha(@IntRange(from=1L, to=255L) int alpha) {
            this.alpha = alpha;
        }

        @FloatRange(from=0.0, to=1.0)
        public float getRatio() {
            return this.ratio;
        }

        public void setRatio(@FloatRange(from=0.0, to=1.0) float ratio) {
            this.ratio = ratio;
        }

        public float getThick() {
            if (this.thick == -1.0f) {
                this.thick = ConvertUtils.toPx((float)1.0f);
            }
            return this.thick;
        }

        public void setThick(float thick) {
            this.thick = thick;
        }

        protected int getWidth() {
            return this.width;
        }

        protected void setWidth(int width) {
            this.width = width;
        }

        @Size(value=2L)
        protected int[] getArea() {
            return this.area;
        }

        protected void setArea(@Size(value=2L) int[] area) {
            this.area = area;
        }

        public String toString() {
            return "color=" + this.color + ", alpha=" + this.alpha + ", thick=" + this.thick + ", width=" + this.width;
        }
    }

    private class ScrollerTask
    implements Runnable {
        private ScrollerTask() {
        }

        @Override
        public void run() {
            if (WheelView.this.itemHeight == 0) {
                LogUtils.debug((Object)this, (String)"itemHeight is zero");
                return;
            }
            int newY = WheelView.this.getScrollY();
            if (WheelView.this.initialY - newY != 0) {
                WheelView.this.startScrollerTask();
                return;
            }
            final int remainder = WheelView.this.initialY % WheelView.this.itemHeight;
            final int divided = WheelView.this.initialY / WheelView.this.itemHeight;
            LogUtils.verbose((Object)this, (String)("initialY: " + WheelView.this.initialY + ", remainder: " + remainder + ", divided: " + divided));
            if (remainder == 0) {
                WheelView.this.selectedIndex = divided + WheelView.this.offset;
                WheelView.this.onSelectedCallBack();
                return;
            }
            if (remainder > WheelView.this.itemHeight / 2) {
                WheelView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        WheelView.this.smoothScrollTo(0, WheelView.this.initialY - remainder + WheelView.this.itemHeight);
                        WheelView.this.selectedIndex = divided + WheelView.this.offset + 1;
                        WheelView.this.onSelectedCallBack();
                    }
                });
            } else {
                WheelView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        WheelView.this.smoothScrollTo(0, WheelView.this.initialY - remainder);
                        WheelView.this.selectedIndex = divided + WheelView.this.offset;
                        WheelView.this.onSelectedCallBack();
                    }
                });
            }
        }
    }

    @Deprecated
    public static interface OnWheelViewListener
    extends OnWheelListener {
    }

    public static interface OnWheelListener {
        public void onSelected(boolean var1, int var2, String var3);
    }
}

