/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Size;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.util.LogUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LinkagePicker
extends WheelPicker {
    protected String selectedFirstItem = "";
    protected String selectedSecondItem = "";
    protected String selectedThirdItem = "";
    protected int selectedFirstIndex = 0;
    protected int selectedSecondIndex = 0;
    protected int selectedThirdIndex = 0;
    protected DataProvider provider;
    private OnLinkageListener onLinkageListener;
    private double firstColumnWeight = 0.0;
    private double secondColumnWeight = 0.0;
    private double thirdColumnWeight = 0.0;
    private OnWheelListener onWheelListener;

    public LinkagePicker(Activity activity, DataProvider provider) {
        super(activity);
        this.provider = provider;
    }

    @Deprecated
    public LinkagePicker(Activity activity, ArrayList<String> firstList, ArrayList<ArrayList<String>> secondList) {
        this(activity, firstList, secondList, null);
    }

    @Deprecated
    public LinkagePicker(Activity activity, ArrayList<String> firstList, ArrayList<ArrayList<String>> secondList, ArrayList<ArrayList<ArrayList<String>>> thirdList) {
        super(activity);
        this.provider = new DefaultDataProvider(firstList, secondList, thirdList);
    }

    public void setSelectedItem(String firstText, String secondText) {
        this.setSelectedItem(firstText, secondText, "");
    }

    public void setSelectedItem(String firstText, String secondText, String thirdText) {
        if (null == this.provider) {
            throw new IllegalArgumentException("please set data provider at first");
        }
        List<String> firstData = this.provider.provideFirstData();
        for (int i = 0; i < firstData.size(); ++i) {
            String ft = firstData.get(i);
            if (!ft.contains(firstText)) continue;
            this.selectedFirstIndex = i;
            LogUtils.debug((String)("init select first text: " + ft + ", index:" + this.selectedFirstIndex));
            break;
        }
        List<String> secondData = this.provider.provideSecondData(this.selectedFirstIndex);
        for (int j = 0; j < secondData.size(); ++j) {
            String st = secondData.get(j);
            if (!st.contains(secondText)) continue;
            this.selectedSecondIndex = j;
            LogUtils.debug((String)("init select second text: " + st + ", index:" + this.selectedSecondIndex));
            break;
        }
        if (this.provider.isOnlyTwo()) {
            return;
        }
        List<String> thirdData = this.provider.provideThirdData(this.selectedFirstIndex, this.selectedSecondIndex);
        for (int k = 0; k < thirdData.size(); ++k) {
            String tt = thirdData.get(k);
            if (!tt.contains(thirdText)) continue;
            this.selectedThirdIndex = k;
            LogUtils.debug((String)("init select third text: " + tt + ", index:" + this.selectedThirdIndex));
            break;
        }
    }

    public String getSelectedFirstItem() {
        return this.selectedFirstItem;
    }

    public String getSelectedSecondItem() {
        return this.selectedSecondItem;
    }

    public String getSelectedThirdItem() {
        return this.selectedThirdItem;
    }

    public int getSelectedFirstIndex() {
        return this.selectedFirstIndex;
    }

    public int getSelectedSecondIndex() {
        return this.selectedSecondIndex;
    }

    public int getSelectedThirdIndex() {
        return this.selectedThirdIndex;
    }

    public void setColumnWeight(@FloatRange(from=0.0, to=1.0) double firstColumnWeight, @FloatRange(from=0.0, to=1.0) double secondColumnWeight, @FloatRange(from=0.0, to=1.0) double thirdColumnWeight) {
        this.firstColumnWeight = firstColumnWeight;
        this.secondColumnWeight = secondColumnWeight;
        this.thirdColumnWeight = thirdColumnWeight;
    }

    public void setColumnWeight(@FloatRange(from=0.0, to=1.0) double firstColumnWeight, @FloatRange(from=0.0, to=1.0) double secondColumnWeight) {
        this.firstColumnWeight = firstColumnWeight;
        this.secondColumnWeight = secondColumnWeight;
        this.thirdColumnWeight = 0.0;
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnLinkageListener(OnLinkageListener onLinkageListener) {
        this.onLinkageListener = onLinkageListener;
    }

    @Size(value=3L)
    protected int[] getColumnWidths(boolean onlyTwoColumn) {
        LogUtils.verbose((Object)((Object)this), (String)String.format(Locale.CHINA, "column weight is: %f-%f-%f", this.firstColumnWeight, this.secondColumnWeight, this.thirdColumnWeight));
        int[] widths = new int[3];
        if (this.firstColumnWeight == 0.0 && this.secondColumnWeight == 0.0 && this.thirdColumnWeight == 0.0) {
            if (onlyTwoColumn) {
                widths[0] = this.screenWidthPixels / 2;
                widths[1] = widths[0];
                widths[2] = 0;
            } else {
                widths[0] = this.screenWidthPixels / 3;
                widths[1] = widths[0];
                widths[2] = widths[0];
            }
        } else {
            widths[0] = (int)((double)this.screenWidthPixels * this.firstColumnWeight);
            widths[1] = (int)((double)this.screenWidthPixels * this.secondColumnWeight);
            widths[2] = (int)((double)this.screenWidthPixels * this.thirdColumnWeight);
        }
        return widths;
    }

    @NonNull
    protected View makeCenterView() {
        if (null == this.provider) {
            throw new IllegalArgumentException("please set data provider before make view");
        }
        int[] widths = this.getColumnWidths(this.provider.isOnlyTwo());
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView firstView = new WheelView((Context)this.activity);
        firstView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(widths[0], -2));
        firstView.setTextSize(this.textSize);
        firstView.setTextColor(this.textColorNormal, this.textColorFocus);
        firstView.setLineConfig(this.lineConfig);
        firstView.setOffset(this.offset);
        firstView.setCycleDisable(this.cycleDisable);
        layout.addView((View)firstView);
        final WheelView secondView = new WheelView((Context)this.activity);
        secondView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(widths[1], -2));
        secondView.setTextSize(this.textSize);
        secondView.setTextColor(this.textColorNormal, this.textColorFocus);
        secondView.setLineConfig(this.lineConfig);
        secondView.setOffset(this.offset);
        secondView.setCycleDisable(this.cycleDisable);
        layout.addView((View)secondView);
        final WheelView thirdView = new WheelView((Context)this.activity);
        thirdView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(widths[2], -2));
        thirdView.setTextSize(this.textSize);
        thirdView.setTextColor(this.textColorNormal, this.textColorFocus);
        thirdView.setLineConfig(this.lineConfig);
        thirdView.setOffset(this.offset);
        thirdView.setCycleDisable(this.cycleDisable);
        layout.addView((View)thirdView);
        if (this.provider.isOnlyTwo()) {
            thirdView.setVisibility(8);
        }
        firstView.setItems(this.provider.provideFirstData(), this.selectedFirstIndex);
        firstView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                List<String> secondData;
                LinkagePicker.this.selectedFirstItem = item;
                LinkagePicker.this.selectedFirstIndex = index;
                if (LinkagePicker.this.onWheelListener != null) {
                    LinkagePicker.this.onWheelListener.onFirstWheeled(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedFirstItem);
                }
                if ((secondData = LinkagePicker.this.provider.provideSecondData(LinkagePicker.this.selectedFirstIndex)).size() < LinkagePicker.this.selectedSecondIndex) {
                    LinkagePicker.this.selectedSecondIndex = 0;
                }
                LinkagePicker.this.selectedThirdIndex = 0;
                secondView.setItems(secondData, LinkagePicker.this.selectedSecondIndex);
                if (LinkagePicker.this.provider.isOnlyTwo()) {
                    return;
                }
                thirdView.setItems(LinkagePicker.this.provider.provideThirdData(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex), LinkagePicker.this.selectedThirdIndex);
            }
        });
        secondView.setItems(this.provider.provideSecondData(this.selectedFirstIndex), this.selectedSecondIndex);
        secondView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                LinkagePicker.this.selectedSecondItem = item;
                LinkagePicker.this.selectedSecondIndex = index;
                if (LinkagePicker.this.onWheelListener != null) {
                    LinkagePicker.this.onWheelListener.onSecondWheeled(LinkagePicker.this.selectedSecondIndex, LinkagePicker.this.selectedSecondItem);
                }
                if (LinkagePicker.this.provider.isOnlyTwo()) {
                    return;
                }
                List<String> thirdData = LinkagePicker.this.provider.provideThirdData(LinkagePicker.this.selectedFirstIndex, LinkagePicker.this.selectedSecondIndex);
                if (thirdData.size() < LinkagePicker.this.selectedThirdIndex) {
                    LinkagePicker.this.selectedThirdIndex = 0;
                }
                thirdView.setItems(thirdData, LinkagePicker.this.selectedThirdIndex);
            }
        });
        if (this.provider.isOnlyTwo()) {
            return layout;
        }
        thirdView.setItems(this.provider.provideThirdData(this.selectedFirstIndex, this.selectedSecondIndex), this.selectedThirdIndex);
        thirdView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                LinkagePicker.this.selectedThirdItem = item;
                LinkagePicker.this.selectedThirdIndex = index;
                if (LinkagePicker.this.onWheelListener != null) {
                    LinkagePicker.this.onWheelListener.onThirdWheeled(LinkagePicker.this.selectedThirdIndex, LinkagePicker.this.selectedThirdItem);
                }
            }
        });
        return layout;
    }

    public void onSubmit() {
        if (this.onLinkageListener != null) {
            if (this.provider.isOnlyTwo()) {
                this.onLinkageListener.onPicked(this.selectedFirstItem, this.selectedSecondItem, null);
            } else {
                this.onLinkageListener.onPicked(this.selectedFirstItem, this.selectedSecondItem, this.selectedThirdItem);
            }
        }
    }

    public static class DefaultDataProvider
    implements DataProvider {
        private ArrayList<String> firstList = new ArrayList();
        private ArrayList<ArrayList<String>> secondList = new ArrayList();
        private ArrayList<ArrayList<ArrayList<String>>> thirdList = new ArrayList();
        private boolean onlyTwo = false;

        public DefaultDataProvider(ArrayList<String> firstList, ArrayList<ArrayList<String>> secondList, ArrayList<ArrayList<ArrayList<String>>> thirdList) {
            this.firstList = firstList;
            this.secondList = secondList;
            if (thirdList == null || thirdList.size() == 0) {
                this.onlyTwo = true;
            } else {
                this.thirdList = thirdList;
            }
        }

        @Override
        public boolean isOnlyTwo() {
            return this.onlyTwo;
        }

        @Override
        public List<String> provideFirstData() {
            return this.firstList;
        }

        @Override
        public List<String> provideSecondData(int firstIndex) {
            return this.secondList.get(firstIndex);
        }

        @Override
        public List<String> provideThirdData(int firstIndex, int secondIndex) {
            if (this.onlyTwo) {
                return new ArrayList<String>();
            }
            return this.thirdList.get(firstIndex).get(secondIndex);
        }
    }

    public static interface DataProvider {
        public boolean isOnlyTwo();

        public List<String> provideFirstData();

        public List<String> provideSecondData(int var1);

        public List<String> provideThirdData(int var1, int var2);
    }

    public static abstract class OnWheelListener {
        public abstract void onFirstWheeled(int var1, String var2);

        public abstract void onSecondWheeled(int var1, String var2);

        public void onThirdWheeled(int index, String item) {
        }
    }

    public static interface OnLinkageListener {
        public void onPicked(String var1, String var2, String var3);
    }
}

