/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.qqtheme.framework.entity.City;
import cn.qqtheme.framework.entity.County;
import cn.qqtheme.framework.entity.Province;
import cn.qqtheme.framework.picker.LinkagePicker;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public class AddressPicker
extends LinkagePicker {
    private OnAddressPickListener onAddressPickListener;
    private OnWheelListener onWheelListener;
    private boolean hideProvince = false;
    private boolean hideCounty = false;
    private List<Province> provinceList = new ArrayList<Province>();

    public AddressPicker(Activity activity, ArrayList<Province> data) {
        super(activity);
        this.parseData(data);
    }

    private void parseData(ArrayList<Province> data) {
        int provinceSize = data.size();
        this.provinceList.clear();
        this.provinceList.addAll(data);
        for (int x = 0; x < provinceSize; ++x) {
            Province pro = data.get(x);
            this.firstList.add(pro.getAreaName());
            ArrayList<City> cities = pro.getCities();
            ArrayList<String> xCities = new ArrayList<String>();
            ArrayList xCounties = new ArrayList();
            int citySize = cities.size();
            for (int y = 0; y < citySize; ++y) {
                City cit = cities.get(y);
                xCities.add(cit.getAreaName());
                ArrayList<County> counties = cit.getCounties();
                ArrayList<String> yCounties = new ArrayList<String>();
                int countySize = counties.size();
                if (countySize == 0) {
                    yCounties.add(cit.getAreaName());
                } else {
                    for (int z = 0; z < countySize; ++z) {
                        yCounties.add(counties.get(z).getAreaName());
                    }
                }
                xCounties.add(yCounties);
            }
            this.secondList.add(xCities);
            this.thirdList.add(xCounties);
        }
    }

    @Override
    public void setSelectedItem(String province, String city, String county) {
        super.setSelectedItem(province, city, county);
    }

    public Province getSelectedProvince() {
        return this.provinceList.get(this.selectedFirstIndex);
    }

    public City getSelectedCity() {
        return this.getSelectedProvince().getCities().get(this.selectedSecondIndex);
    }

    public County getSelectedCounty() {
        return this.getSelectedCity().getCounties().get(this.selectedThirdIndex);
    }

    public void setHideProvince(boolean hideProvince) {
        this.hideProvince = hideProvince;
    }

    public void setHideCounty(boolean hideCounty) {
        this.hideCounty = hideCounty;
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnAddressPickListener(OnAddressPickListener listener) {
        this.onAddressPickListener = listener;
    }

    @Override
    @Deprecated
    public final void setOnLinkageListener(LinkagePicker.OnLinkageListener onLinkageListener) {
        throw new UnsupportedOperationException("Please use setOnAddressPickListener instead.");
    }

    @Override
    @NonNull
    protected View makeCenterView() {
        if (this.hideCounty) {
            this.hideProvince = false;
        }
        if (this.firstList.size() == 0) {
            throw new IllegalArgumentException("please initial data at first, can't be empty");
        }
        int[] widths = this.getColumnWidths(this.hideProvince || this.hideCounty);
        int provinceWidth = widths[0];
        int cityWidth = widths[1];
        int countyWidth = widths[2];
        if (this.hideProvince) {
            provinceWidth = 0;
            cityWidth = widths[0];
            countyWidth = widths[1];
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView provinceView = new WheelView((Context)this.activity);
        provinceView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(provinceWidth, -2));
        provinceView.setTextSize(this.textSize);
        provinceView.setTextColor(this.textColorNormal, this.textColorFocus);
        provinceView.setLineVisible(this.lineVisible);
        provinceView.setLineColor(this.lineColor);
        provinceView.setOffset(this.offset);
        provinceView.setCycleDisable(this.cycleDisable);
        layout.addView((View)provinceView);
        if (this.hideProvince) {
            provinceView.setVisibility(8);
        }
        final WheelView cityView = new WheelView((Context)this.activity);
        cityView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(cityWidth, -2));
        cityView.setTextSize(this.textSize);
        cityView.setTextColor(this.textColorNormal, this.textColorFocus);
        cityView.setLineVisible(this.lineVisible);
        cityView.setLineColor(this.lineColor);
        cityView.setOffset(this.offset);
        cityView.setCycleDisable(this.cycleDisable);
        layout.addView((View)cityView);
        final WheelView countyView = new WheelView((Context)this.activity);
        countyView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(countyWidth, -2));
        countyView.setTextSize(this.textSize);
        countyView.setTextColor(this.textColorNormal, this.textColorFocus);
        countyView.setLineVisible(this.lineVisible);
        countyView.setLineColor(this.lineColor);
        countyView.setOffset(this.offset);
        countyView.setCycleDisable(this.cycleDisable);
        layout.addView((View)countyView);
        if (this.hideCounty) {
            countyView.setVisibility(8);
        }
        provinceView.setItems((List<String>)this.firstList, this.selectedFirstIndex);
        provinceView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                ArrayList cities;
                AddressPicker.this.selectedFirstItem = item;
                AddressPicker.this.selectedFirstIndex = index;
                AddressPicker.this.selectedThirdIndex = 0;
                if (AddressPicker.this.onWheelListener != null) {
                    AddressPicker.this.onWheelListener.onProvinceWheeled(AddressPicker.this.selectedFirstIndex, AddressPicker.this.selectedFirstItem);
                }
                if ((cities = (ArrayList)AddressPicker.this.secondList.get(AddressPicker.this.selectedFirstIndex)).size() < AddressPicker.this.selectedSecondIndex) {
                    AddressPicker.this.selectedSecondIndex = 0;
                }
                cityView.setItems((List<String>)cities, isUserScroll ? 0 : AddressPicker.this.selectedSecondIndex);
                ArrayList counties = (ArrayList)AddressPicker.this.thirdList.get(AddressPicker.this.selectedFirstIndex);
                if (counties.size() > 0) {
                    countyView.setItems((List<String>)((List)counties.get(0)), isUserScroll ? 0 : AddressPicker.this.selectedThirdIndex);
                } else {
                    countyView.setItems(new ArrayList<String>());
                }
            }
        });
        cityView.setItems((List<String>)((List)this.secondList.get(this.selectedFirstIndex)), this.selectedSecondIndex);
        cityView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                ArrayList counties;
                AddressPicker.this.selectedSecondItem = item;
                AddressPicker.this.selectedSecondIndex = index;
                if (AddressPicker.this.onWheelListener != null) {
                    AddressPicker.this.onWheelListener.onCityWheeled(AddressPicker.this.selectedSecondIndex, AddressPicker.this.selectedSecondItem);
                }
                if ((counties = (ArrayList)((ArrayList)AddressPicker.this.thirdList.get(AddressPicker.this.selectedFirstIndex)).get(AddressPicker.this.selectedSecondIndex)).size() < AddressPicker.this.selectedThirdIndex) {
                    AddressPicker.this.selectedThirdIndex = 0;
                }
                if (counties.size() > 0) {
                    countyView.setItems((List<String>)counties, isUserScroll ? 0 : AddressPicker.this.selectedThirdIndex);
                } else {
                    countyView.setItems(new ArrayList<String>());
                }
            }
        });
        countyView.setItems((List<String>)((List)((ArrayList)this.thirdList.get(this.selectedFirstIndex)).get(this.selectedSecondIndex)), this.selectedThirdIndex);
        countyView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                AddressPicker.this.selectedThirdItem = item;
                AddressPicker.this.selectedThirdIndex = index;
                if (AddressPicker.this.onWheelListener != null) {
                    AddressPicker.this.onWheelListener.onCountyWheeled(AddressPicker.this.selectedThirdIndex, AddressPicker.this.selectedThirdItem);
                }
            }
        });
        return layout;
    }

    @Override
    public void onSubmit() {
        if (this.onAddressPickListener != null) {
            Province province = this.getSelectedProvince();
            City city = this.getSelectedCity();
            County county = null;
            if (!this.hideCounty) {
                county = this.getSelectedCounty();
            }
            this.onAddressPickListener.onAddressPicked(province, city, county);
        }
    }

    public static interface OnWheelListener {
        public void onProvinceWheeled(int var1, String var2);

        public void onCityWheeled(int var1, String var2);

        public void onCountyWheeled(int var1, String var2);
    }

    public static interface OnAddressPickListener {
        public void onAddressPicked(Province var1, City var2, County var3);
    }
}

