/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.wheelpicker.OptionPicker;
import com.github.gzuliyujiang.wheelpicker.entity.ConstellationEntity;
import com.github.gzuliyujiang.wheelpicker.entity.DateEntity;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConstellationPicker
extends OptionPicker {
    public static String JSON = "[{\"id\":0,\"name\":\"\u4e0d\u9650\",\"startDate\":\"\",\"endDate\":\"\",\"english\":\"Unlimited\"},\n{\"id\":1,\"name\":\"\u767d\u7f8a\u5ea7\",\"startDate\":\"3-21\",\"endDate\":\"4-19\",\"english\":\"Aries\"},\n{\"id\":2,\"name\":\"\u91d1\u725b\u5ea7\",\"startDate\":\"4-20\",\"endDate\":\"5-20\",\"english\":\"Taurus\"},\n{\"id\":3,\"name\":\"\u53cc\u5b50\u5ea7\",\"startDate\":\"5-21\",\"endDate\":\"6-21\",\"english\":\"Gemini\"},\n{\"id\":4,\"name\":\"\u5de8\u87f9\u5ea7\",\"startDate\":\"6-22\",\"endDate\":\"7-22\",\"english\":\"Cancer\"},\n{\"id\":5,\"name\":\"\u72ee\u5b50\u5ea7\",\"startDate\":\"7-23\",\"endDate\":\"8-22\",\"english\":\"Leo\"},\n{\"id\":6,\"name\":\"\u5904\u5973\u5ea7\",\"startDate\":\"8-23\",\"endDate\":\"9-22\",\"english\":\"Virgo\"},\n{\"id\":7,\"name\":\"\u5929\u79e4\u5ea7\",\"startDate\":\"9-23\",\"endDate\":\"10-23\",\"english\":\"Libra\"},\n{\"id\":8,\"name\":\"\u5929\u874e\u5ea7\",\"startDate\":\"10-24\",\"endDate\":\"11-22\",\"english\":\"Scorpio\"},\n{\"id\":9,\"name\":\"\u5c04\u624b\u5ea7\",\"startDate\":\"11-23\",\"endDate\":\"12-21\",\"english\":\"Sagittarius\"},\n{\"id\":10,\"name\":\"\u6469\u7faf\u5ea7\",\"startDate\":\"12-22\",\"endDate\":\"1-19\",\"english\":\"Capricorn\"},\n{\"id\":11,\"name\":\"\u6c34\u74f6\u5ea7\",\"startDate\":\"1-20\",\"endDate\":\"2-18\",\"english\":\"Aquarius\"},\n{\"id\":12,\"name\":\"\u53cc\u9c7c\u5ea7\",\"startDate\":\"2-19\",\"endDate\":\"3-20\",\"english\":\"Pisces\"}]";
    private boolean includeUnlimited = false;

    public ConstellationPicker(Activity activity) {
        super(activity);
    }

    public ConstellationPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    public void setIncludeUnlimited(boolean includeUnlimited) {
        this.includeUnlimited = includeUnlimited;
        this.setData(this.provideData());
    }

    @Override
    public void setDefaultValue(Object item) {
        if (item instanceof String) {
            this.setDefaultValueByName(item.toString());
        } else {
            super.setDefaultValue(item);
        }
    }

    public void setDefaultValueById(String id2) {
        ConstellationEntity entity = new ConstellationEntity();
        entity.setId(id2);
        super.setDefaultValue(entity);
    }

    public void setDefaultValueByName(String name) {
        ConstellationEntity entity = new ConstellationEntity();
        entity.setName(name);
        super.setDefaultValue(entity);
    }

    public void setDefaultValueByDate(DateEntity date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.toTimeInMillis());
        this.setDefaultValueByDate(calendar.getTime());
    }

    public void setDefaultValueByDate(Date date) {
        String name;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        switch (month) {
            case 1: {
                name = day < 21 ? "\u6469\u7faf\u5ea7" : "\u6c34\u74f6\u5ea7";
                break;
            }
            case 2: {
                name = day < 20 ? "\u6c34\u74f6\u5ea7" : "\u53cc\u9c7c\u5ea7";
                break;
            }
            case 3: {
                name = day < 21 ? "\u53cc\u9c7c\u5ea7" : "\u767d\u7f8a\u5ea7";
                break;
            }
            case 4: {
                name = day < 21 ? "\u767d\u7f8a\u5ea7" : "\u91d1\u725b\u5ea7";
                break;
            }
            case 5: {
                name = day < 22 ? "\u91d1\u725b\u5ea7" : "\u53cc\u5b50\u5ea7";
                break;
            }
            case 6: {
                name = day < 22 ? "\u53cc\u5b50\u5ea7" : "\u5de8\u87f9\u5ea7";
                break;
            }
            case 7: {
                name = day < 23 ? "\u5de8\u87f9\u5ea7" : "\u72ee\u5b50\u5ea7";
                break;
            }
            case 8: {
                name = day < 24 ? "\u72ee\u5b50\u5ea7" : "\u5904\u5973\u5ea7";
                break;
            }
            case 9: {
                name = day < 24 ? "\u5904\u5973\u5ea7" : "\u5929\u79e4\u5ea7";
                break;
            }
            case 10: {
                name = day < 24 ? "\u5929\u79e4\u5ea7" : "\u5929\u874e\u5ea7";
                break;
            }
            case 11: {
                name = day < 23 ? "\u5929\u874e\u5ea7" : "\u5c04\u624b\u5ea7";
                break;
            }
            case 12: {
                name = day < 22 ? "\u5c04\u624b\u5ea7" : "\u6469\u7faf\u5ea7";
                break;
            }
            default: {
                name = "\u4e0d\u9650";
            }
        }
        this.setDefaultValueByName(name);
    }

    public void setDefaultValueByEnglish(String english) {
        ConstellationEntity entity = new ConstellationEntity();
        entity.setEnglish(english);
        super.setDefaultValue(entity);
    }

    @Override
    protected List<?> provideData() {
        ArrayList<ConstellationEntity> data = new ArrayList<ConstellationEntity>();
        try {
            JSONArray jsonArray = new JSONArray(JSON);
            int n = jsonArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                ConstellationEntity entity = new ConstellationEntity();
                entity.setId(jsonObject.getString("id"));
                entity.setStartDate(jsonObject.getString("startDate"));
                entity.setEndDate(jsonObject.getString("endDate"));
                entity.setName(jsonObject.getString("name"));
                entity.setEnglish(jsonObject.getString("english"));
                if (!this.includeUnlimited && "0".equals(entity.getId())) continue;
                data.add(entity);
            }
        }
        catch (JSONException e) {
            DialogLog.print((Object)((Object)e));
        }
        return data;
    }
}

