/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.wheelpicker.R;
import com.github.gzuliyujiang.wheelview.contract.OnWheelChangedListener;
import com.github.gzuliyujiang.wheelview.widget.WheelView;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseWheelLayout
extends LinearLayout
implements OnWheelChangedListener {
    private final List<WheelView> wheelViews = new ArrayList<WheelView>();

    public BaseWheelLayout(Context context) {
        super(context);
        this.init(context, null, R.attr.WheelStyle, R.style.WheelDefault);
    }

    public BaseWheelLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, R.attr.WheelStyle, R.style.WheelDefault);
    }

    public BaseWheelLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, R.style.WheelDefault);
    }

    public BaseWheelLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.setOrientation(1);
        BaseWheelLayout.inflate((Context)context, (int)this.provideLayoutRes(), (ViewGroup)this);
        this.onInit(context);
        this.wheelViews.clear();
        this.wheelViews.addAll(this.provideWheelViews());
        this.initAttrs(context, attrs, defStyleAttr, defStyleRes);
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setOnWheelChangedListener((OnWheelChangedListener)this);
        }
    }

    protected void onInit(@NonNull Context context) {
    }

    private void initAttrs(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        float density = context.getResources().getDisplayMetrics().density;
        float scaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BaseWheelLayout, defStyleAttr, defStyleRes);
        this.setVisibleItemCount(typedArray.getInt(R.styleable.BaseWheelLayout_wheel_visibleItemCount, 5));
        this.setSameWidthEnabled(typedArray.getBoolean(R.styleable.BaseWheelLayout_wheel_sameWidthEnabled, false));
        this.setMaxWidthText(typedArray.getString(R.styleable.BaseWheelLayout_wheel_maxWidthText));
        this.setTextColor(typedArray.getColor(R.styleable.BaseWheelLayout_wheel_itemTextColor, -7829368));
        this.setSelectedTextColor(typedArray.getColor(R.styleable.BaseWheelLayout_wheel_itemTextColorSelected, -16777216));
        this.setTextSize(typedArray.getDimension(R.styleable.BaseWheelLayout_wheel_itemTextSize, 15.0f * scaledDensity));
        this.setSelectedTextSize(typedArray.getDimension(R.styleable.BaseWheelLayout_wheel_itemTextSizeSelected, 15.0f * scaledDensity));
        this.setSelectedTextBold(typedArray.getBoolean(R.styleable.BaseWheelLayout_wheel_itemTextBoldSelected, false));
        this.setTextAlign(typedArray.getInt(R.styleable.BaseWheelLayout_wheel_itemTextAlign, 0));
        this.setItemSpace(typedArray.getDimensionPixelSize(R.styleable.BaseWheelLayout_wheel_itemSpace, (int)(20.0f * density)));
        this.setCyclicEnabled(typedArray.getBoolean(R.styleable.BaseWheelLayout_wheel_cyclicEnabled, false));
        this.setIndicatorEnabled(typedArray.getBoolean(R.styleable.BaseWheelLayout_wheel_indicatorEnabled, false));
        this.setIndicatorColor(typedArray.getColor(R.styleable.BaseWheelLayout_wheel_indicatorColor, -3552823));
        this.setIndicatorSize(typedArray.getDimension(R.styleable.BaseWheelLayout_wheel_indicatorSize, 1.0f * density));
        this.setCurvedIndicatorSpace(typedArray.getDimensionPixelSize(R.styleable.BaseWheelLayout_wheel_curvedIndicatorSpace, (int)(1.0f * density)));
        this.setCurtainEnabled(typedArray.getBoolean(R.styleable.BaseWheelLayout_wheel_curtainEnabled, false));
        this.setCurtainColor(typedArray.getColor(R.styleable.BaseWheelLayout_wheel_curtainColor, -1996488705));
        this.setCurtainCorner(typedArray.getInt(R.styleable.BaseWheelLayout_wheel_curtainCorner, 0));
        this.setCurtainRadius(typedArray.getDimension(R.styleable.BaseWheelLayout_wheel_curtainRadius, 0.0f));
        this.setAtmosphericEnabled(typedArray.getBoolean(R.styleable.BaseWheelLayout_wheel_atmosphericEnabled, false));
        this.setCurvedEnabled(typedArray.getBoolean(R.styleable.BaseWheelLayout_wheel_curvedEnabled, false));
        this.setCurvedMaxAngle(typedArray.getInteger(R.styleable.BaseWheelLayout_wheel_curvedMaxAngle, 90));
        typedArray.recycle();
        this.onAttributeSet(context, attrs);
    }

    protected void onAttributeSet(@NonNull Context context, @Nullable AttributeSet attrs) {
    }

    @LayoutRes
    protected abstract int provideLayoutRes();

    protected abstract List<WheelView> provideWheelViews();

    public void setStyle(@StyleRes int style2) {
        this.initAttrs(this.getContext(), null, R.attr.WheelStyle, style2);
        this.requestLayout();
        this.invalidate();
    }

    public void onWheelScrolled(WheelView view, int offset) {
    }

    public void onWheelScrollStateChanged(WheelView view, int state) {
    }

    public void onWheelLoopFinished(WheelView view) {
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setEnabled(enabled);
        }
    }

    public void setVisibleItemCount(int visibleItemCount) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setVisibleItemCount(visibleItemCount);
        }
    }

    public void setItemSpace(@Px int space) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setItemSpace(space);
        }
    }

    public void setSameWidthEnabled(boolean sameWidthEnabled) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setSameWidthEnabled(sameWidthEnabled);
        }
    }

    public void setDefaultItemPosition(int position) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setDefaultPosition(position);
        }
    }

    public void setCurtainEnabled(boolean hasCurtain) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurtainEnabled(hasCurtain);
        }
    }

    public void setCurtainColor(@ColorInt int color) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurtainColor(color);
        }
    }

    public void setCurtainCorner(int corner) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurtainCorner(corner);
        }
    }

    public void setCurtainRadius(@Px float radius) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurtainRadius(radius);
        }
    }

    public void setAtmosphericEnabled(boolean hasAtmospheric) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setAtmosphericEnabled(hasAtmospheric);
        }
    }

    public void setCurvedEnabled(boolean curved) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurvedEnabled(curved);
        }
    }

    public void setCurvedMaxAngle(int curvedMaxAngle) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurvedMaxAngle(curvedMaxAngle);
        }
    }

    public void setCurvedIndicatorSpace(@Px int space) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCurvedIndicatorSpace(space);
        }
    }

    public void setCyclicEnabled(boolean cyclic) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setCyclicEnabled(cyclic);
        }
    }

    public void setIndicatorEnabled(boolean hasIndicator) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setIndicatorEnabled(hasIndicator);
        }
    }

    public void setIndicatorSize(@Px float size) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setIndicatorSize(size);
        }
    }

    public void setIndicatorColor(@ColorInt int color) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setIndicatorColor(color);
        }
    }

    public void setMaxWidthText(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setMaxWidthText(text);
        }
    }

    public void setTextSize(@Px float textSize) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setTextSize(textSize);
        }
    }

    public void setSelectedTextSize(@Px float textSize) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setSelectedTextSize(textSize);
        }
    }

    public void setTextColor(@ColorInt int color) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setTextColor(color);
        }
    }

    public void setSelectedTextColor(@ColorInt int color) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setSelectedTextColor(color);
        }
    }

    public void setSelectedTextBold(boolean bold) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setSelectedTextBold(bold);
        }
    }

    public void setTextAlign(int align) {
        for (WheelView wheelView : this.wheelViews) {
            wheelView.setTextAlign(align);
        }
    }
}

