/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.dialog.ModalDialog;
import com.github.gzuliyujiang.wheelpicker.contract.OnTimeMeridiemPickedListener;
import com.github.gzuliyujiang.wheelpicker.contract.OnTimePickedListener;
import com.github.gzuliyujiang.wheelpicker.widget.TimeWheelLayout;

public class TimePicker
extends ModalDialog {
    protected TimeWheelLayout wheelLayout;
    private OnTimePickedListener onTimePickedListener;
    private OnTimeMeridiemPickedListener onTimeMeridiemPickedListener;

    public TimePicker(@NonNull Activity activity) {
        super(activity);
    }

    public TimePicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView() {
        this.wheelLayout = new TimeWheelLayout((Context)this.activity);
        return this.wheelLayout;
    }

    protected void onCancel() {
    }

    protected void onOk() {
        int hour = this.wheelLayout.getSelectedHour();
        int minute = this.wheelLayout.getSelectedMinute();
        int second = this.wheelLayout.getSelectedSecond();
        if (this.onTimePickedListener != null) {
            this.onTimePickedListener.onTimePicked(hour, minute, second);
        }
        if (this.onTimeMeridiemPickedListener != null) {
            this.onTimeMeridiemPickedListener.onTimePicked(hour, minute, second, this.wheelLayout.isAnteMeridiem());
        }
    }

    public void setOnTimePickedListener(OnTimePickedListener onTimePickedListener) {
        this.onTimePickedListener = onTimePickedListener;
    }

    public void setOnTimeMeridiemPickedListener(OnTimeMeridiemPickedListener onTimeMeridiemPickedListener) {
        this.onTimeMeridiemPickedListener = onTimeMeridiemPickedListener;
    }

    public final TimeWheelLayout getWheelLayout() {
        return this.wheelLayout;
    }
}

