/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.wheelpicker.R;
import com.github.gzuliyujiang.wheelpicker.contract.OnTimeMeridiemSelectedListener;
import com.github.gzuliyujiang.wheelpicker.contract.OnTimeSelectedListener;
import com.github.gzuliyujiang.wheelpicker.contract.TimeFormatter;
import com.github.gzuliyujiang.wheelpicker.entity.TimeEntity;
import com.github.gzuliyujiang.wheelpicker.impl.SimpleTimeFormatter;
import com.github.gzuliyujiang.wheelpicker.widget.BaseWheelLayout;
import com.github.gzuliyujiang.wheelview.contract.WheelFormatter;
import com.github.gzuliyujiang.wheelview.widget.NumberWheelView;
import com.github.gzuliyujiang.wheelview.widget.WheelView;
import java.util.Arrays;
import java.util.List;

public class TimeWheelLayout
extends BaseWheelLayout {
    private NumberWheelView hourWheelView;
    private NumberWheelView minuteWheelView;
    private NumberWheelView secondWheelView;
    private TextView hourLabelView;
    private TextView minuteLabelView;
    private TextView secondLabelView;
    private WheelView meridiemWheelView;
    private TimeEntity startValue;
    private TimeEntity endValue;
    private Integer selectedHour;
    private Integer selectedMinute;
    private Integer selectedSecond;
    private boolean isAnteMeridiem;
    private int timeMode;
    private OnTimeSelectedListener onTimeSelectedListener;
    private OnTimeMeridiemSelectedListener onTimeMeridiemSelectedListener;

    public TimeWheelLayout(Context context) {
        super(context);
    }

    public TimeWheelLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TimeWheelLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public TimeWheelLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected int provideLayoutRes() {
        return R.layout.wheel_picker_time;
    }

    @Override
    protected int[] provideStyleableRes() {
        return R.styleable.TimeWheelLayout;
    }

    @Override
    protected List<WheelView> provideWheelViews() {
        return Arrays.asList(this.hourWheelView, this.minuteWheelView, this.secondWheelView, this.meridiemWheelView);
    }

    @Override
    protected void onInit(@NonNull Context context) {
        this.hourWheelView = (NumberWheelView)this.findViewById(R.id.wheel_picker_time_hour_wheel);
        this.minuteWheelView = (NumberWheelView)this.findViewById(R.id.wheel_picker_time_minute_wheel);
        this.secondWheelView = (NumberWheelView)this.findViewById(R.id.wheel_picker_time_second_wheel);
        this.hourLabelView = (TextView)this.findViewById(R.id.wheel_picker_time_hour_label);
        this.minuteLabelView = (TextView)this.findViewById(R.id.wheel_picker_time_minute_label);
        this.secondLabelView = (TextView)this.findViewById(R.id.wheel_picker_time_second_label);
        this.meridiemWheelView = (WheelView)this.findViewById(R.id.wheel_picker_time_meridiem_wheel);
    }

    @Override
    protected void onAttributeSet(@NonNull Context context, @NonNull TypedArray typedArray) {
        float density = context.getResources().getDisplayMetrics().density;
        this.setTextSize(typedArray.getDimensionPixelSize(R.styleable.TimeWheelLayout_wheel_itemTextSize, (int)(15.0f * context.getResources().getDisplayMetrics().scaledDensity)));
        this.setVisibleItemCount(typedArray.getInt(R.styleable.TimeWheelLayout_wheel_visibleItemCount, 5));
        this.setSameWidthEnabled(typedArray.getBoolean(R.styleable.TimeWheelLayout_wheel_sameWidthEnabled, false));
        this.setMaxWidthText(typedArray.getString(R.styleable.TimeWheelLayout_wheel_maxWidthText));
        this.setSelectedTextColor(typedArray.getColor(R.styleable.TimeWheelLayout_wheel_itemTextColorSelected, -16777216));
        this.setTextColor(typedArray.getColor(R.styleable.TimeWheelLayout_wheel_itemTextColor, -7829368));
        this.setItemSpace(typedArray.getDimensionPixelSize(R.styleable.TimeWheelLayout_wheel_itemSpace, (int)(20.0f * density)));
        this.setCyclicEnabled(typedArray.getBoolean(R.styleable.TimeWheelLayout_wheel_cyclicEnabled, false));
        this.setIndicatorEnabled(typedArray.getBoolean(R.styleable.TimeWheelLayout_wheel_indicatorEnabled, false));
        this.setIndicatorColor(typedArray.getColor(R.styleable.TimeWheelLayout_wheel_indicatorColor, -3552823));
        this.setIndicatorSize(typedArray.getDimension(R.styleable.TimeWheelLayout_wheel_indicatorSize, 1.0f * density));
        this.setCurvedIndicatorSpace(typedArray.getDimensionPixelSize(R.styleable.TimeWheelLayout_wheel_curvedIndicatorSpace, (int)(1.0f * density)));
        this.setCurtainEnabled(typedArray.getBoolean(R.styleable.TimeWheelLayout_wheel_curtainEnabled, false));
        this.setCurtainColor(typedArray.getColor(R.styleable.TimeWheelLayout_wheel_curtainColor, -1996488705));
        this.setAtmosphericEnabled(typedArray.getBoolean(R.styleable.TimeWheelLayout_wheel_atmosphericEnabled, false));
        this.setCurvedEnabled(typedArray.getBoolean(R.styleable.TimeWheelLayout_wheel_curvedEnabled, false));
        this.setCurvedMaxAngle(typedArray.getInteger(R.styleable.TimeWheelLayout_wheel_curvedMaxAngle, 90));
        this.setTextAlign(typedArray.getInt(R.styleable.TimeWheelLayout_wheel_itemTextAlign, 0));
        this.setTimeMode(typedArray.getInt(R.styleable.TimeWheelLayout_wheel_timeMode, 0));
        String hourLabel = typedArray.getString(R.styleable.TimeWheelLayout_wheel_hourLabel);
        String minuteLabel = typedArray.getString(R.styleable.TimeWheelLayout_wheel_minuteLabel);
        String secondLabel = typedArray.getString(R.styleable.TimeWheelLayout_wheel_secondLabel);
        this.setTimeLabel(hourLabel, minuteLabel, secondLabel);
        this.setTimeFormatter(new SimpleTimeFormatter(this));
        this.setRange(TimeEntity.target(0, 0, 0), TimeEntity.target(23, 59, 59), TimeEntity.now());
    }

    public void onWheelSelected(WheelView view, int position) {
        int id2 = view.getId();
        if (id2 == R.id.wheel_picker_time_hour_wheel) {
            this.selectedHour = (Integer)this.hourWheelView.getItem(position);
            this.selectedMinute = null;
            this.selectedSecond = null;
            this.changeMinute(this.selectedHour);
            this.timeSelectedCallback();
            return;
        }
        if (id2 == R.id.wheel_picker_time_minute_wheel) {
            this.selectedMinute = (Integer)this.minuteWheelView.getItem(position);
            this.selectedSecond = null;
            this.changeSecond();
            this.timeSelectedCallback();
            return;
        }
        if (id2 == R.id.wheel_picker_time_second_wheel) {
            this.selectedSecond = (Integer)this.secondWheelView.getItem(position);
            this.timeSelectedCallback();
        }
    }

    @Override
    public void onWheelScrollStateChanged(WheelView view, int state) {
        int id2 = view.getId();
        if (id2 == R.id.wheel_picker_time_hour_wheel) {
            this.minuteWheelView.setEnabled(state == 0);
            this.secondWheelView.setEnabled(state == 0);
            return;
        }
        if (id2 == R.id.wheel_picker_time_minute_wheel) {
            this.hourWheelView.setEnabled(state == 0);
            this.secondWheelView.setEnabled(state == 0);
            return;
        }
        if (id2 == R.id.wheel_picker_time_second_wheel) {
            this.hourWheelView.setEnabled(state == 0);
            this.minuteWheelView.setEnabled(state == 0);
        }
    }

    private void timeSelectedCallback() {
        if (this.onTimeSelectedListener != null) {
            this.secondWheelView.post(new Runnable(){

                @Override
                public void run() {
                    TimeWheelLayout.this.onTimeSelectedListener.onTimeSelected(TimeWheelLayout.this.selectedHour, TimeWheelLayout.this.selectedMinute, TimeWheelLayout.this.selectedSecond);
                }
            });
        }
        if (this.onTimeMeridiemSelectedListener != null) {
            this.secondWheelView.post(new Runnable(){

                @Override
                public void run() {
                    TimeWheelLayout.this.onTimeMeridiemSelectedListener.onTimeSelected(TimeWheelLayout.this.selectedHour, TimeWheelLayout.this.selectedMinute, TimeWheelLayout.this.selectedSecond, TimeWheelLayout.this.isAnteMeridiem());
                }
            });
        }
    }

    public void setTimeMode(int timeMode) {
        this.timeMode = timeMode;
        this.hourWheelView.setVisibility(0);
        this.hourLabelView.setVisibility(0);
        this.minuteWheelView.setVisibility(0);
        this.minuteLabelView.setVisibility(0);
        this.secondWheelView.setVisibility(0);
        this.secondLabelView.setVisibility(0);
        this.meridiemWheelView.setVisibility(8);
        if (timeMode == -1) {
            this.hourWheelView.setVisibility(8);
            this.hourLabelView.setVisibility(8);
            this.minuteWheelView.setVisibility(8);
            this.minuteLabelView.setVisibility(8);
            this.secondWheelView.setVisibility(8);
            this.secondLabelView.setVisibility(8);
            this.timeMode = timeMode;
            return;
        }
        if (timeMode == 2 || timeMode == 0) {
            this.secondWheelView.setVisibility(8);
            this.secondLabelView.setVisibility(8);
        }
        if (this.isHour12Mode()) {
            this.meridiemWheelView.setVisibility(0);
            this.meridiemWheelView.setData(Arrays.asList("AM", "PM"));
        }
    }

    public boolean isHour12Mode() {
        return this.timeMode == 2 || this.timeMode == 3;
    }

    public void setRange(TimeEntity startValue, TimeEntity endValue) {
        this.setRange(startValue, endValue, null);
    }

    public void setRange(TimeEntity startValue, TimeEntity endValue, TimeEntity defaultValue) {
        if (startValue == null) {
            startValue = TimeEntity.target(this.isHour12Mode() ? 1 : 0, 0, 0);
        }
        if (endValue == null) {
            endValue = TimeEntity.target(this.isHour12Mode() ? 12 : 23, 59, 59);
        }
        if (endValue.toTimeInMillis() < startValue.toTimeInMillis()) {
            throw new IllegalArgumentException("Ensure the start time is less than the time date");
        }
        this.startValue = startValue;
        this.endValue = endValue;
        if (defaultValue != null) {
            this.isAnteMeridiem = defaultValue.getHour() <= 12;
            defaultValue.setHour(this.wrapHour(defaultValue.getHour()));
            this.selectedHour = defaultValue.getHour();
            this.selectedMinute = defaultValue.getMinute();
            this.selectedSecond = defaultValue.getSecond();
        }
        this.changeHour();
        this.changeAnteMeridiem();
    }

    public void setDefaultValue(@NonNull TimeEntity defaultValue) {
        this.setRange(this.startValue, this.endValue, defaultValue);
    }

    public void setTimeFormatter(final TimeFormatter timeFormatter) {
        if (timeFormatter == null) {
            return;
        }
        this.hourWheelView.setFormatter(new WheelFormatter(){

            public String formatItem(@NonNull Object value) {
                return timeFormatter.formatHour((Integer)value);
            }
        });
        this.minuteWheelView.setFormatter(new WheelFormatter(){

            public String formatItem(@NonNull Object value) {
                return timeFormatter.formatMinute((Integer)value);
            }
        });
        this.secondWheelView.setFormatter(new WheelFormatter(){

            public String formatItem(@NonNull Object value) {
                return timeFormatter.formatSecond((Integer)value);
            }
        });
    }

    public void setTimeLabel(CharSequence hour, CharSequence minute, CharSequence second) {
        this.hourLabelView.setText(hour);
        this.minuteLabelView.setText(minute);
        this.secondLabelView.setText(second);
    }

    public void setOnTimeSelectedListener(OnTimeSelectedListener onTimeSelectedListener) {
        this.onTimeSelectedListener = onTimeSelectedListener;
    }

    public void setOnTimeMeridiemSelectedListener(OnTimeMeridiemSelectedListener onTimeMeridiemSelectedListener) {
        this.onTimeMeridiemSelectedListener = onTimeMeridiemSelectedListener;
    }

    public final TimeEntity getStartValue() {
        return this.startValue;
    }

    public final TimeEntity getEndValue() {
        return this.endValue;
    }

    public final NumberWheelView getHourWheelView() {
        return this.hourWheelView;
    }

    public final NumberWheelView getMinuteWheelView() {
        return this.minuteWheelView;
    }

    public final NumberWheelView getSecondWheelView() {
        return this.secondWheelView;
    }

    public final TextView getHourLabelView() {
        return this.hourLabelView;
    }

    public final TextView getMinuteLabelView() {
        return this.minuteLabelView;
    }

    public final TextView getSecondLabelView() {
        return this.secondLabelView;
    }

    public final WheelView getMeridiemWheelView() {
        return this.meridiemWheelView;
    }

    @Deprecated
    public final TextView getMeridiemLabelView() {
        throw new UnsupportedOperationException("Use getMeridiemWheelView instead");
    }

    public final int getSelectedHour() {
        int hour = (Integer)this.hourWheelView.getCurrentItem();
        return this.wrapHour(hour);
    }

    private int wrapHour(int hour) {
        if (this.isHour12Mode() && hour > 12) {
            hour -= 12;
        }
        return hour;
    }

    public final int getSelectedMinute() {
        return (Integer)this.minuteWheelView.getCurrentItem();
    }

    public final int getSelectedSecond() {
        if (this.timeMode == 2 || this.timeMode == 0) {
            return 0;
        }
        return (Integer)this.secondWheelView.getCurrentItem();
    }

    public final boolean isAnteMeridiem() {
        return this.meridiemWheelView.getCurrentItem().toString().equalsIgnoreCase("AM");
    }

    private void changeHour() {
        int min = Math.min(this.startValue.getHour(), this.endValue.getHour());
        int max = Math.max(this.startValue.getHour(), this.endValue.getHour());
        int minHour = this.isHour12Mode() ? 1 : 0;
        int maxHour = this.isHour12Mode() ? 12 : 23;
        min = Math.max(minHour, min);
        max = Math.min(maxHour, max);
        if (this.selectedHour == null) {
            this.selectedHour = min;
        }
        this.hourWheelView.setRange(min, max, 1);
        this.hourWheelView.setDefaultValue((Object)this.selectedHour);
        this.changeMinute(this.selectedHour);
    }

    private void changeMinute(int hour) {
        int max;
        int min;
        if (hour == this.startValue.getHour() && hour == this.endValue.getHour()) {
            min = this.startValue.getMinute();
            max = this.endValue.getMinute();
        } else if (hour == this.startValue.getHour()) {
            min = this.startValue.getMinute();
            max = 59;
        } else if (hour == this.endValue.getHour()) {
            min = 0;
            max = this.endValue.getMinute();
        } else {
            min = 0;
            max = 59;
        }
        if (this.selectedMinute == null) {
            this.selectedMinute = min;
        }
        this.minuteWheelView.setRange(min, max, 1);
        this.minuteWheelView.setDefaultValue((Object)this.selectedMinute);
        this.changeSecond();
    }

    private void changeSecond() {
        if (this.selectedSecond == null) {
            this.selectedSecond = 0;
        }
        this.secondWheelView.setRange(0, 59, 1);
        this.secondWheelView.setDefaultValue((Object)this.selectedSecond);
    }

    private void changeAnteMeridiem() {
        this.meridiemWheelView.setDefaultValue((Object)(this.isAnteMeridiem ? "AM" : "PM"));
    }
}

