/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.dialog.DialogLog;
import com.github.gzuliyujiang.wheelpicker.OptionPicker;
import com.github.gzuliyujiang.wheelpicker.annotation.EthnicSpec;
import com.github.gzuliyujiang.wheelpicker.entity.EthnicEntity;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EthnicPicker
extends OptionPicker {
    public static final String JSON = "[{\"code\":\"01\",\"name\":\"\u6c49\u65cf\",\"spelling\":\"Han\"},{\"code\":\"02\",\"name\":\"\u8499\u53e4\u65cf\",\"spelling\":\"Mongol\"},{\"code\":\"03\",\"name\":\"\u56de\u65cf\",\"spelling\":\"Hui\"},{\"code\":\"04\",\"name\":\"\u85cf\u65cf\",\"spelling\":\"Zang\"},{\"code\":\"05\",\"name\":\"\u7ef4\u543e\u5c14\u65cf\",\"spelling\":\"Uygur\"},{\"code\":\"06\",\"name\":\"\u82d7\u65cf\",\"spelling\":\"Miao\"},{\"code\":\"07\",\"name\":\"\u5f5d\u65cf\",\"spelling\":\"Yi\"},{\"code\":\"08\",\"name\":\"\u58ee\u65cf\",\"spelling\":\"Zhuang\"},{\"code\":\"09\",\"name\":\"\u5e03\u4f9d\u65cf\",\"spelling\":\"Buyei\"},{\"code\":\"10\",\"name\":\"\u671d\u9c9c\u65cf\",\"spelling\":\"Chosen\"},{\"code\":\"11\",\"name\":\"\u6ee1\u65cf\",\"spelling\":\"Man\"},{\"code\":\"12\",\"name\":\"\u4f97\u65cf\",\"spelling\":\"Dong\"},{\"code\":\"13\",\"name\":\"\u7476\u65cf\",\"spelling\":\"Yao\"},{\"code\":\"14\",\"name\":\"\u767d\u65cf\",\"spelling\":\"Bai\"},{\"code\":\"15\",\"name\":\"\u571f\u5bb6\u65cf\",\"spelling\":\"Tujia\"},{\"code\":\"16\",\"name\":\"\u54c8\u5c3c\u65cf\",\"spelling\":\"Hani\"},{\"code\":\"17\",\"name\":\"\u54c8\u8428\u514b\u65cf\",\"spelling\":\"Kazak\"},{\"code\":\"18\",\"name\":\"\u50a3\u65cf\",\"spelling\":\"Dai\"},{\"code\":\"19\",\"name\":\"\u9ece\u65cf\",\"spelling\":\"Li\"},{\"code\":\"20\",\"name\":\"\u5088\u50f3\u65cf\",\"spelling\":\"Lisu\"},{\"code\":\"21\",\"name\":\"\u4f64\u65cf\",\"spelling\":\"Va\"},{\"code\":\"22\",\"name\":\"\u7572\u65cf\",\"spelling\":\"She\"},{\"code\":\"23\",\"name\":\"\u9ad8\u5c71\u65cf\",\"spelling\":\"Gaoshan\"},{\"code\":\"24\",\"name\":\"\u62c9\u795c\u65cf\",\"spelling\":\"Lahu\"},{\"code\":\"25\",\"name\":\"\u6c34\u65cf\",\"spelling\":\"Sui\"},{\"code\":\"26\",\"name\":\"\u4e1c\u4e61\u65cf\",\"spelling\":\"Dongxiang\"},{\"code\":\"27\",\"name\":\"\u7eb3\u897f\u65cf\",\"spelling\":\"Naxi\"},{\"code\":\"28\",\"name\":\"\u666f\u9887\u65cf\",\"spelling\":\"Jingpo\"},{\"code\":\"29\",\"name\":\"\u67ef\u5c14\u514b\u5b5c\u65cf\",\"spelling\":\"Kirgiz\"},{\"code\":\"30\",\"name\":\"\u571f\u65cf\",\"spelling\":\"Tu\"},{\"code\":\"31\",\"name\":\"\u8fbe\u65a1\u5c14\u65cf\",\"spelling\":\"Daur\"},{\"code\":\"32\",\"name\":\"\u4eeb\u4f6c\u65cf\",\"spelling\":\"Mulao\"},{\"code\":\"33\",\"name\":\"\u7f8c\u65cf\",\"spelling\":\"Qiang\"},{\"code\":\"34\",\"name\":\"\u5e03\u6717\u65cf\",\"spelling\":\"Blang\"},{\"code\":\"35\",\"name\":\"\u6492\u62c9\u65cf\",\"spelling\":\"Salar\"},{\"code\":\"36\",\"name\":\"\u6bdb\u96be\u65cf\",\"spelling\":\"Maonan\"},{\"code\":\"37\",\"name\":\"\u4ee1\u4f6c\u65cf\",\"spelling\":\"Gelao\"},{\"code\":\"38\",\"name\":\"\u9521\u4f2f\u65cf\",\"spelling\":\"Xibe\"},{\"code\":\"39\",\"name\":\"\u963f\u660c\u65cf\",\"spelling\":\"Achang\"},{\"code\":\"40\",\"name\":\"\u666e\u7c73\u65cf\",\"spelling\":\"Pumi\"},{\"code\":\"41\",\"name\":\"\u5854\u5409\u514b\u65cf\",\"spelling\":\"Tajik\"},{\"code\":\"42\",\"name\":\"\u6012\u65cf\",\"spelling\":\"Nu\"},{\"code\":\"43\",\"name\":\"\u4e4c\u5b5c\u522b\u514b\u65cf\",\"spelling\":\"Uzbek\"},{\"code\":\"44\",\"name\":\"\u4fc4\u7f57\u65af\u65cf\",\"spelling\":\"Russ\"},{\"code\":\"45\",\"name\":\"\u9102\u6e29\u514b\u65cf\",\"spelling\":\"Ewenki\"},{\"code\":\"46\",\"name\":\"\u5fb7\u6602\u65cf\",\"spelling\":\"Deang\"},{\"code\":\"47\",\"name\":\"\u4fdd\u5b89\u65cf\",\"spelling\":\"Bonan\"},{\"code\":\"48\",\"name\":\"\u88d5\u56fa\u65cf\",\"spelling\":\"Yugur\"},{\"code\":\"49\",\"name\":\"\u4eac\u65cf\",\"spelling\":\"Gin\"},{\"code\":\"50\",\"name\":\"\u5854\u5854\u5c14\u65cf\",\"spelling\":\"Tatar\"},{\"code\":\"51\",\"name\":\"\u72ec\u9f99\u65cf\",\"spelling\":\"Derung\"},{\"code\":\"52\",\"name\":\"\u9102\u4f26\u6625\u65cf\",\"spelling\":\"Oroqen\"},{\"code\":\"53\",\"name\":\"\u8d6b\u54f2\u65cf\",\"spelling\":\"Hezhen\"},{\"code\":\"54\",\"name\":\"\u95e8\u5df4\u65cf\",\"spelling\":\"Monba\"},{\"code\":\"55\",\"name\":\"\u73de\u5df4\u65cf\",\"spelling\":\"Lhoba\"},{\"code\":\"56\",\"name\":\"\u57fa\u8bfa\u65cf\",\"spelling\":\"Jino\"}]";
    private int ethnicSpec = 1;

    public EthnicPicker(@NonNull Activity activity) {
        super(activity);
    }

    public EthnicPicker(@NonNull Activity activity, int themeResId) {
        super(activity, themeResId);
    }

    @Override
    protected void initData() {
        super.initData();
        this.titleView.setText((CharSequence)"\u6c11\u65cf\u9009\u62e9");
    }

    public void setEthnicSpec(@EthnicSpec int ethnicSpec) {
        this.ethnicSpec = ethnicSpec;
        this.setData(this.provideData());
    }

    public void setDefaultValueByCode(String code) {
        EthnicEntity entity = new EthnicEntity();
        entity.setCode(code);
        this.setDefaultValue(entity);
    }

    public void setDefaultValueByName(String name) {
        EthnicEntity entity = new EthnicEntity();
        entity.setName(name);
        this.setDefaultValue(entity);
    }

    public void setDefaultValueBySpelling(String spelling) {
        EthnicEntity entity = new EthnicEntity();
        entity.setSpelling(spelling);
        this.setDefaultValue(entity);
    }

    protected List<EthnicEntity> provideData() {
        ArrayList<EthnicEntity> data = new ArrayList<EthnicEntity>();
        try {
            JSONArray jsonArray = new JSONArray(JSON);
            int n = jsonArray.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                EthnicEntity entity = new EthnicEntity();
                entity.setCode(jsonObject.getString("code"));
                entity.setName(jsonObject.getString("name"));
                entity.setSpelling(jsonObject.getString("spelling"));
                data.add(entity);
            }
        }
        catch (JSONException e) {
            DialogLog.print((Object)((Object)e));
        }
        switch (this.ethnicSpec) {
            case 1: {
                EthnicEntity other = new EthnicEntity();
                other.setCode("97");
                other.setName("\u5176\u4ed6");
                other.setSpelling("Other");
                data.add(other);
                EthnicEntity foreign = new EthnicEntity();
                foreign.setCode("98");
                foreign.setName("\u5916\u56fd\u8840\u7edf");
                foreign.setSpelling("Foreign");
                data.add(foreign);
                break;
            }
            case 3: {
                EthnicEntity unrecognized = new EthnicEntity();
                unrecognized.setCode("97");
                unrecognized.setName("\u672a\u5b9a\u65cf\u79f0\u4eba\u53e3");
                unrecognized.setSpelling("Unrecognized");
                data.add(unrecognized);
                EthnicEntity naturalization = new EthnicEntity();
                naturalization.setCode("98");
                naturalization.setName("\u5165\u7c4d");
                naturalization.setSpelling("Naturalization");
                data.add(naturalization);
                break;
            }
        }
        return data;
    }
}

