/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.dialog.ModalDialog;
import com.github.gzuliyujiang.wheelpicker.contract.OnDatimePickedListener;
import com.github.gzuliyujiang.wheelpicker.widget.DatimeWheelLayout;

public class DatimePicker
extends ModalDialog {
    protected DatimeWheelLayout wheelLayout;
    private OnDatimePickedListener onDatimePickedListener;

    public DatimePicker(@NonNull Activity activity) {
        super(activity);
    }

    public DatimePicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView() {
        this.wheelLayout = new DatimeWheelLayout((Context)this.activity);
        return this.wheelLayout;
    }

    protected void initData() {
        super.initData();
        this.titleView.setText((CharSequence)"\u65e5\u671f\u65f6\u95f4\u9009\u62e9");
    }

    protected void onCancel() {
    }

    protected void onOk() {
        if (this.onDatimePickedListener != null) {
            int year = this.wheelLayout.getSelectedYear();
            int month = this.wheelLayout.getSelectedMonth();
            int day = this.wheelLayout.getSelectedDay();
            int hour = this.wheelLayout.getSelectedHour();
            int minute = this.wheelLayout.getSelectedMinute();
            int second = this.wheelLayout.getSelectedSecond();
            this.onDatimePickedListener.onDatimePicked(year, month, day, hour, minute, second);
        }
    }

    public void setOnDatimePickedListener(OnDatimePickedListener onDatimePickedListener) {
        this.onDatimePickedListener = onDatimePickedListener;
    }

    public final DatimeWheelLayout getWheelLayout() {
        return this.wheelLayout;
    }
}

