/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.github.gzuliyujiang.wheelpicker.R;
import com.github.gzuliyujiang.wheelpicker.contract.LinkageProvider;
import com.github.gzuliyujiang.wheelpicker.contract.OnLinkageSelectedListener;
import com.github.gzuliyujiang.wheelpicker.widget.BaseWheelLayout;
import com.github.gzuliyujiang.wheelview.contract.WheelFormatter;
import com.github.gzuliyujiang.wheelview.widget.WheelView;
import java.util.Arrays;
import java.util.List;

public class LinkageWheelLayout
extends BaseWheelLayout {
    private WheelView firstWheelView;
    private WheelView secondWheelView;
    private WheelView thirdWheelView;
    private TextView firstLabelView;
    private TextView secondLabelView;
    private TextView thirdLabelView;
    private ProgressBar loadingView;
    private Object firstValue;
    private Object secondValue;
    private Object thirdValue;
    private int firstIndex;
    private int secondIndex;
    private int thirdIndex;
    private LinkageProvider dataProvider;
    private OnLinkageSelectedListener onLinkageSelectedListener;

    public LinkageWheelLayout(Context context) {
        super(context);
    }

    public LinkageWheelLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LinkageWheelLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public LinkageWheelLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected int provideLayoutRes() {
        return R.layout.wheel_picker_linkage;
    }

    @Override
    protected int[] provideStyleableRes() {
        return R.styleable.LinkageWheelLayout;
    }

    @Override
    protected List<WheelView> provideWheelViews() {
        return Arrays.asList(this.firstWheelView, this.secondWheelView, this.thirdWheelView);
    }

    @Override
    protected void onInit(@NonNull Context context) {
        this.firstWheelView = (WheelView)this.findViewById(R.id.wheel_picker_linkage_first_wheel);
        this.secondWheelView = (WheelView)this.findViewById(R.id.wheel_picker_linkage_second_wheel);
        this.thirdWheelView = (WheelView)this.findViewById(R.id.wheel_picker_linkage_third_wheel);
        this.firstLabelView = (TextView)this.findViewById(R.id.wheel_picker_linkage_first_label);
        this.secondLabelView = (TextView)this.findViewById(R.id.wheel_picker_linkage_second_label);
        this.thirdLabelView = (TextView)this.findViewById(R.id.wheel_picker_linkage_third_label);
        this.loadingView = (ProgressBar)this.findViewById(R.id.wheel_picker_linkage_loading);
    }

    @Override
    protected void onAttributeSet(@NonNull Context context, @NonNull TypedArray typedArray) {
        float density = context.getResources().getDisplayMetrics().density;
        this.setTextSize(typedArray.getDimensionPixelSize(R.styleable.LinkageWheelLayout_wheel_itemTextSize, (int)(15.0f * context.getResources().getDisplayMetrics().scaledDensity)));
        this.setVisibleItemCount(typedArray.getInt(R.styleable.LinkageWheelLayout_wheel_visibleItemCount, 5));
        this.setSameWidthEnabled(typedArray.getBoolean(R.styleable.LinkageWheelLayout_wheel_sameWidthEnabled, false));
        this.setMaxWidthText(typedArray.getString(R.styleable.LinkageWheelLayout_wheel_maxWidthText));
        this.setSelectedTextColor(typedArray.getColor(R.styleable.LinkageWheelLayout_wheel_itemTextColorSelected, -16777216));
        this.setTextColor(typedArray.getColor(R.styleable.LinkageWheelLayout_wheel_itemTextColor, -7829368));
        this.setItemSpace(typedArray.getDimensionPixelSize(R.styleable.LinkageWheelLayout_wheel_itemSpace, (int)(20.0f * density)));
        this.setCyclicEnabled(typedArray.getBoolean(R.styleable.LinkageWheelLayout_wheel_cyclicEnabled, false));
        this.setIndicatorEnabled(typedArray.getBoolean(R.styleable.LinkageWheelLayout_wheel_indicatorEnabled, false));
        this.setIndicatorColor(typedArray.getColor(R.styleable.LinkageWheelLayout_wheel_indicatorColor, -3552823));
        this.setIndicatorSize(typedArray.getDimension(R.styleable.LinkageWheelLayout_wheel_indicatorSize, 1.0f * density));
        this.setCurvedIndicatorSpace(typedArray.getDimensionPixelSize(R.styleable.LinkageWheelLayout_wheel_curvedIndicatorSpace, (int)(1.0f * density)));
        this.setCurtainEnabled(typedArray.getBoolean(R.styleable.LinkageWheelLayout_wheel_curtainEnabled, false));
        this.setCurtainColor(typedArray.getColor(R.styleable.LinkageWheelLayout_wheel_curtainColor, -1996488705));
        this.setAtmosphericEnabled(typedArray.getBoolean(R.styleable.LinkageWheelLayout_wheel_atmosphericEnabled, false));
        this.setCurvedEnabled(typedArray.getBoolean(R.styleable.LinkageWheelLayout_wheel_curvedEnabled, false));
        this.setCurvedMaxAngle(typedArray.getInteger(R.styleable.LinkageWheelLayout_wheel_curvedMaxAngle, 90));
        this.setTextAlign(typedArray.getInt(R.styleable.LinkageWheelLayout_wheel_itemTextAlign, 0));
        this.setFirstVisible(typedArray.getBoolean(R.styleable.LinkageWheelLayout_wheel_firstVisible, true));
        this.setThirdVisible(typedArray.getBoolean(R.styleable.LinkageWheelLayout_wheel_thirdVisible, true));
        String firstLabel = typedArray.getString(R.styleable.LinkageWheelLayout_wheel_firstLabel);
        String secondLabel = typedArray.getString(R.styleable.LinkageWheelLayout_wheel_secondLabel);
        String thirdLabel = typedArray.getString(R.styleable.LinkageWheelLayout_wheel_thirdLabel);
        this.setLabel(firstLabel, secondLabel, thirdLabel);
    }

    public void onWheelSelected(WheelView view, int position) {
        int id2 = view.getId();
        if (id2 == R.id.wheel_picker_linkage_first_wheel) {
            this.firstIndex = position;
            this.secondIndex = 0;
            this.thirdIndex = 0;
            this.changeSecondData();
            this.changeThirdData();
            this.selectedCallback();
            return;
        }
        if (id2 == R.id.wheel_picker_linkage_second_wheel) {
            this.secondIndex = position;
            this.thirdIndex = 0;
            this.changeThirdData();
            this.selectedCallback();
            return;
        }
        if (id2 == R.id.wheel_picker_linkage_third_wheel) {
            this.thirdIndex = position;
            this.selectedCallback();
        }
    }

    @Override
    public void onWheelScrollStateChanged(WheelView view, int state) {
        int id2 = view.getId();
        if (id2 == R.id.wheel_picker_linkage_first_wheel) {
            this.secondWheelView.setEnabled(state == 0);
            this.thirdWheelView.setEnabled(state == 0);
            return;
        }
        if (id2 == R.id.wheel_picker_linkage_second_wheel) {
            this.firstWheelView.setEnabled(state == 0);
            this.thirdWheelView.setEnabled(state == 0);
            return;
        }
        if (id2 == R.id.wheel_picker_linkage_third_wheel) {
            this.firstWheelView.setEnabled(state == 0);
            this.secondWheelView.setEnabled(state == 0);
        }
    }

    public void setData(@NonNull LinkageProvider provider) {
        this.dataProvider = provider;
        this.setFirstVisible(provider.firstLevelVisible());
        this.setThirdVisible(provider.thirdLevelVisible());
        this.firstIndex = provider.findFirstIndex(this.firstValue);
        this.secondIndex = provider.findSecondIndex(this.firstIndex, this.secondValue);
        this.thirdIndex = provider.findThirdIndex(this.firstIndex, this.secondIndex, this.thirdValue);
        this.changeFirstData();
        this.changeSecondData();
        this.changeThirdData();
    }

    public void setDefaultValue(Object first, Object second, Object third) {
        this.firstValue = first;
        this.secondValue = second;
        this.thirdValue = third;
    }

    public void setFormatter(WheelFormatter first, WheelFormatter second, WheelFormatter third) {
        this.firstWheelView.setFormatter(first);
        this.secondWheelView.setFormatter(second);
        this.thirdWheelView.setFormatter(third);
    }

    public void setLabel(CharSequence first, CharSequence second, CharSequence third) {
        this.firstLabelView.setText(first);
        this.secondLabelView.setText(second);
        this.thirdLabelView.setText(third);
    }

    public void showLoading() {
        this.loadingView.setVisibility(0);
    }

    public void hideLoading() {
        this.loadingView.setVisibility(8);
    }

    public void setOnLinkageSelectedListener(OnLinkageSelectedListener onLinkageSelectedListener) {
        this.onLinkageSelectedListener = onLinkageSelectedListener;
    }

    public void setFirstVisible(boolean visible) {
        if (visible) {
            this.firstWheelView.setVisibility(0);
            this.firstLabelView.setVisibility(0);
        } else {
            this.firstWheelView.setVisibility(8);
            this.firstLabelView.setVisibility(8);
        }
    }

    public void setThirdVisible(boolean visible) {
        if (visible) {
            this.thirdWheelView.setVisibility(0);
            this.thirdLabelView.setVisibility(0);
        } else {
            this.thirdWheelView.setVisibility(8);
            this.thirdLabelView.setVisibility(8);
        }
    }

    private void selectedCallback() {
        if (this.onLinkageSelectedListener == null) {
            return;
        }
        this.thirdWheelView.post(new Runnable(){

            @Override
            public void run() {
                Object first = LinkageWheelLayout.this.firstWheelView.getCurrentItem();
                Object second = LinkageWheelLayout.this.secondWheelView.getCurrentItem();
                Object third = LinkageWheelLayout.this.thirdWheelView.getCurrentItem();
                LinkageWheelLayout.this.onLinkageSelectedListener.onLinkageSelected(first, second, third);
            }
        });
    }

    private void changeFirstData() {
        this.firstWheelView.setData(this.dataProvider.provideFirstData());
        this.firstWheelView.setDefaultPosition(this.firstIndex);
    }

    private void changeSecondData() {
        this.secondWheelView.setData(this.dataProvider.linkageSecondData(this.firstIndex));
        this.secondWheelView.setDefaultPosition(this.secondIndex);
    }

    private void changeThirdData() {
        if (!this.dataProvider.thirdLevelVisible()) {
            return;
        }
        this.thirdWheelView.setData(this.dataProvider.linkageThirdData(this.firstIndex, this.secondIndex));
        this.thirdWheelView.setDefaultPosition(this.thirdIndex);
    }

    public final WheelView getFirstWheelView() {
        return this.firstWheelView;
    }

    public final WheelView getSecondWheelView() {
        return this.secondWheelView;
    }

    public final WheelView getThirdWheelView() {
        return this.thirdWheelView;
    }

    public final TextView getFirstLabelView() {
        return this.firstLabelView;
    }

    public final TextView getSecondLabelView() {
        return this.secondLabelView;
    }

    public final TextView getThirdLabelView() {
        return this.thirdLabelView;
    }

    public final ProgressBar getLoadingView() {
        return this.loadingView;
    }
}

