/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.basepicker.ConfirmPicker;
import com.github.gzuliyujiang.wheelpicker.contract.OnTimePickedListener;
import com.github.gzuliyujiang.wheelpicker.widget.TimeWheelLayout;

public class TimePicker
extends ConfirmPicker {
    protected TimeWheelLayout wheelLayout;
    private OnTimePickedListener onTimePickedListener;

    public TimePicker(@NonNull Activity activity) {
        super(activity);
    }

    public TimePicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    @NonNull
    protected View createBodyView(@NonNull Activity activity) {
        this.wheelLayout = new TimeWheelLayout((Context)activity);
        return this.wheelLayout;
    }

    protected void initView(@NonNull View contentView) {
        super.initView(contentView);
    }

    @Deprecated
    protected int provideTimeMode() {
        throw new UnsupportedOperationException("Use `picker.getWheelLayout().setTimeMode()` instead");
    }

    protected void onCancel() {
    }

    protected void onOk() {
        if (this.onTimePickedListener != null) {
            int hour = this.wheelLayout.getSelectedHour();
            int minute = this.wheelLayout.getSelectedMinute();
            int second = this.wheelLayout.getSelectedSecond();
            this.onTimePickedListener.onTimePicked(hour, minute, second);
        }
    }

    public void setOnTimePickedListener(OnTimePickedListener onTimePickedListener) {
        this.onTimePickedListener = onTimePickedListener;
    }

    public final TimeWheelLayout getWheelLayout() {
        return this.wheelLayout;
    }
}

