/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.gzuliyujiang.wheelpicker.R;
import com.github.gzuliyujiang.wheelpicker.contract.DateFormatter;
import com.github.gzuliyujiang.wheelpicker.contract.OnDateSelectedListener;
import com.github.gzuliyujiang.wheelpicker.entity.DateEntity;
import com.github.gzuliyujiang.wheelpicker.impl.SimpleDateFormatter;
import com.github.gzuliyujiang.wheelpicker.widget.BaseWheelLayout;
import com.github.gzuliyujiang.wheelview.contract.WheelFormatter;
import com.github.gzuliyujiang.wheelview.widget.NumberWheelView;
import com.github.gzuliyujiang.wheelview.widget.WheelView;
import java.util.Arrays;
import java.util.List;

public class DateWheelLayout
extends BaseWheelLayout {
    private NumberWheelView yearWheelView;
    private NumberWheelView monthWheelView;
    private NumberWheelView dayWheelView;
    private TextView yearLabelView;
    private TextView monthLabelView;
    private TextView dayLabelView;
    private DateEntity startValue;
    private DateEntity endValue;
    private Integer selectedYear;
    private Integer selectedMonth;
    private Integer selectedDay;
    private OnDateSelectedListener onDateSelectedListener;

    public DateWheelLayout(Context context) {
        super(context);
    }

    public DateWheelLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public DateWheelLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public DateWheelLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected int provideLayoutRes() {
        return R.layout.wheel_picker_date;
    }

    @Override
    protected int[] provideStyleableRes() {
        return R.styleable.DateWheelLayout;
    }

    @Override
    protected List<WheelView> provideWheelViews() {
        return Arrays.asList(this.yearWheelView, this.monthWheelView, this.dayWheelView);
    }

    @Override
    protected void onInit(@NonNull Context context) {
        this.yearWheelView = (NumberWheelView)this.findViewById(R.id.wheel_picker_date_year_wheel);
        this.monthWheelView = (NumberWheelView)this.findViewById(R.id.wheel_picker_date_month_wheel);
        this.dayWheelView = (NumberWheelView)this.findViewById(R.id.wheel_picker_date_day_wheel);
        this.yearLabelView = (TextView)this.findViewById(R.id.wheel_picker_date_year_label);
        this.monthLabelView = (TextView)this.findViewById(R.id.wheel_picker_date_month_label);
        this.dayLabelView = (TextView)this.findViewById(R.id.wheel_picker_date_day_label);
        this.setDateFormatter(new SimpleDateFormatter());
        this.setRange(DateEntity.today(), DateEntity.yearOnFuture(30));
    }

    @Override
    protected void onAttributeSet(@NonNull Context context, @NonNull TypedArray typedArray) {
        float density = context.getResources().getDisplayMetrics().density;
        this.setTextSize(typedArray.getDimensionPixelSize(R.styleable.DateWheelLayout_wheel_itemTextSize, (int)(15.0f * context.getResources().getDisplayMetrics().scaledDensity)));
        this.setVisibleItemCount(typedArray.getInt(R.styleable.DateWheelLayout_wheel_visibleItemCount, 5));
        this.setSameWidthEnabled(typedArray.getBoolean(R.styleable.DateWheelLayout_wheel_sameWidthEnabled, false));
        this.setMaxWidthText(typedArray.getString(R.styleable.DateWheelLayout_wheel_maxWidthText));
        this.setSelectedTextColor(typedArray.getColor(R.styleable.DateWheelLayout_wheel_itemTextColorSelected, -16777216));
        this.setTextColor(typedArray.getColor(R.styleable.DateWheelLayout_wheel_itemTextColor, -7829368));
        this.setItemSpace(typedArray.getDimensionPixelSize(R.styleable.DateWheelLayout_wheel_itemSpace, (int)(20.0f * density)));
        this.setCyclicEnabled(typedArray.getBoolean(R.styleable.DateWheelLayout_wheel_cyclicEnabled, false));
        this.setIndicatorEnabled(typedArray.getBoolean(R.styleable.DateWheelLayout_wheel_indicatorEnabled, false));
        this.setIndicatorColor(typedArray.getColor(R.styleable.DateWheelLayout_wheel_indicatorColor, -1166541));
        this.setIndicatorSize(typedArray.getDimension(R.styleable.DateWheelLayout_wheel_indicatorSize, 1.0f * density));
        this.setCurtainEnabled(typedArray.getBoolean(R.styleable.DateWheelLayout_wheel_curtainEnabled, false));
        this.setCurtainColor(typedArray.getColor(R.styleable.DateWheelLayout_wheel_curtainColor, -1996488705));
        this.setAtmosphericEnabled(typedArray.getBoolean(R.styleable.DateWheelLayout_wheel_atmosphericEnabled, false));
        this.setCurvedEnabled(typedArray.getBoolean(R.styleable.DateWheelLayout_wheel_curvedEnabled, false));
        this.setCurvedMaxAngle(typedArray.getInteger(R.styleable.DateWheelLayout_wheel_curvedMaxAngle, 90));
        this.setTextAlign(typedArray.getInt(R.styleable.DateWheelLayout_wheel_itemTextAlign, 0));
        this.setDateMode(typedArray.getInt(R.styleable.DateWheelLayout_wheel_dateMode, 0));
        String yearLabel = typedArray.getString(R.styleable.DateWheelLayout_wheel_yearLabel);
        String monthLabel = typedArray.getString(R.styleable.DateWheelLayout_wheel_monthLabel);
        String dayLabel = typedArray.getString(R.styleable.DateWheelLayout_wheel_dayLabel);
        this.setDateLabel(yearLabel, monthLabel, dayLabel);
    }

    public void onWheelSelected(WheelView view, int position) {
        int id2 = view.getId();
        if (id2 == R.id.wheel_picker_date_year_wheel) {
            this.selectedYear = (Integer)this.yearWheelView.getItem(position);
            this.selectedMonth = null;
            this.selectedDay = null;
            this.changeMonth(this.selectedYear);
            this.dateSelectedCallback();
            return;
        }
        if (id2 == R.id.wheel_picker_date_month_wheel) {
            this.selectedMonth = (Integer)this.monthWheelView.getItem(position);
            this.selectedDay = null;
            this.changeDay(this.selectedYear, this.selectedMonth);
            this.dateSelectedCallback();
            return;
        }
        if (id2 == R.id.wheel_picker_date_day_wheel) {
            this.selectedDay = (Integer)this.dayWheelView.getItem(position);
            this.dateSelectedCallback();
        }
    }

    private void dateSelectedCallback() {
        if (this.onDateSelectedListener == null) {
            return;
        }
        this.dayWheelView.post(new Runnable(){

            @Override
            public void run() {
                DateWheelLayout.this.onDateSelectedListener.onDateSelected(DateWheelLayout.this.selectedYear, DateWheelLayout.this.selectedMonth, DateWheelLayout.this.selectedDay);
            }
        });
    }

    public void setDateMode(int dateMode) {
        if (dateMode == -1) {
            this.yearWheelView.setVisibility(8);
            this.yearLabelView.setVisibility(8);
            this.monthWheelView.setVisibility(8);
            this.monthLabelView.setVisibility(8);
            this.dayWheelView.setVisibility(8);
            this.dayLabelView.setVisibility(8);
            return;
        }
        if (dateMode == 2) {
            this.yearWheelView.setVisibility(8);
            this.yearLabelView.setVisibility(8);
            return;
        }
        if (dateMode == 1) {
            this.dayWheelView.setVisibility(8);
            this.dayLabelView.setVisibility(8);
        }
    }

    public void setRange(@NonNull DateEntity startValue, @NonNull DateEntity endValue) {
        this.setRange(startValue, endValue, null);
    }

    public void setRange(@NonNull DateEntity startValue, @NonNull DateEntity endValue, @Nullable DateEntity defaultValue) {
        this.startValue = startValue;
        this.endValue = endValue;
        if (defaultValue != null) {
            this.selectedYear = defaultValue.getYear();
            this.selectedMonth = defaultValue.getMonth();
            this.selectedDay = defaultValue.getDay();
        }
        this.changeYear();
    }

    public void setDefaultValue(final @NonNull DateEntity defaultValue) {
        if (this.startValue == null) {
            this.startValue = DateEntity.today();
        }
        if (this.endValue == null) {
            this.endValue = DateEntity.yearOnFuture(30);
        }
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                DateWheelLayout.this.setRange(DateWheelLayout.this.startValue, DateWheelLayout.this.endValue, defaultValue);
            }
        }, 200L);
    }

    public void setDateFormatter(final DateFormatter dateFormatter) {
        if (dateFormatter == null) {
            return;
        }
        this.yearWheelView.setFormatter(new WheelFormatter(){

            public String formatItem(@NonNull Object value) {
                return dateFormatter.formatYear((Integer)value);
            }
        });
        this.monthWheelView.setFormatter(new WheelFormatter(){

            public String formatItem(@NonNull Object value) {
                return dateFormatter.formatMonth((Integer)value);
            }
        });
        this.dayWheelView.setFormatter(new WheelFormatter(){

            public String formatItem(@NonNull Object value) {
                return dateFormatter.formatDay((Integer)value);
            }
        });
    }

    public void setDateLabel(CharSequence year, CharSequence month, CharSequence day) {
        this.yearLabelView.setText(year);
        this.monthLabelView.setText(month);
        this.dayLabelView.setText(day);
    }

    public void setOnDateSelectedListener(OnDateSelectedListener onDateSelectedListener) {
        this.onDateSelectedListener = onDateSelectedListener;
    }

    public final DateEntity getStartValue() {
        return this.startValue;
    }

    public final DateEntity getEndValue() {
        return this.endValue;
    }

    public final NumberWheelView getYearWheelView() {
        return this.yearWheelView;
    }

    public final NumberWheelView getMonthWheelView() {
        return this.monthWheelView;
    }

    public final NumberWheelView getDayWheelView() {
        return this.dayWheelView;
    }

    public final TextView getYearLabelView() {
        return this.yearLabelView;
    }

    public final TextView getMonthLabelView() {
        return this.monthLabelView;
    }

    public final TextView getDayLabelView() {
        return this.dayLabelView;
    }

    public final int getSelectedYear() {
        return (Integer)this.yearWheelView.getCurrentItem();
    }

    public final int getSelectedMonth() {
        return (Integer)this.monthWheelView.getCurrentItem();
    }

    public final int getSelectedDay() {
        return (Integer)this.dayWheelView.getCurrentItem();
    }

    private void changeYear() {
        int min = Math.min(this.startValue.getYear(), this.endValue.getYear());
        int max = Math.max(this.startValue.getYear(), this.endValue.getYear());
        if (this.selectedYear == null) {
            this.selectedYear = min;
        }
        this.yearWheelView.setRange(min, max, 1);
        this.yearWheelView.setDefaultValue((Object)this.selectedYear);
        this.changeMonth(this.selectedYear);
    }

    private void changeMonth(int year) {
        int max;
        int min;
        if (this.startValue.getYear() == this.endValue.getYear()) {
            min = Math.min(this.startValue.getMonth(), this.endValue.getMonth());
            max = Math.max(this.startValue.getMonth(), this.endValue.getMonth());
        } else if (year == this.startValue.getYear()) {
            min = this.startValue.getMonth();
            max = 12;
        } else if (year == this.endValue.getYear()) {
            min = 1;
            max = this.endValue.getMonth();
        } else {
            min = 1;
            max = 12;
        }
        if (this.selectedMonth == null) {
            this.selectedMonth = min;
        }
        this.monthWheelView.setRange(min, max, 1);
        this.monthWheelView.setDefaultValue((Object)this.selectedMonth);
        this.changeDay(year, this.selectedMonth);
    }

    private void changeDay(int year, int month) {
        int max;
        int min;
        if (year == this.startValue.getYear() && month == this.startValue.getMonth() && year == this.endValue.getYear() && month == this.endValue.getMonth()) {
            min = this.startValue.getDay();
            max = this.endValue.getDay();
        } else if (year == this.startValue.getYear() && month == this.startValue.getMonth()) {
            min = this.startValue.getDay();
            max = this.getTotalDaysInMonth(year, month);
        } else if (year == this.endValue.getYear() && month == this.endValue.getMonth()) {
            min = 1;
            max = this.endValue.getDay();
        } else {
            min = 1;
            max = this.getTotalDaysInMonth(year, month);
        }
        if (this.selectedDay == null) {
            this.selectedDay = min;
        }
        this.dayWheelView.setRange(min, max, 1);
        this.dayWheelView.setDefaultValue((Object)this.selectedDay);
    }

    private int getTotalDaysInMonth(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                boolean isLeap;
                if (year <= 0) {
                    return 29;
                }
                boolean bl = isLeap = year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
                if (isLeap) {
                    return 29;
                }
                return 28;
            }
        }
        return 30;
    }
}

