/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.utility;

import com.github.gzuliyujiang.basepicker.PickerLog;
import com.github.gzuliyujiang.wheelpicker.entity.CityEntity;
import com.github.gzuliyujiang.wheelpicker.entity.CountyEntity;
import com.github.gzuliyujiang.wheelpicker.entity.ProvinceEntity;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AddressParser {
    public static List<ProvinceEntity> parseData(String json) {
        try {
            JSONArray provinceArray = new JSONArray(json);
            return AddressParser.parseProvince(provinceArray);
        }
        catch (JSONException e) {
            PickerLog.print((Object)((Object)e));
            return new ArrayList<ProvinceEntity>();
        }
    }

    private static List<ProvinceEntity> parseProvince(JSONArray provinceArray) {
        ArrayList<ProvinceEntity> data = new ArrayList<ProvinceEntity>();
        int x = provinceArray.length();
        for (int i = 0; i < x; ++i) {
            ProvinceEntity provinceEntity = new ProvinceEntity();
            JSONObject provinceObject = provinceArray.optJSONObject(i);
            provinceEntity.setCode(provinceObject.optString("code"));
            provinceEntity.setName(provinceObject.optString("name"));
            provinceEntity.setCityList(new ArrayList<CityEntity>());
            JSONArray cityArray = provinceObject.optJSONArray("cityList");
            AddressParser.parseCity(provinceEntity, cityArray);
            data.add(provinceEntity);
        }
        return data;
    }

    private static void parseCity(ProvinceEntity provinceEntity, JSONArray cityArray) {
        if (cityArray == null || cityArray.length() == 0) {
            return;
        }
        int y = cityArray.length();
        for (int j = 0; j < y; ++j) {
            CityEntity cityEntity = new CityEntity();
            JSONObject cityObject = cityArray.optJSONObject(j);
            cityEntity.setCode(cityObject.optString("code"));
            cityEntity.setName(cityObject.optString("name"));
            cityEntity.setCountyList(new ArrayList<CountyEntity>());
            provinceEntity.getCityList().add(cityEntity);
            JSONArray countyArray = cityObject.optJSONArray("areaList");
            AddressParser.parseCounty(cityEntity, countyArray);
        }
    }

    private static void parseCounty(CityEntity cityEntity, JSONArray countyArray) {
        if (countyArray == null || countyArray.length() == 0) {
            return;
        }
        int z = countyArray.length();
        for (int k = 0; k < z; ++k) {
            CountyEntity countyEntity = new CountyEntity();
            JSONObject countyObject = countyArray.optJSONObject(k);
            countyEntity.setCode(countyObject.optString("code"));
            countyEntity.setName(countyObject.optString("name"));
            cityEntity.getCountyList().add(countyEntity);
        }
    }
}

