/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.impl;

import androidx.annotation.NonNull;
import com.github.gzuliyujiang.wheelpicker.contract.LinkageProvider;
import com.github.gzuliyujiang.wheelpicker.entity.CityEntity;
import com.github.gzuliyujiang.wheelpicker.entity.CountyEntity;
import com.github.gzuliyujiang.wheelpicker.entity.ProvinceEntity;
import java.util.ArrayList;
import java.util.List;

public class AddressProvider
implements LinkageProvider {
    private final List<ProvinceEntity> data;
    private final int mode;

    public AddressProvider(@NonNull List<ProvinceEntity> data, int mode) {
        this.data = data;
        this.mode = mode;
    }

    @Override
    public boolean firstLevelVisible() {
        return this.mode == 0 || this.mode == 1;
    }

    @Override
    public boolean thirdLevelVisible() {
        return this.mode == 0 || this.mode == 2;
    }

    @NonNull
    public List<ProvinceEntity> provideFirstData() {
        return this.data;
    }

    @NonNull
    public List<CityEntity> linkageSecondData(int firstIndex) {
        if (this.data.size() == 0) {
            return new ArrayList<CityEntity>();
        }
        if (firstIndex == -1) {
            firstIndex = 0;
        }
        return this.data.get(firstIndex).getCityList();
    }

    @NonNull
    public List<CountyEntity> linkageThirdData(int firstIndex, int secondIndex) {
        List<CityEntity> data = this.linkageSecondData(firstIndex);
        if (data.size() == 0) {
            return new ArrayList<CountyEntity>();
        }
        if (secondIndex == -1) {
            secondIndex = 0;
        }
        return data.get(secondIndex).getCountyList();
    }

    @Override
    public int findFirstIndex(Object firstValue) {
        if (firstValue == null) {
            return -1;
        }
        if (firstValue instanceof ProvinceEntity) {
            return this.data.indexOf(firstValue);
        }
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            ProvinceEntity entity = this.data.get(i);
            if (!entity.getCode().equals(firstValue.toString()) && !entity.getName().contains(firstValue.toString())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int findSecondIndex(int firstIndex, Object secondValue) {
        if (secondValue == null) {
            return -1;
        }
        List<CityEntity> cityList = this.linkageSecondData(firstIndex);
        if (secondValue instanceof CityEntity) {
            return cityList.indexOf(secondValue);
        }
        int n = cityList.size();
        for (int i = 0; i < n; ++i) {
            CityEntity entity = cityList.get(i);
            if (!entity.getCode().equals(secondValue.toString()) && !entity.getName().contains(secondValue.toString())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int findThirdIndex(int firstIndex, int secondIndex, Object thirdValue) {
        if (thirdValue == null) {
            return -1;
        }
        List<CountyEntity> countyList = this.linkageThirdData(firstIndex, secondIndex);
        if (thirdValue instanceof CountyEntity) {
            return countyList.indexOf(thirdValue);
        }
        int n = countyList.size();
        for (int i = 0; i < n; ++i) {
            CountyEntity entity = countyList.get(i);
            if (!entity.getCode().equals(thirdValue.toString()) && !entity.getName().contains(thirdValue.toString())) continue;
            return i;
        }
        return -1;
    }
}

