/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker.entity;

import androidx.annotation.NonNull;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Objects;

public class DateEntity
implements Serializable {
    private int year;
    private int month;
    private int day;

    public static DateEntity target(int year, int month, int day) {
        DateEntity entity = new DateEntity();
        entity.setYear(year);
        entity.setMonth(month);
        entity.setDay(day);
        return entity;
    }

    public static DateEntity today() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return DateEntity.target(year, month, day);
    }

    public static DateEntity dayOnFuture(int day) {
        DateEntity entity = DateEntity.today();
        entity.setDay(entity.getDay() + day);
        return entity;
    }

    public static DateEntity monthOnFuture(int month) {
        DateEntity entity = DateEntity.today();
        entity.setMonth(entity.getMonth() + month);
        return entity;
    }

    public static DateEntity yearOnFuture(int year) {
        DateEntity entity = DateEntity.today();
        entity.setYear(entity.getYear() + year);
        return entity;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateEntity that = (DateEntity)o;
        return this.year == that.year && this.month == that.month && this.day == that.day;
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.day);
    }

    @NonNull
    public String toString() {
        return this.year + "-" + this.month + "-" + this.day;
    }
}

