/*
 * Decompiled with CFR 0.152.
 */
package com.github.gzuliyujiang.wheelpicker;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.github.gzuliyujiang.wheelpicker.LinkagePicker;
import com.github.gzuliyujiang.wheelpicker.contract.AddressLoader;
import com.github.gzuliyujiang.wheelpicker.contract.AddressReceiver;
import com.github.gzuliyujiang.wheelpicker.contract.LinkageProvider;
import com.github.gzuliyujiang.wheelpicker.contract.OnAddressPickedListener;
import com.github.gzuliyujiang.wheelpicker.contract.OnLinkagePickedListener;
import com.github.gzuliyujiang.wheelpicker.entity.CityEntity;
import com.github.gzuliyujiang.wheelpicker.entity.CountyEntity;
import com.github.gzuliyujiang.wheelpicker.entity.ProvinceEntity;
import com.github.gzuliyujiang.wheelpicker.impl.AddressProvider;
import com.github.gzuliyujiang.wheelpicker.impl.AssetsAddressLoader;
import java.util.List;

public class AddressPicker
extends LinkagePicker
implements AddressReceiver {
    private AddressLoader addressLoader;
    private int addressMode;
    private OnAddressPickedListener onAddressPickedListener;

    public AddressPicker(@NonNull Activity activity) {
        super(activity);
    }

    public AddressPicker(@NonNull Activity activity, @StyleRes int themeResId) {
        super(activity, themeResId);
    }

    protected void initData() {
        super.initData();
        if (this.addressLoader == null) {
            return;
        }
        this.addressLoader.loadJson(this);
    }

    @Override
    public void onAddressReceived(@NonNull List<ProvinceEntity> data) {
        this.wheelLayout.setData(new AddressProvider(data, this.addressMode));
    }

    @Override
    @Deprecated
    public void setData(@NonNull LinkageProvider data) {
        throw new UnsupportedOperationException("Use setAddressMode or setAddressLoader instead");
    }

    @Override
    @Deprecated
    public void setOnLinkagePickedListener(OnLinkagePickedListener onLinkagePickedListener) {
        throw new UnsupportedOperationException("Use setOnAddressPickedListener instead");
    }

    @Override
    protected void onOk() {
        if (this.onAddressPickedListener != null) {
            ProvinceEntity province = (ProvinceEntity)this.wheelLayout.getFirstWheelView().getCurrentItem();
            CityEntity city = (CityEntity)this.wheelLayout.getSecondWheelView().getCurrentItem();
            CountyEntity county = (CountyEntity)this.wheelLayout.getThirdWheelView().getCurrentItem();
            this.onAddressPickedListener.onAddressPicked(province, city, county);
        }
    }

    public void setOnAddressPickedListener(OnAddressPickedListener onAddressPickedListener) {
        this.onAddressPickedListener = onAddressPickedListener;
    }

    public void setAddressLoader(@NonNull AddressLoader loader) {
        this.addressLoader = loader;
    }

    public void setAddressMode(String jsonPath, int mode) {
        this.addressMode = mode;
        this.setAddressLoader(new AssetsAddressLoader(this.getContext(), jsonPath));
    }
}

