/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.support.annotation.NonNull;
import cn.qqtheme.framework.entity.CarNumberCity;
import cn.qqtheme.framework.entity.CarNumberProvince;
import cn.qqtheme.framework.picker.LinkagePicker;
import java.util.ArrayList;
import java.util.List;

public class CarNumberPicker
extends LinkagePicker<CarNumberProvince, CarNumberCity, Void> {
    private static final String[] ABBREVIATIONS = new String[]{"\u4eac", "\u6d25", "\u5180", "\u664b", "\u8499", "\u8fbd", "\u5409", "\u9ed1", "\u6caa", "\u82cf", "\u6d59", "\u7696", "\u95fd", "\u8d63", "\u9c81", "\u8c6b", "\u9102", "\u6e58", "\u7ca4", "\u6842", "\u743c", "\u6e1d", "\u5ddd", "\u8d35", "\u4e91", "\u85cf", "\u9655", "\u7518", "\u9752", "\u5b81", "\u65b0"};

    public CarNumberPicker(Activity activity) {
        super(activity, new CarNumberDataProvider());
    }

    private static class CarNumberDataProvider
    implements LinkagePicker.Provider<CarNumberProvince, CarNumberCity, Void> {
        private List<CarNumberProvince> provinces = new ArrayList<CarNumberProvince>();

        CarNumberDataProvider() {
            for (String abbreviation : ABBREVIATIONS) {
                this.provinces.add(new CarNumberProvince(abbreviation));
            }
        }

        @Override
        public boolean isOnlyTwo() {
            return true;
        }

        @Override
        @NonNull
        public List<CarNumberProvince> initFirstData() {
            return this.provinces;
        }

        @Override
        @NonNull
        public List<CarNumberCity> linkageSecondData(int firstIndex) {
            return this.provinces.get(firstIndex).getSeconds();
        }

        @Override
        @NonNull
        public List<Void> linkageThirdData(int firstIndex, int secondIndex) {
            return new ArrayList<Void>();
        }
    }
}

