/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.widget.WheelView;

public abstract class WheelPicker
extends ConfirmPopup<View> {
    protected int textSize = 16;
    protected int textColorNormal = -4473925;
    protected int textColorFocus = -16611122;
    protected int offset = 2;
    protected boolean cycleDisable = true;
    protected WheelView.LineConfig lineConfig;
    private View contentView;

    public WheelPicker(Activity activity) {
        super(activity);
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public void setTextColor(@ColorInt int textColorFocus, @ColorInt int textColorNormal) {
        this.textColorFocus = textColorFocus;
        this.textColorNormal = textColorNormal;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColorFocus = textColor;
    }

    public void setLineVisible(boolean lineVisible) {
        if (null == this.lineConfig) {
            this.lineConfig = new WheelView.LineConfig();
        }
        this.lineConfig.setVisible(lineVisible);
    }

    public void setShadowVisible(boolean shadowVisible) {
        if (null == this.lineConfig) {
            this.lineConfig = new WheelView.LineConfig();
        }
        this.lineConfig.setShadowVisible(shadowVisible);
    }

    public void setLineColor(@ColorInt int lineColor) {
        if (null == this.lineConfig) {
            this.lineConfig = new WheelView.LineConfig();
        }
        this.lineConfig.setVisible(true);
        this.lineConfig.setColor(lineColor);
    }

    public void setLineConfig(@Nullable WheelView.LineConfig config) {
        if (null == config) {
            this.lineConfig = new WheelView.LineConfig();
            this.lineConfig.setVisible(false);
            this.lineConfig.setShadowVisible(false);
        } else {
            this.lineConfig = config;
        }
    }

    public void setOffset(@IntRange(from=1L, to=3L) int offset) {
        this.offset = offset;
    }

    public void setCycleDisable(boolean cycleDisable) {
        this.cycleDisable = cycleDisable;
    }

    public View getContentView() {
        if (null == this.contentView) {
            this.contentView = this.makeCenterView();
        }
        return this.contentView;
    }

    protected void showAfter() {
        super.showAfter();
        ViewGroup view = this.getRootView();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        ObjectAnimator translation = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{300.0f, 0.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{alpha, translation});
        animatorSet.setDuration(600L);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.start();
    }

    public void dismiss() {
        ViewGroup view = this.getRootView();
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)view, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator translation = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{0.0f, 300.0f});
        animatorSet.playTogether(new Animator[]{alpha, translation});
        animatorSet.setDuration(600L);
        animatorSet.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                WheelPicker.this.dismissImmediately();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorSet.start();
    }
}

