/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import cn.qqtheme.framework.util.ConvertUtils;
import cn.qqtheme.framework.util.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WheelView
extends ListView
implements AbsListView.OnScrollListener,
View.OnTouchListener {
    public static final int SMOOTH_SCROLL_DURATION = 50;
    public static final int TEXT_SIZE = 16;
    public static final float TEXT_ALPHA = 0.8f;
    public static final int TEXT_COLOR_FOCUS = -16611122;
    public static final int TEXT_COLOR_NORMAL = -4473925;
    public static final int ITEM_OFF_SET = 2;
    public static final int ITEM_HEIGHT = 40;
    public static final int ITEM_PADDING_TOP_BOTTOM = 5;
    public static final int ITEM_PADDING_LEFT_RIGHT = 10;
    public static final int ITEM_MARGIN = 5;
    public static final int ITEM_TAG_IMAGE = 100;
    public static final int ITEM_TAG_TEXT = 101;
    public static final int LINE_ALPHA = 220;
    public static final int LINE_COLOR = -8139290;
    public static final float LINE_THICK = 1.0f;
    private static final int MATCH_PARENT = -1;
    private static final int WRAP_CONTENT = -2;
    private int itemHeightPixels = 0;
    private int currentPosition = -1;
    private WheelAdapter adapter = new WheelAdapter();
    private OnWheelListener onWheelListener;
    private int textSize = 16;
    private int textColorNormal = -4473925;
    private int textColorFocus = -16611122;
    private boolean isUserScroll = false;
    private LineConfig lineConfig = null;

    public WheelView(Context context) {
        super(context);
        this.init();
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public WheelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setVerticalScrollBarEnabled(false);
        this.setScrollingCacheEnabled(false);
        this.setCacheColorHint(0);
        this.setFadingEdgeLength(0);
        this.setOverScrollMode(2);
        this.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.setDividerHeight(0);
        this.setOnScrollListener(this);
        this.setOnTouchListener(this);
        if (Build.VERSION.SDK_INT >= 21) {
            this.setNestedScrollingEnabled(true);
        }
        this.addOnGlobalLayoutListener();
        super.setAdapter((ListAdapter)this.adapter);
    }

    private void addOnGlobalLayoutListener() {
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT >= 16) {
                    WheelView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    WheelView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                int childCount = WheelView.this.getChildCount();
                if (childCount > 0 && WheelView.this.itemHeightPixels == 0) {
                    WheelView.this.itemHeightPixels = WheelView.this.getChildAt(0).getHeight();
                    LogUtils.verbose((Object)this, (String)("itemHeightPixels=" + WheelView.this.itemHeightPixels));
                    if (WheelView.this.itemHeightPixels != 0) {
                        int wheelSize = WheelView.this.adapter.getWheelSize();
                        ViewGroup.LayoutParams params = WheelView.this.getLayoutParams();
                        params.height = WheelView.this.itemHeightPixels * wheelSize;
                        WheelView.this.refreshVisibleItems(WheelView.this.getFirstVisiblePosition(), WheelView.this.getCurrentPosition() + wheelSize / 2, wheelSize / 2);
                        WheelView.this.changeBackground();
                    }
                }
            }
        });
    }

    private void changeBackground() {
        WheelDrawable drawable;
        int wheelSize = this.adapter.getWheelSize();
        if (null == this.lineConfig) {
            this.lineConfig = new LineConfig();
        }
        this.lineConfig.setWidth(this.getWidth());
        this.lineConfig.setHeight(this.itemHeightPixels * wheelSize);
        this.lineConfig.setWheelSize(wheelSize);
        this.lineConfig.setItemHeight(this.itemHeightPixels);
        HoloWheelDrawable holoWheelDrawable = new HoloWheelDrawable(this.lineConfig);
        if (this.lineConfig.isShadowVisible()) {
            ShadowWheelDrawable shadowWheelDrawable = new ShadowWheelDrawable(this.lineConfig);
            drawable = this.lineConfig.isVisible() ? new LayerDrawable(new Drawable[]{shadowWheelDrawable, holoWheelDrawable}) : shadowWheelDrawable;
        } else {
            drawable = holoWheelDrawable;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            super.setBackground((Drawable)drawable);
        } else {
            super.setBackgroundDrawable((Drawable)drawable);
        }
    }

    private void _setItems(List<String> list) {
        if (null == list || list.size() == 0) {
            throw new IllegalArgumentException("data are empty");
        }
        this.adapter.setData(list);
    }

    public void setItems(List<String> list) {
        this._setItems(list);
        this.setSelectedIndex(0);
    }

    public void setItems(String[] list) {
        this.setItems(Arrays.asList(list));
    }

    public void setItems(List<String> list, int index) {
        this._setItems(list);
        this.setSelectedIndex(index);
    }

    public void setItems(List<String> list, String item) {
        this._setItems(list);
        this.setSelectedItem(item);
    }

    public void setItems(String[] list, int index) {
        this.setItems(Arrays.asList(list), index);
    }

    public void setItems(String[] list, String item) {
        this.setItems(Arrays.asList(list), item);
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public int getTextColor() {
        return this.textColorFocus;
    }

    public void setTextColor(@ColorInt int textColorNormal, @ColorInt int textColorFocus) {
        this.textColorNormal = textColorNormal;
        this.textColorFocus = textColorFocus;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColorFocus = textColor;
    }

    public int getOffset() {
        return (this.adapter.getWheelSize() - 1) / 2;
    }

    public void setOffset(@IntRange(from=1L, to=3L) int offset) {
        if (offset < 1 || offset > 3) {
            throw new IllegalArgumentException("Offset must between 1 and 3");
        }
        int wheelSize = offset * 2 + 1;
        this.adapter.setWheelSize(wheelSize);
    }

    public void setCycleDisable(boolean cycleDisable) {
        this.adapter.setLoop(!cycleDisable);
    }

    public int getSelectedIndex() {
        return this.getCurrentPosition();
    }

    public void setSelectedIndex(int index) {
        this.setSelection(index);
    }

    public String getSelectedItem() {
        int position = this.getCurrentPosition();
        return this.adapter.getData().get(position);
    }

    public void setSelectedItem(String item) {
        this.setSelection(this.adapter.getData().indexOf(item));
    }

    public void setSelection(int selection) {
        this.isUserScroll = false;
        super.setSelection(this.getRealPosition(selection));
        this.refreshCurrentPosition();
    }

    private int getRealPosition(int position) {
        int realCount = this.adapter.getRealCount();
        if (realCount == 0) {
            return 0;
        }
        if (this.adapter.isLoop()) {
            int d = 0x3FFFFFFF / realCount;
            return position + d * realCount - this.adapter.getWheelSize() / 2;
        }
        return position;
    }

    public int getCurrentPosition() {
        if (this.currentPosition == -1) {
            return 0;
        }
        return this.currentPosition;
    }

    @Deprecated
    public void setAdapter(ListAdapter adapter) {
        if (adapter == null || !(adapter instanceof WheelAdapter)) {
            throw new IllegalArgumentException("please invoke setItems");
        }
        this.adapter = (WheelAdapter)adapter;
        super.setAdapter((ListAdapter)this.adapter);
    }

    public int getWheelCount() {
        return this.adapter.getRealCount();
    }

    private int getSmoothDistance(float scrollDistance) {
        if (Math.abs(scrollDistance) <= 2.0f) {
            return (int)scrollDistance;
        }
        if (Math.abs(scrollDistance) < 12.0f) {
            return scrollDistance > 0.0f ? 2 : -2;
        }
        return (int)(scrollDistance / 6.0f);
    }

    private void refreshCurrentPosition() {
        if (this.getChildAt(0) == null || this.itemHeightPixels == 0) {
            return;
        }
        int firstPosition = this.getFirstVisiblePosition();
        if (this.adapter.isLoop() && firstPosition == 0) {
            return;
        }
        int position = Math.abs(this.getChildAt(0).getY()) <= (float)(this.itemHeightPixels / 2) ? firstPosition : firstPosition + 1;
        int wheelSize = this.adapter.getWheelSize();
        this.refreshVisibleItems(firstPosition, position + wheelSize / 2, wheelSize / 2);
        if (this.adapter.isLoop()) {
            position = (position + wheelSize / 2) % this.getWheelCount();
        }
        if (position == this.currentPosition) {
            LogUtils.verbose((String)("scrolling position: " + position));
            return;
        }
        this.currentPosition = position;
        LogUtils.verbose((String)("refresh position as: " + position));
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                int index = WheelView.this.getSelectedIndex();
                String item = WheelView.this.getSelectedItem();
                LogUtils.verbose((String)("isUserScroll=" + WheelView.this.isUserScroll + ", index=" + index + ", item=" + item));
                if (null != WheelView.this.onWheelListener) {
                    WheelView.this.onWheelListener.onSelected(WheelView.this.isUserScroll, index, item);
                }
            }
        }, 10L);
    }

    private void refreshVisibleItems(int firstPosition, int curPosition, int offset) {
        for (int i = curPosition - offset; i <= curPosition + offset; ++i) {
            View itemView = this.getChildAt(i - firstPosition);
            if (itemView == null) continue;
            TextView textView = (TextView)itemView.findViewWithTag((Object)101);
            this.refreshTextView(i, curPosition, itemView, textView);
        }
    }

    private void refreshTextView(int position, int curPosition, View itemView, TextView textView) {
        if (curPosition == position) {
            float defTextZoom = 1.1f;
            this.setTextView(itemView, textView, this.textColorFocus, (float)this.textSize * defTextZoom, 1.0f);
        } else {
            int delta = Math.abs(position - curPosition);
            float alpha = (float)Math.pow(0.8f, delta);
            this.setTextView(itemView, textView, this.textColorNormal, this.textSize, alpha);
        }
    }

    private void setTextView(View itemView, TextView textView, int textColor, float textSize, float textAlpha) {
        textView.setTextColor(textColor);
        textView.setTextSize(1, textSize);
        itemView.setAlpha(textAlpha);
    }

    public boolean onTouch(View v, MotionEvent event) {
        v.getParent().requestDisallowInterceptTouchEvent(true);
        this.isUserScroll = true;
        switch (event.getAction()) {
            case 0: {
                LogUtils.verbose((Object)((Object)this), (String)"press down");
                break;
            }
            case 1: {
                LogUtils.verbose((Object)((Object)this), (String)("press up: currentPosition=" + this.getCurrentPosition()));
            }
        }
        return false;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (scrollState != 0) {
            return;
        }
        View itemView = this.getChildAt(0);
        if (itemView == null) {
            return;
        }
        float deltaY = itemView.getY();
        if ((int)deltaY == 0 || this.itemHeightPixels == 0) {
            return;
        }
        if (Math.abs(deltaY) < (float)(this.itemHeightPixels / 2)) {
            int d = this.getSmoothDistance(deltaY);
            this.smoothScrollBy(d, 50);
        } else {
            int d = this.getSmoothDistance((float)this.itemHeightPixels + deltaY);
            this.smoothScrollBy(d, 50);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (visibleItemCount != 0) {
            this.refreshCurrentPosition();
        }
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        int width = this.getLayoutParams().width;
        LogUtils.verbose((Object)((Object)this), (String)("onMeasure: width is " + width));
        if (width == -2) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), heightSpec);
        } else {
            super.onMeasure(widthSpec, heightSpec);
        }
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setLineConfig(LineConfig lineConfig) {
        this.lineConfig = lineConfig;
    }

    private static class ShadowWheelDrawable
    extends WheelDrawable {
        private static final int[] SHADOWS_COLORS = new int[]{-6710887, 0xAAAAAA, 0xAAAAAA};
        private GradientDrawable topShadow = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, SHADOWS_COLORS);
        private GradientDrawable bottomShadow = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, SHADOWS_COLORS);
        private Paint bgPaint;
        private Paint paint;
        private Paint dividerPaint;
        private Paint borderPaint;
        private int wheelSize;
        private int itemHeight;

        public ShadowWheelDrawable(LineConfig config) {
            super(config);
            this.wheelSize = config.getWheelSize();
            this.itemHeight = config.getItemHeight();
            this.init();
        }

        private void init() {
            this.bgPaint = new Paint(1);
            this.bgPaint.setColor(0);
            this.paint = new Paint(1);
            this.paint.setColor(-254816305);
            this.dividerPaint = new Paint(1);
            this.dividerPaint.setColor(-4868683);
            this.dividerPaint.setStrokeWidth(3.0f);
            this.borderPaint = new Paint(1);
            this.borderPaint.setStrokeWidth(2.0f);
            this.borderPaint.setColor(-6710887);
        }

        @Override
        public void draw(Canvas canvas) {
            canvas.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.bgPaint);
            if (this.itemHeight != 0) {
                canvas.drawRect(0.0f, (float)(this.itemHeight * (this.wheelSize / 2)), (float)this.width, (float)(this.itemHeight * (this.wheelSize / 2 + 1)), this.paint);
                canvas.drawLine(0.0f, (float)(this.itemHeight * (this.wheelSize / 2)), (float)this.width, (float)(this.itemHeight * (this.wheelSize / 2)), this.dividerPaint);
                canvas.drawLine(0.0f, (float)(this.itemHeight * (this.wheelSize / 2 + 1)), (float)this.width, (float)(this.itemHeight * (this.wheelSize / 2 + 1)), this.dividerPaint);
                this.topShadow.setBounds(0, 0, this.width, this.itemHeight);
                this.topShadow.draw(canvas);
                this.bottomShadow.setBounds(0, this.height - this.itemHeight, this.width, this.height);
                this.bottomShadow.draw(canvas);
                canvas.drawLine(0.0f, 0.0f, 0.0f, (float)this.height, this.borderPaint);
                canvas.drawLine((float)this.width, 0.0f, (float)this.width, (float)this.height, this.borderPaint);
            }
        }
    }

    private static class HoloWheelDrawable
    extends WheelDrawable {
        private Paint bgPaint;
        private Paint paint;
        private int wheelSize;
        private int itemHeight;
        private float ratio;

        public HoloWheelDrawable(LineConfig config) {
            super(config);
            this.wheelSize = config.getWheelSize();
            this.itemHeight = config.getItemHeight();
            this.ratio = config.getRatio();
            this.init(config);
        }

        private void init(LineConfig config) {
            this.bgPaint = new Paint(1);
            this.bgPaint.setColor(0);
            this.paint = new Paint(1);
            this.paint.setStrokeWidth(config.getThick());
            this.paint.setColor(config.getColor());
            this.paint.setAlpha(config.getAlpha());
        }

        @Override
        public void draw(Canvas canvas) {
            canvas.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.bgPaint);
            if (this.itemHeight != 0) {
                canvas.drawLine((float)this.width * this.ratio, (float)(this.itemHeight * (this.wheelSize / 2)), (float)this.width * (1.0f - this.ratio), (float)(this.itemHeight * (this.wheelSize / 2)), this.paint);
                canvas.drawLine((float)this.width * this.ratio, (float)(this.itemHeight * (this.wheelSize / 2 + 1)), (float)this.width * (1.0f - this.ratio), (float)(this.itemHeight * (this.wheelSize / 2 + 1)), this.paint);
            }
        }
    }

    private static class WheelDrawable
    extends Drawable {
        protected int width;
        protected int height;
        private Paint bgPaint;

        public WheelDrawable(LineConfig config) {
            this.width = config.getWidth();
            this.height = config.getHeight();
            this.init();
        }

        private void init() {
            this.bgPaint = new Paint(1);
            this.bgPaint.setColor(0);
        }

        public void draw(Canvas canvas) {
            canvas.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.bgPaint);
        }

        public void setAlpha(int alpha) {
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return 0;
        }
    }

    private static class WheelAdapter
    extends BaseAdapter {
        protected List<String> data = new ArrayList<String>();
        protected boolean isLoop = false;
        protected int wheelSize = 5;

        private WheelAdapter() {
        }

        public final int getRealCount() {
            return this.data.size();
        }

        public final int getCount() {
            if (this.isLoop) {
                return Integer.MAX_VALUE;
            }
            return this.data.size() > 0 ? this.data.size() + this.wheelSize - 1 : 0;
        }

        public final long getItemId(int position) {
            return this.data.size() > 0 ? (long)(position % this.data.size()) : (long)position;
        }

        public final String getItem(int position) {
            return this.data.size() > 0 ? this.data.get(position % this.data.size()) : null;
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            return false;
        }

        public final View getView(int position, View convertView, ViewGroup parent) {
            position = this.isLoop ? (position %= this.data.size()) : (position < this.wheelSize / 2 ? -1 : (position >= this.wheelSize / 2 + this.data.size() ? -1 : (position -= this.wheelSize / 2)));
            View view = position == -1 ? this.bindView(0, convertView, parent) : this.bindView(position, convertView, parent);
            if (!this.isLoop) {
                if (position == -1) {
                    view.setVisibility(4);
                } else {
                    view.setVisibility(0);
                }
            }
            return view;
        }

        public View bindView(int position, View convertView, ViewGroup parent) {
            ItemView itemView = convertView == null ? new ItemView(parent.getContext()) : (ItemView)convertView;
            itemView.setText(this.data.get(position));
            return itemView;
        }

        public final WheelAdapter setLoop(boolean loop) {
            if (loop != this.isLoop) {
                this.isLoop = loop;
                super.notifyDataSetChanged();
            }
            return this;
        }

        public final WheelAdapter setWheelSize(int wheelSize) {
            if ((wheelSize & 1) == 0) {
                throw new IllegalArgumentException("wheel size must be an odd number.");
            }
            this.wheelSize = wheelSize;
            super.notifyDataSetChanged();
            return this;
        }

        public final WheelAdapter setData(List<String> list) {
            if (null == list) {
                this.data.clear();
                super.notifyDataSetChanged();
                return this;
            }
            this.data = list;
            super.notifyDataSetChanged();
            return this;
        }

        public List<String> getData() {
            return this.data;
        }

        public int getWheelSize() {
            return this.wheelSize;
        }

        public boolean isLoop() {
            return this.isLoop;
        }

        @Deprecated
        public final void notifyDataSetChanged() {
            super.notifyDataSetChanged();
        }

        @Deprecated
        public final void notifyDataSetInvalidated() {
            super.notifyDataSetInvalidated();
        }
    }

    private static class ItemView
    extends LinearLayout {
        private ImageView imageView;
        private TextView textView;

        public ItemView(Context context) {
            super(context);
            this.init(context);
        }

        public ItemView(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.init(context);
        }

        public ItemView(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
            this.init(context);
        }

        private void init(Context context) {
            this.setOrientation(0);
            int paddingTopBottom = ConvertUtils.toPx((Context)context, (float)5.0f);
            int paddingLeftRight = ConvertUtils.toPx((Context)context, (float)10.0f);
            this.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
            this.setGravity(17);
            int height = ConvertUtils.toPx((Context)context, (float)40.0f);
            this.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, height));
            this.imageView = new ImageView(this.getContext());
            this.imageView.setTag((Object)100);
            this.imageView.setVisibility(8);
            LinearLayout.LayoutParams imageParams = new LinearLayout.LayoutParams(-2, -2);
            imageParams.rightMargin = ConvertUtils.toPx((Context)context, (float)5.0f);
            this.addView((View)this.imageView, (ViewGroup.LayoutParams)imageParams);
            this.textView = new TextView(this.getContext());
            this.textView.setTag((Object)101);
            this.textView.setEllipsize(TextUtils.TruncateAt.END);
            this.textView.setSingleLine(true);
            this.textView.setIncludeFontPadding(false);
            this.textView.setGravity(17);
            this.textView.setTextColor(-16777216);
            LinearLayout.LayoutParams textParams = new LinearLayout.LayoutParams(-1, -2);
            this.addView((View)this.textView, (ViewGroup.LayoutParams)textParams);
        }

        public void setText(CharSequence text) {
            this.textView.setText(text);
        }

        public void setImage(@DrawableRes int resId) {
            this.imageView.setVisibility(0);
            this.imageView.setImageResource(resId);
        }
    }

    public static class LineConfig {
        private boolean visible = true;
        private boolean shadowVisible = false;
        private int color = -8139290;
        private int alpha = 220;
        private float ratio = 0.16666667f;
        private float thick = 1.0f;
        private int width = 0;
        private int height = 0;
        private int itemHeight = 0;
        private int wheelSize = 0;

        public LineConfig() {
        }

        public LineConfig(@FloatRange(from=0.0, to=1.0) float ratio) {
            this.ratio = ratio;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setShadowVisible(boolean shadowVisible) {
            this.shadowVisible = shadowVisible;
        }

        public boolean isShadowVisible() {
            return this.shadowVisible;
        }

        @ColorInt
        public int getColor() {
            return this.color;
        }

        public void setColor(@ColorInt int color) {
            this.color = color;
        }

        @IntRange(from=1L, to=255L)
        public int getAlpha() {
            return this.alpha;
        }

        public void setAlpha(@IntRange(from=1L, to=255L) int alpha) {
            this.alpha = alpha;
        }

        @FloatRange(from=0.0, to=1.0)
        public float getRatio() {
            return this.ratio;
        }

        public void setRatio(@FloatRange(from=0.0, to=1.0) float ratio) {
            this.ratio = ratio;
        }

        public float getThick() {
            return this.thick;
        }

        public void setThick(float thick) {
            this.thick = thick;
        }

        protected int getWidth() {
            return this.width;
        }

        protected void setWidth(int width) {
            this.width = width;
        }

        protected int getHeight() {
            return this.height;
        }

        protected void setHeight(int height) {
            this.height = height;
        }

        protected int getItemHeight() {
            return this.itemHeight;
        }

        protected void setItemHeight(int itemHeight) {
            this.itemHeight = itemHeight;
        }

        protected int getWheelSize() {
            return this.wheelSize;
        }

        protected void setWheelSize(int wheelSize) {
            this.wheelSize = wheelSize;
        }

        public String toString() {
            return "visible=" + this.visible + "color=" + this.color + ", alpha=" + this.alpha + ", thick=" + this.thick + ", width=" + this.width;
        }
    }

    @Deprecated
    public static interface OnWheelViewListener
    extends OnWheelListener {
    }

    public static interface OnWheelListener {
        public void onSelected(boolean var1, int var2, String var3);
    }
}

