/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.widget.WheelView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SinglePicker<T>
extends WheelPicker {
    protected ArrayList<T> items = new ArrayList();
    private OnWheelListener onWheelListener;
    private OnItemPickListener<T> onItemPickListener;
    private int selectedItemIndex = 0;
    private String label = "";

    public SinglePicker(Activity activity, T[] items) {
        this(activity, Arrays.asList(items));
    }

    public SinglePicker(Activity activity, List<T> items) {
        super(activity);
        if (null == items || items.size() == 0) {
            return;
        }
        this.items.addAll(items);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSelectedIndex(int index) {
        if (index >= 0 && index < this.items.size()) {
            this.selectedItemIndex = index;
        }
    }

    public void setSelectedItem(@NonNull T item) {
        this.setSelectedIndex(this.items.indexOf(item));
    }

    public void setOnWheelListener(OnWheelListener onWheelListener) {
        this.onWheelListener = onWheelListener;
    }

    public void setOnItemPickListener(OnItemPickListener<T> listener) {
        this.onItemPickListener = listener;
    }

    @NonNull
    protected View makeCenterView() {
        if (this.items.size() == 0) {
            throw new IllegalArgumentException("please initial items at first, can't be empty");
        }
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView optionView = new WheelView((Context)this.activity);
        optionView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        optionView.setTextSize(this.textSize);
        optionView.setTextColor(this.textColorNormal, this.textColorFocus);
        optionView.setLineVisible(this.lineVisible);
        optionView.setLineColor(this.lineColor);
        optionView.setOffset(this.offset);
        optionView.setCycleDisable(this.cycleDisable);
        layout.addView((View)optionView);
        TextView labelView = new TextView((Context)this.activity);
        labelView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        labelView.setTextColor(this.textColorFocus);
        labelView.setTextSize((float)this.textSize);
        layout.addView((View)labelView);
        if (!TextUtils.isEmpty((CharSequence)this.label)) {
            labelView.setText((CharSequence)this.label);
        }
        optionView.setItems(this.getStringList(), this.selectedItemIndex);
        optionView.setOnWheelListener(new WheelView.OnWheelListener(){

            @Override
            public void onSelected(boolean isUserScroll, int index, String item) {
                SinglePicker.this.selectedItemIndex = index;
                if (SinglePicker.this.onWheelListener != null) {
                    SinglePicker.this.onWheelListener.onWheeled(SinglePicker.this.selectedItemIndex, item);
                }
            }
        });
        return layout;
    }

    private List<String> getStringList() {
        ArrayList<String> stringList = new ArrayList<String>();
        for (T item : this.items) {
            stringList.add(item.toString());
        }
        return stringList;
    }

    public void onSubmit() {
        if (this.onItemPickListener != null) {
            this.onItemPickListener.onItemPicked(this.selectedItemIndex, this.getSelectedItem());
        }
    }

    public T getSelectedItem() {
        return this.items.get(this.selectedItemIndex);
    }

    public int getSelectedIndex() {
        return this.selectedItemIndex;
    }

    public static interface OnWheelListener {
        public void onWheeled(int var1, String var2);
    }

    public static interface OnItemPickListener<T> {
        public void onItemPicked(int var1, T var2);
    }
}

