/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import cn.qqtheme.framework.picker.WheelPicker;
import cn.qqtheme.framework.util.DateUtils;
import cn.qqtheme.framework.widget.WheelView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DateTimePicker
extends WheelPicker {
    public static final int YEAR_MONTH_DAY = 0;
    public static final int YEAR_MONTH = 1;
    public static final int MONTH_DAY = 2;
    public static final int HOUR_OF_DAY = 3;
    public static final int HOUR = 4;
    private ArrayList<String> years = new ArrayList();
    private ArrayList<String> months = new ArrayList();
    private ArrayList<String> days = new ArrayList();
    private String yearLabel = "\u5e74";
    private String monthLabel = "\u6708";
    private String dayLabel = "\u65e5";
    private int selectedYearIndex = 0;
    private int selectedMonthIndex = 0;
    private int selectedDayIndex = 0;
    private String hourLabel = "\u65f6";
    private String minuteLabel = "\u5206";
    private String selectedHour = "";
    private String selectedMinute = "";
    private OnDateTimePickListener onDateTimePickListener;
    private int mode;

    public DateTimePicker(Activity activity, int mode) {
        super(activity);
        int i;
        this.textSize = 16;
        this.mode = mode;
        for (i = 2000; i <= 2050; ++i) {
            this.years.add(String.valueOf(i));
        }
        for (i = 1; i <= 12; ++i) {
            this.months.add(DateUtils.fillZero((int)i));
        }
        for (i = 1; i <= 31; ++i) {
            this.days.add(DateUtils.fillZero((int)i));
        }
        this.selectedHour = DateUtils.fillZero((int)Calendar.getInstance().get(11));
        this.selectedMinute = DateUtils.fillZero((int)Calendar.getInstance().get(12));
    }

    @NonNull
    protected View makeCenterView() {
        int i;
        LinearLayout layout = new LinearLayout((Context)this.activity);
        layout.setOrientation(0);
        layout.setGravity(17);
        WheelView yearView = new WheelView(this.activity.getBaseContext());
        yearView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        yearView.setTextSize(this.textSize);
        yearView.setTextColor(this.textColorNormal, this.textColorFocus);
        yearView.setLineVisible(this.lineVisible);
        yearView.setLineColor(this.lineColor);
        yearView.setOffset(this.offset);
        layout.addView((View)yearView);
        TextView yearTextView = new TextView((Context)this.activity);
        yearTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        yearTextView.setTextSize((float)this.textSize);
        yearTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.yearLabel)) {
            yearTextView.setText((CharSequence)this.yearLabel);
        }
        layout.addView((View)yearTextView);
        WheelView monthView = new WheelView(this.activity.getBaseContext());
        monthView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        monthView.setTextSize(this.textSize);
        monthView.setTextColor(this.textColorNormal, this.textColorFocus);
        monthView.setLineVisible(this.lineVisible);
        monthView.setLineColor(this.lineColor);
        monthView.setOffset(this.offset);
        layout.addView((View)monthView);
        TextView monthTextView = new TextView((Context)this.activity);
        monthTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        monthTextView.setTextSize((float)this.textSize);
        monthTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.monthLabel)) {
            monthTextView.setText((CharSequence)this.monthLabel);
        }
        layout.addView((View)monthTextView);
        final WheelView dayView = new WheelView(this.activity.getBaseContext());
        dayView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        dayView.setTextSize(this.textSize);
        dayView.setTextColor(this.textColorNormal, this.textColorFocus);
        dayView.setLineVisible(this.lineVisible);
        dayView.setLineColor(this.lineColor);
        dayView.setOffset(this.offset);
        layout.addView((View)dayView);
        TextView dayTextView = new TextView((Context)this.activity);
        dayTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        dayTextView.setTextSize((float)this.textSize);
        dayTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.dayLabel)) {
            dayTextView.setText((CharSequence)this.dayLabel);
        }
        layout.addView((View)dayTextView);
        WheelView hourView = new WheelView((Context)this.activity);
        hourView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        hourView.setTextSize(this.textSize);
        hourView.setTextColor(this.textColorNormal, this.textColorFocus);
        hourView.setLineVisible(this.lineVisible);
        hourView.setLineColor(this.lineColor);
        layout.addView((View)hourView);
        TextView hourTextView = new TextView((Context)this.activity);
        hourTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        hourTextView.setTextSize((float)this.textSize);
        hourTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.hourLabel)) {
            hourTextView.setText((CharSequence)this.hourLabel);
        }
        layout.addView((View)hourTextView);
        WheelView minuteView = new WheelView((Context)this.activity);
        minuteView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        minuteView.setTextSize(this.textSize);
        minuteView.setTextColor(this.textColorNormal, this.textColorFocus);
        minuteView.setLineVisible(this.lineVisible);
        minuteView.setLineColor(this.lineColor);
        minuteView.setOffset(this.offset);
        layout.addView((View)minuteView);
        TextView minuteTextView = new TextView((Context)this.activity);
        minuteTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        minuteTextView.setTextSize((float)this.textSize);
        minuteTextView.setTextColor(this.textColorFocus);
        if (!TextUtils.isEmpty((CharSequence)this.minuteLabel)) {
            minuteTextView.setText((CharSequence)this.minuteLabel);
        }
        layout.addView((View)minuteTextView);
        if (this.mode == 1) {
            dayView.setVisibility(8);
            dayTextView.setVisibility(8);
        } else if (this.mode == 2) {
            yearView.setVisibility(8);
            yearTextView.setVisibility(8);
        }
        if (this.mode != 2) {
            if (!TextUtils.isEmpty((CharSequence)this.yearLabel)) {
                yearTextView.setText((CharSequence)this.yearLabel);
            }
            if (this.selectedYearIndex == 0) {
                yearView.setItems(this.years);
            } else {
                yearView.setItems(this.years, this.selectedYearIndex);
            }
            yearView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

                @Override
                public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                    DateTimePicker.this.selectedYearIndex = selectedIndex;
                    DateTimePicker.this.days.clear();
                    int maxDays = DateUtils.calculateDaysInMonth((int)DateTimePicker.this.stringToYearMonthDay(item), (int)DateTimePicker.this.stringToYearMonthDay((String)DateTimePicker.this.months.get(DateTimePicker.this.selectedMonthIndex)));
                    for (int i = 1; i <= maxDays; ++i) {
                        DateTimePicker.this.days.add(DateUtils.fillZero((int)i));
                    }
                    if (DateTimePicker.this.selectedDayIndex >= maxDays) {
                        DateTimePicker.this.selectedDayIndex = DateTimePicker.this.days.size() - 1;
                    }
                    dayView.setItems((List<String>)DateTimePicker.this.days, DateTimePicker.this.selectedDayIndex);
                }
            });
        }
        if (!TextUtils.isEmpty((CharSequence)this.monthLabel)) {
            monthTextView.setText((CharSequence)this.monthLabel);
        }
        if (this.selectedMonthIndex == 0) {
            monthView.setItems(this.months);
        } else {
            monthView.setItems(this.months, this.selectedMonthIndex);
        }
        monthView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                DateTimePicker.this.selectedMonthIndex = selectedIndex;
                if (DateTimePicker.this.mode != 1) {
                    DateTimePicker.this.days.clear();
                    int maxDays = DateUtils.calculateDaysInMonth((int)DateTimePicker.this.stringToYearMonthDay((String)DateTimePicker.this.years.get(DateTimePicker.this.selectedYearIndex)), (int)DateTimePicker.this.stringToYearMonthDay(item));
                    for (int i = 1; i <= maxDays; ++i) {
                        DateTimePicker.this.days.add(DateUtils.fillZero((int)i));
                    }
                    if (DateTimePicker.this.selectedDayIndex >= maxDays) {
                        DateTimePicker.this.selectedDayIndex = DateTimePicker.this.days.size() - 1;
                    }
                    dayView.setItems((List<String>)DateTimePicker.this.days, DateTimePicker.this.selectedDayIndex);
                }
            }
        });
        if (this.mode != 1) {
            if (!TextUtils.isEmpty((CharSequence)this.dayLabel)) {
                dayTextView.setText((CharSequence)this.dayLabel);
            }
            if (this.selectedDayIndex == 0) {
                dayView.setItems(this.days);
            } else {
                dayView.setItems(this.days, this.selectedDayIndex);
            }
            dayView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

                @Override
                public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                    DateTimePicker.this.selectedDayIndex = selectedIndex;
                }
            });
        }
        ArrayList<String> hours = new ArrayList<String>();
        if (this.mode == 4) {
            for (i = 1; i <= 12; ++i) {
                hours.add(DateUtils.fillZero((int)i));
            }
        } else {
            for (i = 0; i < 24; ++i) {
                hours.add(DateUtils.fillZero((int)i));
            }
        }
        hourView.setItems(hours, this.selectedHour);
        ArrayList<String> minutes = new ArrayList<String>();
        for (int i2 = 0; i2 < 60; ++i2) {
            minutes.add(DateUtils.fillZero((int)i2));
        }
        minuteView.setItems(minutes, this.selectedMinute);
        hourView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                DateTimePicker.this.selectedHour = item;
            }
        });
        minuteView.setOnWheelViewListener(new WheelView.OnWheelViewListener(){

            @Override
            public void onSelected(boolean isUserScroll, int selectedIndex, String item) {
                DateTimePicker.this.selectedMinute = item;
            }
        });
        return layout;
    }

    protected void onSubmit() {
        if (this.onDateTimePickListener == null) {
            return;
        }
        String year = this.getSelectedYear();
        String month = this.getSelectedMonth();
        String day = this.getSelectedDay();
        switch (this.mode) {
            case 1: {
                ((OnYearMonthPickListener)this.onDateTimePickListener).onDateTimePicked(year, month, this.selectedHour, this.selectedMinute);
                break;
            }
            case 2: {
                ((OnMonthDayPickListener)this.onDateTimePickListener).onDateTimePicked(month, day, this.selectedHour, this.selectedMinute);
                break;
            }
            default: {
                ((OnYearMonthDayTimePickListener)this.onDateTimePickListener).onDateTimePicked(year, month, day, this.selectedHour, this.selectedMinute);
            }
        }
    }

    public String getSelectedYear() {
        return this.years.get(this.selectedYearIndex);
    }

    public String getSelectedMonth() {
        return this.months.get(this.selectedMonthIndex);
    }

    public String getSelectedDay() {
        return this.days.get(this.selectedDayIndex);
    }

    private int stringToYearMonthDay(String text) {
        if (text.startsWith("0")) {
            text = text.substring(1);
        }
        return Integer.parseInt(text);
    }

    public void setLabel(String yearLabel, String monthLabel, String dayLabel, String hourLabel, String minuteLabel) {
        this.yearLabel = yearLabel;
        this.monthLabel = monthLabel;
        this.dayLabel = dayLabel;
        this.hourLabel = hourLabel;
        this.minuteLabel = minuteLabel;
    }

    public void setRange(int startYear, int endYear) {
        this.years.clear();
        for (int i = startYear; i <= endYear; ++i) {
            this.years.add(String.valueOf(i));
        }
    }

    private int findItemIndex(ArrayList<String> items, int item) {
        int index = Collections.binarySearch(items, item, new Comparator<Object>(){

            @Override
            public int compare(Object lhs, Object rhs) {
                String lhsStr = lhs.toString();
                String rhsStr = rhs.toString();
                lhsStr = lhsStr.startsWith("0") ? lhsStr.substring(1) : lhsStr;
                rhsStr = rhsStr.startsWith("0") ? rhsStr.substring(1) : rhsStr;
                return Integer.parseInt(lhsStr) - Integer.parseInt(rhsStr);
            }
        });
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    public void setSelectedItem(int year, int month, int day, int hour, int minute) {
        this.selectedYearIndex = this.findItemIndex(this.years, year);
        this.selectedMonthIndex = this.findItemIndex(this.months, month);
        this.selectedDayIndex = this.findItemIndex(this.days, day);
        this.selectedHour = String.valueOf(hour);
        this.selectedMinute = String.valueOf(minute);
    }

    public void setSelectedItem(int yearOrMonth, int monthOrDay, int hour, int minute) {
        if (this.mode == 2) {
            this.selectedMonthIndex = this.findItemIndex(this.months, yearOrMonth);
            this.selectedDayIndex = this.findItemIndex(this.days, monthOrDay);
        } else {
            this.selectedYearIndex = this.findItemIndex(this.years, yearOrMonth);
            this.selectedMonthIndex = this.findItemIndex(this.months, monthOrDay);
        }
        this.selectedHour = String.valueOf(hour);
        this.selectedMinute = String.valueOf(minute);
    }

    public void setOnDateTimePickListener(OnDateTimePickListener listener) {
        this.onDateTimePickListener = listener;
    }

    public static interface OnMonthDayPickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2, String var3, String var4);
    }

    public static interface OnYearMonthPickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2, String var3, String var4);
    }

    public static interface OnYearMonthDayTimePickListener
    extends OnDateTimePickListener {
        public void onDateTimePicked(String var1, String var2, String var3, String var4, String var5);
    }

    protected static interface OnDateTimePickListener {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

